use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    like exception { bif(qw/update topic/) }, qr/usage:/, 'usage';
    isa_ok exception { bif(qw/update topic 100/) },
      'Bif::Error::UserRepoNotFound';

    bif(qw/init/);

    isa_ok exception { bif(qw/update topic 100/) }, 'Bif::Error::TopicNotFound';
    isa_ok exception { bif( qw/update topic 1/, ); }, 'Bif::Error::WrongKind';

    my $p = bif(qw/ new project todo title --message m1 /);

    my $t = bif(qw/new topic task title --message m4/);

    my $u = bif(
        qw/update topic/,
        $t->{id},
        qw/done --title/,
        'title with space',
        qw/--message m4/
    );

    isa_ok $u, 'Bif::OK::ChangeTask';

    bifcheck;
};

done_testing();
