CREATE TABLE plan_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    plan_id INTEGER NOT NULL,
    name VARCHAR,
    title VARCHAR,
    new INTEGER,
    add_remove INTEGER CHECK( add_remove BETWEEN 0 AND 1 ),
    host_id INTEGER,
    FOREIGN KEY(id) REFERENCES deltas(id),
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(plan_id) REFERENCES plans(id) ON DELETE CASCADE,
    FOREIGN KEY(host_id) REFERENCES hosts(id) ON DELETE CASCADE
);

CREATE TRIGGER
    plan_deltas_ai_3
AFTER INSERT ON
    plan_deltas
FOR EACH ROW WHEN
    NEW.add_remove = 0
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.plan_id,
        NEW.name,
        NEW.title,
        NEW.add_remove,
        NEW.host_id
    );

    DELETE FROM
        plan_hosts
    WHERE
        plan_id = NEW.plan_id AND
        host_id = NEW.host_id
    ;

END;


CREATE TRIGGER
    plan_deltas_ai_2
AFTER INSERT ON
    plan_deltas
FOR EACH ROW WHEN
    NEW.add_remove = 1
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.plan_id,
        NEW.name,
        NEW.title,
        NEW.add_remove,
        NEW.host_id
    );

    INSERT INTO
        plan_hosts(
            plan_id,
            host_id
        )
    VALUES(
        NEW.plan_id,
        NEW.host_id
    );

END;


CREATE TRIGGER
    plan_deltas_ai_1
AFTER INSERT ON
    plan_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.plan_id,
        NEW.name,
        NEW.title,
        NEW.add_remove,
        NEW.host_id
    );


    UPDATE
        changes
    SET
        ucount = ucount + 1
    WHERE
        id = NEW.change_id
    ;

END;
