CREATE TABLE func_new_topic(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    link_topic_id INTEGER NOT NULL,
    project_id INTEGER NOT NULL,
    topic_status_id INTEGER NOT NULL,
    title VARCHAR(1024) NOT NULL,
    tkind VARCHAR NOT NULL,
    uuid VARCHAR(40)
);


CREATE TRIGGER
    func_new_topic_bi_1
BEFORE INSERT ON
    func_new_topic
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.link_topic_id,
        NEW.project_id,
        NEW.topic_status_id,
        NEW.title,
        NEW.change_id
    );


    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_topic'
    );


    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_topic' || x'0A'
                || '  link_topic_uuid: ' || lt.uuid || x'0A'
                || '  project_uuid: ' || p.uuid || x'0A'
                ||
                    CASE WHEN
                        NEW.title IS NULL
                    THEN
                        '  title: ~' || x'0A'
                    WHEN
                        NEW.title = '-'
                    THEN
                        '  title: ''-''' || x'0A'
                    WHEN
                        instr(NEW.title, x'0A') OR
                        instr(NEW.title, '\\')
                    THEN
                        '  title: "' 
                        || REPLACE(
                              REPLACE(
                                REPLACE(NEW.title, '\\', '\\\\'),
                                x'0A', '\n'), '"', '\"')
                        || '"' || x'0A'
                    WHEN
                        instr(NEW.title, ' ') OR
                        NEW.title = '' -- not at all sufficient
                    THEN
                        '  title: ''' || NEW.title || '''' || x'0A'
                    ELSE
                        '  title: ' || NEW.title || x'0A'
                    END
                || '  tkind: ' || NEW.tkind || x'0A'
                || '  topic_status_uuid: ' || s.uuid || x'0A'
            FROM
                nodes s
            INNER JOIN
                nodes lt
            ON
                lt.id = NEW.link_topic_id
            INNER JOIN
                nodes p
            ON
                p.id = NEW.project_id
            WHERE
                s.id = NEW.topic_status_id
        )
    WHERE
        id = NEW.change_id
    ;


    INSERT INTO
        func_new_node(
            change_id,
            id,
            parent_id,
            name,
            kind
        )
    SELECT
        NEW.change_id,
        NEW.id,
        ts.project_id,
        NEW.id,
        'topic'
    FROM
        topic_status ts
    WHERE
        ts.id = NEW.topic_status_id
    ;


    -- TODO move into func-new-node?
    INSERT INTO
        node_deltas(
            id,
            change_id,
            node_id,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.id
    );


    INSERT INTO topics(
        id,
        link_topic_id,
        project_id,
        topic_status_id,
        title,
        tkind
    )
    VALUES(
        NEW.id,
        NEW.link_topic_id,
        NEW.project_id,
        NEW.topic_status_id,
        NEW.title,
        NEW.tkind
    );


    INSERT INTO
        link_topic_deltas(
            id,
            link_topic_id,
            topic_id,
            title,
            topic_status_id,
            change_id
        )
    VALUES(
        currval('deltas'),
        NEW.link_topic_id,
        NEW.id,
        NEW.title,
        NEW.topic_status_id,
        NEW.change_id
    );

    SELECT RAISE(IGNORE);
END;
