CREATE TABLE func_new_topic_status(
    change_id INTEGER NOT NULL,
    id INTEGER NOT NULL,
    project_id INTEGER,
    tkind VARCHAR NOT NULL,
    status VARCHAR(40) NOT NULL,
    rank INTEGER NOT NULL,
    def INTEGER,
    uuid VARCHAR(40)
);

CREATE TRIGGER
    func_new_topic_status_bi_1
BEFORE INSERT ON
    func_new_topic_status
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.id,
        NEW.project_id,
        NEW.tkind,
        NEW.status,
        NEW.rank,
        NEW.def,
        NEW.uuid
    );


    UPDATE
        changes
    SET
        yaml = yaml || (
            SELECT
                '-' || x'0A'
                || '  _delta: new_topic_status' || x'0A'
                || '  def: ' || COALESCE(NEW.def,'~') || x'0A'
                || '  project_uuid: ' || p.uuid || x'0A'
                || '  rank: ' || NEW.rank || x'0A'
                || CASE WHEN
                    NEW.status = '-'
                THEN
                    '  status: ''-''' || x'0A'
                ELSE
                    '  status: ' || NEW.status || x'0A'
                END
                || '  tkind: ' || NEW.tkind || x'0A'
            FROM
                nodes p
            WHERE
                p.id = NEW.project_id
        )
    WHERE
        id = NEW.change_id
    ;

    INSERT INTO func_new_node(
        id,
        parent_id,
        change_id,
        name,
        kind,
        uuid
    )
    VALUES(
        NEW.id,
        NEW.project_id,
        NEW.change_id,
        NEW.id,
        'topic_status',
        NEW.uuid
    );
 

    INSERT INTO
        topic_status(
            id,
            project_id,
            tkind,
            status,
            rank,
            def
        )
    VALUES(
        NEW.id,
        NEW.project_id,
        NEW.tkind,
        NEW.status,
        NEW.rank,
        NEW.def
    );

    INSERT INTO deltas(
        id,
        change_id,
        action
    )
    VALUES(
        nextval('deltas'),
        NEW.change_id,
        'new_topic_status'
    );

    INSERT INTO
        node_deltas(
            id,
            change_id,
            node_id,
            name
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.id
    );

    INSERT INTO
        topic_status_deltas(
            id,
            change_id,
            topic_status_id,
            status,
            rank,
            def
        )
    VALUES(
        currval('deltas'),
        NEW.change_id,
        NEW.id,
        NEW.status,
        NEW.rank,
        NEW.def
    );

    SELECT RAISE(IGNORE);
END;
