CREATE TABLE func_import_update_topic(
    uuid VARCHAR(40),
    topic_status_uuid VARCHAR(40),
    title VARCHAR(1024)
);


CREATE TRIGGER
    func_import_update_topic_bi_1
BEFORE INSERT ON
    func_import_update_topic
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.uuid,
        NEW.topic_status_uuid,
        NEW.title
    );

    INSERT INTO
        func_update_topic(
            change_id,
            id,
            topic_status_id,
            title
        )
    SELECT
        currval('changes'),
        n.id,
        s.id,
        NEW.title
    FROM
        nodes n
    LEFT JOIN
        nodes s
    ON
        s.uuid = NEW.topic_status_uuid
    WHERE
        n.uuid = NEW.uuid
    ;

    SELECT RAISE(IGNORE);
END;
