package App::bif::show::hub;
use strict;
use warnings;
use Bif::Mo;

our $VERSION = '0.1.5_6';
extends 'App::bif::show';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $db   = $self->db;
    my $hub  = $self->get_hub( $opts->{id} ? $opts->{id} : $opts->{name} );

    my @data;

    push(
        @data,
        $self->header(
            '  ID', $hub->{id},
            $opts->{full} ? $hub->{uuid} : substr( $hub->{uuid}, 1, 8 )
        ),
    );

    push( @data, $self->header( '  Location', $hub->{location}, ) );

    my $info = $db->xhashref(
        select     => [qw/n.ctime n.ctimetz n.mtime n.mtimetz/],
        from       => 'nodes n',
        inner_join => 'changes c',
        on         => 'c.id = n.first_change_id',
        where      => { 'n.id' => $hub->{id} },
    );

    $self->start_pager;
    print $self->render_table( 'l  l', [ 'Hub', $hub->{name} ], \@data, 1 );
    print "\n";

    $self->dispatch( 'App::bif::log::hub', opts => { id => $hub->{id} } )
      if $opts->{log};

    return $self->ok( 'ShowHub', \@data );
}

1;
__END__

=head1 NAME

=for bif-doc #show

bif-show-hub - display a hub's current status

=head1 VERSION

0.1.5_6 (2015-10-20)

=head1 SYNOPSIS

    bif show hub NAME [OPTIONS...]

=head1 DESCRIPTION

The B<bif-show-hub> command displays a summary of a hub's current
status.

    bif show hub local
    # Hub:       local                            
    # ID:        1 <2bc47651>                     
    # Location:  /home/mark/src/bif/.bif <default>

=head1 ARGUMENTS & OPTIONS

=over

=item NAME

A hub name or location. Required. You can use "-" to show the status of
the current repository.

=item --full, -f

Display a more verbose version of the current status.

=item --uuid, -U

Lookup the node using ID as a UUID string instead of a node integer.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2014-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.



