use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    like exception { bif(qw/update/) }, qr/usage:/, 'usage';
    isa_ok exception { bif(qw/update junk/) }, 'Bif::Error::UserRepoNotFound';

    bif(qw/init/);
    isa_ok exception { bif(qw/update todo/) }, 'Bif::Error::TopicNotFound';

    my $h = bif(qw/ new hub name title --message m1/);
    my $u = bif( qw/update name --message m2 --title/, 'space title' );
    isa_ok $u, 'Bif::OK::ChangeHub';

    my $p = bif(qw/ new project todo --message m3 title /);
    $u = bif(qw/update todo --message m4/);
    isa_ok $u, 'Bif::OK::ChangeProject';

    my $t = bif(qw/new task todo title --message m5/);
    $u = bif( qw/update/, $t->{id}, qw/--message m6/ );
    isa_ok $u, 'Bif::OK::ChangeTask';

    my $i = bif(qw/new issue todo title --message m7/);
    $u = bif( qw/update/, $i->{id}, qw/--message m8/ );
    isa_ok $u, 'Bif::OK::ChangeIssue';
};

done_testing();
