use strict;
use warnings;
use lib 't/lib';
use File::chdir;
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    isa_ok exception { bif(qw/push project/) },      'OptArgs::Usage';
    isa_ok exception { bif(qw/push project todo/) }, 'OptArgs::Usage';
    isa_ok exception { bif(qw/push project todo hub.bifhub/) },
      'Bif::Error::UserRepoNotFound';

    bif(qw/init/);

    isa_ok exception { bif(qw/push project todo hub.bifhub/) },
      'Bif::Error::ProjectNotFound';

    my $pinfo = bif(qw/new project todo title -m message/);
    bif(qw/update todo -m m2/);

    my $tinfo = bif(qw/new task -m message -p todo tasktitle/);
    bif( qw/update/, $tinfo->{id}, qw/-m m2/ );

    my $iinfo = bif(qw/new issue -m message -p todo issuetitle/);
    bif( qw/update/, $iinfo->{id}, qw/-m m2/ );

    isa_ok exception { bif( qw/push project/, $tinfo->{id}, qw/hub.bifhub/ ) },
      'Bif::Error::ProjectNotFound';

    isa_ok exception { bif(qw/push project todo hub.bifhub/) },
      'Bif::Error::HubNotFound';

    bif(qw/init hub.bifhub/);
    bif(qw{pull hub hub.bifhub});

    isa_ok bif(qw{push project todo hub.bifhub}), 'Bif::OK::PushProject';
    isa_ok hub(qw/show project todo/),            'Bif::OK::ShowProject';

    bifcheck;
};

done_testing();
