CREATE TABLE hubs (
    id INTEGER NOT NULL PRIMARY KEY,
    location VARCHAR NOT NULL UNIQUE,
    hash CHAR(40) DEFAULT 'da39a3ee5e6b4b0d3255bfef95601890afd80709',
    num_changes INTEGER NOT NULL DEFAULT 0,
    FOREIGN KEY (id) REFERENCES projects(id) ON DELETE CASCADE
);


CREATE TRIGGER
    hubs_bd_1
BEFORE DELETE ON
    hubs
FOR EACH ROW
BEGIN
    SELECT debug( 
        OLD.id
    );

    /*
        The following is necessary, because although FK relationships
        do result in the remove of rows from hubs_tomerge, the deletion
        of rows from hub_deltas just inserts more rows.
    */

    DELETE FROM
        hub_deltas
    WHERE
        hub_id = OLD.id
    ;

END;


CREATE TRIGGER
    hubs_ad_1
AFTER DELETE ON
    hubs
FOR EACH ROW
BEGIN
    SELECT debug(
        OLD.id
    );

    DELETE FROM
        nodes
    WHERE
        id = OLD.id
    ;

END;
