package App::bif::push::issue;
use strict;
use warnings;
use feature 'state';
use Bif::Mo;
use DBIx::ThinSQL qw/concat qv/;

our $VERSION = '0.1.5_5';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $info = $self->get_node( $opts->{id}, 'issue' );
    my $dbw  = $self->dbw;

    $dbw->txn(
        sub {

            foreach my $path ( @{ $opts->{path} } ) {

                my $pinfo = $self->get_project($path);

                my $existing = $dbw->xval(
                    select     => 'ist.status',
                    from       => 'issues i',
                    inner_join => 'issues i2',
                    on         => 'i2.id = i.src_id',
                    inner_join => 'issue_status ist',
                    on         => {
                        'ist.id'         => \'i2.issue_status_id',
                        'ist.project_id' => $pinfo->{id},
                    },
                    where        => { 'i.id' => $info->{id} },
                    union_select => 'ist.status',
                    from         => 'issues i',
                    inner_join   => 'issue_status ist',
                    on           => {
                        'ist.id'         => \'i.issue_status_id',
                        'ist.project_id' => $pinfo->{id},
                    },
                    where => { 'i.src_id' => $info->{id} },
                );

                if ($existing) {
                    if ( $opts->{err_on_exists} ) {
                        return $self->err( 'DestinationExists',
                            "$opts->{id} already has status $path:$existing\n"
                        );
                    }
                    else {
                        print
                          "$opts->{id} already has status $path:$existing\n";
                        next;
                    }
                }

=cut

# Not yet sure what I should be doing here. Will comment it out until
# after the next issue reorganisation

                my @unsatisfied = map { $_->[0] } $dbw->xarrayrefs(
                    select        => 'p.path',
                    from          => 'project_issues pi',
                    inner_join    => 'projects p',
                    on            => 'p.id = pi.project_id',
                    inner_join    => 'hubs h',
                    on            => 'h.id = p.hub_id',
                    where         => { 'pi.issue_id' => $info->{id} },
                    except_select => 'p2.path',
                    from          => 'projects p',
                    inner_join    => 'hub_related_projects hrp',
                    on            => 'hrp.hub_id = p.hub_id',
                    inner_join    => 'projects p2',
                    on            => 'p2.id = hrp.project_id',
                    inner_join    => 'hubs h',
                    on            => 'h.id = p2.hub_id',
                    where         => { 'p.id' => $pinfo->{id} },
                );

                if (@unsatisfied) {
                    my $name = $dbw->xval(
                        select     => ['n.name'],
                        from       => 'nodes n',
                        inner_join => 'hubs h',
                        on         => 'h.id = p.hub_id',
                        where      => { 'n.id' => $pinfo->{id} },
                    );

                    @unsatisfied = join ', ', @unsatisfied;

                    return $self->err( 'NoCooperation',
                        "$path\@$name has no cooperation with @unsatisfied" );
                }
=cut

                $opts->{message} ||= $self->prompt_edit;

                $opts->{change_id} =
                  $self->new_change( parent_id => $info->{first_change_id}, );

                $opts->{message} //= 'junk';

                my $status_id = $dbw->xval(
                    select => 'id',
                    from   => 'issue_status',
                    where  => {
                        project_id => $pinfo->{id},
                        def        => 1,
                    },
                );

                my $id = $dbw->nextval('nodes');

                $dbw->xdo(
                    insert_into => [
                        'func_new_issue', qw/change_id id src_id
                          issue_status_id title /
                    ],
                    select => [
                        qv( $opts->{change_id} ), qv($id),
                        qv( $info->{id} ),        qv($status_id),
                        'i.title'
                    ],
                    from  => 'issues i',
                    where => {
                        'i.id' => $info->{id},
                    },
                );

                my $src = $dbw->xval(
                    select => 'n.path',
                    from   => 'nodes n',
                    where  => { 'n.id' => $info->{id}, },
                );

                my $dest = $dbw->xval(
                    select => 'n.path',
                    from   => 'nodes n',
                    where  => { 'n.id' => $id, },
                );

                $self->end_change(
                    id               => $opts->{change_id},
                    action_format    => "push issue $src (%s) $dest (%s)",
                    action_node_id_1 => $info->{id},
                    action_node_id_2 => $pinfo->{id},
                    message          => "[ forked: $src -> $dest ]\n\n"
                      . $opts->{message},
                );

            }
        }
    );

    return $self->ok('PushIssue');
}

1;
__END__

=head1 NAME

=for bif-doc #sync

bif-push-issue - push an issue to another project

=head1 VERSION

0.1.5_5 (2015-08-13)

=head1 SYNOPSIS

    bif push issue ID PATH [OPTIONS...]

=head1 DESCRIPTION

The B<bif-push-issue> command is used to modify the relationship
between a node and a previously unrelated project. The type of the
node being pushed determines the type of relationship changes that are
possible.

Pushing an issue for example "shares" that node with another project.
Comments made in any project for that issue will appear everywhere
else, but status changes are project-specific.  In order for that to be
possible however, the destination project must already be cooperating
with all of the projects already associated with the issue.

=head1 ARGUMENTS & OPTIONS

=over

=item ID

An issue ID. Required.

=item PATH

The destination project PATH. Required.

=item --error-on-exists

Raise an error in the event the issue already exists at the destination
project.

=item --message, -m MESSAGE

The push message if desired.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

