package App::bif::list::hubs;
use strict;
use warnings;
use Bif::Mo;
use Term::ANSIColor qw/color/;

our $VERSION = '0.1.5_5';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $db   = $self->db;

    DBIx::ThinSQL->import(qw/ qv concat/);

    my $data = $db->xarrayrefs(
        select     => [ 'n.kind', 'h.id', 'n.path', 'h.location', ],
        from       => 'hubs h',
        inner_join => 'nodes n',
        on         => 'n.id = h.id',
        order_by => [ 'n.path', 'h.location' ],
    );

    return $self->ok('ListHubs') unless $data;

    $self->start_pager( scalar @$data );

    print $self->render_table( ' l r  l  l ',
        [ 'Type', 'ID', 'Path', 'Location' ], $data );

    return $self->ok('ListHubs');
}

1;
__END__

=head1 NAME

=for bif-doc #list

bif-list-hubs - list hubs registered with current repository

=head1 VERSION

0.1.5_5 (2015-08-13)

=head1 SYNOPSIS

    bif list hubs

=head1 DESCRIPTION

Lists the hubs associated with the current repository.

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

