CREATE TABLE change_topics(
    change_id INTEGER NOT NULL,
    topic_id INTEGER NOT NULL,
    merkled INTEGER NOT NULL DEFAULT 0,
    hub_change INTEGER NOT NULL DEFAULT 0,
    project_change INTEGER NOT NULL DEFAULT 0,
    PRIMARY KEY(change_id,topic_id) ON CONFLICT IGNORE,
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(topic_id) REFERENCES topics(id) ON DELETE CASCADE
) WITHOUT ROWID;


CREATE TRIGGER
    change_topics_bu_1
BEFORE UPDATE OF
    merkled
ON
    change_topics
FOR EACH ROW WHEN
    NEW.merkled = 1
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.topic_id,
        NEW.merkled
    );
/*
    INSERT OR IGNORE INTO
        hub_changes(
            hub_id,
            prefix,
            change_id
        )
    SELECT
        ph.hub_id,
        SUBSTR(c.uuid, 1, 1),
        NEW.change_id
    FROM
        topics_tree tt
    INNER JOIN
        project_hubs ph
    ON
        ph.project_id = tt.parent
    INNER JOIN
        changes c
    ON
        c.id = NEW.change_id
    WHERE
        tt.child = NEW.topic_id
    ;

    DELETE FROM
        change_topics
    WHERE
        change_id = NEW.change_id AND
        topic_id = NEW.topic_id
    ;

    SELECT RAISE(IGNORE);
*/
END;
