CREATE TABLE func_import_new_project(
    parent_uuid VARCHAR(40),
    name VARCHAR(40) NOT NULL,
    title VARCHAR(1024) NOT NULL,
    uuid VARCHAR(40)
);


CREATE TRIGGER
    func_import_new_project_bi_1
BEFORE INSERT ON
    func_import_new_project
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.parent_uuid,
        NEW.name,
        NEW.title,
        NEW.uuid
    );

    INSERT INTO
        func_new_project(
            change_id,
            id,
            parent_id,
            name,
            title,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('topics'),
        pp.id,
        NEW.name,
        NEW.title,
        NEW.uuid
    FROM
        (SELECT 1)
    LEFT JOIN
        topics pp
    ON
        pp.uuid = NEW.parent_uuid
    ;

    SELECT RAISE(IGNORE);
END;
