package Bif::Sync::Plugin::Project;
use strict;
use warnings;
use DBIx::ThinSQL qw/qv sq/;
use Log::Any '$log';

our $VERSION = '0.1.5_4';

sub Bif::Sync::real_import_project {
    my $self   = shift;
    my $result = $self->recv_changesets;
    return 'ProjectImported' if $result eq 'RecvChangesets';
    return $result;
}

sub Bif::Sync::real_transfer_project_related_changes {
    my $self = shift;

    my $tmp   = $self->temp_table;
    my $total = $self->db->xval(
        select => 'COUNT(t.id)',
        from   => "$tmp t",
    );

    my $r = $self->exchange_changesets(
        $total,
        [
            select   => 't.id AS id',
            from     => "$tmp t",
            order_by => 't.id ASC',
        ],
    );

    $self->db->xdo( delete_from => $tmp );

    return $r unless $r eq 'ExchangeChangesets';
    return 'TransferProjectRelatedChanges';
}

sub Bif::Sync::real_export_project {
    my $self = shift;
    my $id   = shift;

    my $total = $self->db->xval(
        select => 'p.num_changes',
        from   => 'projects p',
        where  => { 'p.id' => $id },
    );

    my $recv = $self->send_changesets(
        $total,
        [
            select => 'pc.change_id AS id',
            from   => 'project_changes pc',
            where  => {
                'pc.project_id'  => $id,
                'pc.change_id !' => undef,
            },
            order_by => 'pc.change_id ASC',
        ]
    );

    return 'ProjectExported' if $recv eq 'ChangesetsSent';
    return $recv;
}

1;

=head1 NAME

=for bif-doc #perl

Bif::Sync::Plugin::Project - synchronisation plugin for projects

