package App::bif::show::version;
use strict;
use warnings;
use App::bif::Build;
use Bif::Mo;

our $VERSION = '0.1.5_4';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;

    print "version:   $App::bif::Build::VERSION\n"
      . "commit:    $App::bif::Build::COMMIT\n"
      . "built:     $App::bif::Build::DATE\n\n";

    print "bin:       $0\n" . "lib:       $App::bif::Build::FILE\n"
      unless defined &static::find;

    my $user_repo = eval { $self->user_repo };
    printf "user_repo: %s\n", $@ ? '(not found)' : $user_repo;

    my $repo = eval { $self->repo };
    printf "repo:      %s\n", ref $@ ? '(not found)' : $repo;

    return $self->ok('ShowVersion');
}

1;
__END__

=head1 NAME

=for bif-doc #show

bif-show-version - display bif version information

=head1 VERSION

0.1.5_4 (2015-08-04)

=head1 SYNOPSIS

    bif show version [OPTIONS...]

=head1 DESCRIPTION

The B<bif-show-version> command displays bif version and build
information.

=head1 SEE ALSO

L<bif>(1), L<App::bif::Build>

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

