CREATE TABLE func_import_identity(
    name VARCHAR,
    shortname VARCHAR,
    contact_uuid VARCHAR(40),
    default_contact_method_uuid VARCHAR(40),
    uuid VARCHAR(40)
);

CREATE TRIGGER
    func_import_identity_bi_1
BEFORE INSERT ON
    func_import_identity
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.name,
        NEW.shortname,
        NEW.contact_uuid,
        NEW.default_contact_method_uuid,
        NEW.uuid
    );

    INSERT INTO
        func_new_identity(
            change_id,
            id,
            name,
            shortname,
            contact_id,
            default_contact_method_id,
            uuid
        )
    VALUES(
        currval('changes'),
        nextval('topics'),
        NEW.name,
        NEW.shortname,
        NEW.contact_uuid,
        NEW.default_contact_method_uuid,
        NEW.uuid
    );

    SELECT RAISE(IGNORE);
END;
