CREATE TABLE func_import_hub_repo(
    hub_uuid VARCHAR(40) NOT NULL,
    location VARCHAR NOT NULL,
    uuid VARCHAR(40)
);


CREATE TRIGGER
    func_import_hub_repo_bi_1
BEFORE INSERT ON
    func_import_hub_repo
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.hub_uuid,
        NEW.location,
        NEW.uuid
    );

    INSERT INTO
        func_new_hub_repo(
            change_id,
            id,
            hub_id,
            location,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('topics'),
        h.id,
        NEW.location,
        NEW.uuid
    FROM
        topics h
    WHERE
        h.uuid = NEW.hub_uuid
    ;

    SELECT RAISE(IGNORE);
END;
