package App::bif::update::hub;
use strict;
use warnings;
use Bif::Mo;

our $VERSION = '0.1.5_3';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $dbw  = $self->dbw;
    my $info = $self->get_hub( $opts->{id} ? $opts->{id} : $opts->{name} );

    if ( $opts->{reply} ) {
        my $uinfo =
          $self->get_change( $opts->{reply}, $info->{first_change_id} );
        $opts->{parent_uid} = $uinfo->{id};
    }
    else {
        $opts->{parent_uid} = $info->{first_change_id};
    }

    $opts->{message} ||= $self->prompt_edit( opts => $self );

    $dbw->txn(
        sub {
            $opts->{change_id} =
              $self->new_change( parent_id => $opts->{parent_uid} );

            $dbw->xdo(
                insert_into => 'func_update_hub',
                values      => {
                    change_id => $opts->{change_id},
                    id        => $info->{id},
                    name      => $opts->{name},
                    title     => $opts->{title},
                },
            );

            my $path = $dbw->xval(
                select => 'path',
                from   => 'topic_path tp',
                where  => { 'tp.id' => $opts->{id} },
            );

            $self->end_change(
                id                => $opts->{change_id},
                action_format     => "update hub $path (%s)",
                action_topic_id_1 => $info->{id},
                message           => $opts->{message},
            );

        }
    );

    return $self->ok('ChangeHub');
}

1;
__END__

=head1 NAME

=for bif-doc #modify

bif-update-hub - update or comment a hub

=head1 VERSION

0.1.5_3 (2015-06-30)

=head1 SYNOPSIS

    bif update hub ID [OPTIONS...]

=head1 DESCRIPTION

The B<bif-update-hub> command adds a comment to a hub, possibly setting
a new name at the same time.

=head1 ARGUMENTS & OPTIONS

=over

=item ID

An hub ID, required.

=item --name, -n

The new name for the hub.

=item --message, -m

The message describing this change in detail.

=back

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

