/*
    This table exists to allow a mapping from changes back to
    $TOPIC_deltas without having to query every delta table looking for
    matches. It lets callers do the reverse of INSERT INTO func_blah,
    namely create what would be the input to import_new_task...
*/
CREATE TABLE deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    action VARCHAR NOT NULL,
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE
);

CREATE INDEX deltas_change_id ON deltas(change_id);

