CREATE TABLE func_import_issue(
    issue_status_uuid VARCHAR(40) NOT NULL,
    src_uuid VARCHAR(40),
    title VARCHAR(1024) NOT NULL,
    uuid VARCHAR(40) NOT NULL
);


CREATE TRIGGER
    func_import_issue_bi_1
BEFORE INSERT ON
    func_import_issue
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.issue_status_uuid,
        NEW.title,
        NEW.src_uuid,
        NEW.uuid
    );

    INSERT INTO
        func_new_issue(
            change_id,
            id,
            issue_status_id,
            title,
            src_id,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('topics'),
        ist.id,
        NEW.title,
        s.id,
        NEW.uuid
    FROM
        topics ist
    LEFT JOIN
        topics s
    ON
        s.uuid = NEW.src_uuid
    WHERE
        ist.uuid = NEW.issue_status_uuid
    ;

    SELECT RAISE(IGNORE);
END;
