CREATE TABLE func_import_project_delta(
    update_uuid VARCHAR(40) NOT NULL,
    project_uuid VARCHAR(40) NOT NULL,
    parent_uuid VARCHAR(40),
    status_uuid VARCHAR(40),
    hub_uuid VARCHAR(40),
    name VARCHAR(40),
    title VARCHAR(1024)
);


CREATE TRIGGER
    func_import_project_delta_bi_1
BEFORE INSERT ON
    func_import_project_delta
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.update_uuid,
        NEW.project_uuid,
        NEW.parent_uuid,
        NEW.status_uuid,
        NEW.hub_uuid,
        NEW.name,
        NEW.title
    );

    INSERT INTO
        func_update_project(
            update_id,
            id,
            parent_id,
            status_id,
            hub_uuid,
            name,
            title
        )
    SELECT
        u.id,
        projects.id,
        parents.id,
        project_status.id,
        NEW.hub_uuid,
        NEW.name,
        NEW.title
    FROM
        topics AS projects
    INNER JOIN
        updates u
    ON
        u.uuid = NEW.update_uuid
    LEFT JOIN
        topics AS parents
    ON
        parents.uuid = NEW.parent_uuid
    LEFT JOIN
        topics AS project_status
    ON
        project_status.uuid = NEW.status_uuid
    WHERE
        projects.uuid = NEW.project_uuid
    ;

    SELECT RAISE(IGNORE);
END;
