/*
 * "The Road goes ever on and on, down from the door where it began."
 */

#ifdef OEMVS
#pragma runopts(HEAP(1M,32K,ANYWHERE,KEEP,8K,4K))
#endif


#include "EXTERN.h"
#include "perl.h"

static void xs_init _((void));
static PerlInterpreter *my_perl;

int
#ifdef CAN_PROTOTYPE
main(int argc, char **argv, char **env)
#else
main(argc, argv, env)
int argc;
char **argv;
char **env;
#endif
{
    int exitstatus;

#ifdef USE_THREADS
    MUTEX_INIT(&malloc_mutex); 
#endif

    PERL_SYS_INIT(&argc,&argv);

    perl_init_i18nl10n(1);

    if (!do_undump) {
	my_perl = perl_alloc();
	if (!my_perl)
	    exit(1);
	perl_construct( my_perl );
	perl_destruct_level = 0;
    }

    exitstatus = perl_parse( my_perl, xs_init, argc, argv, (char **) NULL );
    if (!exitstatus) {
	exitstatus = perl_run( my_perl );
    }

    perl_destruct( my_perl );
    perl_free( my_perl );

    PERL_SYS_TERM();

    exit( exitstatus );
    return exitstatus;
}

/* Register any extra external extensions */

/* Do not delete this line--writemain depends on it */

static void
xs_init(void)
{
  dXSUB_SYS;
}
