#!/bin/bash

. "$(dirname "$0")/config.sh"

if [ "$syntax" = "postgres" ]; then

  run_sys_sql <<EOF
CREATE DATABASE $db WITH TEMPLATE=template0 ENCODING = 'UTF8';
EOF
  run_sql -f "$pmltq_dir/sql/init_postgres.sql"
  run_sql -f "$pmltq_dir/sql/pml2base_init-pg.sql"

elif [ "$syntax" = "oracle" ]; then
  
  run_sys_sql <<EOF
CREATE USER $user PROFILE "DEFAULT" IDENTIFIED BY "$password" DEFAULT TABLESPACE "USERS" TEMPORARY TABLESPACE "TEMP" ACCOUNT UNLOCK;
GRANT CREATE session TO $user;
GRANT "CONNECT" TO $user;
GRANT "RESOURCE" TO $user;
quit
EOF

  echo quit | run_sql @ "$pmltq_dir/sql/init_oracle.sql"
  echo quit | run_sql @ "$pmltq_dir/sql/pml2base_init.sql"

fi

[ -n "$config_cleanup" ] && eval "$config_cleanup"

exit 0;

