use v6;
use Test;

use OWL::IRI;
use OWL::Ontology;

#-------------------------------------------------------------------------------
OWL::IRI.prefix( prefix => 'my-ont', local-name => 'file://my-ont/OWL#');
OWL::IRI.prefix(local-name => 'file://Perl6/Projects/OWL#');

my OWL::Ontology $o .= new(:iri('file://Perl6/Projects/OWL#'));

#-------------------------------------------------------------------------------
subtest {
  isa-ok $o, 'Ontology', 'Object Ontology';

  # Axioms is an array of which the first entry is always a declaration
  #
  my $axioms = $o.axioms{'http://www.w3.org/2002/07/owl#thing'};
  isa-ok $axioms[0], 'Declaration', 'owl:thing is a declaration';
  is $axioms[0].get-type, 'class', 'owl:thing is a class declaration';
  isa-ok $axioms[0].get-entity, 'Entity', 'owl:thing is an Entity';
  isa-ok $axioms[0].get-entity, 'Class', 'owl:thing is also a Class';

  my Str $iri-string = $axioms[0].get-entity.get-iri.Str;
  is $iri-string, 'http://www.w3.org/2002/07/owl#thing', "IRI is $iri-string";

  $axioms = $o.axioms{'http://www.w3.org/2002/07/owl#top-data-property'};
  is $axioms[0].get-type, 'data-property', 'owl:top-data-property is a data-property declaration';
#  todo 'Class DataProperty not defined yet', 1;
  isa-ok $axioms[0].get-entity, 'DataProperty', 'owl:top-object-property is a DataProperty';

  $axioms = $o.axioms{'http://www.w3.org/2000/01/rdf-schema#literal'};
  is $axioms[0].get-type, 'data-type', 'rdfs:literal is a data-type declaration';
#  todo 'Class DataType not defined yet', 1;
  isa-ok $axioms[0].get-entity, 'DataType', 'rdfs:literal is a DataType';

  $axioms = $o.axioms{'http://www.w3.org/2002/07/owl#top-object-property'};
  isa-ok $axioms[0].get-entity, 'ObjectProperty', 'owl:top-object-property is an ObjectProperty';

}, 'Ontology tests';

#-------------------------------------------------------------------------------
subtest {
  $o.declaration( [ class => <person my-ont:human> ] );

  my $axioms = $o.axioms{'file://Perl6/Projects/OWL#person'};
  is $axioms[0].get-type, 'class', 'person is a class declaration';

  $axioms = $o.axioms{'file://my-ont/OWL#human'};
  is $axioms[0].get-type, 'class', 'my-ont:human is a class declaration';

  nok $o.declaration( [ class => <nex:non-exist> ] ), 'Unknown prefix error';
  nok $o.declaration( [ unknown => 'x' ] ), 'Unknown type error';

  $o.declaration( [ data-property => <age> ] );
  nok $o.declaration( [ data-type => <age> ] ), 'Redefine error';

  $o.declaration( [ named-individual => <Bill Mary> ] );
  $axioms = $o.axioms{'file://Perl6/Projects/OWL#Bill'};
  is $axioms[0].get-type, 'named-individual', 'Bill is a named-individual declaration';
#  todo 'Class NamedIndividual not defined yet', 1;
  isa-ok $axioms[0].get-entity, 'NamedIndividual', 'Bill is a NamedIndividual';

}, 'declaration tests';

#-------------------------------------------------------------------------------
subtest {

  $o.sub-class-of( [ person => <woman man father mother> ] );
  $o.sub-class-of( [ person => <mother> ] );
}, 'sub class tests';

#-------------------------------------------------------------------------------
subtest {

  $o.class-assertion( [ person => 'Mary' ] );
  $o.class-assertion( [ person => 'Mary' ] );
}, 'class assertion tests';

#-------------------------------------------------------------------------------
# Cleanup
#
done();
exit(0);
