use v6;
use Test;

use Decimal;
use Decimal::D128;

#-------------------------------------------------------------------------------
subtest 'encode decimal128', {
  my Decimal::D128 $d128 .= new(:num(Inf));
  my Buf $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78,
  ), 'Inf ok';

  $d128 .= new(:num(-Inf));
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8,
  ), '-Inf ok';

  $d128 .= new(:num(NaN));
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c
  ), 'quiet NaN ok';

#`{{
  $d128 .= new(:str<-NaN>);
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
#??    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc
  ), 'signalling NaN ok';
}}

  $d128 .= new(:str<0>);
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x22,
  ), '0';

  $d128 .= new(:str<0000.00000e0>);
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x22,
  ), '0000.00000e0';

  $d128 .= new(:str<1>);
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x22,
  ), '1';

  $d128 .= new(:str<1e-10>);
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x05, 0x22,
  ), '1e-10';

  $d128 .= new(:str('9.999999999999999999999999999999999e6144'));
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0xff, 0xfc, 0xf3, 0xcf, 0x3f, 0xff, 0xfc, 0xf3,
    0xcf, 0x3f, 0xff, 0xfc, 0xf3, 0xcf, 0xff, 0x77,
  ), '9.999999999999999999999999999999999e6144';

  $d128 .= new(:str('1e-6143'));
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x08, 0x00,
  ), '1e-6143';

  $d128 .= new(:str('0.000000000000000000000000000000001e-6143'));
  $b = $d128.encode;
  is-deeply $b, Buf.new(
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  ), '0.000000000000000000000000000000001e-6143';
}

#-------------------------------------------------------------------------------
subtest 'encode exceptions', {
  throws-like {
    my Decimal::D128 $d128 .= new(:str<1e6145>);
    $d128.encode;
  }, X::Decimal, :message(/:s exponent too large/);

  throws-like {
    my Decimal::D128 $d128 .= new(:str<1e-7145>);
    $d128.encode;
  }, X::Decimal, :message(/:s exponent too small/);

  throws-like {
    my Decimal::D128 $d128 .= new(:str<2347652347652345762347652376452345237465>);
    $d128.encode;
  }, X::Decimal, :message(/:s coefficient too big/);
}

#-------------------------------------------------------------------------------
done-testing;


#done-testing;
#=finish
