use strict;
BEGIN { $^W = 1 } # use warnings in Perl 5.6 parlance
use ExtUtils::MakeMaker qw( prompt WriteMakefile );
use Config ();
use Getopt::Long();
use Data::Dumper ();

my $TESTDB  = "test";

use vars qw($opt);
$opt =
  { "help" => \&Usage,
  };
Getopt::Long::GetOptions($opt, "help", "testdsn=s", "testuser=s","testpassword=s");
my $source = {};

foreach my $key (qw/testdsn testuser testpassword/) {
  Configure($opt, $source, $key);
}

print <<"MSG";
I will use the following settings for compiling and testing:

MSG

delete $opt->{'help'};
my $keylen = 0;
foreach my $key (keys %$opt) {
  $keylen = length($key) if length($key) > $keylen;
}
my $slen = 0;
foreach my $val (values %$source) {
  $slen = length($val) if length($val) > $slen;
}
foreach my $key (sort { $a cmp $b} keys %$opt) {
  printf("  %-" . $keylen . "s (%-" . $slen . "s) = %s\n",
	 $key, $source->{$key}, $opt->{$key})
}

print <<"MSG";

To change these settings, see 'perl Makefile.PL --help'.

MSG

#sleep 5;

eval { require File::Spec };
my $fileName = $@ ?
  "t/cgi-uploader.config" : File::Spec->catfile("t", "cgi-uploader.config");
die "Failed to determine location of $fileName" unless -f $fileName;

if (open(FILE, ">$fileName")) {
    print FILE '$dsn      = q!'.$opt->{testdsn}."!;\n";
    print FILE '$user     = q!'.$opt->{testuser}."!;\n";
    print FILE '$password = q!'.$opt->{testpassword}."!;\n";
	print FILE "1;\n";
    close(FILE) or die "Failed to create $fileName: $!";
}

sub Configure {
    my($opt, $source, $param) = @_;

    if (exists($opt->{$param})) {
        $source->{$param} = "Users choice";
        return;
    }
    elsif ($param eq "testuser"  || $param eq "testpassword" || 
             $param eq "testdsn") {
        $source->{$param} = "default";
        $opt->{$param} = "";
    } else {
        die "Unknown configuration parameter: $param";
    }
}


sub Usage {
  print STDERR <<"USAGE";
Usage: perl $0 [options]

Possible options are:

  --testdsn=<dsn>         Use the DBI datasource <dsn> for running the test suite

	  Postgres Example:
	   dbi:Pg:dbname=\$db;host=\$host;username=\$user;password=\$pw

	  MySQL Example:
	   DBI:mysql:database=\$db;host=\$hostname

 --testuser=<user>	

 --testpassword=<password>	

  --help                 Print this message and exit

  Tables named "uploads" and "cgi_uploader_test"  will be created and then
  removed.  If a table by that name already exists, the tests will be skipped.

USAGE
  exit 1;
}



use 5.005;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'		=> 'CGI::Uploader',
    'VERSION_FROM'	=> 'lib/CGI/Uploader.pm', # finds $VERSION
    'PREREQ_PM'		=> {
		'CGI::Carp' 		  => 0,
		'Params::Validate'    => 0,
        'DBI'                 => 0,
        'CGI'                 => 0,
		'File::Copy'		  => 0,
		'SQL::Abstract'	      => 0,
		'Image::Magick'		  => 0,
        'Test::DatabaseRow'   => 0,
	}, 
    ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
      (
		  #ABSTRACT_FROM => 'lib/CGI/Uploader.pm', # retrieve abstract from module
       AUTHOR     => 'Mark Stosberg <mark@summersault.com>') : ()),
);


