use ExtUtils::MakeMaker;

use 5.008;

WriteMakefile
 ( NAME	 	=> 'XML::Compile'
 , VERSION	=> '1.06'

 , PREREQ_PM    =>
   { XML::LibXML               => 1.65
   , XML::Compile::Tester      => 0.05
   , XML::RegExp               => 0.02
   , IO                        => 1.22
   , Log::Report               => 0.21

   , Math::BigInt              => 1.77
   , Math::BigRat              => 0.10
   , bignum                    => 0.10
   , Digest::MD5               => 2.36
   , List::Util                => 0

   , Test::More                => 0.54
   , Test::Deep                => 0.095
   , Test::Pod                 => '1.00'
   }

 , EXE_FILES    =>
   [ 'bin/xml2yaml'
   , 'bin/schema2example'
   ]
 , AUTHOR       => 'Mark Overmeer'
 , ABSTRACT     => 'Compilation based XML processing'
 , LICENSE      => 'perl'
 );

### used by oodist during production of distribution
sub MY::postamble { <<'__POSTAMBLE' }

# for DIST
RAWDIR          = ../public_html/xml-compile/raw
DISTDIR         = ../public_html/xml-compile/source
LICENSE         = artistic
SKIP_LINKS	= XML::LibXML

# for POD
EXTENDS		= ../XMLSOAP:../XMLSOAP12:../XMLDaemon:../XMLDumper:../XMLCache:../XMLSimple:../XMLTester:../XMLRewrite
FIRST_YEAR      = 2006
EMAIL           = perl@overmeer.net
WEBSITE         = http://perl.overmeer.net/xml-compile/
PODTAIL		= ../XML-shared-podtail

# for HTML
HTML_OUTPUT     = ../public_html/xml-compile/html
HTML_DOCROOT    = /xml-compile/html
HTML_PACKAGE    = ../public_html/xml-compile/htmlpkg

__POSTAMBLE
