#!/usr/bin/perl
#
# Encoding and Decoding of 8bit
#

use Test::More;
use strict;
use warnings;

use lib qw(. t);

use Mail::Message::Body::Lines;
use Mail::Message::TransferEnc::EightBit;
use Tools;

BEGIN { plan tests => 6 }

my $decoded = <<DECODED;
yefoiuhsjhkw284Ue\000iouoi\013wei
sdfuljlkjliua\000aba
DECODED

my $encoded = <<ENCODED;
yefoiuhsjhkw284Ueiouoiwei
sdfuljlkjliuaaba
ENCODED

my $codec = Mail::Message::TransferEnc::EightBit->new;
ok(defined $codec);
is($codec->name, '8bit');

# Test encoding

my $body   = Mail::Message::Body::Lines->new
  ( mime_type => 'text/html'
  , data      => $decoded
  );

my $enc    = $codec->encode($body);
ok($body!=$enc);
is($enc->mimeType, 'text/html');
is($enc->transferEncoding, '8bit');
is($enc->string, $encoded);

# Test decoding

