# Copyrights 2007-2015 by [Mark Overmeer].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.01.
package Dancer2::Logger::LogReport;
use vars '$VERSION';
$VERSION = '1.06';

# ABSTRACT: Dancer2 logger engine for Log::Report

use strict;
use warnings;

use Moo;
use Dancer2::Core::Types;
use Scalar::Util qw/blessed/;
use Log::Report  'logreport', syntax => 'REPORT', mode => 'DEBUG';

our $AUTHORITY = 'cpan:MARKOV';

my %level_dancer2lr =
  ( core  => 'TRACE'
  , debug => 'TRACE'
  );

with 'Dancer2::Core::Role::Logger';

# Set by calling function
has dispatchers =>
  ( is    => 'ro'
  , isa   => Maybe[HashRef]
  , lazy  => 1
  );

sub BUILD
{   my $self = shift;
    my $dispatchers = $self->dispatchers;

    foreach my $name (keys %$dispatchers)
    {   my %dispatcher = %{$dispatchers->{$name}};
        my $type       = delete $dispatcher{type};
        dispatcher $type => $name, %dispatcher;
    }
}


sub log($$$)
{   my ($self, $level, $params) = @_;

    # all dancer levels are the same as L::R levels, except:
    my $msg;
    if(blessed $params && $params->isa('Log::Report::Message'))
    {   $msg = $params;
    }
    else
    {   $msg = $self->format_message($level => $params);
        $msg =~ s/\n+$//;
    }

    # The levels are nearly the same.
    my $reason = $level_dancer2lr{$level} // uc $level;

    report {is_fatal => 0}, $reason => $msg;

    undef;
}
 
#--------------

1;
