package Egg::Helper::Welcom::Japanese;
#
# Copyright 2006 Bee Flag, Corp. All Rights Reserved.
# Masatoshi Mizuno E<lt>mizunoE<64>bomcity.comE<gt>
#
# $Id$
#
use strict;
use base qw/Egg::Helper::Welcom/;

our $VERSION= '0.01';

sub content {
	my($class, $e)= @_;
	my $title= $class->title($e);
	my $project= $class->project($e);
	my $egg_label= $class->label($e);
	my $eggurl= $class->egg_url($e);
	my $footer= $class->footer($e);
	my $project_name= $e->namespace;
	my $style= $class->style($e);
	<<END_OF_CONTENT;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<title>$title</title>
<head>
<meta http-equiv="Content-Language" content="ja" />
<meta http-equiv="Content-Type" content="text/html; charset=euc-jp" />
<style type="text/css">
$style
</style>
</head>
<body>
<div id="container">
<div id="banner">
<img src="/images/egg_logo.png" width="236" height="73" alt="Egg - WEB application framework." />
<div>
ǤȤޤ<br />
β̤ɽƤȤϡ˵ΥС Egg - WEB application framework. ưƤޤ
</div>
</div>
<h1>$title</h1>
<div id="project">$project</div>
<div id="content">
<p>ǤϡΥץȤ dispatch ĥޤ礦</p>
<p>Ϥ controller ܤ̤Ʋեξ [MYPROJECT]/lib/$project_name.pm Ǥ</p>
<pre>
 use Egg qw/-Debag Filter::EUC_JP/;
</pre>
<p>ǥեȤǤ Egg ɤ߹ϤʤäƤޤ</p>
<p>-Debug ϥǥХå⡼ɤư̣ޤƬ '-' ǻϤޤΤƥե饰Ȥưޤ</p>
<p> Filter::EUC_JP ϥץ饰 require ¾ν Egg ưǹԤޤ
 ץ饰̾ 'Egg::Plugin' 򽤾饹̾ɾޤ
 Ĥޤꤳξ Egg::Plugin::Filter::EUC_JP ɤ߹ޤޤ<br />
 ʤߤˤΥץ饰ϥꥯȥ꡼ͤʥǡˤԤ٤ΤΤǤ<br >
 \&nbsp; ܤ Egg::Plugin::Filter::EUC_JP ΥɥȤ
</p>
<p> dispatch ܤ̤Ʋեξ [MYPROJECT]/lib/$project_name/D.pm Ǥ</p>
<p> dispatch  despacth_map ᥽åɤ URI١ΥȥδΤˤʤޤ</p>
<p> despacth_map ǲԤɤޤ [MYPROJECT]/lib/$project_name/D/Root.pm ˽ϰܤޤ
줬 sub-despacth ˤʤޤϤޤǥǥեȤưǤä Root.pm ʳ sub-despacth Ƥֻޤ
<pre>
 package $project_name\::D;
 use strict;
 
 sub despacth_map {
   my(\$dispat, \$e)= \@_;

   return qw{ Root };
   #  D::Root->_default ƤӽФޤ
   # ˥ȤΥ롼ȥƥĤϤ٤˻ȤˤʤȻפޤ
   # D::Root->_default ƤФ D::Root->_begin ˸ƤФ졢
   # D::Root->_default νλ D::Root->_end ƤФޤ

   return qw{ Root help };
   #  D::Root->help ƤӽФޤ

   return qw{ Hoge content };
   #  D::Hoge->content
   # ξ D::Hoge ȤʤꡢD::Hoge->_begin θƤӽФߤޤ줬
   # 줿 D::Root->_begin ƤӽФޤǽã D Ǥ D::_begin 
   # ϲԤޤ󡣤Τ褦˵ _begin õ褦ư򤷤ޤ
   #  D::Hoge->_end ƱͤԤޤ

   return qw{ Hoge::Foo admin }
   # ơ˿
   # ε D::Hoge::Foo Ǥ
   # D::Hoge::Foo->_begin  D::Hoge::->_begin  D::Root->_bebin νޤ
   # D::Hoge::Foo->_begin ƤӽФ D::Hoge::->_begin ȤʹߤϸƤФ
   # ޤ

   return \$dispat->_template( 'boo.tmpl' );
   # ϥƥץ졼ȤǤ
   # ξ D::Root ˤʤޤ D::Root->_default ϸƤФޤ

   return qw{ Hoge::Foo 0 }, \$dispat->_template( 'boo.tmpl' );
   #  D::Hoge::Foo ˤʤޤ
   # 裲̾᥽å̾ǤξϻꤷƤ̵̣ʤΤ 0 ˤƤޤ

   return \$e->finished( 404 );  # NOT_FOUND
   # λȥơɤ𤷤ƽλޤ
   # _begin , _end ʤɤθƤӽФƥ󥻥ˤʤޤ

   return \$e->redirect( 'http://domainname/hooo.html' );
   # Σգң̤ز̤žޤ
   # _begin  _end θƤӽФͭǤ

   return \$e->response->body( 'Hello world!' );
   # ƥĤľܽϤޤ

   \$e->response->body( 'Hello world!' );
   return qw{ Hoge::Foo };
   # ƥĤľܽϤꤷޤ

 }
</pre>

<p>ޤȤƤޤ</p>
<p>ͤѤߤξ dispatch ο񤤤Ѥޤ</p>
<ul>
 <li><b>\$e->finished( response_code )</b><br />
  Ƥ sub-dispatch ϥ󥻥ˤʤޤ
 </li>
 <li><b>\$e->response->body, \$e->template, \$e->response->redirect ...</b><br />
  _default ¾sub-dispatch ᥽åɤθƤӽФϥ󥻥뤷ޤ _begin  _end ϸƤФޤ
 </li>
 <li><b>\$e->response->body</b><br />
  ĤǤǤ... VIEW ν⥭󥻥ˤʤޤ
 </li>
</ul>

<p> sub-dispatch Ǥ</p>
<pre>
 package $project_name\::D::Root;
 use strict;
 use Egg::Const;   # 쥹ݥ󥹥ɤͤ˸䤹񤯰٤...
 
 # sub-dispatch γƥ᥽åɤϤ裱 dispatch Ȱäơ֥
 # ȤǤϤޤ󡣸ƤӽФ줿ΤΥ饹̾Ϥޤ
 # dispatch ֥Ȥɬפʤ \$e->dispatch  \$e->d ȤäƲ
 
 sub _begin {
   my(\$class, \$e)= \@_;
   ....
   # ϻ˹ԤäƤǤ
 }
 sub _default {
   my(\$class, \$e)= \@_;
   # sub-dispatch νؤɤξƥץ졼ȤǴλ
   # פޤ VIEW  HTML::Template ʤɤΥѥ᡼ʤ
   # ΤΤѤϥѥ᡼Ԥˤʤޤ
 
   my \$param= \$e->request->params;
   \$e->view->param( 'param1'=> \$param->{param1} );
     
   \$e->stash->{param1}= \$param->{param1};
 
   ........... ɬפʽ...
 
   return \$e->template( 'hoge.tmpl' );
   # dispatch Ǥϥƥץ졼 dispatch->_template Ȥޤ
   #  sub-dispatch Ǥľܥƥץ졼ɤǤ
   # dispatch Ǥȥ顼ˤʤޤΤդƲ
 
   return \$e->response->body( 'Hello world!' );
   # ľܽƤƤ⹽ޤ
 
   return \$e->response->redirect( 'http://domainname/hoge.html' );
   # Σգң̤ز̤žޤ
 
   return \$e->finished( FORBIDDEN );
   # VIEW ˽Ϥꤷ쥹ݥ󥹥ɤǽλޤ
 }
 sub banban {
   my(\$class, \$e)= \@_;
 
   # ϥ桼Υ᥽åɡ
   # dispatch  '_' Ϥޤ̾Υ᥽åɤꤷƸƤֻϤǤ
   # 褦ˤʤäƤޤ
 
   return \$e->template( 'banban.tmpl' );
 }
 sub _end {
   my(\$class, \$e)= \@_;
   ....
   # ˤϻ...
 }
</pre>

<a href="$eggurl" target="_blank">
<img style="float:right;" src="/images/egg125x125.gif" width="125" height="125" alt="Egg - WEB application framework." /></a>

<p>⤦դƤȻפޤƥץ졼Ȥʤ sub-dispatch ˽ϤɬפϤޤ</p>
<p>³ <a href="$eggurl">Egg-Rlease - WEB application framework ۡڡ</a> </p>

<div class="footbanner">
<a href="$eggurl" target="_blank">
<img src="/images/egg80x15.gif" width="80" height="15" alt="Egg - WEB application framework." /></a>
<a href="$eggurl" target="_blank">
<img src="/images/egg224x33.gif" width="224" height="33" alt="Egg - WEB application framework." /></a>
</div>

</div>
$footer
</div>
<br />
</body>
</html>
END_OF_CONTENT
}

1;

__END__

=head1 NAME

Egg::Helper::Welcom::Japanese - Japanese default page.

=head1 SEE ALSO

L<Egg::Release>,
L<Egg::Helper::Script>,
L<Egg::Helper::Welcom>,

=head1 AUTHOR

Masatoshi Mizuno, E<lt>mizunoE<64>bomcity.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Bee Flag, Corp. E<lt>L<http://egg.bomcity.com/>E<gt>, All Rights Reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
