%module "Math::GSL::Multiroots"
%include "gsl_typemaps.i"

%typemap(in) gsl_multiroot_function * {
    gsl_multiroot_function *f;
    /* stub */
    $1 = &f;
}

%{
    #include "gsl/gsl_types.h"
    #include "gsl/gsl_multiroots.h"
%}

%include "gsl/gsl_types.h"
%include "gsl/gsl_multiroots.h"


%perlcode %{
@EXPORT_OK = qw/
               gsl_multiroot_fdjacobian 
               gsl_multiroot_fsolver_alloc 
               gsl_multiroot_fsolver_free 
               gsl_multiroot_fsolver_set 
               gsl_multiroot_fsolver_iterate 
               gsl_multiroot_fsolver_name 
               gsl_multiroot_fsolver_root 
               gsl_multiroot_fsolver_dx 
               gsl_multiroot_fsolver_f 
               gsl_multiroot_fdfsolver_alloc 
               gsl_multiroot_fdfsolver_set 
               gsl_multiroot_fdfsolver_iterate 
               gsl_multiroot_fdfsolver_free 
               gsl_multiroot_fdfsolver_name 
               gsl_multiroot_fdfsolver_root 
               gsl_multiroot_fdfsolver_dx 
               gsl_multiroot_fdfsolver_f 
               gsl_multiroot_test_delta 
               gsl_multiroot_test_residual 
               $gsl_multiroot_fsolver_dnewton
               $gsl_multiroot_fsolver_broyden
               $gsl_multiroot_fsolver_hybrid
               $gsl_multiroot_fsolver_hybrids
               $gsl_multiroot_fdfsolver_newton
               $gsl_multiroot_fdfsolver_gnewton
               $gsl_multiroot_fdfsolver_hybridj
               $gsl_multiroot_fdfsolver_hybridsj
             /;
%EXPORT_TAGS = ( all => [ @EXPORT_OK ] );

__END__

=head1 NAME

Math::GSL::Multiroots -Functions for multidimensional root-finding (solving nonlinear systems with n equations in n unknowns).

=head1 SYNOPSIS

This module is not yet implemented. Patches Welcome!

use Math::GSL::Multiroots qw /:all/;

=head1 DESCRIPTION

Here is a list of all the functions in this module :

=over 

=item * C<gsl_multiroot_fdjacobian >

=item * C<gsl_multiroot_fsolver_alloc >

=item * C<gsl_multiroot_fsolver_free >

=item * C<gsl_multiroot_fsolver_set >

=item * C<gsl_multiroot_fsolver_iterate >

=item * C<gsl_multiroot_fsolver_name >

=item * C<gsl_multiroot_fsolver_root >

=item * C<gsl_multiroot_fsolver_dx >

=item * C<gsl_multiroot_fsolver_f >

=item * C<gsl_multiroot_fdfsolver_alloc >

=item * C<gsl_multiroot_fdfsolver_set >

=item * C<gsl_multiroot_fdfsolver_iterate >

=item * C<gsl_multiroot_fdfsolver_free >

=item * C<gsl_multiroot_fdfsolver_name >

=item * C<gsl_multiroot_fdfsolver_root >

=item * C<gsl_multiroot_fdfsolver_dx >

=item * C<gsl_multiroot_fdfsolver_f >

=item * C<gsl_multiroot_test_delta >

=item * C<gsl_multiroot_test_residual >

=back

For more informations on the functions, we refer you to the GSL offcial
documentation: L<http://www.gnu.org/software/gsl/manual/html_node/>

Tip : search on google: site:http://www.gnu.org/software/gsl/manual/html_node/ name_of_the_function_you_want


=head1 AUTHORS

Jonathan Leto <jonathan@leto.net> and Thierry Moisan <thierry.moisan@gmail.com>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2008 Jonathan Leto and Thierry Moisan

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

%}
