use 5.007003;
use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
	module_name        => 'Sys::Mmap::Simple',
	license            => 'perl',
	dist_author        => 'Leon Timmermans <leont@cpan.org>',
	dist_version_from  => 'lib/Sys/Mmap/Simple.pm',
	configure_requires => {
		'Module::Build'=> 0,
	},
	build_requires => {
		'ExtUtils::CBuilder' => 0,
		'Module::Build'=> 0,
		'IO::Handle'   => 0,
		'Test::More'   => 0,
		'Time::HiRes'  => 0,
		threads        => 0,
	},
	requires => {
		perl           => 5.007003,
	},
	meta_merge => {
		resources      => {
			bugtracker => 'http://rt.cpan.org/NoAuth/Bugs.html?Dist=Sys-Mmap-Simple',
		},
		keywords       => [ 'mmap', 'memory mapping' ],
	},
	add_to_cleanup     => ['Sys-Mmap-Simple-*'],
	create_makefile_pl => 'passthrough',
	sign               => 1,
);

$builder->create_build_script();
