package # hide from PAUSE
App::YTDL::GetData;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( get_yt_list_info get_new_video_url get_download_info );

use JSON                qw( decode_json );
use LWP::UserAgent      qw();
use Term::ANSIScreen    qw( :screen );
use Try::Tiny           qw( try catch );

use if $^O eq 'MSWin32', 'Win32::Console::ANSI';

use App::YTDL::Helper      qw( uni_capture HIDE_CURSOR SHOW_CURSOR );
use App::YTDL::DataExtract qw( json_to_hash );


sub get_yt_list_info {
    my ( $opt, $url ) = @_;
    my $show_progress = 1;
    my $ua = LWP::UserAgent->new(
        agent         => $opt->{useragent},
        timeout       => $opt->{timeout},
        show_progress => $show_progress
    );
    my $tmp;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            my $res = $ua->get( $url );
            die $res->status_line, ': ', $url if ! $res->is_success;
            my $json = $res->decoded_content;
            $tmp = decode_json( $json );
            die $url . ' - error fetching youtube list info!' if ! defined $tmp || ! %$tmp;
        }
        catch {
            say "$count/$opt->{retries}  $_"; #
            return if $count == $opt->{retries};
            $ok = 0;
            sleep $opt->{retries} * 3;
        };
        return $tmp if $ok;
    }
}


sub get_new_video_url {
    my ( $opt, $info, $ex, $video_id, $fmt ) = @_;
    my @cmd = ( $opt->{youtube_dl} );
    push @cmd, '--user-agent', $opt->{useragent} if defined $opt->{useragent};
    push @cmd, '--socket-timeout', $opt->{timeout};
    #push @cmd, '-v';
    push @cmd, '--format', $fmt, '--get-url', '--', $video_id;
    my $video_url;
    try {
        $video_url = uni_capture( @cmd );
        die $video_id . ' - could not get new video url!' if ! $video_url;
    }
    catch {
        say $_;
        $video_url = undef;
    };
    return $video_url;
}


sub get_download_info {
    my ( $opt, $video_id, $message ) = @_;
    my @cmd = ( $opt->{youtube_dl} );
    push @cmd, '--user-agent', $opt->{useragent} if defined $opt->{useragent};
    push @cmd, '--socket-timeout', $opt->{timeout};
    push @cmd, '--youtube-skip-dash-manifest';
    #push @cmd, '-v';
    push @cmd, '--dump-json', '--', $video_id;
    my $json_all;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            print HIDE_CURSOR;
            print $message . '...';
            $json_all = uni_capture( @cmd );
            print "\r", clline;
            print $message . "done.\n";
            print SHOW_CURSOR;
            die $video_id . ' - no JSON!' if ! $json_all;
        }
        catch {
            say "$count/$opt->{retries}  $video_id: $_"; #
            if ( $count == $opt->{retries} ) {
                push @{$opt->{error_get_download_infos}}, $video_id; # $ex
                return;
            }
            $ok = 0;
            print SHOW_CURSOR;
            sleep $opt->{retries} * 3;
        };
        last RETRY if $ok;
    }
    $opt->{up}++;
    my $tmp = {};
    for my $json ( split /\n+/, $json_all ) {
        json_to_hash( $opt, $tmp, $json );
    }
    return $tmp
}




1;


__END__
