#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
// Sub id declarations
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_both_false(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_both_true(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_left_true(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_nagate(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_push_mortal_leave_scope(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_right_true(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_not_false(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_not_true(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_or_both_false(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_or_both_true(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_or_left_true(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_or_right_true(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_both_false(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // BOOL_INT
  int_vars[0] = int_vars[3];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_both_true(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // BOOL_INT
  int_vars[0] = int_vars[3];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[4];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[2];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // MOVE_INT
  int_vars[5] = int_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L41: // GOTO
  goto L42;
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L43: // BOOL_INT
  int_vars[0] = int_vars[4];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L46: // BOOL_INT
  int_vars[0] = int_vars[2];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L49: // BOOL_INT
  int_vars[0] = int_vars[2];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L52: // BOOL_INT
  int_vars[0] = int_vars[3];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[4];
L56: // MOVE_INT
  int_vars[5] = int_vars[0];
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L63: // GOTO
  goto L64;
L64: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L65: // BOOL_INT
  int_vars[0] = int_vars[4];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // BOOL_INT
  int_vars[0] = int_vars[2];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L71: // BOOL_INT
  int_vars[0] = int_vars[2];
L72: // GOTO
  goto L75;
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L74: // BOOL_INT
  int_vars[0] = int_vars[3];
L75: // GOTO
  goto L78;
L76: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[4];
L78: // MOVE_INT
  int_vars[5] = int_vars[0];
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L85: // GOTO
  goto L86;
L86: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L87: // BOOL_INT
  int_vars[0] = int_vars[4];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L90: // BOOL_INT
  int_vars[0] = int_vars[2];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L93: // BOOL_INT
  int_vars[0] = int_vars[2];
L94: // GOTO
  goto L97;
L95: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L96: // BOOL_INT
  int_vars[0] = int_vars[3];
L97: // GOTO
  goto L100;
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L99: // BOOL_INT
  int_vars[0] = int_vars[4];
L100: // MOVE_INT
  int_vars[5] = int_vars[0];
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L102: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_NE_ZERO
  if (int_vars[0]) { goto L108; }
L105: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L107: // GOTO
  goto L108;
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L112;
L110: // INIT_INT
  int_vars[6] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L112;
L112: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_left_true(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // BOOL_INT
  int_vars[0] = int_vars[3];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_nagate(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // BOOL_INT
  int_vars[0] = int_vars[3];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L31;
L26: // GOTO
  goto L27;
L27: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L31;
L29: // INIT_INT
  int_vars[6] = 0;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L31;
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_push_mortal_leave_scope(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[14];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 13;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L17: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L30: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L32: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L36: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L39: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L45: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L47: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L51: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L54: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L60: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L62: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L67: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L69: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L72: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L77: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L78: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L80: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L83: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L84: // BOOL_INT
  int_vars[0] = int_vars[0];
L85: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L90; }
L86: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L88: // BOOL_INT
  int_vars[0] = int_vars[2];
L89: // GOTO
  goto L92;
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L91: // BOOL_INT
  int_vars[0] = int_vars[3];
L92: // GOTO
  goto L96;
L93: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L95: // BOOL_INT
  int_vars[0] = int_vars[4];
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L115; }
L98: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L99: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L100: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L102: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L104: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L105: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L106: // BOOL_INT
  int_vars[0] = int_vars[0];
L107: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L112; }
L108: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L110: // BOOL_INT
  int_vars[0] = int_vars[2];
L111: // GOTO
  goto L114;
L112: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L113: // BOOL_INT
  int_vars[0] = int_vars[3];
L114: // GOTO
  goto L118;
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L117: // BOOL_INT
  int_vars[0] = int_vars[4];
L118: // BOOL_INT
  int_vars[0] = int_vars[0];
L119: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L137; }
L120: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L121: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L122: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L124: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LogicalOperator";
    const char* sub_name = "logical_and_push_mortal_leave_scope";
    const char* file = "TestCase/LogicalOperator.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L150;
  }
L126: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L127: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L128: // BOOL_INT
  int_vars[0] = int_vars[0];
L129: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L134; }
L130: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L132: // BOOL_INT
  int_vars[0] = int_vars[2];
L133: // GOTO
  goto L136;
L134: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L135: // BOOL_INT
  int_vars[0] = int_vars[3];
L136: // GOTO
  goto L140;
L137: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L138: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L139: // BOOL_INT
  int_vars[0] = int_vars[4];
L140: // BOOL_INT
  int_vars[0] = int_vars[0];
L141: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L145; }
L142: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L143: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L150;
L144: // GOTO
  goto L145;
L145: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 9;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L146: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L147: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L150;
L148: // INIT_INT
  int_vars[6] = 0;
L149: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L150;
L150: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L151: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_and_right_true(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[2];
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // BOOL_INT
  int_vars[0] = int_vars[3];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_not_false(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // GOTO
  goto L9;
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[3];
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_not_true(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // GOTO
  goto L9;
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[3];
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L15: // BOOL_INT
  int_vars[0] = int_vars[4];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // BOOL_INT
  int_vars[0] = int_vars[2];
L19: // GOTO
  goto L22;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[3];
L22: // MOVE_INT
  int_vars[4] = int_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L34;
L29: // GOTO
  goto L30;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L34;
L32: // INIT_INT
  int_vars[6] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L34;
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_or_both_false(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // GOTO
  goto L15;
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // BOOL_INT
  int_vars[0] = int_vars[3];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[3];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_or_both_true(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // GOTO
  goto L15;
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[3];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[3];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // BOOL_INT
  int_vars[0] = int_vars[4];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[2];
L25: // GOTO
  goto L34;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[3];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // BOOL_INT
  int_vars[0] = int_vars[2];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[3];
L34: // MOVE_INT
  int_vars[4] = int_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L41: // GOTO
  goto L42;
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L43: // BOOL_INT
  int_vars[0] = int_vars[4];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L48; }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L46: // BOOL_INT
  int_vars[0] = int_vars[2];
L47: // GOTO
  goto L56;
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L49: // BOOL_INT
  int_vars[0] = int_vars[3];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[2];
L53: // GOTO
  goto L56;
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[3];
L56: // MOVE_INT
  int_vars[4] = int_vars[0];
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L58: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L63: // GOTO
  goto L64;
L64: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L65: // BOOL_INT
  int_vars[0] = int_vars[4];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L70; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // BOOL_INT
  int_vars[0] = int_vars[2];
L69: // GOTO
  goto L78;
L70: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L71: // BOOL_INT
  int_vars[0] = int_vars[3];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L76; }
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L74: // BOOL_INT
  int_vars[0] = int_vars[2];
L75: // GOTO
  goto L78;
L76: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[3];
L78: // MOVE_INT
  int_vars[4] = int_vars[0];
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L80: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L85: // GOTO
  goto L86;
L86: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L87: // BOOL_INT
  int_vars[0] = int_vars[4];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // BOOL_INT
  int_vars[0] = int_vars[2];
L91: // GOTO
  goto L100;
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L93: // BOOL_INT
  int_vars[0] = int_vars[3];
L94: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L96: // BOOL_INT
  int_vars[0] = int_vars[2];
L97: // GOTO
  goto L100;
L98: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L99: // BOOL_INT
  int_vars[0] = int_vars[3];
L100: // MOVE_INT
  int_vars[4] = int_vars[0];
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L102: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_NE_ZERO
  if (int_vars[0]) { goto L108; }
L105: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L112;
L107: // GOTO
  goto L108;
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L112;
L110: // INIT_INT
  int_vars[6] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L112;
L112: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_or_left_true(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // GOTO
  goto L15;
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // BOOL_INT
  int_vars[0] = int_vars[3];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[3];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LogicalOperator__logical_or_right_true(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // GOTO
  goto L15;
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[3];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[2];
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // BOOL_INT
  int_vars[0] = int_vars[3];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


