#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Point_3b__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__x = -1;
static int32_t FIELD_ID_TestCase__Point_3b__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__y = -1;
static int32_t FIELD_ID_TestCase__Point_3b__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__z = -1;
static int32_t FIELD_ID_TestCase__Point_3d__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__x = -1;
static int32_t FIELD_ID_TestCase__Point_3d__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__y = -1;
static int32_t FIELD_ID_TestCase__Point_3d__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__z = -1;
static int32_t FIELD_ID_TestCase__Point_3f__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__x = -1;
static int32_t FIELD_ID_TestCase__Point_3f__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__y = -1;
static int32_t FIELD_ID_TestCase__Point_3f__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__z = -1;
static int32_t FIELD_ID_TestCase__Point_3i__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__x = -1;
static int32_t FIELD_ID_TestCase__Point_3i__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__y = -1;
static int32_t FIELD_ID_TestCase__Point_3i__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__z = -1;
static int32_t FIELD_ID_TestCase__Point_3l__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__x = -1;
static int32_t FIELD_ID_TestCase__Point_3l__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__y = -1;
static int32_t FIELD_ID_TestCase__Point_3l__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__z = -1;
static int32_t FIELD_ID_TestCase__Point_3s__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__x = -1;
static int32_t FIELD_ID_TestCase__Point_3s__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__y = -1;
static int32_t FIELD_ID_TestCase__Point_3s__z = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__z = -1;
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
static int32_t FIELD_ID_TestCase__Minimal__y = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__y = -1;
static int32_t FIELD_ID_TestCase__x_int = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_int = -1;
static int32_t FIELD_ID_TestCase__x_byte = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_byte = -1;
static int32_t FIELD_ID_TestCase__x_short = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_short = -1;
static int32_t FIELD_ID_TestCase__x_long = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_long = -1;
static int32_t FIELD_ID_TestCase__x_float = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_float = -1;
static int32_t FIELD_ID_TestCase__x_double = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_double = -1;
static int32_t FIELD_ID_TestCase__minimal = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__minimal = -1;
static int32_t FIELD_ID_TestCase__x_iarray = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_iarray = -1;
static int32_t FIELD_ID_TestCase__x_barray = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__x_barray = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Byte__new = - 1;
static int32_t SUB_ID_TestCase__Minimal__set_x = - 1;
static int32_t SUB_ID_TestCase__Minimal__set_y = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MAX = - 1;
static int32_t SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE = - 1;
static int32_t SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MAX = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_SPVM__Byte = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
// Function Declarations
// [SIG]double()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__DOUBLE_PRECICE(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__FLOAT_PRECICE(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]oarray(oarray)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__any_object_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&byte)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&double)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&float)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&int)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&long)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&short)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3b(TestCase::Point_3b)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3d(TestCase::Point_3d)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3f(TestCase::Point_3f)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3i(TestCase::Point_3i)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3l(TestCase::Point_3l)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3s(TestCase::Point_3s)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&TestCase::Point_3b)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&TestCase::Point_3d)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&TestCase::Point_3f)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&TestCase::Point_3i)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&TestCase::Point_3l)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(&TestCase::Point_3s)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]void(&TestCase::Point_3i,&int,&TestCase::Point_3i,&int)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_numeric_ref_mixed_arg(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]object(object)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_any_object_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Minimal[]()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]byte[](byte[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_byte_array_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]SPVM::Byte(SPVM::Byte)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_byte_object_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3b()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_byte_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]double[](double[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_double_array_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]SPVM::Double(SPVM::Double)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_double_object_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3d()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_double_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]float[](float[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_float_array_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]SPVM::Float(SPVM::Float)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_float_object_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3f()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_float_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int[](int[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_int_array_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]SPVM::Int(SPVM::Int)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_int_object_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3i()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_int_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]long[](long[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_long_array_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]SPVM::Long(SPVM::Long)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_long_object_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3l()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_long_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]oarray()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_oarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]short[](short[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_short_array_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]SPVM::Short(SPVM::Short)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_short_object_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Point_3s()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_short_value(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]string[](string[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_string_array_only(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]TestCase::Minimal()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__set_exception(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__set_exception_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(byte[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_byte_array_bin(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(byte[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_byte_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(byte[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_byte_array_from_bin(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(double[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_double_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(float[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_float_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_int_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(long[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_long_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3b[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3d[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3f[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3i[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3l[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3s[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3b[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3d[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3f[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3i[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3l[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3s[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(byte[][])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_barray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(double[][])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_darray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(float[][])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_farray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int[][])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_iarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(long[][])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_larray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_oarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(short[][])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_sarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(short[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_short_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_object_set(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_object_set_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(byte[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(double[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(float[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(int[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(long[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(TestCase::Point_3i[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_mulnum_t_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(short[])
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]string(string,string)
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__string_argments_and_return_value(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__ExchangeAPI__DOUBLE_PRECICE(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 65536.5;
L2: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L5;
L3: // INIT_DOUBLE
  double_vars[1] = 0;
L4: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__FLOAT_PRECICE(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 16384.5;
L2: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L5;
L3: // INIT_FLOAT
  float_vars[1] = 0;
L4: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L5;
L5: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__any_object_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Byte < 0) {
      BASIC_TYPE_ID_SPVM__Byte = env->get_basic_type_id(env, "SPVM::Byte");
      if (BASIC_TYPE_ID_SPVM__Byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Byte;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "any_object_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // PUSH_ARG_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
L9: // CALL_SUB_OBJECT
  // SPVM::Byte->new
  {
    if (SUB_ID_SPVM__Byte__new < 0) {
      SUB_ID_SPVM__Byte__new = env->get_sub_id(env, "SPVM::Byte", "new", "SPVM::Byte(byte)");
      if (SUB_ID_SPVM__Byte__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Byte new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Byte__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "any_object_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 154;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L12: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "any_object_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 154;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L14: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L15: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L19;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L17: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L18: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[2];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L19;
L19: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L20: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L2: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // SET_DEREF_BYTE
  *(int8_t*)*(void**)&ref_vars[0] = byte_vars[1];
L7: // INIT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[3];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GET_DEREF_DOUBLE
  double_vars[0] = *(double*)*(void**)&ref_vars[0];
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L4: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L5: // SET_DEREF_DOUBLE
  *(double*)*(void**)&ref_vars[0] = double_vars[2];
L6: // INIT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  float float_vars[3];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GET_DEREF_FLOAT
  float_vars[0] = *(float*)*(void**)&ref_vars[0];
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[1];
L4: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L5: // SET_DEREF_FLOAT
  *(float*)*(void**)&ref_vars[0] = float_vars[2];
L6: // INIT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GET_DEREF_INT
  int_vars[1] = *(int32_t*)*(void**)&ref_vars[0];
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L4: // SET_DEREF_INT
  *(int32_t*)*(void**)&ref_vars[0] = int_vars[3];
L5: // INIT_INT
  int_vars[2] = 0;
L6: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L7;
L7: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[3];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GET_DEREF_LONG
  long_vars[0] = *(int64_t*)*(void**)&ref_vars[0];
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[1];
L4: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L5: // SET_DEREF_LONG
  *(int64_t*)*(void**)&ref_vars[0] = long_vars[2];
L6: // INIT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L8;
L8: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_numeric_ref_arg_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[0];
L2: // CONVERT_SHORT_TO_INT
  int_vars[1] = (int32_t)short_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // SET_DEREF_SHORT
  *(int16_t*)*(void**)&ref_vars[0] = short_vars[1];
L7: // INIT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L9;
L9: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[6];
  char convert_string_buffer[21];
  // Copy arguments to variables
  byte_vars[0] = *(int8_t*)&stack[0];
  byte_vars[1] = *(int8_t*)&stack[1];
  byte_vars[2] = *(int8_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // RETURN_MULNUM_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  *(int8_t*)&stack[1] = byte_vars[1];
  *(int8_t*)&stack[2] = byte_vars[2];
  goto L4;
L2: // INIT_MULNUM_BYTE
  byte_vars[3] = 0;
  byte_vars[4] = 0;
  byte_vars[5] = 0;
L3: // RETURN_MULNUM_BYTE
  *(int8_t*)&stack[0] = byte_vars[3];
  *(int8_t*)&stack[1] = byte_vars[4];
  *(int8_t*)&stack[2] = byte_vars[5];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  double_vars[0] = *(double*)&stack[0];
  double_vars[1] = *(double*)&stack[1];
  double_vars[2] = *(double*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // RETURN_MULNUM_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  *(double*)&stack[1] = double_vars[1];
  *(double*)&stack[2] = double_vars[2];
  goto L4;
L2: // INIT_MULNUM_DOUBLE
  double_vars[3] = 0;
  double_vars[4] = 0;
  double_vars[5] = 0;
L3: // RETURN_MULNUM_DOUBLE
  *(double*)&stack[0] = double_vars[3];
  *(double*)&stack[1] = double_vars[4];
  *(double*)&stack[2] = double_vars[5];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  float_vars[0] = *(float*)&stack[0];
  float_vars[1] = *(float*)&stack[1];
  float_vars[2] = *(float*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // RETURN_MULNUM_FLOAT
  *(float*)&stack[0] = float_vars[0];
  *(float*)&stack[1] = float_vars[1];
  *(float*)&stack[2] = float_vars[2];
  goto L4;
L2: // INIT_MULNUM_FLOAT
  float_vars[3] = 0;
  float_vars[4] = 0;
  float_vars[5] = 0;
L3: // RETURN_MULNUM_FLOAT
  *(float*)&stack[0] = float_vars[3];
  *(float*)&stack[1] = float_vars[4];
  *(float*)&stack[2] = float_vars[5];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  int_vars[1] = *(int32_t*)&stack[0];
  int_vars[2] = *(int32_t*)&stack[1];
  int_vars[3] = *(int32_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // RETURN_MULNUM_INT
  *(int32_t*)&stack[0] = int_vars[1];
  *(int32_t*)&stack[1] = int_vars[2];
  *(int32_t*)&stack[2] = int_vars[3];
  goto L4;
L2: // INIT_MULNUM_INT
  int_vars[5] = 0;
  int_vars[6] = 0;
  int_vars[7] = 0;
L3: // RETURN_MULNUM_INT
  *(int32_t*)&stack[0] = int_vars[5];
  *(int32_t*)&stack[1] = int_vars[6];
  *(int32_t*)&stack[2] = int_vars[7];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[6];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  long_vars[0] = *(int64_t*)&stack[0];
  long_vars[1] = *(int64_t*)&stack[1];
  long_vars[2] = *(int64_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // RETURN_MULNUM_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  *(int64_t*)&stack[1] = long_vars[1];
  *(int64_t*)&stack[2] = long_vars[2];
  goto L4;
L2: // INIT_MULNUM_LONG
  long_vars[3] = 0;
  long_vars[4] = 0;
  long_vars[5] = 0;
L3: // RETURN_MULNUM_LONG
  *(int64_t*)&stack[0] = long_vars[3];
  *(int64_t*)&stack[1] = long_vars[4];
  *(int64_t*)&stack[2] = long_vars[5];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_arg_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[6];
  char convert_string_buffer[21];
  // Copy arguments to variables
  short_vars[0] = *(int16_t*)&stack[0];
  short_vars[1] = *(int16_t*)&stack[1];
  short_vars[2] = *(int16_t*)&stack[2];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // RETURN_MULNUM_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  *(int16_t*)&stack[1] = short_vars[1];
  *(int16_t*)&stack[2] = short_vars[2];
  goto L4;
L2: // INIT_MULNUM_SHORT
  short_vars[3] = 0;
  short_vars[4] = 0;
  short_vars[5] = 0;
L3: // RETURN_MULNUM_SHORT
  *(int16_t*)&stack[0] = short_vars[3];
  *(int16_t*)&stack[1] = short_vars[4];
  *(int16_t*)&stack[2] = short_vars[5];
  goto L4;
L4: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_DEREF_GET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&byte_vars[0] = *(int8_t*)&value_ref[0];
  }
L2: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // MULNUM_DEREF_SET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&value_ref[0] = *(int8_t*)&byte_vars[1];
  }
L7: // MULNUM_DEREF_GET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&byte_vars[0] = *(int8_t*)&value_ref[1];
  }
L8: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L11: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L12: // MULNUM_DEREF_SET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&value_ref[1] = *(int8_t*)&byte_vars[1];
  }
L13: // MULNUM_DEREF_GET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&byte_vars[0] = *(int8_t*)&value_ref[2];
  }
L14: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L17: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L18: // MULNUM_DEREF_SET_FIELD_BYTE
  {
    int8_t* value_ref = *(int8_t**)&ref_vars[0];
    *(int8_t*)&value_ref[2] = *(int8_t*)&byte_vars[1];
  }
L19: // INIT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  double double_vars[4];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_DEREF_GET_FETCH_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&double_vars[0] = *(double*)&value_ref[0];
  }
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L4: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L5: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L6: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[0] = *(double*)&double_vars[3];
  }
L7: // MULNUM_DEREF_GET_FETCH_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&double_vars[0] = *(double*)&value_ref[1];
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L10: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L11: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L12: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[1] = *(double*)&double_vars[3];
  }
L13: // MULNUM_DEREF_GET_FETCH_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&double_vars[0] = *(double*)&value_ref[2];
  }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L16: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L17: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L18: // MULNUM_DEREF_SET_FIELD_DOUBLE
  {
    double* value_ref = *(double**)&ref_vars[0];
    *(double*)&value_ref[2] = *(double*)&double_vars[3];
  }
L19: // INIT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  float float_vars[4];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_DEREF_GET_FETCH_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&float_vars[0] = *(float*)&value_ref[0];
  }
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[1];
L4: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L5: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L6: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[0] = *(float*)&float_vars[3];
  }
L7: // MULNUM_DEREF_GET_FETCH_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&float_vars[0] = *(float*)&value_ref[1];
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L10: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L11: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L12: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[1] = *(float*)&float_vars[3];
  }
L13: // MULNUM_DEREF_GET_FETCH_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&float_vars[0] = *(float*)&value_ref[2];
  }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L16: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L17: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L18: // MULNUM_DEREF_SET_FIELD_FLOAT
  {
    float* value_ref = *(float**)&ref_vars[0];
    *(float*)&value_ref[2] = *(float*)&float_vars[3];
  }
L19: // INIT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[1] = *(int32_t*)&value_ref[0];
  }
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[0] = *(int32_t*)&int_vars[4];
  }
L6: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[2] = *(int32_t*)&value_ref[1];
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L9: // MOVE_INT
  int_vars[5] = int_vars[4];
L10: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[1] = *(int32_t*)&int_vars[5];
  }
L11: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[2] = *(int32_t*)&value_ref[2];
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L14: // MOVE_INT
  int_vars[5] = int_vars[4];
L15: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[2] = *(int32_t*)&int_vars[5];
  }
L16: // INIT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int64_t long_vars[4];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_DEREF_GET_FETCH_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&long_vars[0] = *(int64_t*)&value_ref[0];
  }
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[1];
L4: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L5: // MOVE_LONG
  long_vars[3] = long_vars[2];
L6: // MULNUM_DEREF_SET_FIELD_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&value_ref[0] = *(int64_t*)&long_vars[3];
  }
L7: // MULNUM_DEREF_GET_FETCH_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&long_vars[0] = *(int64_t*)&value_ref[1];
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L10: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L11: // MOVE_LONG
  long_vars[3] = long_vars[2];
L12: // MULNUM_DEREF_SET_FIELD_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&value_ref[1] = *(int64_t*)&long_vars[3];
  }
L13: // MULNUM_DEREF_GET_FETCH_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&long_vars[0] = *(int64_t*)&value_ref[2];
  }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L16: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L17: // MOVE_LONG
  long_vars[3] = long_vars[2];
L18: // MULNUM_DEREF_SET_FIELD_LONG
  {
    int64_t* value_ref = *(int64_t**)&ref_vars[0];
    *(int64_t*)&value_ref[2] = *(int64_t*)&long_vars[3];
  }
L19: // INIT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_arg_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[1] = {0};
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_DEREF_GET_FETCH_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&short_vars[0] = *(int16_t*)&value_ref[0];
  }
L2: // CONVERT_SHORT_TO_INT
  int_vars[1] = (int32_t)short_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // MULNUM_DEREF_SET_FIELD_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&value_ref[0] = *(int16_t*)&short_vars[1];
  }
L7: // MULNUM_DEREF_GET_FETCH_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&short_vars[0] = *(int16_t*)&value_ref[1];
  }
L8: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MULNUM_DEREF_SET_FIELD_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&value_ref[1] = *(int16_t*)&short_vars[1];
  }
L13: // MULNUM_DEREF_GET_FETCH_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&short_vars[0] = *(int16_t*)&value_ref[2];
  }
L14: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L16: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L17: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L18: // MULNUM_DEREF_SET_FIELD_SHORT
  {
    int16_t* value_ref = *(int16_t**)&ref_vars[0];
    *(int16_t*)&value_ref[2] = *(int16_t*)&short_vars[1];
  }
L19: // INIT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__call_sub_value_ref_numeric_ref_mixed_arg(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[4] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  ref_vars[0] = *(void**)&stack[0];
  ref_vars[1] = *(void**)&stack[1];
  ref_vars[2] = *(void**)&stack[2];
  ref_vars[3] = *(void**)&stack[3];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[1] = *(int32_t*)&value_ref[0];
  }
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // ADD_INT
  int_vars[3] = int_vars[1] + int_vars[2];
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[0] = *(int32_t*)&int_vars[4];
  }
L6: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[2] = *(int32_t*)&value_ref[1];
  }
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L8: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L9: // MOVE_INT
  int_vars[5] = int_vars[4];
L10: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[1] = *(int32_t*)&int_vars[5];
  }
L11: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&int_vars[2] = *(int32_t*)&value_ref[2];
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L14: // MOVE_INT
  int_vars[5] = int_vars[4];
L15: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[0];
    *(int32_t*)&value_ref[2] = *(int32_t*)&int_vars[5];
  }
L16: // GET_DEREF_INT
  int_vars[2] = *(int32_t*)*(void**)&ref_vars[1];
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L18: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L19: // SET_DEREF_INT
  *(int32_t*)*(void**)&ref_vars[1] = int_vars[4];
L20: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[2];
    *(int32_t*)&int_vars[2] = *(int32_t*)&value_ref[0];
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L22: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L23: // MOVE_INT
  int_vars[5] = int_vars[4];
L24: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[2];
    *(int32_t*)&value_ref[0] = *(int32_t*)&int_vars[5];
  }
L25: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[2];
    *(int32_t*)&int_vars[2] = *(int32_t*)&value_ref[1];
  }
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L27: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L28: // MOVE_INT
  int_vars[5] = int_vars[4];
L29: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[2];
    *(int32_t*)&value_ref[1] = *(int32_t*)&int_vars[5];
  }
L30: // MULNUM_DEREF_GET_FETCH_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[2];
    *(int32_t*)&int_vars[2] = *(int32_t*)&value_ref[2];
  }
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L33: // MOVE_INT
  int_vars[5] = int_vars[4];
L34: // MULNUM_DEREF_SET_FIELD_INT
  {
    int32_t* value_ref = *(int32_t**)&ref_vars[2];
    *(int32_t*)&value_ref[2] = *(int32_t*)&int_vars[5];
  }
L35: // GET_DEREF_INT
  int_vars[2] = *(int32_t*)*(void**)&ref_vars[3];
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L38: // SET_DEREF_INT
  *(int32_t*)*(void**)&ref_vars[3] = int_vars[4];
L39: // RETURN_VOID
  goto L40;
L40: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_any_object_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L14: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L16: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L18: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L24: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__y < 0, 0)) {
      FIELD_ID_TestCase__Minimal__y = env->get_field_id(env, "TestCase::Minimal", "y", "int");
      if (FIELD_ID_TestCase__Minimal__y < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal y");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__y = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__y);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__y) = int_vars[2];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 26;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L36: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 27;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L38: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 27;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L44: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 28;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L46: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__y < 0, 0)) {
      FIELD_ID_TestCase__Minimal__y = env->get_field_id(env, "TestCase::Minimal", "y", "int");
      if (FIELD_ID_TestCase__Minimal__y < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal y");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__y = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__y);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__y) = int_vars[2];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_array";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 28;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L49: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L53;
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L6;
  }
L3: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  goto L6;
L4: // INIT_BYTE
  byte_vars[1] = 0;
L5: // RETURN_BYTE
  *(int8_t*)&stack[0] = byte_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_byte_array_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_byte_object_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_byte_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[7];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_BYTE
  byte_vars[0] = 0;
  byte_vars[1] = 0;
  byte_vars[2] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L4: // MULNUM_SET_FIELD_BYTE
  byte_vars[0] = byte_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[2];
L7: // MULNUM_SET_FIELD_BYTE
  byte_vars[1] = byte_vars[3];
L8: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_byte_value";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L10: // MULNUM_SET_FIELD_BYTE
  byte_vars[2] = byte_vars[3];
L11: // RETURN_MULNUM_BYTE
  *(int8_t*)&stack[0] = byte_vars[0];
  *(int8_t*)&stack[1] = byte_vars[1];
  *(int8_t*)&stack[2] = byte_vars[2];
  goto L14;
L12: // INIT_MULNUM_BYTE
  byte_vars[4] = 0;
  byte_vars[5] = 0;
  byte_vars[6] = 0;
L13: // RETURN_MULNUM_BYTE
  *(int8_t*)&stack[0] = byte_vars[4];
  *(int8_t*)&stack[1] = byte_vars[5];
  *(int8_t*)&stack[2] = byte_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 127;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L6;
  }
L3: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  goto L6;
L4: // INIT_DOUBLE
  double_vars[1] = 0;
L5: // RETURN_DOUBLE
  *(double*)&stack[0] = double_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_double_array_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_double_object_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_double_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[7];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
  double_vars[2] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L4: // MULNUM_SET_FIELD_DOUBLE
  double_vars[0] = double_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[2];
L7: // MULNUM_SET_FIELD_DOUBLE
  double_vars[1] = double_vars[3];
L8: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_double_value";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L10: // MULNUM_SET_FIELD_DOUBLE
  double_vars[2] = double_vars[3];
L11: // RETURN_MULNUM_DOUBLE
  *(double*)&stack[0] = double_vars[0];
  *(double*)&stack[1] = double_vars[1];
  *(double*)&stack[2] = double_vars[2];
  goto L14;
L12: // INIT_MULNUM_DOUBLE
  double_vars[4] = 0;
  double_vars[5] = 0;
  double_vars[6] = 0;
L13: // RETURN_MULNUM_DOUBLE
  *(double*)&stack[0] = double_vars[4];
  *(double*)&stack[1] = double_vars[5];
  *(double*)&stack[2] = double_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L6;
  }
L3: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[0];
  goto L6;
L4: // INIT_FLOAT
  float_vars[1] = 0;
L5: // RETURN_FLOAT
  *(float*)&stack[0] = float_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_float_array_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_float_object_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_float_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[7];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_FLOAT
  float_vars[0] = 0;
  float_vars[1] = 0;
  float_vars[2] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[2];
L4: // MULNUM_SET_FIELD_FLOAT
  float_vars[0] = float_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[2];
L7: // MULNUM_SET_FIELD_FLOAT
  float_vars[1] = float_vars[3];
L8: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_float_value";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 86;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L10: // MULNUM_SET_FIELD_FLOAT
  float_vars[2] = float_vars[3];
L11: // RETURN_MULNUM_FLOAT
  *(float*)&stack[0] = float_vars[0];
  *(float*)&stack[1] = float_vars[1];
  *(float*)&stack[2] = float_vars[2];
  goto L14;
L12: // INIT_MULNUM_FLOAT
  float_vars[4] = 0;
  float_vars[5] = 0;
  float_vars[6] = 0;
L13: // RETURN_MULNUM_FLOAT
  *(float*)&stack[0] = float_vars[4];
  *(float*)&stack[1] = float_vars[5];
  *(float*)&stack[2] = float_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[5];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L6;
  }
L3: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[1];
  goto L6;
L4: // INIT_INT
  int_vars[3] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_int_array_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_int_object_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_int_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_INT
  int_vars[1] = 0;
  int_vars[2] = 0;
  int_vars[3] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L3: // MULNUM_SET_FIELD_INT
  int_vars[1] = int_vars[5];
L4: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L5: // MULNUM_SET_FIELD_INT
  int_vars[2] = int_vars[5];
L6: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_int_value";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L12;
  }
L8: // MULNUM_SET_FIELD_INT
  int_vars[3] = int_vars[5];
L9: // RETURN_MULNUM_INT
  *(int32_t*)&stack[0] = int_vars[1];
  *(int32_t*)&stack[1] = int_vars[2];
  *(int32_t*)&stack[2] = int_vars[3];
  goto L12;
L10: // INIT_MULNUM_INT
  int_vars[6] = 0;
  int_vars[7] = 0;
  int_vars[8] = 0;
L11: // RETURN_MULNUM_INT
  *(int32_t*)&stack[0] = int_vars[6];
  *(int32_t*)&stack[1] = int_vars[7];
  *(int32_t*)&stack[2] = int_vars[8];
  goto L12;
L12: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L6;
  }
L3: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  goto L6;
L4: // INIT_LONG
  long_vars[1] = 0;
L5: // RETURN_LONG
  *(int64_t*)&stack[0] = long_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_long_array_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_long_object_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_long_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[7];
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_LONG
  long_vars[0] = 0;
  long_vars[1] = 0;
  long_vars[2] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L4: // MULNUM_SET_FIELD_LONG
  long_vars[0] = long_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[2];
L7: // MULNUM_SET_FIELD_LONG
  long_vars[1] = long_vars[3];
L8: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_long_value";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L10: // MULNUM_SET_FIELD_LONG
  long_vars[2] = long_vars[3];
L11: // RETURN_MULNUM_LONG
  *(int64_t*)&stack[0] = long_vars[0];
  *(int64_t*)&stack[1] = long_vars[1];
  *(int64_t*)&stack[2] = long_vars[2];
  goto L14;
L12: // INIT_MULNUM_LONG
  long_vars[4] = 0;
  long_vars[5] = 0;
  long_vars[6] = 0;
L13: // RETURN_MULNUM_LONG
  *(int64_t*)&stack[0] = long_vars[4];
  *(int64_t*)&stack[1] = long_vars[5];
  *(int64_t*)&stack[2] = long_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_oarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 36;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L14: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L16: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L18: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L20: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L24: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__y < 0, 0)) {
      FIELD_ID_TestCase__Minimal__y = env->get_field_id(env, "TestCase::Minimal", "y", "int");
      if (FIELD_ID_TestCase__Minimal__y < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal y");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__y = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__y);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__y) = int_vars[2];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L26: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L36: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 40;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L38: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[2];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 40;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L44: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L46: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__y < 0, 0)) {
      FIELD_ID_TestCase__Minimal__y = env->get_field_id(env, "TestCase::Minimal", "y", "int");
      if (FIELD_ID_TestCase__Minimal__y < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal y");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__y = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__y);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__y) = int_vars[2];
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L49: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L53;
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L6;
  }
L3: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  goto L6;
L4: // INIT_SHORT
  short_vars[1] = 0;
L5: // RETURN_SHORT
  *(int16_t*)&stack[0] = short_vars[1];
  goto L6;
L6: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_short_array_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_short_object_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_short_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[4];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[7];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_SHORT
  short_vars[0] = 0;
  short_vars[1] = 0;
  short_vars[2] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L4: // MULNUM_SET_FIELD_SHORT
  short_vars[0] = short_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // CONVERT_INT_TO_SHORT
  short_vars[3] = (int16_t)int_vars[2];
L7: // MULNUM_SET_FIELD_SHORT
  short_vars[1] = short_vars[3];
L8: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[3] = *(int16_t*)&stack[0];
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "return_short_value";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L10: // MULNUM_SET_FIELD_SHORT
  short_vars[2] = short_vars[3];
L11: // RETURN_MULNUM_SHORT
  *(int16_t*)&stack[0] = short_vars[0];
  *(int16_t*)&stack[1] = short_vars[1];
  *(int16_t*)&stack[2] = short_vars[2];
  goto L14;
L12: // INIT_MULNUM_SHORT
  short_vars[4] = 0;
  short_vars[5] = 0;
  short_vars[6] = 0;
L13: // RETURN_MULNUM_SHORT
  *(int16_t*)&stack[0] = short_vars[4];
  *(int16_t*)&stack[1] = short_vars[5];
  *(int16_t*)&stack[2] = short_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_string_array_only(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L5: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[1];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L6;
L6: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L7: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__return_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // RETURN_UNDEF
  *(void**)&stack[0] = NULL;
  goto L5;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L4: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[0];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L5;
L5: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L6: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__set_exception(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\xE3\x81\x82\xE3\x81\x84\xE3\x81\x86", 9));
L5: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "set_exception";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L18;
  }
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L18;
L12: // GOTO
  goto L13;
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L18;
L16: // INIT_INT
  int_vars[6] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__set_exception_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L3: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_byte_array_bin(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_bin";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L5: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 97;
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_bin";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 98;
L15: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_bin";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 391;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L21: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 99;
L23: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L26: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_bin";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 392;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L42;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L29: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L42;
L34: // GOTO
  goto L35;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L42;
L40: // INIT_INT
  int_vars[6] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L42;
L42: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_byte_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 404;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L5: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 97;
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L14: // MOVE_CONSTANT_INT
  int_vars[4] = 98;
L15: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 406;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L21: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L22: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 406;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L24: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L25: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L28: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 407;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L44;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L31: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L44;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // GOTO
  goto L40;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L44;
L42: // INIT_INT
  int_vars[6] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L44;
L44: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L45: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_byte_array_from_bin(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\xE3\x81\x82", 3));
L4: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_byte_array_from_bin";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 380;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L17;
  }
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L11: // GOTO
  goto L12;
L12: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_double_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_double_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 479;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 97;
L6: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L7: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_double_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 98;
L14: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_double_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L21: // CALL_SUB_DOUBLE
  // TestCase::ExchangeAPI->DOUBLE_PRECICE
  {
    if (SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE < 0) {
      SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE = env->get_sub_id(env, "TestCase::ExchangeAPI", "DOUBLE_PRECICE", "double()");
      if (SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::ExchangeAPI DOUBLE_PRECICE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE;
    exception_flag = SPPRECOMPILE__TestCase__ExchangeAPI__DOUBLE_PRECICE(env, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_double_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L23: // MOVE_DOUBLE
  double_vars[2] = double_vars[1];
L24: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[2]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L27: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_double_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 482;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L30: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_float_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_float_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 464;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 97;
L6: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L7: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_float_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 98;
L14: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_float_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 466;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L21: // CALL_SUB_FLOAT
  // TestCase::ExchangeAPI->FLOAT_PRECICE
  {
    if (SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE < 0) {
      SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE = env->get_sub_id(env, "TestCase::ExchangeAPI", "FLOAT_PRECICE", "float()");
      if (SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::ExchangeAPI FLOAT_PRECICE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE;
    exception_flag = SPPRECOMPILE__TestCase__ExchangeAPI__FLOAT_PRECICE(env, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_float_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 466;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L23: // MOVE_FLOAT
  float_vars[2] = float_vars[1];
L24: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[2]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L27: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_float_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 467;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L30: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_int_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[2] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_int_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 434;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 97;
L6: // MOVE_INT
  int_vars[4] = int_vars[3];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_int_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 98;
L14: // MOVE_INT
  int_vars[5] = int_vars[4];
L15: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_int_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 436;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L21: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_int_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 436;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L23: // MOVE_INT
  int_vars[5] = int_vars[4];
L24: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L27: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_int_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 437;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L30: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_long_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_long_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 97;
L6: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L7: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_long_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 98;
L14: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L15: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L19: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_long_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L21: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_long_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L23: // MOVE_LONG
  long_vars[2] = long_vars[1];
L24: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[2]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L27: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_long_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L30: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 850;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L6: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L7: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 850;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L9: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L10: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // MOVE_INT
  int_vars[3] = int_vars[2];
L15: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 851;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L17: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // MOVE_INT
  int_vars[3] = int_vars[2];
L24: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 852;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L26: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L27: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L28: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // MOVE_INT
  int_vars[3] = int_vars[2];
L33: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 853;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L35: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L36: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L37: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // MOVE_INT
  int_vars[3] = int_vars[2];
L42: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 854;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L44: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L46: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L50: // MOVE_INT
  int_vars[3] = int_vars[2];
L51: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 855;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L53: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L55: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L59: // MOVE_INT
  int_vars[3] = int_vars[2];
L60: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 856;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L64: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L68: // MOVE_INT
  int_vars[3] = int_vars[2];
L69: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 857;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L73: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L77: // MOVE_INT
  int_vars[3] = int_vars[2];
L78: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 858;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L80: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L81: // MOVE_CONSTANT_INT
  int_vars[5] = 8;
L82: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L85: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 859;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L88: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // GOTO
  goto L102;
L102: // GOTO
  goto L103;
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L107;
L105: // INIT_INT
  int_vars[6] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 980;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 980;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L8: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 981;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L17: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // MOVE_INT
  int_vars[3] = int_vars[2];
L22: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 982;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L25: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L26: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 983;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L34: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L35: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // MOVE_INT
  int_vars[3] = int_vars[2];
L40: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 984;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L43: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L44: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 985;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L52: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L53: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L57: // MOVE_INT
  int_vars[3] = int_vars[2];
L58: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 986;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L61: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L62: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L66: // MOVE_INT
  int_vars[3] = int_vars[2];
L67: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 987;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L70: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L71: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 988;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 8;
L79: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L80: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L83: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 989;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L86: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L105;
L103: // INIT_INT
  int_vars[6] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 954;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L6: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 954;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L8: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 955;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L17: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // MOVE_INT
  int_vars[3] = int_vars[2];
L22: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 956;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L25: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L26: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 957;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L34: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L35: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // MOVE_INT
  int_vars[3] = int_vars[2];
L40: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 958;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L43: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L44: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 959;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L52: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L53: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L57: // MOVE_INT
  int_vars[3] = int_vars[2];
L58: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 960;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L61: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L62: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L66: // MOVE_INT
  int_vars[3] = int_vars[2];
L67: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 961;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L70: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L71: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 962;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 8;
L79: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L80: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L83: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 963;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L86: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L105;
L103: // INIT_INT
  int_vars[6] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 902;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L6: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 902;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L8: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 903;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // MOVE_INT
  int_vars[3] = int_vars[2];
L21: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 904;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L24: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // MOVE_INT
  int_vars[3] = int_vars[2];
L29: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 905;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L32: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L90; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 906;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L40: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L89; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L44: // MOVE_INT
  int_vars[3] = int_vars[2];
L45: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 907;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L48: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L52: // MOVE_INT
  int_vars[3] = int_vars[2];
L53: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 908;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L56: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L60: // MOVE_INT
  int_vars[3] = int_vars[2];
L61: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 909;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L64: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L68: // MOVE_INT
  int_vars[3] = int_vars[2];
L69: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 910;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 8;
L72: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L75: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 911;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L78: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L97;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // GOTO
  goto L87;
L87: // GOTO
  goto L88;
L88: // GOTO
  goto L89;
L89: // GOTO
  goto L90;
L90: // GOTO
  goto L91;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L97;
L95: // INIT_INT
  int_vars[6] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L97;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 928;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L6: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 928;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L8: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 929;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L17: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // MOVE_INT
  int_vars[3] = int_vars[2];
L22: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 930;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L25: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L26: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 931;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L34: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L35: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // MOVE_INT
  int_vars[3] = int_vars[2];
L40: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 932;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L43: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L44: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 933;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L52: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L53: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L57: // MOVE_INT
  int_vars[3] = int_vars[2];
L58: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 934;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L61: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L62: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L66: // MOVE_INT
  int_vars[3] = int_vars[2];
L67: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 935;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L70: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L71: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 936;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 8;
L79: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L80: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L83: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 937;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L86: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L105;
L103: // INIT_INT
  int_vars[6] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_binary_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 876;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L6: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L7: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 876;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L9: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L10: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // MOVE_INT
  int_vars[3] = int_vars[2];
L15: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 877;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L17: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // MOVE_INT
  int_vars[3] = int_vars[2];
L24: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 878;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L26: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L27: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L28: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // MOVE_INT
  int_vars[3] = int_vars[2];
L33: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 879;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L35: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L36: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L37: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // MOVE_INT
  int_vars[3] = int_vars[2];
L42: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 880;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L44: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L46: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L50: // MOVE_INT
  int_vars[3] = int_vars[2];
L51: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 881;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L53: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L55: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L59: // MOVE_INT
  int_vars[3] = int_vars[2];
L60: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 882;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L62: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L64: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L68: // MOVE_INT
  int_vars[3] = int_vars[2];
L69: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 883;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L71: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L73: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L77: // MOVE_INT
  int_vars[3] = int_vars[2];
L78: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 884;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L80: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L81: // MOVE_CONSTANT_INT
  int_vars[5] = 8;
L82: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L85: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_binary_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 885;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L88: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // GOTO
  goto L102;
L102: // GOTO
  goto L103;
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L107;
L105: // INIT_INT
  int_vars[6] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 689;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L6: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L7: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 689;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L9: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L10: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // MOVE_INT
  int_vars[3] = int_vars[2];
L15: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 690;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L17: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // MOVE_INT
  int_vars[3] = int_vars[2];
L24: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 691;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L26: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L27: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L28: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // MOVE_INT
  int_vars[3] = int_vars[2];
L33: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 692;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L35: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L36: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L37: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // MOVE_INT
  int_vars[3] = int_vars[2];
L42: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 693;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L44: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L46: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L50: // MOVE_INT
  int_vars[3] = int_vars[2];
L51: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 694;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L53: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L55: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L59: // MOVE_INT
  int_vars[3] = int_vars[2];
L60: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 695;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L64: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L68: // MOVE_INT
  int_vars[3] = int_vars[2];
L69: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 696;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L73: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L77: // MOVE_INT
  int_vars[3] = int_vars[2];
L78: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 697;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L80: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L81: // MOVE_CONSTANT_INT
  int_vars[5] = 8;
L82: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L85: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 698;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L88: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // GOTO
  goto L102;
L102: // GOTO
  goto L103;
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L107;
L105: // INIT_INT
  int_vars[6] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 824;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L6: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 824;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L8: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 825;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L17: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // MOVE_INT
  int_vars[3] = int_vars[2];
L22: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 826;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L25: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L26: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 827;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L34: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L35: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // MOVE_INT
  int_vars[3] = int_vars[2];
L40: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 828;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L43: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L44: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 829;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L52: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L53: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L57: // MOVE_INT
  int_vars[3] = int_vars[2];
L58: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 830;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L61: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L62: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L66: // MOVE_INT
  int_vars[3] = int_vars[2];
L67: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 831;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L70: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L71: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 832;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 8;
L79: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L80: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L83: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 833;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L86: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L105;
L103: // INIT_INT
  int_vars[6] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 797;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L6: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 797;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L8: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 798;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L17: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // MOVE_INT
  int_vars[3] = int_vars[2];
L22: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 799;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L25: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L26: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 800;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L34: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L35: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // MOVE_INT
  int_vars[3] = int_vars[2];
L40: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 801;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L43: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L44: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 802;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L52: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L53: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L57: // MOVE_INT
  int_vars[3] = int_vars[2];
L58: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 803;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L61: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L62: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L66: // MOVE_INT
  int_vars[3] = int_vars[2];
L67: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 804;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L70: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L71: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 805;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 8;
L79: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L80: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L83: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L86: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L105;
L103: // INIT_INT
  int_vars[6] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 743;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L6: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 743;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L8: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 744;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // MOVE_INT
  int_vars[3] = int_vars[2];
L21: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 745;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L24: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // MOVE_INT
  int_vars[3] = int_vars[2];
L29: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 746;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L32: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L90; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 747;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L40: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L89; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L44: // MOVE_INT
  int_vars[3] = int_vars[2];
L45: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 748;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L48: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L52: // MOVE_INT
  int_vars[3] = int_vars[2];
L53: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 749;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L56: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L60: // MOVE_INT
  int_vars[3] = int_vars[2];
L61: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 750;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L64: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L68: // MOVE_INT
  int_vars[3] = int_vars[2];
L69: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 751;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 8;
L72: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L75: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 752;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L78: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L97;
L83: // GOTO
  goto L84;
L84: // GOTO
  goto L85;
L85: // GOTO
  goto L86;
L86: // GOTO
  goto L87;
L87: // GOTO
  goto L88;
L88: // GOTO
  goto L89;
L89: // GOTO
  goto L90;
L90: // GOTO
  goto L91;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L97;
L95: // INIT_INT
  int_vars[6] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L97;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 770;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L6: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 770;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L8: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 771;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L17: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // MOVE_INT
  int_vars[3] = int_vars[2];
L22: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 772;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L25: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L26: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // MOVE_INT
  int_vars[3] = int_vars[2];
L31: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 773;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L34: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L35: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // MOVE_INT
  int_vars[3] = int_vars[2];
L40: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 774;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L43: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L44: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 775;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L52: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L53: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L57: // MOVE_INT
  int_vars[3] = int_vars[2];
L58: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 776;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L61: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L62: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L66: // MOVE_INT
  int_vars[3] = int_vars[2];
L67: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 777;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 7;
L70: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L71: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 778;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 8;
L79: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L80: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L83: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 779;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L86: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L105;
L91: // GOTO
  goto L92;
L92: // GOTO
  goto L93;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L105;
L103: // INIT_INT
  int_vars[6] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L105;
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_mulnum_array_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 716;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L6: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L7: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 716;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L9: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L10: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // MOVE_INT
  int_vars[3] = int_vars[2];
L15: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 717;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L17: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // MOVE_INT
  int_vars[3] = int_vars[2];
L24: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 718;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L26: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L27: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L28: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // MOVE_INT
  int_vars[3] = int_vars[2];
L33: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 719;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L35: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L36: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L37: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // MOVE_INT
  int_vars[3] = int_vars[2];
L42: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 720;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L44: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L46: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L50: // MOVE_INT
  int_vars[3] = int_vars[2];
L51: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 721;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L53: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L55: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L59: // MOVE_INT
  int_vars[3] = int_vars[2];
L60: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 722;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L62: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L64: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L68: // MOVE_INT
  int_vars[3] = int_vars[2];
L69: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 723;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L71: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 7;
L73: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L77: // MOVE_INT
  int_vars[3] = int_vars[2];
L78: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 724;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L80: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L81: // MOVE_CONSTANT_INT
  int_vars[5] = 8;
L82: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L85: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_mulnum_array_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 725;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L88: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // GOTO
  goto L102;
L102: // GOTO
  goto L103;
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L107;
L105: // INIT_INT
  int_vars[6] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_barray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L9: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L14: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L17: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 506;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L20: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 506;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L22: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L24: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L30: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 507;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L33: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 507;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L35: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L36: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L37: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L43: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L46: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L48: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L49: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L50: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L53: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L56: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 509;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L59: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 509;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L61: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L63: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L69: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L72: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_barray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 510;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L74: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L75: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L76: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L103;
L82: // GOTO
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // GOTO
  goto L86;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // GOTO
  goto L89;
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // GOTO
  goto L92;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L93: // GOTO
  goto L95;
L94: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // GOTO
  goto L98;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L103;
L101: // INIT_INT
  int_vars[6] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_darray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 595;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 595;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L11: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L14: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L17: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 596;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L20: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 596;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L23: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L24: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L30: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L33: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L36: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L37: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L43: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 598;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L46: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 598;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L49: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L50: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L53: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L56: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L59: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L62: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L63: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L69: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L72: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_darray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L75: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L76: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L103;
L82: // GOTO
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // GOTO
  goto L86;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // GOTO
  goto L89;
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // GOTO
  goto L92;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L93: // GOTO
  goto L95;
L94: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // GOTO
  goto L98;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L103;
L101: // INIT_INT
  int_vars[6] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_farray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 577;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 577;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L11: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L14: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L17: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 578;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L20: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 578;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L23: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L24: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L30: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 579;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L33: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 579;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L36: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L37: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L43: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L46: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L49: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L50: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L53: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L56: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 581;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L59: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 581;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L62: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L63: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L69: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 582;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L72: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_farray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 582;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L75: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L76: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L103;
L82: // GOTO
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // GOTO
  goto L86;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // GOTO
  goto L89;
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // GOTO
  goto L92;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L93: // GOTO
  goto L95;
L94: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // GOTO
  goto L98;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L103;
L101: // INIT_INT
  int_vars[6] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_iarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L16: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 542;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 542;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L22: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 543;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L31: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 543;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L43: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L46: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L52: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 545;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L55: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 545;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L58: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L79; }
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L64: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 546;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L67: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_iarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 546;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L97;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L70: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L71: // BOOL_INT
  int_vars[0] = int_vars[0];
L72: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L73: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L75: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L97;
L76: // GOTO
  goto L77;
L77: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L78: // GOTO
  goto L80;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // GOTO
  goto L83;
L82: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // GOTO
  goto L86;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // GOTO
  goto L89;
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // GOTO
  goto L92;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L97;
L95: // INIT_INT
  int_vars[6] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L97;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_larray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 559;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 559;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L11: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L14: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L17: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 560;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L20: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 560;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L23: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L24: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L30: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 561;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L33: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 561;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L36: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L37: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L91; }
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L43: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 562;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L46: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 562;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L49: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L50: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L51: // BOOL_INT
  int_vars[0] = int_vars[0];
L52: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L88; }
L53: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L56: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L59: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L62: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L63: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L85; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L69: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 564;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L72: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_larray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 564;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L103;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L75: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L76: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L83; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L80: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L81: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L103;
L82: // GOTO
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // GOTO
  goto L86;
L85: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L86: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L87: // GOTO
  goto L89;
L88: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // GOTO
  goto L92;
L91: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L92: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L93: // GOTO
  goto L95;
L94: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // GOTO
  goto L98;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L103;
L101: // INIT_INT
  int_vars[6] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L103;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_oarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L6: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_int < 0, 0)) {
      FIELD_ID_TestCase__x_int = env->get_field_id(env, "TestCase", "x_int", "int");
      if (FIELD_ID_TestCase__x_int < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_int = env->get_field_offset(env, FIELD_ID_TestCase__x_int);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_int);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L9: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 495;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L17: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_int < 0, 0)) {
      FIELD_ID_TestCase__x_int = env->get_field_id(env, "TestCase", "x_int", "int");
      if (FIELD_ID_TestCase__x_int < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_int = env->get_field_offset(env, FIELD_ID_TestCase__x_int);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_int);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_oarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 495;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L20: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L26: // GOTO
  goto L27;
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // GOTO
  goto L30;
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_object_array_len_element_sarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 523;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 523;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L9: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L13: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L109; }
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L22: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L24: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L26: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L27: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L28: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L34: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 525;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L37: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 525;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L39: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L40: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L41: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L42: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L43: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L49: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L52: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L54: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L56: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L57: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L58: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L64: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L67: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L69: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L70: // MOVE_CONSTANT_INT
  int_vars[5] = 5;
L71: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L72: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L73: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L79: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L82: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_object_array_len_element_sarray";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L84: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L85: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L86: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L87: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L88: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L115;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // GOTO
  goto L98;
L97: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // GOTO
  goto L101;
L100: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L101: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L102: // GOTO
  goto L104;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L105: // GOTO
  goto L107;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // GOTO
  goto L110;
L109: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L110: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L111: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L115;
L113: // INIT_INT
  int_vars[6] = 0;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L115;
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_new_short_array_binary_pack(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_short_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L5: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 97;
L7: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L8: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L9: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_short_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 420;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L15: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 98;
L17: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L18: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L19: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L23: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_short_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L25: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L26: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_short_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L28: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L29: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[2];
L30: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L33: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_new_short_array_binary_pack";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L36: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L49;
L41: // GOTO
  goto L42;
L42: // GOTO
  goto L43;
L43: // GOTO
  goto L44;
L44: // GOTO
  goto L45;
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L49;
L47: // INIT_INT
  int_vars[6] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L49;
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_object_set(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[2];
  float float_vars[2];
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  int8_t byte_vars[1];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_byte < 0, 0)) {
      FIELD_ID_TestCase__x_byte = env->get_field_id(env, "TestCase", "x_byte", "byte");
      if (FIELD_ID_TestCase__x_byte < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_byte = env->get_field_offset(env, FIELD_ID_TestCase__x_byte);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_byte);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L4: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 127;
L6: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L72; }
L9: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_short < 0, 0)) {
      FIELD_ID_TestCase__x_short = env->get_field_id(env, "TestCase", "x_short", "short");
      if (FIELD_ID_TestCase__x_short < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_short");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_short = env->get_field_offset(env, FIELD_ID_TestCase__x_short);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_short);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L11: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 32767;
L13: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L16: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_int < 0, 0)) {
      FIELD_ID_TestCase__x_int = env->get_field_id(env, "TestCase", "x_int", "int");
      if (FIELD_ID_TestCase__x_int < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_int = env->get_field_offset(env, FIELD_ID_TestCase__x_int);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_int);
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 2147483647;
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L22: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_long < 0, 0)) {
      FIELD_ID_TestCase__x_long = env->get_field_id(env, "TestCase", "x_long", "long");
      if (FIELD_ID_TestCase__x_long < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_long");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_long = env->get_field_offset(env, FIELD_ID_TestCase__x_long);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_long);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 291;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L24: // MOVE_CONSTANT_LONG
  long_vars[1] = 9223372036854775807LL;
L25: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L28: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_float < 0, 0)) {
      FIELD_ID_TestCase__x_float = env->get_field_id(env, "TestCase", "x_float", "float");
      if (FIELD_ID_TestCase__x_float < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_float");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_float = env->get_field_offset(env, FIELD_ID_TestCase__x_float);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_float);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L30: // CALL_SUB_FLOAT
  // TestCase::ExchangeAPI->FLOAT_PRECICE
  {
    if (SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE < 0) {
      SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE = env->get_sub_id(env, "TestCase::ExchangeAPI", "FLOAT_PRECICE", "float()");
      if (SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::ExchangeAPI FLOAT_PRECICE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE;
    exception_flag = SPPRECOMPILE__TestCase__ExchangeAPI__FLOAT_PRECICE(env, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L32: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L35: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_double < 0, 0)) {
      FIELD_ID_TestCase__x_double = env->get_field_id(env, "TestCase", "x_double", "double");
      if (FIELD_ID_TestCase__x_double < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_double = env->get_field_offset(env, FIELD_ID_TestCase__x_double);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_double);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L37: // CALL_SUB_DOUBLE
  // TestCase::ExchangeAPI->DOUBLE_PRECICE
  {
    if (SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE < 0) {
      SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE = env->get_sub_id(env, "TestCase::ExchangeAPI", "DOUBLE_PRECICE", "double()");
      if (SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::ExchangeAPI DOUBLE_PRECICE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE;
    exception_flag = SPPRECOMPILE__TestCase__ExchangeAPI__DOUBLE_PRECICE(env, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L39: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L43: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__minimal < 0, 0)) {
      FIELD_ID_TestCase__minimal = env->get_field_id(env, "TestCase", "minimal", "TestCase::Minimal");
      if (FIELD_ID_TestCase__minimal < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__minimal = env->get_field_offset(env, FIELD_ID_TestCase__minimal);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__minimal);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L45: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L78;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L48: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L78;
L54: // GOTO
  goto L55;
L55: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L56: // GOTO
  goto L58;
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L59: // GOTO
  goto L61;
L60: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L61: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L62: // GOTO
  goto L64;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // GOTO
  goto L67;
L66: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L67: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L68: // GOTO
  goto L70;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L71: // GOTO
  goto L73;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L75: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L78;
L76: // INIT_INT
  int_vars[6] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_object_set_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_iarray < 0, 0)) {
      FIELD_ID_TestCase__x_iarray = env->get_field_id(env, "TestCase", "x_iarray", "int[]");
      if (FIELD_ID_TestCase__x_iarray < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_iarray = env->get_field_offset(env, FIELD_ID_TestCase__x_iarray);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_iarray);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 262;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__x_barray < 0, 0)) {
      FIELD_ID_TestCase__x_barray = env->get_field_id(env, "TestCase", "x_barray", "byte[]");
      if (FIELD_ID_TestCase__x_barray < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase x_barray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__x_barray = env->get_field_offset(env, FIELD_ID_TestCase__x_barray);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__x_barray);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L8: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 267;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L11: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L67; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 2147483647;
L18: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 269;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 2147483647;
L25: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 271;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L31: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 97;
L33: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L39: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 98;
L41: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L45: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 273;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L47: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 99;
L49: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L62; }
L52: // ARRAY_LENGTH
  if (object_vars[2] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[2] + (intptr_t)env->object_length_offset);
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_object_set_object";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L55: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L61; }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L60: // GOTO
  goto L61;
L61: // GOTO
  goto L62;
L62: // GOTO
  goto L63;
L63: // GOTO
  goto L64;
L64: // GOTO
  goto L65;
L65: // GOTO
  goto L66;
L66: // GOTO
  goto L67;
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L69: // INIT_INT
  int_vars[6] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 615;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L5: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 616;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_byte";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 616;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L17: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 665;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.0;
L6: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L12: // CALL_SUB_DOUBLE
  // TestCase::ExchangeAPI->DOUBLE_PRECICE
  {
    if (SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE < 0) {
      SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE = env->get_sub_id(env, "TestCase::ExchangeAPI", "DOUBLE_PRECICE", "double()");
      if (SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::ExchangeAPI DOUBLE_PRECICE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__ExchangeAPI__DOUBLE_PRECICE;
    exception_flag = SPPRECOMPILE__TestCase__ExchangeAPI__DOUBLE_PRECICE(env, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_double";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L14: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 655;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L5: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.0;
L6: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L12: // CALL_SUB_FLOAT
  // TestCase::ExchangeAPI->FLOAT_PRECICE
  {
    if (SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE < 0) {
      SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE = env->get_sub_id(env, "TestCase::ExchangeAPI", "FLOAT_PRECICE", "float()");
      if (SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::ExchangeAPI FLOAT_PRECICE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__ExchangeAPI__FLOAT_PRECICE;
    exception_flag = SPPRECOMPILE__TestCase__ExchangeAPI__FLOAT_PRECICE(env, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_float";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 656;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L14: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[2] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 635;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L6: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // ARRAY_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 636;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L12: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 636;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L14: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L5: // MOVE_CONSTANT_LONG
  long_vars[1] = 0LL;
L6: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L12: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_long";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L14: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_mulnum_t_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // MOVE_INT
  int_vars[2] = int_vars[1];
L4: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_mulnum_t_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 676;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L6: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_mulnum_t_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 676;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L8: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // MOVE_INT
  int_vars[3] = int_vars[2];
L13: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 1]; 
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_mulnum_t_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 677;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // MOVE_INT
  int_vars[3] = int_vars[2];
L21: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 2]; 
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_mulnum_t_int";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 678;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L36;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L24: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L36;
L29: // GOTO
  goto L30;
L30: // GOTO
  goto L31;
L31: // GOTO
  goto L32;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L36;
L34: // INIT_INT
  int_vars[6] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L36;
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__spvm_set_and_get_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[1];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L5: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L24; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L13: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "spvm_set_and_get_short";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L17: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L22: // GOTO
  goto L23;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[6] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ExchangeAPI__string_argments_and_return_value(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[3];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L4: // CONCAT
  {
    void* string1 = object_vars[0];
    void* string2 = object_vars[1];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string3);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ExchangeAPI";
    const char* sub_name = "string_argments_and_return_value";
    const char* file = "TestCase/ExchangeAPI.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L10;
  }
L6: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[2];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L10;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L9: // RETURN_OBJECT
  *(void**)&stack[0] = object_vars[3];
  if (*(void**)&stack[0] != NULL) {
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(*(void**)&stack[0]);
  }
  goto L10;
L10: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L11: // END_SUB
  if (!exception_flag) {
    if (stack[0].oval != NULL) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(stack[0].oval); }
  }
  return exception_flag;
}


