#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Enum__PRIVATE_VALUE = - 1;
static int32_t SUB_ID_TestCase__Enum__INT_ZERO = - 1;
static int32_t SUB_ID_TestCase__Enum__INT_ONE = - 1;
static int32_t SUB_ID_TestCase__Enum__INT_THREE = - 1;
static int32_t SUB_ID_TestCase__Enum__INT_FOUR = - 1;
static int32_t SUB_ID_TestCase__Enum__INT_SIX = - 1;
static int32_t SUB_ID_TestCase__Enum__INT_MINUS_MAX = - 1;
static int32_t SUB_ID_TestCase__Enum__Data1__ONE = - 1;
static int32_t SUB_ID_TestCase__Enum__Data1__TWO = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Enum__enum_descriptor(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Enum__enum_int(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Enum__enum_descriptor(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 12;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Enum__enum_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L19: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L24: // GOTO
  goto L25;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L26: // MOVE_CONSTANT_INT
  int_vars[5] = 4;
L27: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 6;
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 6;
L35: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L40: // GOTO
  goto L41;
L41: // MOVE_CONSTANT_INT
  int_vars[4] = INT32_MIN;
L42: // MOVE_CONSTANT_INT
  int_vars[5] = INT32_MIN;
L43: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_NE_ZERO
  if (int_vars[0]) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L50: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L51: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L56: // GOTO
  goto L57;
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L58: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L59: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_NE_ZERO
  if (int_vars[0]) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L63: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L64: // GOTO
  goto L65;
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L67: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_NE_ZERO
  if (int_vars[0]) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L72: // GOTO
  goto L73;
L73: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L77;
L75: // INIT_INT
  int_vars[6] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L77;
L77: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


