#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_duplicate(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_elsbool_2(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_else(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_elsif(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_byte_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_byte_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_double_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_double_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_float_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_float_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_int_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_int_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_long_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_long_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_object_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_object_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_short_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_short_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_byte_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_byte_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_byte_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_double_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_double_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_double_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_float_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_float_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_float_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_int_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_int_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_int_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_long_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_long_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_long_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_short_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_short_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_short_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_byte_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_byte_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_byte_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_double_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_double_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_double_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_float_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_float_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_float_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_int_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_int_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_int_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_long_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_long_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_long_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_short_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_short_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_short_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_byte_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_byte_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_byte_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_double_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_double_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_double_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_float_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_float_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_float_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_int_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_int_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_int_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_long_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_long_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_long_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_short_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_short_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_short_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_byte_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_byte_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_byte_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_double_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_double_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_double_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_float_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_float_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_float_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_int_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_int_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_int_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_long_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_long_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_long_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_short_left_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_short_right_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_short_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_byte_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_byte_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_double_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_double_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_float_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_float_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_int_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_int_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_long_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_long_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_object_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_object_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_short_different(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_short_same(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_eq(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_ge(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_gt(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_le(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_lt(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_ne(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_duplicate(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L9: // GOTO
  goto L18;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[4];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L15: // GOTO
  goto L18;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L21: // INIT_INT
  int_vars[8] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_elsbool_2(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L6: // GOTO
  goto L21;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // BOOL_INT
  int_vars[0] = int_vars[4];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L12: // GOTO
  goto L21;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[4];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L23: // INIT_INT
  int_vars[8] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_else(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L6: // GOTO
  goto L9;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L9: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L11: // INIT_INT
  int_vars[8] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_elsif(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L19;
L6: // GOTO
  goto L15;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // BOOL_INT
  int_vars[0] = int_vars[4];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L19;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L17: // INIT_INT
  int_vars[8] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L19;
L19: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // BOOL_INT
  int_vars[0] = int_vars[2];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L2: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[0];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L2: // BOOL_FLOAT
  int_vars[0] = !!float_vars[0];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 0LL;
L2: // BOOL_LONG
  int_vars[0] = !!long_vars[0];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_false_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // BOOL_INT
  int_vars[0] = int_vars[2];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // BOOL_INT
  int_vars[0] = int_vars[2];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L2: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[0];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L2: // BOOL_FLOAT
  int_vars[0] = !!float_vars[0];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // BOOL_INT
  int_vars[0] = int_vars[1];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[1];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 1LL;
L2: // BOOL_LONG
  int_vars[0] = !!long_vars[0];
L3: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L7; }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L11;
L6: // GOTO
  goto L7;
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L11;
L9: // INIT_INT
  int_vars[6] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L11;
L11: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "bool_true_object";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 448;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L15;
  }
L4: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L6: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L9: // GOTO
  goto L10;
L10: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L16: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__bool_true_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // BOOL_INT
  int_vars[0] = int_vars[2];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_byte_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_byte_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_double_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_double_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_float_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L3: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_float_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_int_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_int_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L39;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L11: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L12: // MOVE_INT
  int_vars[6] = int_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[2];
L15: // MOVE_INT
  int_vars[0] = int_vars[0];
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[2]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L23: // BOOL_INT
  int_vars[0] = int_vars[2];
L24: // GOTO
  goto L27;
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // BOOL_INT
  int_vars[0] = int_vars[3];
L27: // GOTO
  goto L30;
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L29: // BOOL_INT
  int_vars[0] = int_vars[4];
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L39;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L39;
L37: // INIT_INT
  int_vars[7] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L39;
L39: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_long_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_long_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_object_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "numeric_eq_object_different";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 722;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L17;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "numeric_eq_object_different";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 723;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L17;
  }
L7: // EQ_OBJECT
  int_vars[0] = (object_vars[0] == object_vars[1]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_object_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "numeric_eq_object_same";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 711;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // EQ_OBJECT
  int_vars[0] = (object_vars[0] == object_vars[0]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_short_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_short_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_eq_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // BOOL_INT
  int_vars[0] = int_vars[2];
L5: // MOVE_INT
  int_vars[0] = int_vars[0];
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L8: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L11: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L16: // GOTO
  goto L17;
L17: // GOTO
  goto L18;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_byte_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // GE_INT
  int_vars[0] = (int_vars[2] >= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_byte_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // GE_INT
  int_vars[0] = (int_vars[2] >= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_byte_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // GE_INT
  int_vars[0] = (int_vars[2] >= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_double_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // GE_DOUBLE
  int_vars[0] = (double_vars[0] >= double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_double_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // GE_DOUBLE
  int_vars[0] = (double_vars[0] >= double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_double_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // GE_DOUBLE
  int_vars[0] = (double_vars[0] >= double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_float_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // GE_FLOAT
  int_vars[0] = (float_vars[0] >= float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_float_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // GE_FLOAT
  int_vars[0] = (float_vars[0] >= float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_float_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // GE_FLOAT
  int_vars[0] = (float_vars[0] >= float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_int_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // GE_INT
  int_vars[0] = (int_vars[1] >= int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_int_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L3: // GE_INT
  int_vars[0] = (int_vars[1] >= int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_int_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // GE_INT
  int_vars[0] = (int_vars[1] >= int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_long_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // GE_LONG
  int_vars[0] = (long_vars[0] >= long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_long_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // GE_LONG
  int_vars[0] = (long_vars[0] >= long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_long_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // GE_LONG
  int_vars[0] = (long_vars[0] >= long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_short_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // GE_INT
  int_vars[0] = (int_vars[2] >= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_short_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // GE_INT
  int_vars[0] = (int_vars[2] >= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ge_short_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // GE_INT
  int_vars[0] = (int_vars[2] >= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_byte_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // GT_INT
  int_vars[0] = (int_vars[2] > int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_byte_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // GT_INT
  int_vars[0] = (int_vars[2] > int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_byte_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // GT_INT
  int_vars[0] = (int_vars[2] > int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_double_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // GT_DOUBLE
  int_vars[0] = (double_vars[0] > double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_double_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // GT_DOUBLE
  int_vars[0] = (double_vars[0] > double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_double_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // GT_DOUBLE
  int_vars[0] = (double_vars[0] > double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_float_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // GT_FLOAT
  int_vars[0] = (float_vars[0] > float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_float_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // GT_FLOAT
  int_vars[0] = (float_vars[0] > float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_float_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // GT_FLOAT
  int_vars[0] = (float_vars[0] > float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_int_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // GT_INT
  int_vars[0] = (int_vars[1] > int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_int_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L3: // GT_INT
  int_vars[0] = (int_vars[1] > int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_int_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // GT_INT
  int_vars[0] = (int_vars[1] > int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_long_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // GT_LONG
  int_vars[0] = (long_vars[0] > long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_long_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // GT_LONG
  int_vars[0] = (long_vars[0] > long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_long_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // GT_LONG
  int_vars[0] = (long_vars[0] > long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_short_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // GT_INT
  int_vars[0] = (int_vars[2] > int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_short_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // GT_INT
  int_vars[0] = (int_vars[2] > int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_gt_short_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // GT_INT
  int_vars[0] = (int_vars[2] > int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_byte_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // LE_INT
  int_vars[0] = (int_vars[2] <= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_byte_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // LE_INT
  int_vars[0] = (int_vars[2] <= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_byte_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // LE_INT
  int_vars[0] = (int_vars[2] <= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_double_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // LE_DOUBLE
  int_vars[0] = (double_vars[0] <= double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_double_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // LE_DOUBLE
  int_vars[0] = (double_vars[0] <= double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_double_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // LE_DOUBLE
  int_vars[0] = (double_vars[0] <= double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_float_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // LE_FLOAT
  int_vars[0] = (float_vars[0] <= float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_float_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // LE_FLOAT
  int_vars[0] = (float_vars[0] <= float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_float_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // LE_FLOAT
  int_vars[0] = (float_vars[0] <= float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_int_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // LE_INT
  int_vars[0] = (int_vars[1] <= int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_int_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L3: // LE_INT
  int_vars[0] = (int_vars[1] <= int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_int_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // LE_INT
  int_vars[0] = (int_vars[1] <= int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_long_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // LE_LONG
  int_vars[0] = (long_vars[0] <= long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_long_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // LE_LONG
  int_vars[0] = (long_vars[0] <= long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_long_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // LE_LONG
  int_vars[0] = (long_vars[0] <= long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_short_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // LE_INT
  int_vars[0] = (int_vars[2] <= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_short_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // LE_INT
  int_vars[0] = (int_vars[2] <= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_le_short_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // LE_INT
  int_vars[0] = (int_vars[2] <= int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_byte_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_byte_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_byte_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_double_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // LT_DOUBLE
  int_vars[0] = (double_vars[0] < double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_double_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // LT_DOUBLE
  int_vars[0] = (double_vars[0] < double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_double_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L5: // LT_DOUBLE
  int_vars[0] = (double_vars[0] < double_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_float_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // LT_FLOAT
  int_vars[0] = (float_vars[0] < float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_float_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // LT_FLOAT
  int_vars[0] = (float_vars[0] < float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_float_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L5: // LT_FLOAT
  int_vars[0] = (float_vars[0] < float_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_int_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // LT_INT
  int_vars[0] = (int_vars[1] < int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_int_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L3: // LT_INT
  int_vars[0] = (int_vars[1] < int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_int_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // LT_INT
  int_vars[0] = (int_vars[1] < int_vars[2]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_long_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // LT_LONG
  int_vars[0] = (long_vars[0] < long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_long_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // LT_LONG
  int_vars[0] = (long_vars[0] < long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_long_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // LT_LONG
  int_vars[0] = (long_vars[0] < long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_short_left_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_short_right_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_lt_short_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_byte_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // NE_INT
  int_vars[0] = (int_vars[2] != int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_byte_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // NE_INT
  int_vars[0] = (int_vars[2] != int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_double_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L3: // NE_DOUBLE
  int_vars[0] = (double_vars[0] != double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_double_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // NE_DOUBLE
  int_vars[0] = (double_vars[0] != double_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_float_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L3: // NE_FLOAT
  int_vars[0] = (float_vars[0] != float_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_float_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // NE_FLOAT
  int_vars[0] = (float_vars[0] != float_vars[1]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L13;
L8: // GOTO
  goto L11;
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L13;
L11: // INIT_INT
  int_vars[6] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_int_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // NE_INT
  int_vars[0] = (int_vars[2] != int_vars[4]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_int_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_INT
  int_vars[2] = int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // NE_INT
  int_vars[0] = (int_vars[2] != int_vars[4]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_long_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // NE_LONG
  int_vars[0] = (long_vars[0] != long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_long_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L4: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L5: // NE_LONG
  int_vars[0] = (long_vars[0] != long_vars[1]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_object_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "numeric_ne_object_different";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 883;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L17;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "numeric_ne_object_different";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 884;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L17;
  }
L7: // NE_OBJECT
  int_vars[0] = (object_vars[0] != object_vars[1]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_object_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "numeric_ne_object_same";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 872;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L4: // NE_OBJECT
  int_vars[0] = (object_vars[0] != object_vars[0]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L12;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_short_different(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // NE_INT
  int_vars[0] = (int_vars[2] != int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_short_same(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // NE_INT
  int_vars[0] = (int_vars[2] != int_vars[4]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L17;
L12: // GOTO
  goto L15;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L17;
L15: // INIT_INT
  int_vars[6] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L17;
L17: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__numeric_ne_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "numeric_ne_undef";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 735;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // MOVE_INT
  int_vars[0] = int_vars[0];
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L10; }
L9: // GOTO
  goto L20;
L10: // IS_NOT_UNDEF
  int_vars[0] = object_vars[0] != NULL;
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L13: // IS_NOT_UNDEF
  int_vars[0] = object_vars[0] != NULL;
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L18: // GOTO
  goto L19;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_eq(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[10] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62", 2));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L10: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x64", 2));
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x64\x63\x64", 4));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "", 0));
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[8]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L29: // GOTO
  goto L30;
L30: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L35: // BOOL_INT
  int_vars[0] = int_vars[3];
L36: // GOTO
  goto L39;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L38: // BOOL_INT
  int_vars[0] = int_vars[4];
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L43: // GOTO
  goto L44;
L44: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 23;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L49: // BOOL_INT
  int_vars[0] = int_vars[3];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[4];
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_NE_ZERO
  if (int_vars[0]) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L57: // GOTO
  goto L58;
L58: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 26;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L63: // BOOL_INT
  int_vars[0] = int_vars[3];
L64: // GOTO
  goto L67;
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // BOOL_INT
  int_vars[0] = int_vars[4];
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L71: // GOTO
  goto L72;
L72: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[5];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L77: // BOOL_INT
  int_vars[0] = int_vars[3];
L78: // GOTO
  goto L81;
L79: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L80: // BOOL_INT
  int_vars[0] = int_vars[4];
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L83: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L85: // GOTO
  goto L86;
L86: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 32;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L91: // BOOL_INT
  int_vars[0] = int_vars[3];
L92: // GOTO
  goto L95;
L93: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L94: // BOOL_INT
  int_vars[0] = int_vars[4];
L95: // BOOL_INT
  int_vars[0] = int_vars[0];
L96: // IF_NE_ZERO
  if (int_vars[0]) { goto L100; }
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L98: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L99: // GOTO
  goto L100;
L100: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[9];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_NE_ZERO
  if (int_vars[0]) { goto L107; }
L104: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L105: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L106: // GOTO
  goto L107;
L107: // STRING_EQ
  {
    void* object1 = object_vars[9];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L108: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L111: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L113: // GOTO
  goto L114;
L114: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L116: // MOVE_INT
  int_vars[5] = int_vars[0];
L117: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L118: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L119: // BOOL_INT
  int_vars[0] = int_vars[0];
L120: // IF_NE_ZERO
  if (int_vars[0]) { goto L124; }
L121: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L123: // GOTO
  goto L124;
L124: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 49;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L172;
  }
L126: // MOVE_INT
  int_vars[5] = int_vars[0];
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L128: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L129: // BOOL_INT
  int_vars[0] = int_vars[0];
L130: // IF_NE_ZERO
  if (int_vars[0]) { goto L134; }
L131: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L132: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L133: // GOTO
  goto L134;
L134: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L135: // STRING_EQ
  {
    void* object1 = object_vars[7];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L136: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 57;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L137: // BOOL_INT
  int_vars[0] = int_vars[0];
L138: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L140; }
L139: // GOTO
  goto L140;
L140: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L141: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L142: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L143: // IF_NE_ZERO
  if (int_vars[0]) { goto L148; }
L144: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L145: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L146: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L147: // GOTO
  goto L148;
L148: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L149: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L150: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L151: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L152: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[7];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L153: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_eq";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 69;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L157;
  }
L154: // BOOL_INT
  int_vars[0] = int_vars[0];
L155: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L157; }
L156: // GOTO
  goto L157;
L157: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L158: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L159: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L160: // IF_NE_ZERO
  if (int_vars[0]) { goto L165; }
L161: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L162: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L163: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L164: // GOTO
  goto L165;
L165: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L166: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L167: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L168: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L169: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L172;
L170: // INIT_INT
  int_vars[5] = 0;
L171: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L172;
L172: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L173: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_ge(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[10] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62", 2));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L10: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x64", 2));
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x64\x63\x64", 4));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "", 0));
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[8]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L22: // STRING_GE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L28: // GOTO
  goto L29;
L29: // STRING_GE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L35: // GOTO
  goto L36;
L36: // STRING_GE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 226;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[2];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L44: // BOOL_INT
  int_vars[0] = int_vars[3];
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_NE_ZERO
  if (int_vars[0]) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L49: // GOTO
  goto L50;
L50: // STRING_GE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 229;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // BOOL_INT
  int_vars[0] = int_vars[2];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L63: // GOTO
  goto L64;
L64: // STRING_GE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[5];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 232;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // BOOL_INT
  int_vars[0] = int_vars[2];
L70: // GOTO
  goto L73;
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L72: // BOOL_INT
  int_vars[0] = int_vars[3];
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L77: // GOTO
  goto L78;
L78: // STRING_GE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L84: // GOTO
  goto L85;
L85: // STRING_GE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[9];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_NE_ZERO
  if (int_vars[0]) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L91: // GOTO
  goto L92;
L92: // STRING_GE
  {
    void* object1 = object_vars[9];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L98: // GOTO
  goto L99;
L99: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L100: // STRING_GE
  {
    void* object1 = object_vars[7];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L101: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 247;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L105; }
L104: // GOTO
  goto L105;
L105: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L106: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L107: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L109: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L112: // GOTO
  goto L113;
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L117: // STRING_GE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[7];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp >= 0);
    }
  }
L118: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ge";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 259;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L122;
  }
L119: // BOOL_INT
  int_vars[0] = int_vars[0];
L120: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L122; }
L121: // GOTO
  goto L122;
L122: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L123: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L124: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L125: // IF_NE_ZERO
  if (int_vars[0]) { goto L130; }
L126: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L127: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L129: // GOTO
  goto L130;
L130: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L131: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L132: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L133: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L135: // INIT_INT
  int_vars[4] = 0;
L136: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L137;
L137: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L138: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_gt(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[10] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62", 2));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L10: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x64", 2));
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x64\x63\x64", 4));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "", 0));
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[8]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L22: // STRING_GT
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L158;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L35: // GOTO
  goto L36;
L36: // STRING_GT
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L158;
  }
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L42: // GOTO
  goto L43;
L43: // STRING_GT
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L158;
  }
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // BOOL_INT
  int_vars[0] = int_vars[2];
L49: // GOTO
  goto L52;
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L51: // BOOL_INT
  int_vars[0] = int_vars[3];
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L56: // GOTO
  goto L57;
L57: // STRING_GT
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L158;
  }
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // BOOL_INT
  int_vars[0] = int_vars[2];
L63: // GOTO
  goto L66;
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L65: // BOOL_INT
  int_vars[0] = int_vars[3];
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L70: // GOTO
  goto L71;
L71: // STRING_GT
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[5];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L158;
  }
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L78; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // BOOL_INT
  int_vars[0] = int_vars[2];
L77: // GOTO
  goto L80;
L78: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L79: // BOOL_INT
  int_vars[0] = int_vars[3];
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L84: // GOTO
  goto L85;
L85: // STRING_GT
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 172;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L158;
  }
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_NE_ZERO
  if (int_vars[0]) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L91: // GOTO
  goto L92;
L92: // STRING_GT
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[9];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 175;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L158;
  }
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // BOOL_INT
  int_vars[0] = int_vars[2];
L98: // GOTO
  goto L101;
L99: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L100: // BOOL_INT
  int_vars[0] = int_vars[3];
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L105: // GOTO
  goto L106;
L106: // STRING_GT
  {
    void* object1 = object_vars[9];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 178;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L158;
  }
L108: // BOOL_INT
  int_vars[0] = int_vars[0];
L109: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L113; }
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // BOOL_INT
  int_vars[0] = int_vars[2];
L112: // GOTO
  goto L115;
L113: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L114: // BOOL_INT
  int_vars[0] = int_vars[3];
L115: // BOOL_INT
  int_vars[0] = int_vars[0];
L116: // IF_NE_ZERO
  if (int_vars[0]) { goto L120; }
L117: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L119: // GOTO
  goto L120;
L120: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L121: // STRING_GT
  {
    void* object1 = object_vars[7];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L122: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 184;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L123: // BOOL_INT
  int_vars[0] = int_vars[0];
L124: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L126; }
L125: // GOTO
  goto L126;
L126: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L127: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L128: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L129: // IF_NE_ZERO
  if (int_vars[0]) { goto L134; }
L130: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L132: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L133: // GOTO
  goto L134;
L134: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L135: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L136: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L137: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L138: // STRING_GT
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[7];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 1);
    }
  }
L139: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_gt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 196;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L143;
  }
L140: // BOOL_INT
  int_vars[0] = int_vars[0];
L141: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L143; }
L142: // GOTO
  goto L143;
L143: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L144: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L145: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L146: // IF_NE_ZERO
  if (int_vars[0]) { goto L151; }
L147: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L148: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L149: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L150: // GOTO
  goto L151;
L151: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L152: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L153: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L154: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L155: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L158;
L156: // INIT_INT
  int_vars[4] = 0;
L157: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L158;
L158: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L159: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_le(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[10] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62", 2));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L10: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x64", 2));
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x64\x63\x64", 4));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "", 0));
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[8]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L23: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L30; }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L29: // GOTO
  goto L30;
L30: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L35: // BOOL_INT
  int_vars[0] = int_vars[3];
L36: // GOTO
  goto L39;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L38: // BOOL_INT
  int_vars[0] = int_vars[4];
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L43: // GOTO
  goto L44;
L44: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 353;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L49: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L50: // GOTO
  goto L51;
L51: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 356;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_NE_ZERO
  if (int_vars[0]) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L57: // GOTO
  goto L58;
L58: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[5];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 359;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_NE_ZERO
  if (int_vars[0]) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L63: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L64: // GOTO
  goto L65;
L65: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L70: // BOOL_INT
  int_vars[0] = int_vars[3];
L71: // GOTO
  goto L74;
L72: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L73: // BOOL_INT
  int_vars[0] = int_vars[4];
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L78: // GOTO
  goto L79;
L79: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[9];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L83: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L85: // GOTO
  goto L86;
L86: // STRING_LE
  {
    void* object1 = object_vars[9];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L93; }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L91: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L92: // GOTO
  goto L93;
L93: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L94: // STRING_LE
  {
    void* object1 = object_vars[7];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L95: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 374;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L99;
  }
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L98: // GOTO
  goto L99;
L99: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L100: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L101: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L107; }
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L104: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L105: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L106: // GOTO
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L109: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L110: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L111: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[7];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L112: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_le";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 386;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L116;
  }
L113: // BOOL_INT
  int_vars[0] = int_vars[0];
L114: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L116; }
L115: // GOTO
  goto L116;
L116: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L117: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L118: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L119: // IF_NE_ZERO
  if (int_vars[0]) { goto L124; }
L120: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L121: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L122: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L123: // GOTO
  goto L124;
L124: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L125: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L131;
L129: // INIT_INT
  int_vars[5] = 0;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L131;
L131: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L132: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_lt(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[10] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62", 2));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L10: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x64", 2));
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x64\x63\x64", 4));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "", 0));
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[8]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L22: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L130;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L28: // GOTO
  goto L29;
L29: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L130;
  }
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[2];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // BOOL_INT
  int_vars[0] = int_vars[3];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L42: // GOTO
  goto L43;
L43: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 289;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L130;
  }
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_NE_ZERO
  if (int_vars[0]) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L49: // GOTO
  goto L50;
L50: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L130;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L56: // GOTO
  goto L57;
L57: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[5];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L130;
  }
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L63: // GOTO
  goto L64;
L64: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L130;
  }
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // BOOL_INT
  int_vars[0] = int_vars[2];
L70: // GOTO
  goto L73;
L71: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L72: // BOOL_INT
  int_vars[0] = int_vars[3];
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L77: // GOTO
  goto L78;
L78: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[9];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L130;
  }
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L84: // GOTO
  goto L85;
L85: // STRING_LE
  {
    void* object1 = object_vars[9];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L130;
  }
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_NE_ZERO
  if (int_vars[0]) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L90: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L91: // GOTO
  goto L92;
L92: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L93: // STRING_LE
  {
    void* object1 = object_vars[7];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L94: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 310;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L98;
  }
L95: // BOOL_INT
  int_vars[0] = int_vars[0];
L96: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L97: // GOTO
  goto L98;
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L99: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L100: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L101: // IF_NE_ZERO
  if (int_vars[0]) { goto L106; }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L105: // GOTO
  goto L106;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L108: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L109: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L110: // STRING_LE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[7];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp <= 0);
    }
  }
L111: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_lt";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 322;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L115; }
L114: // GOTO
  goto L115;
L115: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L116: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L117: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L118: // IF_NE_ZERO
  if (int_vars[0]) { goto L123; }
L119: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L120: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L121: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L122: // GOTO
  goto L123;
L123: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L124: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L125: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L126: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L127: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L130;
L128: // INIT_INT
  int_vars[4] = 0;
L129: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L130;
L130: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L131: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__ComparisonOperator__string_ne(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[10] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62", 2));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L10: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x64", 2));
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L12: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x61\x64\x63\x64", 4));
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "", 0));
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[8]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L22: // STRING_NE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 94;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L35: // GOTO
  goto L36;
L36: // STRING_NE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L42: // GOTO
  goto L43;
L43: // STRING_NE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L45: // BOOL_INT
  int_vars[0] = int_vars[0];
L46: // IF_NE_ZERO
  if (int_vars[0]) { goto L50; }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L49: // GOTO
  goto L50;
L50: // STRING_NE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L56: // GOTO
  goto L57;
L57: // STRING_NE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[5];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L63: // GOTO
  goto L64;
L64: // STRING_NE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[6];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L70: // GOTO
  goto L71;
L71: // STRING_NE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[9];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L78; }
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // BOOL_INT
  int_vars[0] = int_vars[2];
L77: // GOTO
  goto L80;
L78: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L79: // BOOL_INT
  int_vars[0] = int_vars[3];
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L84: // GOTO
  goto L85;
L85: // STRING_NE
  {
    void* object1 = object_vars[9];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L137;
  }
L87: // BOOL_INT
  int_vars[0] = int_vars[0];
L88: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L92; }
L89: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L90: // BOOL_INT
  int_vars[0] = int_vars[2];
L91: // GOTO
  goto L94;
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // BOOL_INT
  int_vars[0] = int_vars[3];
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L98: // GOTO
  goto L99;
L99: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L100: // STRING_NE
  {
    void* object1 = object_vars[7];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L101: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 121;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L105; }
L104: // GOTO
  goto L105;
L105: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L106: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L107: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L109: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L112: // GOTO
  goto L113;
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L117: // STRING_NE
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[7];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp != 0);
    }
  }
L118: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::ComparisonOperator";
    const char* sub_name = "string_ne";
    const char* file = "TestCase/ComparisonOperator.spvm";
    int32_t line = 133;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L122;
  }
L119: // BOOL_INT
  int_vars[0] = int_vars[0];
L120: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L122; }
L121: // GOTO
  goto L122;
L122: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L123: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->get_exception(env));
L124: // BOOL_OBJECT
  int_vars[0] = !!object_vars[8];
L125: // IF_NE_ZERO
  if (int_vars[0]) { goto L130; }
L126: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L127: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L129: // GOTO
  goto L130;
L130: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L131: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L132: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L133: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L137;
L135: // INIT_INT
  int_vars[4] = 0;
L136: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L137;
L137: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L138: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


