#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Data__Weaken__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = -1;
static int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = -1;
static int32_t FIELD_ID_TestCase__Weaken__x_int = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Weaken__x_int = -1;
static int32_t FIELD_ID_TestCase__Weaken__x_self = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Weaken__x_self = -1;
// Sub id declarations
// Basic type id declarations
static int32_t BASIC_TYPE_ID_TestCase__Data__Weaken = -1;
static int32_t BASIC_TYPE_ID_TestCase__Weaken = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__isweak_test(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__unweaken_test(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_assign_undef_to_assinged_object(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_assign_undef_to_weakened_field(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_circular_reference(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_circular_reference_weaken_triple(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_circular_reference_weaken_twice(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_cross_reference(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_cross_reference_assign_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_cross_reference_weaken_both(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_cross_reference_weaken_twice(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_self_reference(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_undef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_weaken_ref_count1_object(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Weaken__isweak_test(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "isweak_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 262;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "isweak_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L11: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "isweak_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L13: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "isweak_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 269;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L15: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "isweak_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L17: // ISWEAK_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
int_vars[0]      = env->isweak(env, get_field_object_address);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "isweak_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L23: // GOTO
  goto L24;
L24: // ISWEAK_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
int_vars[0]      = env->isweak(env, get_field_object_address);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "isweak_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L35;
  }
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L35;
L30: // GOTO
  goto L31;
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L35;
L33: // INIT_INT
  int_vars[6] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__unweaken_test(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "unweaken_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 287;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "unweaken_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L11: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "unweaken_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 293;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L13: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "unweaken_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L15: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "unweaken_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 297;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L17: // UNWEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->unweaken(env, get_field_object_address);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "unweaken_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L19: // ISWEAK_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
int_vars[0]      = env->isweak(env, get_field_object_address);
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "unweaken_test";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L30;
  }
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L30;
L25: // GOTO
  goto L26;
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L30;
L28: // INIT_INT
  int_vars[6] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L30;
L30: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L31: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_assign_undef_to_assinged_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L5: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_assinged_object";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L7: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_assinged_object";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L9: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_assinged_object";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L13: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_assinged_object";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L15: // IS_UNDEF
  int_vars[0] = object_vars[2] == NULL;
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L18: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L21: // GOTO
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_assign_undef_to_weakened_field(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_weakened_field";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 196;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L8: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_weakened_field";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 199;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L10: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_weakened_field";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 200;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L12: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_weakened_field";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L14: // SET_FIELD_UNDEF
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
    env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address, NULL);    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_weakened_field";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 203;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L17: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_weakened_field";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 205;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L19: // IS_UNDEF
  int_vars[0] = object_vars[2] == NULL;
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L23: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_assign_undef_to_weakened_field";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 206;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L38;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L38;
L31: // GOTO
  goto L32;
L32: // GOTO
  goto L33;
L33: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L38;
L36: // INIT_INT
  int_vars[6] = 0;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L38;
L38: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L39: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_circular_reference(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 119;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L16: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[2];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 125;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L18: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L20: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[2]    );
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 127;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L22: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 130;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L24: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L27: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L30: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L33: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // BOOL_INT
  int_vars[0] = int_vars[2];
L38: // GOTO
  goto L41;
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // BOOL_INT
  int_vars[0] = int_vars[3];
L41: // GOTO
  goto L44;
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L43: // BOOL_INT
  int_vars[0] = int_vars[4];
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L46: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L69;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L49: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L50: // BOOL_INT
  int_vars[0] = int_vars[0];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // BOOL_INT
  int_vars[0] = int_vars[2];
L54: // GOTO
  goto L57;
L55: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L56: // BOOL_INT
  int_vars[0] = int_vars[3];
L57: // GOTO
  goto L60;
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L59: // BOOL_INT
  int_vars[0] = int_vars[4];
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L63: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L69;
L64: // GOTO
  goto L65;
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L69;
L67: // INIT_INT
  int_vars[6] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L69;
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_circular_reference_weaken_triple(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 167;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L16: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[2];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 176;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L18: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 177;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L20: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[2]    );
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 178;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L22: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L24: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 182;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L26: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L28: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L31: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L34: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L37: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // BOOL_INT
  int_vars[0] = int_vars[2];
L42: // GOTO
  goto L45;
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // BOOL_INT
  int_vars[0] = int_vars[3];
L45: // GOTO
  goto L48;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L47: // BOOL_INT
  int_vars[0] = int_vars[4];
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L62; }
L50: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_triple";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L53: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L57: // BOOL_INT
  int_vars[0] = int_vars[2];
L58: // GOTO
  goto L61;
L59: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L60: // BOOL_INT
  int_vars[0] = int_vars[3];
L61: // GOTO
  goto L64;
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L63: // BOOL_INT
  int_vars[0] = int_vars[4];
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L73;
L68: // GOTO
  goto L69;
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L73;
L71: // INIT_INT
  int_vars[6] = 0;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L73;
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_circular_reference_weaken_twice(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 144;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L11: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L12: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object);
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 147;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L16: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[2];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L18: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 151;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L20: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[2]    );
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L22: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[2];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L24: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 156;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L26: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L29: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L32: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L35: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[2];
L40: // GOTO
  goto L43;
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[3];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[4];
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L48: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_circular_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L71;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L51: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L55: // BOOL_INT
  int_vars[0] = int_vars[2];
L56: // GOTO
  goto L59;
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L58: // BOOL_INT
  int_vars[0] = int_vars[3];
L59: // GOTO
  goto L62;
L60: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L61: // BOOL_INT
  int_vars[0] = int_vars[4];
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L67; }
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L71;
L66: // GOTO
  goto L67;
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L68: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L71;
L69: // INIT_INT
  int_vars[6] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_cross_reference(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L11: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L13: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 38;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L15: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L17: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L23: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L37;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L26: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L37;
L31: // GOTO
  goto L32;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L37;
L35: // INIT_INT
  int_vars[6] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L37;
L37: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L38: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_cross_reference_assign_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[6];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_assign_var";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_assign_var";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 245;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L11: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_assign_var";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L13: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_assign_var";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L15: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_assign_var";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 252;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L18: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_assign_var";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L22: // INIT_INT
  int_vars[4] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_cross_reference_weaken_both(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_both";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 14;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_both";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L11: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_both";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L13: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_both";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L15: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_both";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L21;
L19: // INIT_INT
  int_vars[5] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_cross_reference_weaken_twice(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L9: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x) = int_vars[2];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L11: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[1]    );
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 60;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L13: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L15: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L17: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L19: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L25: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__x < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__x = env->get_field_id(env, "TestCase::Data::Weaken", "x", "int");
      if (FIELD_ID_TestCase__Data__Weaken__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__x);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_cross_reference_weaken_twice";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L39;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L28: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L34; }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L39;
L33: // GOTO
  goto L34;
L34: // GOTO
  goto L35;
L35: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L39;
L37: // INIT_INT
  int_vars[6] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L39;
L39: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L40: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_self_reference(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Weaken = env->get_basic_type_id(env, "TestCase::Weaken");
      if (BASIC_TYPE_ID_TestCase__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Weaken__x_int < 0, 0)) {
      FIELD_ID_TestCase__Weaken__x_int = env->get_field_id(env, "TestCase::Weaken", "x_int", "int");
      if (FIELD_ID_TestCase__Weaken__x_int < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Weaken x_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Weaken__x_int = env->get_field_offset(env, FIELD_ID_TestCase__Weaken__x_int);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Weaken__x_int) = int_vars[2];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_self_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L6: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Weaken__x_self < 0, 0)) {
      FIELD_ID_TestCase__Weaken__x_self = env->get_field_id(env, "TestCase::Weaken", "x_self", "TestCase::Weaken");
      if (FIELD_ID_TestCase__Weaken__x_self < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Weaken x_self");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Weaken__x_self = env->get_field_offset(env, FIELD_ID_TestCase__Weaken__x_self);
    };
    void* object = object_vars[0];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Weaken__x_self);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_self_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 82;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L8: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Weaken__x_self = env->get_field_id(env, "TestCase::Weaken", "x_self", "TestCase::Weaken");
    if (FIELD_ID_TestCase__Weaken__x_self < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Weaken x_self");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Weaken__x_self = env->get_field_offset(env, FIELD_ID_TestCase__Weaken__x_self);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Weaken__x_self);
      env->weaken(env, get_field_object_address);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_self_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L10: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Weaken__x_int < 0, 0)) {
      FIELD_ID_TestCase__Weaken__x_int = env->get_field_id(env, "TestCase::Weaken", "x_int", "int");
      if (FIELD_ID_TestCase__Weaken__x_int < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Weaken x_int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Weaken__x_int = env->get_field_offset(env, FIELD_ID_TestCase__Weaken__x_int);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Weaken__x_int);
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_self_reference";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L13: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_undef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_undef";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 231;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], get_field_object);    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_undef";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 233;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L19;
  }
L8: // BOOL_OBJECT
  int_vars[0] = !!object_vars[1];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L19;
L13: // GOTO
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L19;
L17: // INIT_INT
  int_vars[6] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L19;
L19: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L20: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Weaken__weaken_field_weaken_ref_count1_object(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
      BASIC_TYPE_ID_TestCase__Data__Weaken = env->get_basic_type_id(env, "TestCase::Data::Weaken");
      if (BASIC_TYPE_ID_TestCase__Data__Weaken < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Data::Weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Data__Weaken;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L5: // SET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(get_field_object_address,object_vars[0]    );
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_weaken_ref_count1_object";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 99;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L7: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L8: // WEAKEN_FIELD
  {
    int32_t FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
    if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
      void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
      env->set_exception(env, exception);
      return SPVM_EXCEPTION;
    }
    int32_t FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    void* object = object_vars[1];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Object to weaken an object field must not be undefined.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void** get_field_object_address = (void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      env->weaken(env, get_field_object_address);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_weaken_ref_count1_object";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // GET_FIELD_OBJECT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Data__Weaken__data_weaken < 0, 0)) {
      FIELD_ID_TestCase__Data__Weaken__data_weaken = env->get_field_id(env, "TestCase::Data::Weaken", "data_weaken", "TestCase::Data::Weaken");
      if (FIELD_ID_TestCase__Data__Weaken__data_weaken < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Data::Weaken data_weaken");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken = env->get_field_offset(env, FIELD_ID_TestCase__Data__Weaken__data_weaken);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      void* get_field_object = *(void**)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Data__Weaken__data_weaken);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], get_field_object);    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Weaken";
    const char* sub_name = "weaken_field_weaken_ref_count1_object";
    const char* file = "TestCase/Weaken.spvm";
    int32_t line = 107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L13: // IS_UNDEF
  int_vars[0] = object_vars[2] == NULL;
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L20; }
L16: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L19: // GOTO
  goto L20;
L20: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


