# -*- perl -*-

require 5.004;
use strict;

require ExtUtils::MakeMaker;


my($ok) = 1;
my($recommended) = 0;
print "Checking for Data::Dumper ... ";
$@ = '';
eval "use Data::Dumper ();";
if ($@) {
    $ok = 0;
    print("\nYou don't have installed the Data::Dumper module.\n");
} else {
    print "ok\n";
}

print "Checking for DBI ... ";
$@ = '';
eval "use DBI ();";
if ($@) {
    $ok = 0;
    print("\nYou don't have installed the DBI module.\n");
} else {
    print "ok\n";
}

print "Checking for SNMP, V1.7 or later ... ";
$@ = '';
eval "use SNMP 1.7 ();";
if ($@) {
    $ok = 0;
    print("\nYou don't have installed the SNMP module, version 1.7 or",
	  " later.\n");
} else {
    print "ok\n";
}

print "Checking for MailTools ... ";
$@ = '';
eval "use Mail::Internet ();";
if ($@) {
    $ok = 0;
    print("\nYou don't have installed the Mailtools package.\n");
} else {
    print "ok\n";
}

print "Checking for IO::AtomicFile ... ";
$@ = '';
eval "use IO::AtomicFile;";
if ($@) {
    $recommended = 1;
    print("\nYou don't have installed the IO::Scalar module.\n",
	  "This module is not required, but recommended.\n");
} else {
    print "ok\n";
}

print "Checking for HTML::EP, 0.1005 or later ... ";
$@ = '';
eval "use HTML::EP 0.1005 ;";
if ($@) {
    $recommended = 1;
    print("\nYou don't have installed the HTML::EP module, version",
	  " 0.1005 or later.\n",
	  "This module is required, if you want to display accounting\n",
	  "information generated by the SNMP::Monitor via CGI.\n");
} else {
    print "ok\n";
}

if (!$ok  ||  $recommended) {
    print("\n",
	  "Missing modules are available from any CPAN mirror, for example\n",
	  "\tftp://ftp.funet.fi/pub/languages/perl/CPAN/modules/by-module\n",
	  "\n");
}

if (!$ok) {
    exit 1;
}


use lib "lib";

if ( -f "configuration" ) {
    require Safe;
    require SNMP::Monitor;
    $SNMP::Monitor::config = SNMP::Monitor->Configuration("configuration");
} else {
    require Safe;
    require SNMP::Monitor::Install;
    $SNMP::Monitor::config =
        SNMP::Monitor::Install->Install("./configuration",
					"/etc/snmpmon");
}


ExtUtils::MakeMaker::WriteMakefile(
    'NAME'	   => 'SNMP::Monitor',
    'VERSION_FROM' => 'lib/SNMP/Monitor.pm',
    'EXE_FILES'    => [ 'snmpmon' ],
    'dist'         => { 'SUFFIX'       => ".gz",
			'DIST_DEFAULT' => 'all tardist',
			'COMPRESS'     => "gzip -9f" },
    'realclean'    => { 'FILES' => 'configuration html' },
    'clean'        => { 'FILES' => 'snmpmon' },
    'PL_FILES'     => { 'html_templates/index.ep.PL' => 'html/index.ep',
			'html_templates/graph.ep.PL' => 'html/graph.ep',
			'html_templates/ifgif.ep.PL' => 'html/ifgif.ep',
			'html_templates/stats.ep.PL' => 'html/stats.ep',
		        'snmpmon.PL' => 'snmpmon' }
);


package MY;

sub postamble {
    my($config) = $SNMP::Monitor::config;

    my $etcdir = $config->{'etc_dir'};
    my $perl = $^X;

    <<"EOF";

install ::
	$perl -MFile::Path -e 'mkpath(["$etcdir"], 1, 0755)'
	$perl -MFile::Copy -e 'if (-f "$etcdir/configuration") {  \\
		print "Not overwriting existing configfile" .     \\
			" $etcdir/configuration\\n";              \\
	    } else {                                              \\
		copy("configuration", "$etcdir/configuration");   \\
                chmod 0600, "$etcdir/configuration";              \\
	    }'
EOF
}

sub libscan {
    my($self, $path) = @_;
    if ($path =~ /\~$/) {
	undef;
    } else {
	$path;
    }
}
