/* $Id: MP3Play.xs,v 1.13 1999/09/06 19:43:33 joern Exp $ */
 
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "xaudio.h"
#include "player.h"
#include "control.h"
#include "control_pipe.h"

/*
 * the constants.h include is generated by gen_constant and realizes
 * autoload constants for defines and enums
 *
 */

#include "./constants.h"

/* h2xs stuff */

MODULE = MPEG::MP3Play		PACKAGE = MPEG::MP3Play		

PROTOTYPES: ENABLE

double
constant(name,arg)
	char *		name
	int		arg

const char *
xaudio_error_string(code)
	int	code

unsigned int
xaudio_get_api_version(api_id)
	unsigned int	api_id

int
control_procedure_new(control, control_driver_args, procedure, procedure_args, forwarder, forwarder_args)
	void **	control
	void *	control_driver_args
	XA_ControlProcedure	procedure
	void *	procedure_args
	XA_EventForwarderProcedure	forwarder
	void *	forwarder_args

int
control_procedure_delete(control)
	void *	control

int
control_message_to_bytes(message, buffer, max_size)
	const XA_Message *	message
	unsigned char *	buffer
	int	max_size

int
control_message_from_bytes(message, buffer)
	XA_Message *	message
	const unsigned char *	buffer

int
control_message_send(control, code, ...)
	void *	control
	int	code

int
control_event_send(control, code, ...)
	void *	control
	int	code

int
control_message_send_N(control, code)
	void *	control
	int	code

int
control_message_send_P(control, code, ptr1)
	void *	control
	int	code
	const void *	ptr1

int
control_message_send_S(control, code, str1)
	void *	control
	int	code
#	const char *	str1
	char *	str1

int
control_message_send_SS(control, code, str1, str2)
	void *	control
	int	code
	const char *	str1
	const char *	str2

int
control_message_send_SI(control, code, str1, int1)
	void *	control
	int	code
	const char *	str1
	int	int1

int
control_message_send_I(control, code, int1)
	void *	control
	int	code
	int	int1

int
control_message_send_II(control, code, int1, int2)
	void *	control
	int	code
	int	int1
	int	int2

int
control_message_send_III(control, code, int1, int2, int3)
	void *	control
	int	code
	int	int1
	int	int2
	int	int3

int
control_message_send_IIII(control, code, int1, int2, int3, int4)
	void *	control
	int	code
	int	int1
	int	int2
	int	int3
	int	int4

int
control_message_send_IPI(control, code, int1, ptr1, int2)
	void *	control
	int	code
	int	int1
	const void *	ptr1
	int	int2

int
control_message_post_to_command_queue(control, message)
	void *	control
	const XA_Message *	message

int
control_message_post_to_event_queue(control, message)
	void *	control
	const XA_Message *	message

void
control_message_sprint(string, message)
	char *	string
	const XA_Message *	message

void
control_message_print(message)
	XA_Message *	message


#---- end of h2xs generated stuff

#---------------------------------------------------------------------
# Player Constructor
#---------------------------------------------------------------------

void *
new_player()
CODE:
	void * player;
	if ( XA_SUCCESS != player_new (&player, NULL) ) {
	  player = NULL;
	}
	
	RETVAL = player;
OUTPUT:
RETVAL

#---------------------------------------------------------------------
# Player Desctructor
#---------------------------------------------------------------------

void
destroy_player(player)
	void* player
CODE:
	if ( player != NULL) {
		player_delete (player);
	}

#---------------------------------------------------------------------
# Message Handling
#---------------------------------------------------------------------

#---- control_message_wait

int
control_message_wait (control, msg_href, timeout)
	void *	control
	SV *	msg_href
	int	timeout

	CODE:
	XA_Message	msg;
	int		status;
	
	status = control_message_wait (control, &msg, timeout);

	if ( status == XA_SUCCESS ) {
		convert_message_to_HV (msg_href, &msg);
		status = 1;
	} else {
		status = 0;
	}

	RETVAL = status;

#---- control_message_get

int
control_message_get (control, msg_href)
	void *	control
	SV *	msg_href

	CODE:
	XA_Message	msg;
	int		status;
	
	status = control_message_get (control, &msg);

	if ( status == XA_SUCCESS ) {
		convert_message_to_HV (msg_href, &msg);
		status = 1;
	} else {
		status = 0;
	}

	RETVAL = status;

#---- command_read_pipe

int
command_read_pipe (control)
	void * control
	
	CODE:
	RETVAL = ((XA_PipeControl*)control)->command_read_pipe;
	
	OUTPUT:
	RETVAL


#---- memory leak test sub

#SV*
#test_hash_return(void)
#
#	CODE:
#	HV*	msg_hash;
#	msg_hash = newHV();
#	
#	hv_store (msg_hash,
#		"code", 4,
#		newSViv (42),
#		0
#	);
#
#	ST(0) = sv_newmortal();
#	sv_setsv (ST(0),newRV_noinc(msg_hash));
#
#
#SV*
#test_scalar_return(void)
#
#	CODE:
#	SV*	test;
#
#	test = newSViv(42);
#
#	ST(0) = sv_newmortal();
#
#	sv_setsv (ST(0),newRV_noinc(test);


void
test_hash_set (href)
	SV *	href

	CODE:
	HV*	hash;
	
	hash = (HV*) SvRV(href);
	
	hv_store (hash,
		"code", 4,
		newSViv (42),
		0
	);

