#!/usr/bin/perl -w

###############################################################################
#
# Example of formatting using the Spreadsheet::WriteExcel module
#
# This example shows how to merge two or more cells.  It also demonstrates
# other formatting features. See also the simpler merge1.pl example.
#
# Feb 2001, John McNamara, jmcnamara@cpan.org
#

use strict;
use Spreadsheet::WriteExcel;

# Create a new workbook and add a worksheet
my $workbook  = Spreadsheet::WriteExcel->new("merge2.xls");
my $worksheet = $workbook->addworksheet();

# Set the column width for columns 2 and 3
$worksheet->set_column(1, 2, 20);

# Set the row height for row 2
$worksheet->set_row(2, 30);


# Create a border format
my $border1 = $workbook->addformat();
$border1->set_color('white');
$border1->set_bold();
$border1->set_size(15);
$border1->set_pattern(0x1);
$border1->set_fg_color('green');
$border1->set_border_color('yellow');
$border1->set_top(6);
$border1->set_bottom(6);
$border1->set_left(6);
$border1->set_align('center');
$border1->set_align('vcenter');
$border1->set_merge(); # This is the key feature

# Create another border format. Note you could use copy() here.
my $border2 = $workbook->addformat();
$border2->set_color('white');
$border2->set_bold();
$border2->set_size(15);
$border2->set_pattern(0x1);
$border2->set_fg_color('green');
$border2->set_border_color('yellow');
$border2->set_top(6);
$border2->set_bottom(6);
$border2->set_right(6);
$border2->set_align('center');
$border2->set_align('vcenter');
$border2->set_merge(); # This is the key feature

# Only one cell should contain text, the others should be blank.
$worksheet->write      (2, 1, "Merged Cells", $border1);
$worksheet->write_blank(2, 2,                 $border2);



