package Paws::SageMaker::TrainingSpecification;
  use Moose;
  has MetricDefinitions => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::MetricDefinition]');
  has SupportedHyperParameters => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::HyperParameterSpecification]');
  has SupportedTrainingInstanceTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has SupportedTuningJobObjectiveMetrics => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::HyperParameterTuningJobObjective]');
  has SupportsDistributedTraining => (is => 'ro', isa => 'Bool');
  has TrainingChannels => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::ChannelSpecification]', required => 1);
  has TrainingImage => (is => 'ro', isa => 'Str', required => 1);
  has TrainingImageDigest => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::TrainingSpecification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::TrainingSpecification object:

  $service_obj->Method(Att1 => { MetricDefinitions => $value, ..., TrainingImageDigest => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::TrainingSpecification object:

  $result = $service_obj->Method(...);
  $result->Att1->MetricDefinitions

=head1 DESCRIPTION

Defines how the algorithm is used for a training job.

=head1 ATTRIBUTES


=head2 MetricDefinitions => ArrayRef[L<Paws::SageMaker::MetricDefinition>]

  A list of C<MetricDefinition> objects, which are used for parsing
metrics generated by the algorithm.


=head2 SupportedHyperParameters => ArrayRef[L<Paws::SageMaker::HyperParameterSpecification>]

  A list of the C<HyperParameterSpecification> objects, that define the
supported hyperparameters. This is required if the algorithm supports
automatic model tuning.E<gt>


=head2 B<REQUIRED> SupportedTrainingInstanceTypes => ArrayRef[Str|Undef]

  A list of the instance types that this algorithm can use for training.


=head2 SupportedTuningJobObjectiveMetrics => ArrayRef[L<Paws::SageMaker::HyperParameterTuningJobObjective>]

  A list of the metrics that the algorithm emits that can be used as the
objective metric in a hyperparameter tuning job.


=head2 SupportsDistributedTraining => Bool

  Indicates whether the algorithm supports distributed training. If set
to false, buyers can't request more than one instance during training.


=head2 B<REQUIRED> TrainingChannels => ArrayRef[L<Paws::SageMaker::ChannelSpecification>]

  A list of C<ChannelSpecification> objects, which specify the input
sources to be used by the algorithm.


=head2 B<REQUIRED> TrainingImage => Str

  The Amazon ECR registry path of the Docker image that contains the
training algorithm.


=head2 TrainingImageDigest => Str

  An MD5 hash of the training algorithm that identifies the Docker image
used for training.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

