package Paws::Forecast::DatasetSummary;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str');
  has DatasetArn => (is => 'ro', isa => 'Str');
  has DatasetName => (is => 'ro', isa => 'Str');
  has DatasetType => (is => 'ro', isa => 'Str');
  has Domain => (is => 'ro', isa => 'Str');
  has LastModificationTime => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Forecast::DatasetSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Forecast::DatasetSummary object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., LastModificationTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Forecast::DatasetSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

Provides a summary of the dataset properties used in the ListDatasets
operation. To get the complete set of properties, call the
DescribeDataset operation, and provide the C<DatasetArn>.

=head1 ATTRIBUTES


=head2 CreationTime => Str

  When the dataset was created.


=head2 DatasetArn => Str

  The Amazon Resource Name (ARN) of the dataset.


=head2 DatasetName => Str

  The name of the dataset.


=head2 DatasetType => Str

  The dataset type.


=head2 Domain => Str

  The domain associated with the dataset.


=head2 LastModificationTime => Str

  When you create a dataset, C<LastModificationTime> is the same as
C<CreationTime>. While data is being imported to the dataset,
C<LastModificationTime> is the current time of the C<ListDatasets>
call. After a CreateDatasetImportJob operation has finished,
C<LastModificationTime> is when the import job completed or failed.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Forecast>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

