package NetSuite::Config;

use strict;

sub SearchTypes {

    return {
    
        EntitySearchBasic => {
            'address' => 'SearchStringField',
            'city' => 'SearchStringField',
            'country' => 'SearchEnumMultiSelectField',
            'county' => 'SearchStringField',
            'dateCreated' => 'SearchDateField',
            'email' => 'SearchStringField',
            'entityId' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'fax' => 'SearchStringField',
            'giveAccess' => 'SearchBooleanField',
            'image' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'language' => 'SearchStringField',
            'lastModifiedDate' => 'SearchDateField',
            'phone' => 'SearchStringField',
            'phoneticName' => 'SearchStringField',
            'state' => 'SearchStringField',
            'unsubscribe' => 'SearchBooleanField',
            'zipCode' => 'SearchStringField',
        },
    
        ContactSearchBasic => {
            'address' => 'SearchStringField',
            'availableOffline' => 'SearchBooleanField',
            'category' => 'SearchMultiSelectField',
            'city' => 'SearchStringField',
            'company' => 'SearchStringField',
            'contactRole' => 'SearchMultiSelectField',
            'country' => 'SearchEnumMultiSelectField',
            'county' => 'SearchStringField',
            'dateCreated' => 'SearchDateField',
            'email' => 'SearchStringField',
            'entityId' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'fax' => 'SearchStringField',
            'firstName' => 'SearchStringField',
            'giveAccess' => 'SearchBooleanField',
            'group' => 'SearchMultiSelectField',
            'hasDuplicates' => 'SearchBooleanField',
            'image' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'isPrivate' => 'SearchBooleanField',
            'language' => 'SearchEnumMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'lastName' => 'SearchStringField',
            'middleName' => 'SearchStringField',
            'owner' => 'SearchMultiSelectField',
            'phone' => 'SearchStringField',
            'phoneticName' => 'SearchStringField',
            'salutation' => 'SearchStringField',
            'state' => 'SearchStringField',
            'subsidiary' => 'SearchMultiSelectField',
            'title' => 'SearchStringField',
            'type' => 'SearchEnumMultiSelectField',
            'unsubscribe' => 'SearchBooleanField',
            'zipCode' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        CustomerSearchBasic => {
            'accountNumber' => 'SearchStringField',
            'address' => 'SearchStringField',
            'availableOffline' => 'SearchBooleanField',
            'balance' => 'SearchDoubleField',
            'boughtAmount' => 'SearchDoubleField',
            'boughtDate' => 'SearchDateField',
            'category' => 'SearchMultiSelectField',
            'ccCustomerCode' => 'SearchStringField',
            'ccDefault' => 'SearchBooleanField',
            'ccExpDate' => 'SearchDateField',
            'ccHolderName' => 'SearchStringField',
            'ccNumber' => 'SearchStringField',
            'ccType' => 'SearchMultiSelectField',
            'city' => 'SearchStringField',
            'classBought' => 'SearchMultiSelectField',
            'comments' => 'SearchStringField',
            'contact' => 'SearchStringField',
            'contribution' => 'SearchLongField',
            'country' => 'SearchEnumMultiSelectField',
            'county' => 'SearchStringField',
            'creditHoldOverride' => 'SearchBooleanField',
            'creditLimit' => 'SearchDoubleField',
            'currency' => 'SearchMultiSelectField',
            'custStage' => 'SearchMultiSelectField',
            'custStatus' => 'SearchMultiSelectField',
            'dateClosed' => 'SearchDateField',
            'dateCreated' => 'SearchDateField',
            'daysOverdue' => 'SearchLongField',
            'deptBought' => 'SearchMultiSelectField',
            'email' => 'SearchStringField',
            'endDate' => 'SearchDateField',
            'entityId' => 'SearchStringField',
            'entityStatus' => 'SearchMultiSelectField',
            'externalId' => 'SearchMultiSelectField',
            'fax' => 'SearchStringField',
            'firstName' => 'SearchStringField',
            'firstOrderDate' => 'SearchDateField',
            'firstSaleDate' => 'SearchDateField',
            'giveAccess' => 'SearchBooleanField',
            'group' => 'SearchMultiSelectField',
            'hasDuplicates' => 'SearchBooleanField',
            'image' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'isPerson' => 'SearchBooleanField',
            'isReportedLead' => 'SearchBooleanField',
            'isShipAddress' => 'SearchBooleanField',
            'itemsBought' => 'SearchMultiSelectField',
            'itemsOrdered' => 'SearchMultiSelectField',
            'language' => 'SearchEnumMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'lastName' => 'SearchStringField',
            'leadDate' => 'SearchDateField',
            'leadSource' => 'SearchMultiSelectField',
            'locationBought' => 'SearchMultiSelectField',
            'manualCreditHold' => 'SearchBooleanField',
            'merchantAccount' => 'SearchMultiSelectField',
            'middleName' => 'SearchStringField',
            'onCreditHold' => 'SearchBooleanField',
            'overdueBalance' => 'SearchDoubleField',
            'parent' => 'SearchMultiSelectField',
            'parentItemsBought' => 'SearchMultiSelectField',
            'partner' => 'SearchMultiSelectField',
            'partnerContribution' => 'SearchLongField',
            'partnerRole' => 'SearchMultiSelectField',
            'partnerTeamMember' => 'SearchMultiSelectField',
            'pec' => 'SearchStringField',
            'phone' => 'SearchStringField',
            'phoneticName' => 'SearchStringField',
            'priceLevel' => 'SearchMultiSelectField',
            'prospectDate' => 'SearchDateField',
            'pstExempt' => 'SearchBooleanField',
            'reminderDate' => 'SearchDateField',
            'resaleNumber' => 'SearchStringField',
            'salesRep' => 'SearchMultiSelectField',
            'salesTeamMember' => 'SearchMultiSelectField',
            'salesTeamRole' => 'SearchMultiSelectField',
            'salutation' => 'SearchStringField',
            'shipComplete' => 'SearchBooleanField',
            'shippingItem' => 'SearchMultiSelectField',
            'stage' => 'SearchEnumMultiSelectField',
            'startDate' => 'SearchDateField',
            'state' => 'SearchStringField',
            'subsidBought' => 'SearchMultiSelectField',
            'subsidiary' => 'SearchMultiSelectField',
            'taxable' => 'SearchBooleanField',
            'terms' => 'SearchMultiSelectField',
            'territory' => 'SearchMultiSelectField',
            'title' => 'SearchStringField',
            'unbilledOrders' => 'SearchDoubleField',
            'unsubscribe' => 'SearchBooleanField',
            'url' => 'SearchStringField',
            'vatregnumber' => 'SearchStringField',
            'webLead' => 'SearchBooleanField',
            'zipCode' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        CalendarEventSearchBasic => {
            'attendee' => 'SearchMultiSelectField',
            'calendar' => 'SearchMultiSelectField',
            'completedDate' => 'SearchDateField',
            'createdDate' => 'SearchDateField',
            'externalId' => 'SearchMultiSelectField',
            'instanceStart' => 'SearchDateField',
            'internalId' => 'SearchMultiSelectField',
            'isUpcomingEvent' => 'SearchBooleanField',
            'lastModifiedDate' => 'SearchDateField',
            'location' => 'SearchStringField',
            'organizer' => 'SearchMultiSelectField',
            'resource' => 'SearchMultiSelectField',
            'response' => 'SearchEnumMultiSelectField',
            'startDate' => 'SearchDateField',
            'status' => 'SearchEnumMultiSelectField',
            'title' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        TaskSearchBasic => {
            'actualTime' => 'SearchDoubleField',
            'assigned' => 'SearchMultiSelectField',
            'company' => 'SearchMultiSelectField',
            'completedDate' => 'SearchDateField',
            'contact' => 'SearchMultiSelectField',
            'createdDate' => 'SearchDateField',
            'endDate' => 'SearchDateField',
            'estimatedTime' => 'SearchDoubleField',
            'estimatedTimeOverride' => 'SearchDoubleField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isJobSummaryTask' => 'SearchBooleanField',
            'isJobTask' => 'SearchBooleanField',
            'isPrivate' => 'SearchBooleanField',
            'lastModifiedDate' => 'SearchDateField',
            'milestone' => 'SearchLongField',
            'owner' => 'SearchMultiSelectField',
            'percentComplete' => 'SearchLongField',
            'percentTimeComplete' => 'SearchLongField',
            'priority' => 'SearchEnumMultiSelectField',
            'startDate' => 'SearchDateField',
            'status' => 'SearchEnumMultiSelectField',
            'timeRemaining' => 'SearchDoubleField',
            'title' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        OpportunitySearchBasic => {
            'amount' => 'SearchDoubleField',
            'availableOffline' => 'SearchBooleanField',
            'class' => 'SearchMultiSelectField',
            'closeDate' => 'SearchDateField',
            'competitor' => 'SearchMultiSelectField',
            'contribution' => 'SearchLongField',
            'currencyName' => 'SearchMultiSelectField',
            'custType' => 'SearchMultiSelectField',
            'dateCreated' => 'SearchDateField',
            'daysOpen' => 'SearchLongField',
            'daysToClose' => 'SearchLongField',
            'department' => 'SearchMultiSelectField',
            'entity' => 'SearchMultiSelectField',
            'entityStatus' => 'SearchMultiSelectField',
            'expectedCloseDate' => 'SearchDateField',
            'externalId' => 'SearchMultiSelectField',
            'forecastType' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'item' => 'SearchMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'leadSource' => 'SearchMultiSelectField',
            'location' => 'SearchMultiSelectField',
            'memo' => 'SearchStringField',
            'number' => 'SearchLongField',
            'partner' => 'SearchMultiSelectField',
            'partnerContribution' => 'SearchLongField',
            'partnerRole' => 'SearchMultiSelectField',
            'partnerTeamMember' => 'SearchMultiSelectField',
            'postingPeriod' => 'SearchMultiSelectField',
            'probability' => 'SearchLongField',
            'projAltSalesAmt' => 'SearchDoubleField',
            'projectedTotal' => 'SearchDoubleField',
            'rangeHigh' => 'SearchDoubleField',
            'rangeHighAlt' => 'SearchDoubleField',
            'rangeLow' => 'SearchDoubleField',
            'rangeLowAlt' => 'SearchDoubleField',
            'salesRep' => 'SearchMultiSelectField',
            'salesTeamMember' => 'SearchMultiSelectField',
            'salesTeamRole' => 'SearchMultiSelectField',
            'status' => 'SearchEnumMultiSelectField',
            'subsidiary' => 'SearchMultiSelectField',
            'title' => 'SearchStringField',
            'tranDate' => 'SearchDateField',
            'tranId' => 'SearchStringField',
            'winLossReason' => 'SearchMultiSelectField',
            'wonBy' => 'SearchMultiSelectField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        EmployeeSearchBasic => {
            'address' => 'SearchStringField',
            'alienNumber' => 'SearchStringField',
            'anniversary' => 'SearchDateField',
            'approvalLimit' => 'SearchDoubleField',
            'approver' => 'SearchMultiSelectField',
            'authworkDate' => 'SearchDateField',
            'billingClass' => 'SearchMultiSelectField',
            'birthDate' => 'SearchDateField',
            'birthDay' => 'SearchDateField',
            'cContribution' => 'SearchMultiSelectField',
            'city' => 'SearchStringField',
            'class' => 'SearchMultiSelectField',
            'concurrentWebServicesUser' => 'SearchBooleanField',
            'country' => 'SearchEnumMultiSelectField',
            'county' => 'SearchStringField',
            'dateCreated' => 'SearchDateField',
            'deduction' => 'SearchMultiSelectField',
            'department' => 'SearchMultiSelectField',
            'earning' => 'SearchMultiSelectField',
            'education' => 'SearchMultiSelectField',
            'eligibleForCommission' => 'SearchBooleanField',
            'email' => 'SearchStringField',
            'employeeStatus' => 'SearchMultiSelectField',
            'employeeType' => 'SearchMultiSelectField',
            'employeeTypeKpi' => 'SearchBooleanField',
            'entityId' => 'SearchStringField',
            'ethnicity' => 'SearchMultiSelectField',
            'expenseLimit' => 'SearchDoubleField',
            'externalId' => 'SearchMultiSelectField',
            'fax' => 'SearchStringField',
            'firstName' => 'SearchStringField',
            'gender' => 'SearchBooleanField',
            'giveAccess' => 'SearchBooleanField',
            'group' => 'SearchMultiSelectField',
            'hireDate' => 'SearchDateField',
            'I9Verified' => 'SearchBooleanField',
            'image' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'isJobResource' => 'SearchBooleanField',
            'isTemplate' => 'SearchBooleanField',
            'jobDescription' => 'SearchStringField',
            'laborCost' => 'SearchDoubleField',
            'language' => 'SearchEnumMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'lastName' => 'SearchStringField',
            'lastReviewDate' => 'SearchDateField',
            'location' => 'SearchMultiSelectField',
            'maritalStatus' => 'SearchMultiSelectField',
            'middleName' => 'SearchStringField',
            'nextReviewDate' => 'SearchDateField',
            'offlineAccess' => 'SearchBooleanField',
            'phone' => 'SearchStringField',
            'phoneticName' => 'SearchStringField',
            'primaryEarningAmount' => 'SearchDoubleField',
            'primaryEarningItem' => 'SearchStringField',
            'primaryEarningType' => 'SearchStringField',
            'purchaseOrderApprovalLimit' => 'SearchDoubleField',
            'purchaseOrderApprover' => 'SearchMultiSelectField',
            'purchaseOrderLimit' => 'SearchDoubleField',
            'releaseDate' => 'SearchDateField',
            'residentStatus' => 'SearchMultiSelectField',
            'role' => 'SearchMultiSelectField',
            'salesRep' => 'SearchBooleanField',
            'salesRole' => 'SearchMultiSelectField',
            'salutation' => 'SearchStringField',
            'socialSecurityNumber' => 'SearchStringField',
            'state' => 'SearchStringField',
            'subsidiary' => 'SearchMultiSelectField',
            'supervisor' => 'SearchMultiSelectField',
            'supportRep' => 'SearchBooleanField',
            'timeApprover' => 'SearchMultiSelectField',
            'title' => 'SearchStringField',
            'unsubscribe' => 'SearchBooleanField',
            'usePerquest' => 'SearchBooleanField',
            'visaExpDate' => 'SearchDateField',
            'visaType' => 'SearchMultiSelectField',
            'withholding' => 'SearchMultiSelectField',
            'zipCode' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        PhoneCallSearchBasic => {
            'assigned' => 'SearchMultiSelectField',
            'company' => 'SearchMultiSelectField',
            'completedDate' => 'SearchDateField',
            'contact' => 'SearchMultiSelectField',
            'createdBy' => 'SearchMultiSelectField',
            'createdDate' => 'SearchDateField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isPrivate' => 'SearchBooleanField',
            'lastModifiedDate' => 'SearchDateField',
            'owner' => 'SearchBooleanField',
            'phone' => 'SearchStringField',
            'priority' => 'SearchEnumMultiSelectField',
            'startDate' => 'SearchDateField',
            'status' => 'SearchEnumMultiSelectField',
            'title' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        SupportCaseSearchBasic => {
            'assigned' => 'SearchMultiSelectField',
            'awaitingReply' => 'SearchBooleanField',
            'caseNumber' => 'SearchStringField',
            'category' => 'SearchMultiSelectField',
            'closedDate' => 'SearchDateField',
            'company' => 'SearchStringField',
            'contact' => 'SearchStringField',
            'createdDate' => 'SearchDateField',
            'email' => 'SearchStringField',
            'escalateTo' => 'SearchMultiSelectField',
            'externalId' => 'SearchMultiSelectField',
            'helpDesk' => 'SearchBooleanField',
            'inboundEmail' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'issue' => 'SearchMultiSelectField',
            'item' => 'SearchMultiSelectField',
            'lastMessage' => 'SearchBooleanField',
            'lastModifiedDate' => 'SearchDateField',
            'lastReopenedDate' => 'SearchDateField',
            'locked' => 'SearchBooleanField',
            'message' => 'SearchStringField',
            'messageAuthor' => 'SearchMultiSelectField',
            'messageDate' => 'SearchDateField',
            'messageType' => 'SearchBooleanField',
            'module' => 'SearchMultiSelectField',
            'number' => 'SearchLongField',
            'origin' => 'SearchMultiSelectField',
            'priority' => 'SearchMultiSelectField',
            'product' => 'SearchMultiSelectField',
            'stage' => 'SearchEnumMultiSelectField',
            'status' => 'SearchMultiSelectField',
            'title' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        MessageSearchBasic => {
            'author' => 'SearchMultiSelectField',
            'authorEmail' => 'SearchStringField',
            'bcc' => 'SearchStringField',
            'cc' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'hasAttachment' => 'SearchBooleanField',
            'internalId' => 'SearchMultiSelectField',
            'internalOnly' => 'SearchBooleanField',
            'message' => 'SearchStringField',
            'messageDate' => 'SearchDateField',
            'messageType' => 'SearchEnumMultiSelectField',
            'recipient' => 'SearchMultiSelectField',
            'recipientEmail' => 'SearchStringField',
            'subject' => 'SearchStringField',
        },
    
        NoteSearchBasic => {
            'author' => 'SearchMultiSelectField',
            'direction' => 'SearchBooleanField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'note' => 'SearchStringField',
            'noteDate' => 'SearchDateField',
            'noteType' => 'SearchMultiSelectField',
            'title' => 'SearchStringField',
        },
    
        CustomRecordSearchBasic => {
            'recType' => 'RecordRef',
            'availableOffline' => 'SearchBooleanField',
            'created' => 'SearchDateField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'lastModified' => 'SearchDateField',
            'lastModifiedBy' => 'SearchMultiSelectField',
            'name' => 'SearchStringField',
            'owner' => 'SearchMultiSelectField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        AccountSearchBasic => {
            'balance' => 'SearchDoubleField',
            'description' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'name' => 'SearchStringField',
            'number' => 'SearchStringField',
            'parent' => 'SearchMultiSelectField',
            'type' => 'SearchEnumMultiSelectField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        BinSearchBasic => {
            'binNumber' => 'SearchStringField',
            'inactive' => 'SearchBooleanField',
            'internalId' => 'SearchMultiSelectField',
            'location' => 'SearchMultiSelectField',
            'memo' => 'SearchStringField',
        },
    
        DepartmentSearchBasic => {
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'name' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        LocationSearchBasic => {
            'address' => 'SearchStringField',
            'city' => 'SearchStringField',
            'country' => 'SearchEnumMultiSelectField',
            'county' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'isOffice' => 'SearchBooleanField',
            'makeInventoryAvailable' => 'SearchBooleanField',
            'makeInventoryAvailableStore' => 'SearchBooleanField',
            'name' => 'SearchStringField',
            'phone' => 'SearchStringField',
            'state' => 'SearchStringField',
            'zip' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        ClassificationSearchBasic => {
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'name' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        TransactionSearchBasic => {
            'account' => 'SearchMultiSelectField',
            'accountType' => 'SearchMultiSelectField',
            'actualShipDate' => 'SearchDateField',
            'altSalesAmount' => 'SearchDoubleField',
            'altSalesNetAmount' => 'SearchDoubleField',
            'amount' => 'SearchDoubleField',
            'amountPaid' => 'SearchDoubleField',
            'amountRemaining' => 'SearchDoubleField',
            'anyLineItem' => 'SearchMultiSelectField',
            'appliedToLinkAmount' => 'SearchDoubleField',
            'appliedToLinkType' => 'SearchEnumMultiSelectField',
            'appliedToTransaction' => 'SearchMultiSelectField',
            'applyingLinkAmount' => 'SearchDoubleField',
            'applyingLinkType' => 'SearchEnumMultiSelectField',
            'applyingTransaction' => 'SearchMultiSelectField',
            'billable' => 'SearchBooleanField',
            'billAddress' => 'SearchStringField',
            'billAddressee' => 'SearchStringField',
            'billAttention' => 'SearchStringField',
            'billCity' => 'SearchStringField',
            'billCountry' => 'SearchEnumMultiSelectField',
            'billCounty' => 'SearchStringField',
            'billingSchedule' => 'SearchMultiSelectField',
            'billingStatus' => 'SearchBooleanField',
            'billPhone' => 'SearchStringField',
            'billState' => 'SearchStringField',
            'billZip' => 'SearchStringField',
            'ccCustomerCode' => 'SearchStringField',
            'ccExpireDate' => 'SearchDateField',
            'ccName' => 'SearchStringField',
            'ccNumber' => 'SearchStringField',
            'class' => 'SearchMultiSelectField',
            'cleared' => 'SearchBooleanField',
            'closed' => 'SearchBooleanField',
            'closeDate' => 'SearchDateField',
            'commissionEffectiveDate' => 'SearchDateField',
            'commit' => 'SearchEnumMultiSelectField',
            'confirmationNumber' => 'SearchStringField',
            'contribution' => 'SearchLongField',
            'createdFrom' => 'SearchMultiSelectField',
            'creditAmount' => 'SearchDoubleField',
            'currencyName' => 'SearchMultiSelectField',
            'customerSubOf' => 'SearchMultiSelectField',
            'customForm' => 'SearchMultiSelectField',
            'custType' => 'SearchMultiSelectField',
            'dateCreated' => 'SearchDateField',
            'daysOpen' => 'SearchLongField',
            'daysOverdue' => 'SearchLongField',
            'debitAmount' => 'SearchDoubleField',
            'deferRevRec' => 'SearchBooleanField',
            'department' => 'SearchMultiSelectField',
            'dueDate' => 'SearchDateField',
            'employee' => 'SearchMultiSelectField',
            'endDate' => 'SearchDateField',
            'entityStatus' => 'SearchMultiSelectField',
            'exchangeRate' => 'SearchDoubleField',
            'excludeCommission' => 'SearchBooleanField',
            'expectedCloseDate' => 'SearchDateField',
            'externalId' => 'SearchMultiSelectField',
            'finChrg' => 'SearchBooleanField',
            'forecastType' => 'SearchMultiSelectField',
            'fxAmount' => 'SearchDoubleField',
            'fxVsoeAllocation' => 'SearchDoubleField',
            'fxVsoeAmount' => 'SearchDoubleField',
            'fxVsoePrice' => 'SearchDoubleField',
            'giftCertificate' => 'SearchStringField',
            'grossAmount' => 'SearchDoubleField',
            'includeInForecast' => 'SearchBooleanField',
            'internalId' => 'SearchMultiSelectField',
            'inVsoeBundle' => 'SearchBooleanField',
            'isPayPalMeth' => 'SearchBooleanField',
            'isRevRecTransaction' => 'SearchBooleanField',
            'isShipAddress' => 'SearchBooleanField',
            'item' => 'SearchMultiSelectField',
            'itemSubOf' => 'SearchMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'leadSource' => 'SearchMultiSelectField',
            'location' => 'SearchMultiSelectField',
            'mainline' => 'SearchBooleanField',
            'memo' => 'SearchStringField',
            'memorized' => 'SearchBooleanField',
            'merchantAccount' => 'SearchStringField',
            'multiSubsidiary' => 'SearchBooleanField',
            'name' => 'SearchMultiSelectField',
            'nameText' => 'SearchStringField',
            'netAmount' => 'SearchDoubleField',
            'nextBillDate' => 'SearchDateField',
            'number' => 'SearchLongField',
            'opportunity' => 'SearchMultiSelectField',
            'otherRefNum' => 'SearchLongField',
            'parent' => 'SearchLongField',
            'partner' => 'SearchMultiSelectField',
            'partnerContribution' => 'SearchLongField',
            'partnerRole' => 'SearchMultiSelectField',
            'partnerTeamMember' => 'SearchMultiSelectField',
            'paymentMethod' => 'SearchMultiSelectField',
            'payPalPending' => 'SearchBooleanField',
            'payPalStatus' => 'SearchStringField',
            'payPalTranId' => 'SearchStringField',
            'poAsText' => 'SearchStringField',
            'posting' => 'SearchBooleanField',
            'postingPeriod' => 'SearchMultiSelectField',
            'probability' => 'SearchLongField',
            'promoCode' => 'SearchMultiSelectField',
            'quantity' => 'SearchDoubleField',
            'quantityBilled' => 'SearchDoubleField',
            'quantityCommitted' => 'SearchDoubleField',
            'quantityShipRecv' => 'SearchDoubleField',
            'revRecEndDate' => 'SearchDateField',
            'revRecStartDate' => 'SearchDateField',
            'revRecTermInMonths' => 'SearchLongField',
            'salesRep' => 'SearchMultiSelectField',
            'salesTeamMember' => 'SearchMultiSelectField',
            'salesTeamRole' => 'SearchMultiSelectField',
            'serialNumber' => 'SearchStringField',
            'serialNumbers' => 'SearchStringField',
            'shipAddress' => 'SearchStringField',
            'shipAddressee' => 'SearchStringField',
            'shipAttention' => 'SearchStringField',
            'shipCity' => 'SearchStringField',
            'shipComplete' => 'SearchBooleanField',
            'shipCountry' => 'SearchEnumMultiSelectField',
            'shipCounty' => 'SearchStringField',
            'shipDate' => 'SearchDateField',
            'shipMethod' => 'SearchMultiSelectField',
            'shipPhone' => 'SearchStringField',
            'shipping' => 'SearchBooleanField',
            'shipRecvStatus' => 'SearchBooleanField',
            'shipState' => 'SearchStringField',
            'shipZip' => 'SearchStringField',
            'source' => 'SearchMultiSelectField',
            'startDate' => 'SearchDateField',
            'status' => 'SearchEnumMultiSelectField',
            'subsidiary' => 'SearchMultiSelectField',
            'taxItem' => 'SearchMultiSelectField',
            'taxRate' => 'SearchDoubleField',
            'terms' => 'SearchMultiSelectField',
            'totalAmount' => 'SearchDoubleField',
            'trackingNumbers' => 'SearchStringField',
            'tranDate' => 'SearchDateField',
            'tranId' => 'SearchStringField',
            'tranIsVsoeBundle' => 'SearchBooleanField',
            'type' => 'SearchEnumMultiSelectField',
            'unit' => 'SearchMultiSelectField',
            'vendType' => 'SearchMultiSelectField',
            'voided' => 'SearchBooleanField',
            'vsoeAllocation' => 'SearchDoubleField',
            'vsoeAmount' => 'SearchDoubleField',
            'vsoeDeferral' => 'SearchEnumMultiSelectField',
            'vsoeDelivered' => 'SearchBooleanField',
            'vsoePermitDiscount' => 'SearchEnumMultiSelectField',
            'vsoePrice' => 'SearchDoubleField',
            'webSite' => 'SearchMultiSelectField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        ItemSearchBasic => {
            'account' => 'SearchMultiSelectField',
            'autoLeadTime' => 'SearchBooleanField',
            'autoPreferredStockLevel' => 'SearchBooleanField',
            'autoReorderPoint' => 'SearchBooleanField',
            'availableToPartners' => 'SearchBooleanField',
            'averageCost' => 'SearchDoubleField',
            'category' => 'SearchMultiSelectField',
            'class' => 'SearchMultiSelectField',
            'component' => 'SearchMultiSelectField',
            'componentOf' => 'SearchMultiSelectField',
            'copyDescription' => 'SearchBooleanField',
            'cost' => 'SearchDoubleField',
            'costingMethod' => 'SearchEnumMultiSelectField',
            'created' => 'SearchDateField',
            'dateViewed' => 'SearchDateField',
            'daysBeforeExpiration' => 'SearchDoubleField',
            'demandModifier' => 'SearchDoubleField',
            'department' => 'SearchMultiSelectField',
            'dontShowPrice' => 'SearchBooleanField',
            'ebayAuction' => 'SearchBooleanField',
            'ebayAuctionDuration' => 'SearchEnumMultiSelectField',
            'ebayBuyNowPrice' => 'SearchDoubleField',
            'ebayCategoryId' => 'SearchLongField',
            'ebayItemDescr' => 'SearchStringField',
            'ebayItemSubtitle' => 'SearchStringField',
            'ebayItemTitle' => 'SearchStringField',
            'ebayReservePrice' => 'SearchDoubleField',
            'ebayStartPrice' => 'SearchDoubleField',
            'ebayStore' => 'SearchBooleanField',
            'externalId' => 'SearchMultiSelectField',
            'feedDescription' => 'SearchStringField',
            'feedName' => 'SearchStringField',
            'froogleProductFeed' => 'SearchBooleanField',
            'giftCertAuthCode' => 'SearchStringField',
            'giftCertEmail' => 'SearchStringField',
            'giftCertExpDate' => 'SearchDateField',
            'giftCertFrom' => 'SearchStringField',
            'giftCertMsg' => 'SearchStringField',
            'giftCertOrigAmt' => 'SearchStringField',
            'giftCertRecipient' => 'SearchStringField',
            'imageUrl' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'inventoryLocation' => 'SearchMultiSelectField',
            'isAvailable' => 'SearchBooleanField',
            'isDropShipItem' => 'SearchBooleanField',
            'isFeatured' => 'SearchBooleanField',
            'isFulfillable' => 'SearchBooleanField',
            'isInactive' => 'SearchBooleanField',
            'isOnline' => 'SearchBooleanField',
            'isSpecialOrderItem' => 'SearchBooleanField',
            'issueProduct' => 'SearchMultiSelectField',
            'isTaxable' => 'SearchBooleanField',
            'isVsoeBundle' => 'SearchBooleanField',
            'itemId' => 'SearchStringField',
            'itemUrl' => 'SearchStringField',
            'lastModifiedDate' => 'SearchDateField',
            'lastPurchasePrice' => 'SearchDoubleField',
            'lastQuantityAvailableChange' => 'SearchDateField',
            'leadTime' => 'SearchLongField',
            'location' => 'SearchMultiSelectField',
            'locationAverageCost' => 'SearchDoubleField',
            'locationPreferredStockLevel' => 'SearchDoubleField',
            'locationQuantityAvailable' => 'SearchDoubleField',
            'locationQuantityBackOrdered' => 'SearchDoubleField',
            'locationQuantityCommitted' => 'SearchDoubleField',
            'locationQuantityOnHand' => 'SearchDoubleField',
            'locationQuantityOnOrder' => 'SearchDoubleField',
            'locationReorderPoint' => 'SearchDoubleField',
            'locationTotalValue' => 'SearchDoubleField',
            'manufacturer' => 'SearchStringField',
            'matrix' => 'SearchBooleanField',
            'matrixChild' => 'SearchBooleanField',
            'metaTagHtml' => 'SearchStringField',
            'minimumQuantity' => 'SearchLongField',
            'mpn' => 'SearchStringField',
            'nexTagCategory' => 'SearchStringField',
            'nexTagProductFeed' => 'SearchBooleanField',
            'numberAllowedDownloads' => 'SearchDoubleField',
            'offerSupport' => 'SearchBooleanField',
            'onlineCustomerPrice' => 'SearchDoubleField',
            'onSpecial' => 'SearchBooleanField',
            'overallQuantityPricingType' => 'SearchEnumMultiSelectField',
            'pageTitle' => 'SearchStringField',
            'parent' => 'SearchMultiSelectField',
            'preferredLocation' => 'SearchMultiSelectField',
            'preferredStockLevel' => 'SearchDoubleField',
            'preferredStockLevelDays' => 'SearchLongField',
            'price' => 'SearchDoubleField',
            'pricingGroup' => 'SearchMultiSelectField',
            'purchaseUnit' => 'SearchMultiSelectField',
            'quantityAvailable' => 'SearchDoubleField',
            'quantityBackOrdered' => 'SearchDoubleField',
            'quantityCommitted' => 'SearchDoubleField',
            'quantityOnHand' => 'SearchDoubleField',
            'quantityOnOrder' => 'SearchDoubleField',
            'quantityPricingSchedule' => 'SearchMultiSelectField',
            'reorderMultiple' => 'SearchLongField',
            'reorderPoint' => 'SearchDoubleField',
            'revRecSchedule' => 'SearchMultiSelectField',
            'safetyStockLevel' => 'SearchDoubleField',
            'safetyStockLevelDays' => 'SearchLongField',
            'salesDescription' => 'SearchStringField',
            'saleUnit' => 'SearchMultiSelectField',
            'searchKeywords' => 'SearchStringField',
            'seasonalDemand' => 'SearchBooleanField',
            'serialNumber' => 'SearchStringField',
            'shipIndividually' => 'SearchBooleanField',
            'shipPackage' => 'SearchMultiSelectField',
            'shippingRate' => 'SearchDoubleField',
            'shoppingDotComCategory' => 'SearchStringField',
            'shoppingProductFeed' => 'SearchBooleanField',
            'shopzillaCategoryId' => 'SearchLongField',
            'shopzillaProductFeed' => 'SearchBooleanField',
            'softDescriptor' => 'SearchMultiSelectField',
            'stockDescription' => 'SearchStringField',
            'stockUnit' => 'SearchMultiSelectField',
            'storeDescription' => 'SearchStringField',
            'subsidiary' => 'SearchMultiSelectField',
            'subType' => 'SearchEnumMultiSelectField',
            'taxCode' => 'SearchMultiSelectField',
            'taxSchedule' => 'SearchMultiSelectField',
            'thumbnailUrl' => 'SearchStringField',
            'totalValue' => 'SearchDoubleField',
            'trackLandedCost' => 'SearchBooleanField',
            'type' => 'SearchEnumMultiSelectField',
            'unitsType' => 'SearchMultiSelectField',
            'urlComponent' => 'SearchStringField',
            'useBins' => 'SearchBooleanField',
            'useMarginalRates' => 'SearchBooleanField',
            'vendor' => 'SearchMultiSelectField',
            'vsoeDeferral' => 'SearchMultiSelectField',
            'vsoeDelivered' => 'SearchBooleanField',
            'vsoePermitDiscount' => 'SearchMultiSelectField',
            'vsoePrice' => 'SearchDoubleField',
            'weight' => 'SearchDoubleField',
            'yahooProductFeed' => 'SearchBooleanField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        PartnerSearchBasic => {
            'address' => 'SearchStringField',
            'assignTasks' => 'SearchBooleanField',
            'category' => 'SearchMultiSelectField',
            'city' => 'SearchStringField',
            'class' => 'SearchMultiSelectField',
            'country' => 'SearchEnumMultiSelectField',
            'county' => 'SearchStringField',
            'dateCreated' => 'SearchDateField',
            'department' => 'SearchMultiSelectField',
            'eligibleForCommission' => 'SearchBooleanField',
            'email' => 'SearchStringField',
            'entityId' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'fax' => 'SearchStringField',
            'firstName' => 'SearchStringField',
            'giveAccess' => 'SearchBooleanField',
            'group' => 'SearchMultiSelectField',
            'hasDuplicates' => 'SearchBooleanField',
            'image' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'isPerson' => 'SearchBooleanField',
            'language' => 'SearchEnumMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'lastName' => 'SearchStringField',
            'location' => 'SearchMultiSelectField',
            'middleName' => 'SearchStringField',
            'parent' => 'SearchMultiSelectField',
            'partnerCode' => 'SearchStringField',
            'phone' => 'SearchStringField',
            'phoneticName' => 'SearchStringField',
            'promoCode' => 'SearchMultiSelectField',
            'salutation' => 'SearchStringField',
            'state' => 'SearchStringField',
            'subsidiary' => 'SearchMultiSelectField',
            'title' => 'SearchStringField',
            'unsubscribe' => 'SearchBooleanField',
            'URL' => 'SearchStringField',
            'zipCode' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        VendorSearchBasic => {
            'accountNumber' => 'SearchStringField',
            'address' => 'SearchStringField',
            'balance' => 'SearchDoubleField',
            'category' => 'SearchMultiSelectField',
            'city' => 'SearchStringField',
            'contact' => 'SearchStringField',
            'country' => 'SearchEnumMultiSelectField',
            'county' => 'SearchStringField',
            'creditLimit' => 'SearchDoubleField',
            'currency' => 'SearchMultiSelectField',
            'dateCreated' => 'SearchDateField',
            'eligibleForCommission' => 'SearchBooleanField',
            'email' => 'SearchStringField',
            'entityId' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'fax' => 'SearchStringField',
            'firstName' => 'SearchStringField',
            'giveAccess' => 'SearchBooleanField',
            'group' => 'SearchMultiSelectField',
            'hasDuplicates' => 'SearchBooleanField',
            'image' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'isJobResourceVend' => 'SearchBooleanField',
            'isPerson' => 'SearchBooleanField',
            'laborCost' => 'SearchDoubleField',
            'language' => 'SearchEnumMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'lastName' => 'SearchStringField',
            'middleName' => 'SearchStringField',
            'phone' => 'SearchStringField',
            'phoneticName' => 'SearchStringField',
            'salutation' => 'SearchStringField',
            'state' => 'SearchStringField',
            'subsidiary' => 'SearchMultiSelectField',
            'taxIdNum' => 'SearchStringField',
            'title' => 'SearchStringField',
            'unbilledOrders' => 'SearchDoubleField',
            'unsubscribe' => 'SearchBooleanField',
            'url' => 'SearchStringField',
            'zipCode' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        SiteCategorySearchBasic => {
            'dateViewed' => 'SearchDateField',
            'description' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'name' => 'SearchMultiSelectField',
        },
    
        TimeBillSearchBasic => {
            'approved' => 'SearchBooleanField',
            'billable' => 'SearchBooleanField',
            'class' => 'SearchMultiSelectField',
            'customer' => 'SearchMultiSelectField',
            'date' => 'SearchDateField',
            'dateCreated' => 'SearchDateField',
            'department' => 'SearchMultiSelectField',
            'duration' => 'SearchDoubleField',
            'employee' => 'SearchMultiSelectField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'item' => 'SearchMultiSelectField',
            'lastModified' => 'SearchDateField',
            'location' => 'SearchMultiSelectField',
            'memo' => 'SearchStringField',
            'paidByPayroll' => 'SearchBooleanField',
            'paidExternally' => 'SearchBooleanField',
            'payItem' => 'SearchMultiSelectField',
            'status' => 'SearchBooleanField',
            'subsidiary' => 'SearchMultiSelectField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        SolutionSearchBasic => {
            'abstract' => 'SearchStringField',
            'code' => 'SearchStringField',
            'description' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'find' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'isOnline' => 'SearchBooleanField',
            'number' => 'SearchLongField',
            'status' => 'SearchEnumMultiSelectField',
            'title' => 'SearchStringField',
            'topic' => 'SearchMultiSelectField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        TopicSearchBasic => {
            'description' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'name' => 'SearchStringField',
        },
    
        SubsidiarySearchBasic => {
            'externalId' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'name' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        GiftCertificateSearchBasic => {
            'amountAvailable' => 'SearchDoubleField',
            'amountAvailableBilled' => 'SearchDoubleField',
            'email' => 'SearchStringField',
            'expirationDate' => 'SearchDateField',
            'from' => 'SearchStringField',
            'giftCertCode' => 'SearchStringField',
            'incomeAccount' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isActive' => 'SearchBooleanField',
            'item' => 'SearchMultiSelectField',
            'liabilityAccount' => 'SearchMultiSelectField',
            'message' => 'SearchStringField',
            'name' => 'SearchStringField',
            'originalAmount' => 'SearchDoubleField',
            'purchaseDate' => 'SearchDateField',
        },
    
        FolderSearchBasic => {
            'description' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'folderName' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'modified' => 'SearchDateField',
            'numFiles' => 'SearchLongField',
            'private' => 'SearchBooleanField',
            'size' => 'SearchLongField',
        },
    
        FileSearchBasic => {
            'availableWithoutLogin' => 'SearchBooleanField',
            'created' => 'SearchDateField',
            'dateViewed' => 'SearchDateField',
            'description' => 'SearchStringField',
            'documentSize' => 'SearchLongField',
            'docURL' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'fileType' => 'SearchEnumMultiSelectField',
            'folder' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isAvailable' => 'SearchBooleanField',
            'isLink' => 'SearchBooleanField',
            'modified' => 'SearchDateField',
            'name' => 'SearchStringField',
            'owner' => 'SearchMultiSelectField',
        },
    
        JobSearchBasic => {
            'accountNumber' => 'SearchStringField',
            'actualTime' => 'SearchDoubleField',
            'address' => 'SearchStringField',
            'allowExpenses' => 'SearchBooleanField',
            'allowTime' => 'SearchBooleanField',
            'category' => 'SearchMultiSelectField',
            'city' => 'SearchStringField',
            'contact' => 'SearchStringField',
            'country' => 'SearchEnumMultiSelectField',
            'county' => 'SearchStringField',
            'customer' => 'SearchMultiSelectField',
            'dateCreated' => 'SearchDateField',
            'email' => 'SearchStringField',
            'endDate' => 'SearchDateField',
            'entityId' => 'SearchStringField',
            'estCost' => 'SearchDoubleField',
            'estEndDate' => 'SearchDateField',
            'estimatedTime' => 'SearchDoubleField',
            'estimatedTimeOverride' => 'SearchDoubleField',
            'estRevenue' => 'SearchDoubleField',
            'externalId' => 'SearchMultiSelectField',
            'fax' => 'SearchStringField',
            'giveAccess' => 'SearchBooleanField',
            'image' => 'SearchStringField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'jobResource' => 'SearchMultiSelectField',
            'jobResourceRole' => 'SearchMultiSelectField',
            'language' => 'SearchEnumMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'limitTimeToAssignees' => 'SearchBooleanField',
            'notes' => 'SearchStringField',
            'parent' => 'SearchMultiSelectField',
            'pctComplete' => 'SearchLongField',
            'percentTimeComplete' => 'SearchLongField',
            'phone' => 'SearchStringField',
            'phoneticName' => 'SearchStringField',
            'startDate' => 'SearchDateField',
            'state' => 'SearchStringField',
            'status' => 'SearchMultiSelectField',
            'subsidiary' => 'SearchMultiSelectField',
            'timeRemaining' => 'SearchDoubleField',
            'type' => 'SearchMultiSelectField',
            'unsubscribe' => 'SearchBooleanField',
            'zipCode' => 'SearchStringField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        IssueSearchBasic => {
            'ageInMonths' => 'SearchLongField',
            'assigned' => 'SearchMultiSelectField',
            'buildBroken' => 'SearchMultiSelectField',
            'buildBrokenName' => 'SearchStringField',
            'buildFixed' => 'SearchMultiSelectField',
            'buildFixedName' => 'SearchStringField',
            'buildTarget' => 'SearchMultiSelectField',
            'buildTargetName' => 'SearchStringField',
            'caseCount' => 'SearchLongField',
            'caseNumber' => 'SearchStringField',
            'closedDate' => 'SearchDateField',
            'createdDate' => 'SearchDateField',
            'dateReleased' => 'SearchDateField',
            'details' => 'SearchStringField',
            'duplicateOf' => 'SearchMultiSelectField',
            'eFix' => 'SearchBooleanField',
            'employeeOrTeam' => 'SearchMultiSelectField',
            'eventStatus' => 'SearchEnumMultiSelectField',
            'externalFixedIn' => 'SearchMultiSelectField',
            'externalStatus' => 'SearchMultiSelectField',
            'fixed' => 'SearchDateField',
            'fixedBy' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isOwner' => 'SearchBooleanField',
            'isReviewed' => 'SearchBooleanField',
            'isShowStopper' => 'SearchBooleanField',
            'issueAbstract' => 'SearchStringField',
            'issueNumber' => 'SearchStringField',
            'item' => 'SearchMultiSelectField',
            'lastModifiedDate' => 'SearchDateField',
            'module' => 'SearchMultiSelectField',
            'number' => 'SearchLongField',
            'originalFixedIn' => 'SearchStringField',
            'priority' => 'SearchMultiSelectField',
            'product' => 'SearchMultiSelectField',
            'productTeam' => 'SearchMultiSelectField',
            'reportedBy' => 'SearchMultiSelectField',
            'reproduce' => 'SearchMultiSelectField',
            'reviewer' => 'SearchMultiSelectField',
            'severity' => 'SearchMultiSelectField',
            'source' => 'SearchMultiSelectField',
            'status' => 'SearchMultiSelectField',
            'tags' => 'SearchMultiSelectField',
            'tracking' => 'SearchBooleanField',
            'type' => 'SearchMultiSelectField',
            'userType' => 'SearchMultiSelectField',
            'versionBroken' => 'SearchMultiSelectField',
            'versionFixed' => 'SearchMultiSelectField',
            'versionTarget' => 'SearchMultiSelectField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        GroupMemberSearchBasic => {
            'groupId' => 'SearchMultiSelectField',
        },
    
        SubsidiaryList => {
        },
    
        CampaignSearchBasic => {
            'audience' => 'SearchMultiSelectField',
            'baseCost' => 'SearchDoubleField',
            'campaignEventType' => 'SearchEnumMultiSelectField',
            'campaignId' => 'SearchStringField',
            'category' => 'SearchMultiSelectField',
            'channel' => 'SearchMultiSelectField',
            'cost' => 'SearchDoubleField',
            'createdDate' => 'SearchDateField',
            'endDate' => 'SearchDateField',
            'event' => 'SearchStringField',
            'expectedRevenue' => 'SearchDoubleField',
            'family' => 'SearchMultiSelectField',
            'group' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'item' => 'SearchMultiSelectField',
            'keyword' => 'SearchStringField',
            'lastModifiedDate' => 'SearchDateField',
            'manager' => 'SearchMultiSelectField',
            'number' => 'SearchLongField',
            'offer' => 'SearchMultiSelectField',
            'promoCode' => 'SearchMultiSelectField',
            'recipient' => 'SearchMultiSelectField',
            'response' => 'SearchEnumMultiSelectField',
            'responseCode' => 'SearchLongField',
            'responseComments' => 'SearchStringField',
            'responseDate' => 'SearchDateField',
            'scheduleDate' => 'SearchDateField',
            'searchEngine' => 'SearchMultiSelectField',
            'startDate' => 'SearchDateField',
            'status' => 'SearchEnumMultiSelectField',
            'subscription' => 'SearchMultiSelectField',
            'template' => 'SearchMultiSelectField',
            'title' => 'SearchStringField',
            'vertical' => 'SearchMultiSelectField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
        EntityGroupSearchBasic => {
            'email' => 'SearchStringField',
            'externalId' => 'SearchMultiSelectField',
            'groupName' => 'SearchStringField',
            'groupOwner' => 'SearchMultiSelectField',
            'groupType' => 'SearchMultiSelectField',
            'internalId' => 'SearchMultiSelectField',
            'isInactive' => 'SearchBooleanField',
            'isPrivate' => 'SearchBooleanField',
            'lastModifiedDate' => 'SearchDateField',
            'customFieldList' => 'SearchCustomFieldList',
        },
    
    };

}

sub RecordTypes {

    return {
    
        CalendarEventSearch => {
            'basic' => 'CalendarEventSearchBasic',
            'attendeeJoin' => 'EntitySearchBasic',
            'attendeeContactJoin' => 'ContactSearchBasic',
            'attendeeCustomerJoin' => 'CustomerSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'opportunityJoin' => 'OpportunitySearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        TaskSearch => {
            'basic' => 'TaskSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'companyCustomerJoin' => 'CustomerSearchBasic',
            'contactJoin' => 'ContactSearchBasic',
            'employeeJoin' => 'EmployeeSearchBasic',
            'jobJoin' => 'JobSearchBasic',
            'opportunityJoin' => 'OpportunitySearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        PhoneCallSearch => {
            'basic' => 'PhoneCallSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'contactJoin' => 'ContactSearchBasic',
            'employeeJoin' => 'EmployeeSearchBasic',
            'opportunityJoin' => 'OpportunitySearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        NoteSearch => {
            'basic' => 'NoteSearchBasic',
            'authorJoin' => 'EmployeeSearchBasic',
            'callJoin' => 'PhoneCallSearchBasic',
            'campaignJoin' => 'CampaignSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'contactJoin' => 'ContactSearchBasic',
            'customerJoin' => 'CustomerSearchBasic',
            'employeeJoin' => 'EmployeeSearchBasic',
            'entityJoin' => 'EntitySearchBasic',
            'eventJoin' => 'CalendarEventSearchBasic',
            'issueJoin' => 'IssueSearchBasic',
            'itemJoin' => 'ItemSearchBasic',
            'opportunityJoin' => 'OpportunitySearchBasic',
            'partnerJoin' => 'PartnerSearchBasic',
            'solutionJoin' => 'SolutionSearchBasic',
            'taskJoin' => 'TaskSearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'vendorJoin' => 'VendorSearchBasic',
        },
    
        MessageSearch => {
            'basic' => 'MessageSearchBasic',
            'attachmentsJoin' => 'FileSearchBasic',
            'authorJoin' => 'EntitySearchBasic',
            'campaignJoin' => 'CampaignSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'contactJoin' => 'ContactSearchBasic',
            'customerJoin' => 'CustomerSearchBasic',
            'employeeJoin' => 'EmployeeSearchBasic',
            'entityJoin' => 'EntitySearchBasic',
            'opportunityJoin' => 'OpportunitySearchBasic',
            'partnerJoin' => 'PartnerSearchBasic',
            'recipientJoin' => 'EntitySearchBasic',
            'solutionJoin' => 'SolutionSearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'vendorJoin' => 'VendorSearchBasic',
        },
    
        ContactSearch => {
            'basic' => 'ContactSearchBasic',
            'callJoin' => 'PhoneCallSearchBasic',
            'campaignResponseJoin' => 'CampaignSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'customerJoin' => 'CustomerSearchBasic',
            'customerPrimaryJoin' => 'CustomerSearchBasic',
            'eventJoin' => 'CalendarEventSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'messagesFromJoin' => 'MessageSearchBasic',
            'messagesToJoin' => 'MessageSearchBasic',
            'opportunityJoin' => 'OpportunitySearchBasic',
            'partnerJoin' => 'PartnerSearchBasic',
            'partnerPrimaryJoin' => 'PartnerSearchBasic',
            'taskJoin' => 'TaskSearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
            'vendorJoin' => 'VendorSearchBasic',
            'vendorPrimaryJoin' => 'VendorSearchBasic',
        },
    
        CustomerSearch => {
            'basic' => 'CustomerSearchBasic',
            'callJoin' => 'PhoneCallSearchBasic',
            'campaignResponseJoin' => 'CampaignSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'contactJoin' => 'ContactSearchBasic',
            'contactPrimaryJoin' => 'ContactSearchBasic',
            'eventJoin' => 'CalendarEventSearchBasic',
            'hostedPageJoin' => 'FileSearchBasic',
            'leadSourceJoin' => 'CampaignSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'messagesFromJoin' => 'MessageSearchBasic',
            'messagesToJoin' => 'MessageSearchBasic',
            'opportunityJoin' => 'OpportunitySearchBasic',
            'parentCustomerJoin' => 'CustomerSearchBasic',
            'partnerJoin' => 'PartnerSearchBasic',
            'salesRepJoin' => 'EmployeeSearchBasic',
            'subCustomerJoin' => 'CustomerSearchBasic',
            'taskJoin' => 'TaskSearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
            'webSiteCategoryJoin' => 'SiteCategorySearchBasic',
            'webSiteItemJoin' => 'ItemSearchBasic',
        },
    
        PartnerSearch => {
            'basic' => 'PartnerSearchBasic',
            'campaignResponseJoin' => 'CampaignSearchBasic',
            'contactJoin' => 'ContactSearchBasic',
            'contactPrimaryJoin' => 'ContactSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'messagesFromJoin' => 'MessageSearchBasic',
            'messagesToJoin' => 'MessageSearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        VendorSearch => {
            'basic' => 'VendorSearchBasic',
            'campaignResponseJoin' => 'CampaignSearchBasic',
            'contactJoin' => 'ContactSearchBasic',
            'contactPrimaryJoin' => 'ContactSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'messagesFromJoin' => 'MessageSearchBasic',
            'messagesToJoin' => 'MessageSearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        EntityGroupSearch => {
            'basic' => 'EntityGroupSearchBasic',
            'groupMemberJoin' => 'EntitySearchBasic',
        },
    
        JobSearch => {
            'basic' => 'JobSearchBasic',
            'customerJoin' => 'CustomerSearchBasic',
            'taskJoin' => 'TaskSearchBasic',
        },
    
        SupportCaseSearch => {
            'basic' => 'SupportCaseSearchBasic',
            'contactJoin' => 'ContactSearchBasic',
            'customerJoin' => 'CustomerSearchBasic',
            'employeeJoin' => 'EmployeeSearchBasic',
            'issueJoin' => 'IssueSearchBasic',
            'itemJoin' => 'ItemSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        SolutionSearch => {
            'basic' => 'SolutionSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        TopicSearch => {
            'basic' => 'TopicSearchBasic',
        },
    
        IssueSearch => {
            'basic' => 'IssueSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'employeeJoin' => 'EmployeeSearchBasic',
        },
    
        AccountSearch => {
            'basic' => 'AccountSearchBasic',
        },
    
        DepartmentSearch => {
            'basic' => 'DepartmentSearchBasic',
        },
    
        ClassificationSearch => {
            'basic' => 'ClassificationSearchBasic',
        },
    
        LocationSearch => {
            'basic' => 'LocationSearchBasic',
        },
    
        ItemSearch => {
            'basic' => 'ItemSearchBasic',
            'preferredVendorJoin' => 'VendorSearchBasic',
            'shopperJoin' => 'CustomerSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
            'vendorJoin' => 'VendorSearchBasic',
        },
    
        BinSearch => {
            'basic' => 'BinSearchBasic',
        },
    
        SubsidiarySearch => {
            'basic' => 'SubsidiarySearchBasic',
        },
    
        GiftCertificateSearch => {
            'basic' => 'GiftCertificateSearchBasic',
        },
    
        OpportunitySearch => {
            'basic' => 'OpportunitySearchBasic',
            'callJoin' => 'PhoneCallSearchBasic',
            'customerJoin' => 'CustomerSearchBasic',
            'decisionMakerJoin' => 'ContactSearchBasic',
            'eventJoin' => 'CalendarEventSearchBasic',
            'leadSourceJoin' => 'CampaignSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'partnerJoin' => 'PartnerSearchBasic',
            'salesRepJoin' => 'EmployeeSearchBasic',
            'taskJoin' => 'TaskSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        TransactionSearch => {
            'basic' => 'TransactionSearchBasic',
            'accountJoin' => 'AccountSearchBasic',
            'appliedToTransactionJoin' => 'TransactionSearchBasic',
            'applyingTransactionJoin' => 'TransactionSearchBasic',
            'classJoin' => 'ClassificationSearchBasic',
            'contactPrimaryJoin' => 'ContactSearchBasic',
            'createdFromJoin' => 'TransactionSearchBasic',
            'customerJoin' => 'CustomerSearchBasic',
            'departmentJoin' => 'DepartmentSearchBasic',
            'employeeJoin' => 'EmployeeSearchBasic',
            'itemJoin' => 'ItemSearchBasic',
            'jobJoin' => 'JobSearchBasic',
            'leadSourceJoin' => 'CampaignSearchBasic',
            'locationJoin' => 'LocationSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'opportunityJoin' => 'OpportunitySearchBasic',
            'salesRepJoin' => 'EmployeeSearchBasic',
            'subsidiaryJoin' => 'SubsidiarySearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
            'vendorJoin' => 'VendorSearchBasic',
        },
    
        CustomRecordSearch => {
            'basic' => 'CustomRecordSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        EmployeeSearch => {
            'basic' => 'EmployeeSearchBasic',
            'campaignResponseJoin' => 'CampaignSearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'messagesFromJoin' => 'MessageSearchBasic',
            'messagesToJoin' => 'MessageSearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
        FileSearch => {
            'basic' => 'FileSearchBasic',
            'shopperJoin' => 'CustomerSearchBasic',
        },
    
        FolderSearch => {
            'basic' => 'FolderSearchBasic',
        },
    
        SiteCategorySearch => {
            'basic' => 'SiteCategorySearchBasic',
            'shopperJoin' => 'CustomerSearchBasic',
        },
    
        TimeBillSearch => {
            'basic' => 'TimeBillSearchBasic',
            'callJoin' => 'PhoneCallSearchBasic',
            'caseJoin' => 'SupportCaseSearchBasic',
            'customerJoin' => 'CustomerSearchBasic',
            'employeeJoin' => 'EmployeeSearchBasic',
            'eventJoin' => 'CalendarEventSearchBasic',
            'itemJoin' => 'ItemSearchBasic',
            'taskJoin' => 'TaskSearchBasic',
        },
    
        CampaignSearch => {
            'basic' => 'CampaignSearchBasic',
            'campaignRecipientJoin' => 'EntitySearchBasic',
            'messagesJoin' => 'MessageSearchBasic',
            'transactionJoin' => 'TransactionSearchBasic',
            'userNotesJoin' => 'NoteSearchBasic',
        },
    
    };
    
}

sub RecordFields {

    return {
    
        CalendarEvent => {
            'company' => 'core:RecordRef',
            'contact' => 'core:RecordRef',
            'supportCase' => 'core:RecordRef',
            'transaction' => 'core:RecordRef',
            'period' => 'scheduling:long',
            'frequency' => 'schedulingTypes:CalendarEventFrequency',
            'recurrenceDowMaskList' => 'scheduling:RecurrenceDowMaskList',
            'recurrenceDow' => 'schedulingTypes:CalendarEventDow',
            'recurrenceDowim' => 'schedulingTypes:CalendarEventDowim',
            'seriesStartDate' => 'scheduling:dateTime',
            'endByDate' => 'scheduling:dateTime',
            'noEndDate' => 'scheduling:boolean',
            'sendEmail' => 'scheduling:boolean',
            'customForm' => 'core:RecordRef',
            'title' => 'scheduling:string',
            'location' => 'scheduling:string',
            'startDate' => 'scheduling:dateTime',
            'allDayEvent' => 'scheduling:boolean',
            'timedEvent' => 'scheduling:boolean',
            'reminderType' => 'schedulingTypes:CalendarEventReminderType',
            'reminderMinutes' => 'schedulingTypes:CalendarEventReminderMinutes',
            'status' => 'schedulingTypes:CalendarEventStatus',
            'accessLevel' => 'schedulingTypes:CalendarEventAccessLevel',
            'organizer' => 'core:RecordRef',
            'message' => 'scheduling:string',
            'createdDate' => 'scheduling:dateTime',
            'endDate' => 'scheduling:dateTime',
            'exclusionDateList' => 'scheduling:ExclusionDateList',
            'lastModifiedDate' => 'scheduling:dateTime',
            'owner' => 'core:RecordRef',
            'attendeeList' => 'scheduling:CalendarEventAttendeeList',
            'resourceList' => 'scheduling:CalendarEventResourceList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ExclusionDateList => {
            'exclusionDate' => 'scheduling:dateTime',
        },
    
        RecurrenceDowMaskList => {
            'recurrenceDowMask' => 'schedulingTypes:CalendarEventDow',
        },
    
        CalendarEventAttendee => {
            'sendEmail' => 'scheduling:boolean',
            'attendee' => 'core:RecordRef',
            'response' => 'schedulingTypes:CalendarEventAttendeeResponse',
            'attendance' => 'schedulingTypes:CalendarEventAttendeeAttendance',
        },
    
        CalendarEventAttendeeList => {
            'attendee' => 'scheduling:CalendarEventAttendee',
        },
    
        CalendarEventResource => {
            'resource' => 'core:RecordRef',
            'location' => 'scheduling:string',
        },
    
        CalendarEventResourceList => {
            'resource' => 'scheduling:CalendarEventResource',
        },
    
        Task => {
            'company' => 'core:RecordRef',
            'contact' => 'core:RecordRef',
            'supportCase' => 'core:RecordRef',
            'transaction' => 'core:RecordRef',
            'milestone' => 'core:RecordRef',
            'customForm' => 'core:RecordRef',
            'title' => 'scheduling:string',
            'assigned' => 'core:RecordRef',
            'sendEmail' => 'scheduling:boolean',
            'timedEvent' => 'scheduling:boolean',
            'startDate' => 'scheduling:dateTime',
            'endDate' => 'scheduling:dateTime',
            'dueDate' => 'scheduling:dateTime',
            'completedDate' => 'scheduling:dateTime',
            'priority' => 'schedulingTypes:TaskPriority',
            'status' => 'schedulingTypes:TaskStatus',
            'message' => 'scheduling:string',
            'accessLevel' => 'scheduling:boolean',
            'reminderType' => 'schedulingTypes:TaskReminderType',
            'reminderMinutes' => 'schedulingTypes:TaskReminderMinutes',
            'createdDate' => 'scheduling:dateTime',
            'lastModifiedDate' => 'scheduling:dateTime',
            'owner' => 'core:RecordRef',
            'contactList' => 'scheduling:TaskContactList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        TaskContact => {
            'company' => 'core:RecordRef',
            'contact' => 'core:RecordRef',
        },
    
        TaskContactList => {
            'contact' => 'scheduling:TaskContact',
        },
    
        PhoneCall => {
            'message' => 'scheduling:string',
            'company' => 'core:RecordRef',
            'contact' => 'core:RecordRef',
            'supportCase' => 'core:RecordRef',
            'transaction' => 'core:RecordRef',
            'milestone' => 'core:RecordRef',
            'customForm' => 'core:RecordRef',
            'title' => 'scheduling:string',
            'assigned' => 'core:RecordRef',
            'sendEmail' => 'scheduling:boolean',
            'startDate' => 'scheduling:dateTime',
            'endDate' => 'scheduling:dateTime',
            'timedEvent' => 'scheduling:boolean',
            'completedDate' => 'scheduling:dateTime',
            'phone' => 'scheduling:string',
            'status' => 'schedulingTypes:PhoneCallStatus',
            'priority' => 'schedulingTypes:PhoneCallPriority',
            'accessLevel' => 'scheduling:boolean',
            'reminderType' => 'schedulingTypes:PhoneCallReminderType',
            'reminderMinutes' => 'schedulingTypes:PhoneCallReminderMinutes',
            'createdDate' => 'scheduling:dateTime',
            'lastModifiedDate' => 'scheduling:dateTime',
            'contactList' => 'scheduling:PhoneCallContactList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        PhoneCallContact => {
            'company' => 'core:RecordRef',
            'contact' => 'core:RecordRef',
            'phone' => 'scheduling:string',
            'email' => 'scheduling:string',
        },
    
        PhoneCallContactList => {
            'contact' => 'scheduling:PhoneCallContact',
        },
    
        Note => {
            'title' => 'communication:string',
            'noteType' => 'core:RecordRef',
            'direction' => 'communicationTypes:NoteDirection',
            'noteDate' => 'communication:dateTime',
            'note' => 'communication:string',
            'lastModifiedDate' => 'communication:dateTime',
            'activity' => 'core:RecordRef',
            'author' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'item' => 'core:RecordRef',
            'record' => 'core:RecordRef',
            'recordType' => 'core:RecordRef',
            'topic' => 'core:RecordRef',
            'transaction' => 'core:RecordRef',
        },
    
        Message => {
            'author' => 'core:RecordRef',
            'recipient' => 'core:RecordRef',
            'cc' => 'communication:string',
            'bcc' => 'communication:string',
            'messageDate' => 'communication:dateTime',
            'subject' => 'communication:string',
            'message' => 'communication:string',
            'emailed' => 'communication:boolean',
            'activity' => 'core:RecordRef',
            'incoming' => 'communication:boolean',
            'lastModifiedDate' => 'communication:dateTime',
            'transaction' => 'core:RecordRef',
            'mediaItemList' => 'communication:MessageMediaItemList',
        },
    
        MessageMediaItemList => {
            'mediaItem' => 'communication:File',
        },
    
        Subscriptions => {
            'subscribed' => 'relationships:string',
            'subscription' => 'relationships:string',
            'lastModifiedDate' => 'relationships:dateTime',
        },
    
        SubscriptionsList => {
            'subscriptions' => 'relationships:Subscriptions',
        },
    
        Contact => {
            'customForm' => 'core:RecordRef',
            'entityId' => 'relationships:string',
            'company' => 'core:RecordRef',
            'salutation' => 'relationships:string',
            'firstName' => 'relationships:string',
            'middleName' => 'relationships:string',
            'lastName' => 'relationships:string',
            'title' => 'relationships:string',
            'phone' => 'relationships:string',
            'fax' => 'relationships:string',
            'email' => 'relationships:string',
            'defaultAddress' => 'relationships:string',
            'isPrivate' => 'relationships:boolean',
            'isInactive' => 'relationships:boolean',
            'phoneticName' => 'relationships:string',
            'categoryList' => 'relationships:CategoryList',
            'altEmail' => 'relationships:string',
            'officePhone' => 'relationships:string',
            'homePhone' => 'relationships:string',
            'mobilePhone' => 'relationships:string',
            'supervisor' => 'core:RecordRef',
            'supervisorPhone' => 'relationships:string',
            'assistant' => 'core:RecordRef',
            'assistantPhone' => 'relationships:string',
            'comments' => 'relationships:string',
            'unsubscribe' => 'relationships:boolean',
            'image' => 'core:RecordRef',
            'billPay' => 'relationships:boolean',
            'dateCreated' => 'relationships:dateTime',
            'lastModifiedDate' => 'relationships:dateTime',
            'addressbookList' => 'relationships:ContactAddressbookList',
            'subscriptionsList' => 'relationships:SubscriptionsList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CategoryList => {
            'category' => 'core:RecordRef',
        },
    
        ContactAddressbook => {
            'defaultShipping' => 'relationships:boolean',
            'defaultBilling' => 'relationships:boolean',
            'label' => 'relationships:string',
            'attention' => 'relationships:string',
            'addressee' => 'relationships:string',
            'phone' => 'relationships:string',
            'addr1' => 'relationships:string',
            'addr2' => 'relationships:string',
            'city' => 'relationships:string',
            'zip' => 'relationships:string',
            'country' => 'commonTyp:Country',
            'addrText' => 'relationships:string',
            'override' => 'relationships:boolean',
            'internalId' => 'relationships:string',
            'state' => 'relationships:string',
        },
    
        ContactAddressbookList => {
            'addressbook' => 'relationships:ContactAddressbook',
        },
    
        Customer => {
            'customForm' => 'core:RecordRef',
            'entityId' => 'relationships:string',
            'isPerson' => 'relationships:boolean',
            'phoneticName' => 'relationships:string',
            'salutation' => 'relationships:string',
            'firstName' => 'relationships:string',
            'middleName' => 'relationships:string',
            'lastName' => 'relationships:string',
            'companyName' => 'relationships:string',
            'entityStatus' => 'core:RecordRef',
            'parent' => 'core:RecordRef',
            'phone' => 'relationships:string',
            'fax' => 'relationships:string',
            'email' => 'relationships:string',
            'url' => 'relationships:string',
            'defaultAddress' => 'relationships:string',
            'isInactive' => 'relationships:boolean',
            'category' => 'core:RecordRef',
            'title' => 'relationships:string',
            'printOnCheckAs' => 'relationships:string',
            'altPhone' => 'relationships:string',
            'homePhone' => 'relationships:string',
            'mobilePhone' => 'relationships:string',
            'altEmail' => 'relationships:string',
            'language' => 'commonTypes:Language',
            'comments' => 'relationships:string',
            'dateCreated' => 'relationships:dateTime',
            'image' => 'core:RecordRef',
            'emailPreference' => 'relationshipsTypes:EmailPreference',
            'subsidiary' => 'core:RecordRef',
            'salesRep' => 'core:RecordRef',
            'territory' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'salesGroup' => 'core:RecordRef',
            'vatRegNumber' => 'relationships:string',
            'accountNumber' => 'relationships:string',
            'terms' => 'core:RecordRef',
            'creditLimit' => 'relationships:double',
            'creditHoldOverride' => 'relationshipsTypes:CustomerCreditHoldOverride',
            'balance' => 'relationships:double',
            'overdueBalance' => 'relationships:double',
            'daysOverdue' => 'relationships:long',
            'unbilledOrders' => 'relationships:double',
            'priceLevel' => 'core:RecordRef',
            'currency' => 'core:RecordRef',
            'prefCCProcessor' => 'core:RecordRef',
            'shipComplete' => 'relationships:boolean',
            'taxable' => 'relationships:boolean',
            'taxItem' => 'core:RecordRef',
            'resaleNumber' => 'relationships:string',
            'startDate' => 'relationships:dateTime',
            'endDate' => 'relationships:dateTime',
            'reminderDays' => 'relationships:long',
            'shippingItem' => 'core:RecordRef',
            'thirdPartyAcct' => 'relationships:string',
            'thirdPartyZipcode' => 'relationships:string',
            'thirdPartyCountry' => 'commonTypes:Country',
            'giveAccess' => 'relationships:boolean',
            'accessRole' => 'core:RecordRef',
            'sendEmail' => 'relationships:boolean',
            'password' => 'relationships:string',
            'password2' => 'relationships:string',
            'requirePwdChange' => 'relationships:boolean',
            'accessHelp' => 'relationships:string',
            'campaignCategory' => 'core:RecordRef',
            'leadSource' => 'core:RecordRef',
            'webLead' => 'relationships:string',
            'unsubscribe' => 'relationships:boolean',
            'referrer' => 'relationships:string',
            'keywords' => 'relationships:string',
            'clickStream' => 'relationships:string',
            'lastPageVisited' => 'relationships:string',
            'visits' => 'relationships:long',
            'firstVisit' => 'relationships:dateTime',
            'lastVisit' => 'relationships:dateTime',
            'billPay' => 'relationships:boolean',
            'openingBalance' => 'relationships:double',
            'lastModifiedDate' => 'relationships:dateTime',
            'openingBalanceDate' => 'relationships:dateTime',
            'openingBalanceAccount' => 'core:RecordRef',
            'stage' => 'relationshipsTypes:CustomerStage',
            'salesTeamList' => 'relationships:CustomerSalesTeamList',
            'downloadList' => 'relationships:CustomerDownloadList',
            'addressbookList' => 'relationships:CustomerAddressbookList',
            'subscriptionsList' => 'relationships:SubscriptionsList',
            'contactList' => 'relationships:CustomerContactList',
            'creditCardsList' => 'relationships:CustomerCreditCardsList',
            'groupPricingList' => 'relationships:CustomerGroupPricingList',
            'itemPricingList' => 'relationships:CustomerItemPricingList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CustomerDownload => {
            'file' => 'core:RecordRef',
            'licenseCode' => 'relationships:string',
            'remainingDownloads' => 'relationships:long',
            'expiration' => 'relationships:dateTime',
        },
    
        CustomerDownloadList => {
            'download' => 'relationships:CustomerDownload',
        },
    
        CustomerContact => {
            'contact' => 'core:RecordRef',
            'contactRole' => 'core:RecordRef',
        },
    
        CustomerContactList => {
            'contact' => 'relationships:CustomerContact',
        },
    
        CustomerSalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'relationships:boolean',
            'contribution' => 'relationships:double',
        },
    
        CustomerSalesTeamList => {
            'salesTeam' => 'relationships:CustomerSalesTeam',
        },
    
        CustomerAddressbook => {
            'defaultShipping' => 'relationships:boolean',
            'defaultBilling' => 'relationships:boolean',
            'isResidential' => 'relationships:boolean',
            'label' => 'relationships:string',
            'attention' => 'relationships:string',
            'addressee' => 'relationships:string',
            'phone' => 'relationships:string',
            'addr1' => 'relationships:string',
            'addr2' => 'relationships:string',
            'city' => 'relationships:string',
            'zip' => 'relationships:string',
            'country' => 'commonTyp:Country',
            'addrText' => 'relationships:string',
            'override' => 'relationships:boolean',
            'internalId' => 'relationships:string',
            'state' => 'relationships:string',
        },
    
        CustomerAddressbookList => {
            'addressbook' => 'relationships:CustomerAddressbook',
        },
    
        CustomerCreditCards => {
            'internalId' => 'relationships:string',
            'ccNumber' => 'relationships:string',
            'ccExpireDate' => 'relationships:dateTime',
            'ccName' => 'relationships:string',
            'paymentMethod' => 'core:RecordRef',
            'ccMemo' => 'relationships:string',
            'ccDefault' => 'relationships:boolean',
        },
    
        CustomerCreditCardsList => {
            'creditCards' => 'relationships:CustomerCreditCards',
        },
    
        CustomerGroupPricing => {
            'group' => 'core:RecordRef',
            'level' => 'core:RecordRef',
        },
    
        CustomerGroupPricingList => {
            'groupPricing' => 'relationships:CustomerGroupPricing',
        },
    
        CustomerItemPricing => {
            'item' => 'core:RecordRef',
            'level' => 'core:RecordRef',
        },
    
        CustomerItemPricingList => {
            'itemPricing' => 'relationships:CustomerItemPricing',
        },
    
        CustomerStatus => {
            'name' => 'relationships:string',
            'stage' => 'relationshipsTypes:CustomerStatusStage',
            'probability' => 'relationships:double',
            'description' => 'relationships:string',
            'includeInLeadReports' => 'relationships:boolean',
            'isInactive' => 'relationships:boolean',
        },
    
        Partner => {
            'customForm' => 'core:RecordRef',
            'entityId' => 'relationships:string',
            'partnerCode' => 'relationships:string',
            'isPerson' => 'relationships:boolean',
            'phoneticName' => 'relationships:string',
            'salutation' => 'relationships:string',
            'firstName' => 'relationships:string',
            'middleName' => 'relationships:string',
            'lastName' => 'relationships:string',
            'companyName' => 'relationships:string',
            'parent' => 'core:RecordRef',
            'phone' => 'relationships:string',
            'fax' => 'relationships:string',
            'email' => 'relationships:string',
            'url' => 'relationships:string',
            'defaultAddress' => 'relationships:string',
            'isInactive' => 'relationships:boolean',
            'lastModifiedDate' => 'relationships:dateTime',
            'dateCreated' => 'relationships:dateTime',
            'referringUrl' => 'relationships:string',
            'unsubscribe' => 'relationships:boolean',
            'roleList' => 'core:RecordRefList',
            'categoryList' => 'relationships:CategoryList',
            'title' => 'relationships:string',
            'printOnCheckAs' => 'relationships:string',
            'taxIdNum' => 'relationships:string',
            'comments' => 'relationships:string',
            'image' => 'core:RecordRef',
            'emailPreference' => 'relationshipsTypes:EmailPreference',
            'department' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'homePhone' => 'relationships:string',
            'mobilePhone' => 'relationships:string',
            'altEmail' => 'relationships:string',
            'giveAccess' => 'relationships:boolean',
            'accessRole' => 'core:RecordRef',
            'sendEmail' => 'relationships:boolean',
            'password' => 'relationships:string',
            'password2' => 'relationships:string',
            'requirePwdChange' => 'relationships:boolean',
            'subPartnerLogin' => 'relationships:boolean',
            'promoCodeList' => 'relationships:PartnerPromoCodeList',
            'addressbookList' => 'relationships:PartnerAddressbookList',
            'subscriptionsList' => 'relationships:SubscriptionsList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        PartnerPromoCode => {
            'promoCode' => 'core:RecordRef',
            'discount' => 'relationships:string',
            'endDate' => 'relationships:dateTime',
        },
    
        PartnerPromoCodeList => {
            'promoCode' => 'relationships:PartnerPromoCode',
        },
    
        PartnerAddressbook => {
            'defaultShipping' => 'relationships:boolean',
            'defaultBilling' => 'relationships:boolean',
            'label' => 'relationships:string',
            'attention' => 'relationships:string',
            'addressee' => 'relationships:string',
            'phone' => 'relationships:string',
            'addr1' => 'relationships:string',
            'addr2' => 'relationships:string',
            'city' => 'relationships:string',
            'zip' => 'relationships:string',
            'country' => 'commonTyp:Country',
            'addrText' => 'relationships:string',
            'override' => 'relationships:boolean',
            'internalId' => 'relationships:string',
            'state' => 'relationships:string',
        },
    
        PartnerAddressbookList => {
            'addressbook' => 'relationships:PartnerAddressbook',
        },
    
        Vendor => {
            'customForm' => 'core:RecordRef',
            'entityId' => 'relationships:string',
            'isPerson' => 'relationships:boolean',
            'phoneticName' => 'relationships:string',
            'salutation' => 'relationships:string',
            'firstName' => 'relationships:string',
            'middleName' => 'relationships:string',
            'lastName' => 'relationships:string',
            'companyName' => 'relationships:string',
            'phone' => 'relationships:string',
            'fax' => 'relationships:string',
            'email' => 'relationships:string',
            'url' => 'relationships:string',
            'defaultAddress' => 'relationships:string',
            'isInactive' => 'relationships:boolean',
            'lastModifiedDate' => 'relationships:dateTime',
            'dateCreated' => 'relationships:dateTime',
            'category' => 'core:RecordRef',
            'title' => 'relationships:string',
            'printOnCheckAs' => 'relationships:string',
            'altPhone' => 'relationships:string',
            'homePhone' => 'relationships:string',
            'mobilePhone' => 'relationships:string',
            'altEmail' => 'relationships:string',
            'comments' => 'relationships:string',
            'unsubscribe' => 'relationships:boolean',
            'image' => 'core:RecordRef',
            'emailPreference' => 'relationshipsTypes:EmailPreference',
            'subsidiary' => 'core:RecordRef',
            'accountNumber' => 'relationships:string',
            'legalName' => 'relationships:string',
            'expenseAccount' => 'core:RecordRef',
            'terms' => 'core:RecordRef',
            'creditLimit' => 'relationships:double',
            'openingBalance' => 'relationships:double',
            'openingBalanceDate' => 'relationships:dateTime',
            'openingBalanceAccount' => 'core:RecordRef',
            'balance' => 'relationships:double',
            'unbilledOrders' => 'relationships:double',
            'currency' => 'core:RecordRef',
            'is1099Eligible' => 'relationships:boolean',
            'isJobResourceVend' => 'relationships:boolean',
            'laborCost' => 'relationships:double',
            'taxIdNum' => 'relationships:string',
            'giveAccess' => 'relationships:boolean',
            'sendEmail' => 'relationships:boolean',
            'billPay' => 'relationships:boolean',
            'isAccountant' => 'relationships:boolean',
            'password' => 'relationships:string',
            'password2' => 'relationships:string',
            'requirePwdChange' => 'relationships:boolean',
            'pricingScheduleList' => 'relationships:VendorPricingScheduleList',
            'subscriptionsList' => 'relationships:SubscriptionsList',
            'addressbookList' => 'relationships:VendorAddressbookList',
            'rolesList' => 'relationships:VendorRolesList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        VendorPricingSchedule => {
            'scheduleName' => 'relationships:string',
            'scheduleDiscount' => 'relationships:double',
        },
    
        VendorPricingScheduleList => {
            'pricingSchedule' => 'relationships:VendorPricingSchedule',
        },
    
        VendorAddressbook => {
            'defaultShipping' => 'relationships:boolean',
            'defaultBilling' => 'relationships:boolean',
            'label' => 'relationships:string',
            'attention' => 'relationships:string',
            'addressee' => 'relationships:string',
            'phone' => 'relationships:string',
            'addr1' => 'relationships:string',
            'addr2' => 'relationships:string',
            'city' => 'relationships:string',
            'zip' => 'relationships:string',
            'country' => 'commonTyp:Country',
            'addrText' => 'relationships:string',
            'override' => 'relationships:boolean',
            'internalId' => 'relationships:string',
            'state' => 'relationships:string',
        },
    
        VendorAddressbookList => {
            'addressbook' => 'relationships:VendorAddressbook',
        },
    
        VendorRoles => {
            'selectedRole' => 'core:RecordRef',
        },
    
        VendorRolesList => {
            'roles' => 'relationships:VendorRoles',
        },
    
        EntityGroup => {
            'groupName' => 'relationships:string',
            'groupType' => 'relationshipsTypes:EntityGroupType',
            'email' => 'relationships:string',
            'groupOwner' => 'core:RecordRef',
            'isSavedSearch' => 'relationships:boolean',
            'parentGroupType' => 'relationshipsTypes:EntityGroupType',
            'savedSearch' => 'core:RecordRef',
            'isSalesTeam' => 'relationships:boolean',
            'comments' => 'relationships:string',
            'isPrivate' => 'relationships:boolean',
            'restrictionGroup' => 'core:RecordRef',
            'isInactive' => 'relationships:boolean',
            'isSalesRep' => 'relationships:boolean',
            'isSupportRep' => 'relationships:boolean',
            'isProductTeam' => 'relationships:boolean',
            'isFunctionalTeam' => 'relationships:boolean',
            'issueRole' => 'core:RecordRef',
            'calendarName' => 'relationships:string',
            'calendarStartTime' => 'relationshipsTypes:EntityGroupDailyTime',
            'calendarEndTime' => 'relationshipsTypes:EntityGroupDailyTime',
            'calendarDefaultView' => 'relationshipsTypes:EntityGroupDefView',
            'calendarPeriod' => 'relationshipsTypes:EntityGroupPeriodSize',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        Job => {
            'customForm' => 'core:RecordRef',
            'entityId' => 'relationships:string',
            'companyName' => 'relationships:string',
            'phoneticName' => 'relationships:string',
            'entityStatus' => 'core:RecordRef',
            'defaultAddress' => 'relationships:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'relationships:boolean',
            'lastModifiedDate' => 'relationships:dateTime',
            'dateCreated' => 'relationships:dateTime',
            'category' => 'core:RecordRef',
            'language' => 'core:RecordRef',
            'comments' => 'relationships:string',
            'accountNumber' => 'relationships:string',
            'currency' => 'core:RecordRef',
            'startDate' => 'relationships:dateTime',
            'endDate' => 'relationships:dateTime',
            'phone' => 'relationships:string',
            'altPhone' => 'relationships:string',
            'projectedEndDate' => 'relationships:dateTime',
            'jobType' => 'core:RecordRef',
            'percentComplete' => 'relationships:double',
            'estimatedCost' => 'relationships:double',
            'estimatedRevenue' => 'relationships:double',
            'estimatedTime' => 'relationships:dateTime',
            'estimatedTimeOverride' => 'relationships:dateTime',
            'fax' => 'relationships:string',
            'email' => 'relationships:string',
            'emailPreference' => 'relationshipsTypes:EmailPreference',
            'percentTimeComplete' => 'relationships:double',
            'actualTime' => 'relationships:dateTime',
            'openingBalance' => 'relationships:double',
            'openingBalanceDate' => 'relationships:dateTime',
            'openingBalanceAccount' => 'core:RecordRef',
            'timeRemaining' => 'relationships:dateTime',
            'estimatedLaborCost' => 'relationships:double',
            'subsidiary' => 'core:RecordRef',
            'estimateRevRecTemplate' => 'core:RecordRef',
            'limitTimeToAssignees' => 'relationships:boolean',
            'allowTime' => 'relationships:boolean',
            'allowExpenses' => 'relationships:boolean',
            'jobResourcesList' => 'relationships:JobResourcesList',
            'addressbookList' => 'relationships:JobAddressbookList',
            'milestonesList' => 'relationships:JobMilestonesList',
            'creditCardsList' => 'relationships:JobCreditCardsList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        JobAddressbook => {
            'defaultShipping' => 'relationships:boolean',
            'defaultBilling' => 'relationships:boolean',
            'isResidential' => 'relationships:boolean',
            'label' => 'relationships:string',
            'attention' => 'relationships:string',
            'addressee' => 'relationships:string',
            'phone' => 'relationships:string',
            'addr1' => 'relationships:string',
            'addr2' => 'relationships:string',
            'city' => 'relationships:string',
            'zip' => 'relationships:string',
            'country' => 'commonTyp:Country',
            'addrText' => 'relationships:string',
            'override' => 'relationships:boolean',
            'internalId' => 'relationships:string',
            'state' => 'relationships:string',
        },
    
        JobAddressbookList => {
            'addressbook' => 'relationships:JobAddressbook',
        },
    
        JobResources => {
            'jobResource' => 'core:RecordRef',
            'email' => 'relationships:string',
            'role' => 'core:RecordRef',
        },
    
        JobResourcesList => {
            'jobResources' => 'relationships:JobResources',
        },
    
        JobMilestones => {
            'milestoneName' => 'relationships:string',
            'milestoneOrder' => 'relationships:string',
            'milestoneEstComplete' => 'relationships:dateTime',
            'milestoneCompleted' => 'relationships:boolean',
            'milestoneComments' => 'relationships:string',
        },
    
        JobMilestonesList => {
            'milestones' => 'relationships:JobMilestones',
        },
    
        JobCreditCards => {
            'internalId' => 'relationships:string',
            'ccNumber' => 'relationships:string',
            'ccExpireDate' => 'relationships:dateTime',
            'ccName' => 'relationships:string',
            'paymentMethod' => 'core:RecordRef',
            'ccDefault' => 'relationships:boolean',
        },
    
        JobCreditCardsList => {
            'creditCards' => 'relationships:JobCreditCards',
        },
    
        JobType => {
            'name' => 'relationships:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'relationships:boolean',
        },
    
        JobStatus => {
            'name' => 'relationships:string',
            'description' => 'relationships:string',
            'isInactive' => 'relationships:boolean',
        },
    
        SupportCase => {
            'escalationMessage' => 'support:string',
            'lastReopenedDate' => 'support:dateTime',
            'incomingMessage' => 'support:string',
            'messageNew' => 'support:boolean',
            'outgoingMessage' => 'support:string',
            'emailForm' => 'support:boolean',
            'internalOnly' => 'support:boolean',
            'customForm' => 'core:RecordRef',
            'title' => 'support:string',
            'caseNumber' => 'support:string',
            'startDate' => 'support:dateTime',
            'createdDate' => 'support:dateTime',
            'lastModifiedDate' => 'support:dateTime',
            'lastMessageDate' => 'support:dateTime',
            'company' => 'core:RecordRef',
            'contact' => 'core:RecordRef',
            'email' => 'support:string',
            'phone' => 'support:string',
            'product' => 'core:RecordRef',
            'module' => 'core:RecordRef',
            'item' => 'core:RecordRef',
            'serialNumber' => 'core:RecordRef',
            'inboundEmail' => 'support:string',
            'issue' => 'core:RecordRef',
            'status' => 'core:RecordRef',
            'isInactive' => 'support:boolean',
            'priority' => 'core:RecordRef',
            'origin' => 'core:RecordRef',
            'category' => 'core:RecordRef',
            'assigned' => 'core:RecordRef',
            'helpDesk' => 'support:boolean',
            'emailEmployeesList' => 'support:EmailEmployeesList',
            'escalateToList' => 'support:SupportCaseEscalateToList',
            'solutionsList' => 'support:SupportCaseSolutionsList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        EmailEmployeesList => {
            'emailEmployees' => 'core:RecordRef',
        },
    
        SupportCaseEscalateTo => {
            'escalatee' => 'core:RecordRef',
            'email' => 'support:string',
            'phone' => 'support:string',
        },
    
        SupportCaseEscalateToList => {
            'escalateTo' => 'support:SupportCaseEscalateTo',
        },
    
        SupportCaseSolutions => {
            'solution' => 'core:RecordRef',
            'message' => 'support:string',
        },
    
        SupportCaseSolutionsList => {
            'solutions' => 'support:SupportCaseSolutions',
        },
    
        SupportCaseStatus => {
            'name' => 'support:string',
            'insertBefore' => 'core:RecordRef',
            'stage' => 'supportTypes:SupportCaseStatusStage',
            'caseOnHold' => 'support:boolean',
            'autoCloseCase' => 'support:boolean',
            'description' => 'support:string',
            'isInactive' => 'support:boolean',
        },
    
        SupportCaseType => {
            'name' => 'support:string',
            'insertBefore' => 'core:RecordRef',
            'description' => 'support:string',
            'isInactive' => 'support:boolean',
        },
    
        SupportCaseOrigin => {
            'name' => 'support:string',
            'insertBefore' => 'core:RecordRef',
            'description' => 'support:string',
            'isInactive' => 'support:boolean',
        },
    
        SupportCaseIssue => {
            'name' => 'support:string',
            'insertBefore' => 'core:RecordRef',
            'description' => 'support:string',
            'isInactive' => 'support:boolean',
        },
    
        SupportCasePriority => {
            'name' => 'support:string',
            'insertBefore' => 'core:RecordRef',
            'description' => 'support:string',
            'isInactive' => 'support:boolean',
        },
    
        Solution => {
            'customForm' => 'core:RecordRef',
            'solutionCode' => 'support:string',
            'title' => 'support:string',
            'message' => 'support:string',
            'status' => 'supportTypes:SolutionStatus',
            'displayOnline' => 'support:boolean',
            'isInactive' => 'support:boolean',
            'longDescription' => 'support:string',
            'topicsList' => 'support:SolutionTopicsList',
            'solutionsList' => 'support:SolutionsList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        SolutionTopics => {
            'topic' => 'core:RecordRef',
        },
    
        SolutionTopicsList => {
            'topics' => 'support:SolutionTopics',
        },
    
        Solutions => {
            'solution' => 'core:RecordRef',
            'message' => 'support:string',
        },
    
        SolutionsList => {
            'solutions' => 'support:Solutions',
        },
    
        Topic => {
            'title' => 'support:string',
            'parentTopic' => 'core:RecordRef',
            'description' => 'support:string',
            'isInactive' => 'support:boolean',
            'longDescription' => 'support:string',
            'solutionList' => 'support:TopicSolutionList',
        },
    
        TopicSolution => {
            'solution' => 'core:RecordRef',
            'message' => 'support:string',
        },
    
        TopicSolutionList => {
            'solution' => 'support:TopicSolution',
        },
    
        Issue => {
            'customForm' => 'core:RecordRef',
            'issueNumber' => 'support:string',
            'createdDate' => 'support:dateTime',
            'issueType' => 'core:RecordRef',
            'product' => 'core:RecordRef',
            'module' => 'core:RecordRef',
            'item' => 'core:RecordRef',
            'productTeam' => 'core:RecordRef',
            'source' => 'core:RecordRef',
            'reportedBy' => 'core:RecordRef',
            'reproduce' => 'core:RecordRef',
            'duplicateOf' => 'core:RecordRef',
            'severity' => 'core:RecordRef',
            'priority' => 'core:RecordRef',
            'isShowStopper' => 'support:boolean',
            'assigned' => 'core:RecordRef',
            'reviewer' => 'core:RecordRef',
            'isReviewed' => 'support:boolean',
            'issueStatus' => 'core:RecordRef',
            'lastModifiedDate' => 'support:dateTime',
            'issueTagsList' => 'core:RecordRefList',
            'issueAbstract' => 'support:string',
            'newDetails' => 'support:string',
            'isOwner' => 'support:boolean',
            'trackCode' => 'supportTypes:IssueTrackCode',
            'emailAssignee' => 'support:boolean',
            'emailEmployeesList' => 'support:EmailEmployeesList',
            'emailCellsList' => 'core:RecordRefList',
            'externalAbstract' => 'support:string',
            'externalDetails' => 'support:string',
            'brokenInVersionList' => 'support:IssueVersionList',
            'targetVersionList' => 'support:IssueVersionList',
            'fixedInVersionList' => 'support:IssueVersionList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        IssueVersion => {
            'primary' => 'support:boolean',
            'version' => 'core:RecordRef',
            'build' => 'core:RecordRef',
        },
    
        IssueVersionList => {
            'issueVersion' => 'support:IssueVersion',
        },
    
        ContactCategory => {
            'name' => 'accounting:string',
            'private' => 'accounting:boolean',
            'sync' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
        },
    
        CustomerCategory => {
            'name' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
        },
    
        SalesRole => {
            'name' => 'accounting:string',
            'description' => 'accounting:string',
            'isSalesRep' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
        },
    
        PriceLevel => {
            'name' => 'accounting:string',
            'discountpct' => 'accounting:double',
            'updateExistingPrices' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
        },
    
        WinLossReason => {
            'name' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
        },
    
        Term => {
            'name' => 'accounting:string',
            'dateDriven' => 'accounting:boolean',
            'daysUntilNetDue' => 'accounting:long',
            'discountPercent' => 'accounting:double',
            'daysUntilExpiry' => 'accounting:long',
            'dayOfMonthNetDue' => 'accounting:long',
            'dueNextMonthIfWithinDays' => 'accounting:long',
            'discountPercentDateDriven' => 'accounting:double',
            'dayDiscountExpires' => 'accounting:long',
            'preferred' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
        },
    
        NoteType => {
            'name' => 'accounting:string',
            'description' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
        },
    
        PaymentMethod => {
            'name' => 'accounting:string',
            'creditCard' => 'accounting:boolean',
            'undepFunds' => 'accounting:boolean',
            'account' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'isOnline' => 'accounting:boolean',
            'isDebitCard' => 'accounting:boolean',
        },
    
        LeadSource => {
            'name' => 'accounting:string',
            'description' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
        },
    
        Price => {
            'value' => 'accounting:double',
            'quantity' => 'accounting:double',
        },
    
        PriceList => {
            'price' => 'accounting:Price',
        },
    
        Pricing => {
            'currency' => 'core:RecordRef',
            'priceLevel' => 'core:RecordRef',
            'discount' => 'accounting:double',
            'priceList' => 'accounting:PriceList',
        },
    
        PricingMatrix => {
            'pricing' => 'accounting:Pricing',
        },
    
        Rate => {
            'value' => 'accounting:double',
            'priceLevel' => 'core:RecordRef',
        },
    
        RateList => {
            'rate' => 'accounting:Rate',
        },
    
        BillingRates => {
            'currency' => 'core:RecordRef',
            'billingClass' => 'core:RecordRef',
            'rateList' => 'accounting:RateList',
        },
    
        BillingRatesMatrix => {
            'billingRates' => 'accounting:BillingRates',
        },
    
        Translation => {
            'language' => 'accounting:string',
            'displayName' => 'accounting:string',
            'salesDescription' => 'accounting:string',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'featuredDescription' => 'accounting:string',
            'specialsDescription' => 'accounting:string',
            'pageTitle' => 'accounting:string',
        },
    
        TranslationList => {
            'translation' => 'accounting:Translation',
        },
    
        ItemOptionsList => {
            'itemOptions' => 'core:RecordRef',
        },
    
        ItemVendor => {
            'vendor' => 'core:RecordRef',
            'vendorCode' => 'accounting:string',
            'vendorCurrencyName' => 'accounting:string',
            'purchasePrice' => 'accounting:double',
            'preferredVendor' => 'accounting:boolean',
            'schedule' => 'core:RecordRef',
            'subsidiary' => 'accounting:string',
        },
    
        ItemVendorList => {
            'itemVendor' => 'accounting:ItemVendor',
        },
    
        SiteCategory => {
            'website' => 'core:RecordRef',
            'category' => 'core:RecordRef',
            'categoryDescription' => 'accounting:string',
        },
    
        SiteCategoryList => {
            'siteCategory' => 'accounting:SiteCategory',
        },
    
        ProductFeedList => {
            'productFeed' => 'accountingTypes:ItemProductFeed',
        },
    
        InventoryItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'purchaseDescription' => 'accounting:string',
            'copyDescription' => 'accounting:boolean',
            'cogsAccount' => 'core:RecordRef',
            'salesDescription' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'incomeAccount' => 'core:RecordRef',
            'taxSchedule' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'assetAccount' => 'core:RecordRef',
            'shippingCost' => 'accounting:double',
            'shippingCostUnits' => 'accounting:string',
            'handlingCost' => 'accounting:double',
            'handlingCostUnits' => 'accounting:string',
            'weight' => 'accounting:double',
            'weightUnit' => 'accountingTypes:ItemWeightUnit',
            'weightUnits' => 'accounting:string',
            'costingMethodDisplay' => 'accounting:string',
            'unitsType' => 'core:RecordRef',
            'stockUnit' => 'core:RecordRef',
            'purchaseUnit' => 'core:RecordRef',
            'saleUnit' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'billingSchedule' => 'core:RecordRef',
            'trackLandedCost' => 'accounting:boolean',
            'isDropShipItem' => 'accounting:boolean',
            'isSpecialOrderItem' => 'accounting:boolean',
            'stockDescription' => 'accounting:string',
            'deferredRevenueAccount' => 'core:RecordRef',
            'producer' => 'accounting:boolean',
            'manufacturer' => 'accounting:string',
            'revRecSchedule' => 'core:RecordRef',
            'mpn' => 'accounting:string',
            'manufacturerAddr1' => 'accounting:string',
            'manufacturerCity' => 'accounting:string',
            'manufacturerState' => 'commonTypes:StateAbbreviation',
            'manufacturerZip' => 'accounting:string',
            'countryOfManufacture' => 'commonTypes:Country',
            'manufacturerTaxId' => 'accounting:string',
            'scheduleBNumber' => 'accounting:string',
            'scheduleBQuantity' => 'accounting:long',
            'scheduleBCode' => 'accountingTypes:ScheduleBCode',
            'manufacturerTariff' => 'accounting:string',
            'preferenceCriterion' => 'accountingTypes:ItemPreferenceCriterion',
            'minimumQuantity' => 'accounting:long',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'softDescriptor' => 'core:RecordRef',
            'shipPackage' => 'core:RecordRef',
            'shipIndividually' => 'accounting:boolean',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'pricingGroup' => 'core:RecordRef',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'preferredLocation' => 'core:RecordRef',
            'reorderMultiple' => 'accounting:long',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'totalValue' => 'accounting:double',
            'averageCost' => 'accounting:double',
            'useBins' => 'accounting:boolean',
            'quantityReorderUnits' => 'accounting:string',
            'leadTime' => 'accounting:long',
            'autoLeadTime' => 'accounting:boolean',
            'autoPreferredStockLevel' => 'accounting:boolean',
            'preferredStockLevelDays' => 'accounting:double',
            'safetyStockLevel' => 'accounting:double',
            'safetyStockLevelDays' => 'accounting:long',
            'seasonalDemand' => 'accounting:boolean',
            'demandModifier' => 'accounting:double',
            'autoReorderPoint' => 'accounting:boolean',
            'storeDisplayName' => 'accounting:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'storeDisplayImage' => 'core:RecordRef',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'storeItemTemplate' => 'core:RecordRef',
            'pageTitle' => 'accounting:string',
            'metaTagHtml' => 'accounting:string',
            'searchKeywords' => 'accounting:string',
            'isDonationItem' => 'accounting:boolean',
            'showDefaultDonationAmount' => 'accounting:boolean',
            'maxDonationAmount' => 'accounting:double',
            'dontShowPrice' => 'accounting:boolean',
            'noPriceMessage' => 'accounting:string',
            'onSpecial' => 'accounting:boolean',
            'relatedItemsDescription' => 'accounting:string',
            'specialsDescription' => 'accounting:string',
            'isFeatured' => 'accounting:boolean',
            'featuredDescription' => 'accounting:string',
            'shoppingDotComCategory' => 'accounting:string',
            'shopzillaCategoryId' => 'accounting:long',
            'nexTagCategory' => 'accounting:string',
            'productFeedList' => 'accounting:ProductFeedList',
            'urlComponent' => 'accounting:string',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'costingMethod' => 'accountingTypes:ItemCostingMethod',
            'currency' => 'accounting:string',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'preferredStockLevel' => 'accounting:double',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'purchaseTaxCode' => 'core:RecordRef',
            'quantityBackOrdered' => 'accounting:double',
            'quantityCommitted' => 'accounting:double',
            'quantityAvailable' => 'accounting:double',
            'quantityOnHand' => 'accounting:double',
            'onHandValueMli' => 'accounting:double',
            'quantityOnOrder' => 'accounting:double',
            'rate' => 'accounting:double',
            'reorderPoint' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'siteCategoryList' => 'accounting:SiteCategoryList',
            'vendor' => 'core:RecordRef',
            'translationList' => 'accounting:TranslationList',
            'binNumberList' => 'accounting:InventoryItemBinNumberList',
            'locationsList' => 'accounting:InventoryItemLocationsList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        InventoryItemBinNumber => {
            'binNumber' => 'core:RecordRef',
            'onHand' => 'accounting:string',
            'location' => 'accounting:string',
            'preferredBin' => 'accounting:boolean',
        },
    
        InventoryItemBinNumberList => {
            'binNumber' => 'accounting:InventoryItemBinNumber',
        },
    
        InventoryItemLocations => {
            'location' => 'accounting:string',
            'quantityOnHand' => 'accounting:double',
            'onHandValueMli' => 'accounting:double',
            'averageCostMli' => 'accounting:double',
            'reorderPoint' => 'accounting:double',
            'preferredStockLevel' => 'accounting:double',
            'quantityOnOrder' => 'accounting:double',
            'quantityCommitted' => 'accounting:double',
            'quantityAvailable' => 'accounting:double',
            'quantityBackOrdered' => 'accounting:double',
            'locationId' => 'core:RecordRef',
        },
    
        InventoryItemLocationsList => {
            'locations' => 'accounting:InventoryItemLocations',
        },
    
        DescriptionItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'description' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'issueProduct' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        DiscountItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'description' => 'accounting:string',
            'nonPosting' => 'accounting:boolean',
            'account' => 'core:RecordRef',
            'includeChildren' => 'accounting:boolean',
            'rate' => 'accounting:string',
            'isPreTax' => 'accounting:boolean',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'issueProduct' => 'core:RecordRef',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'taxSchedule' => 'core:RecordRef',
            'deferredRevenueAccount' => 'core:RecordRef',
            'expenseAccount' => 'core:RecordRef',
            'incomeAccount' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'salesTaxCode' => 'core:RecordRef',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        MarkupItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'description' => 'accounting:string',
            'nonPosting' => 'accounting:boolean',
            'account' => 'core:RecordRef',
            'includeChildren' => 'accounting:boolean',
            'rate' => 'accounting:string',
            'isPreTax' => 'accounting:boolean',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'issueProduct' => 'core:RecordRef',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'taxSchedule' => 'core:RecordRef',
            'deferredRevenueAccount' => 'core:RecordRef',
            'expenseAccount' => 'core:RecordRef',
            'incomeAccount' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'salesTaxCode' => 'core:RecordRef',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        PaymentItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'description' => 'accounting:string',
            'paymentMethod' => 'core:RecordRef',
            'undepFunds' => 'accounting:boolean',
            'includeChildren' => 'accounting:boolean',
            'issueProduct' => 'core:RecordRef',
            'account' => 'core:RecordRef',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'displayName' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        SubtotalItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'displayName' => 'accounting:string',
            'issueProduct' => 'core:RecordRef',
            'description' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        NonInventoryPurchaseItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'purchaseDescription' => 'accounting:string',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'expenseAccount' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'unitsType' => 'core:RecordRef',
            'purchaseUnit' => 'core:RecordRef',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'taxSchedule' => 'core:RecordRef',
            'deferralAccount' => 'core:RecordRef',
            'amortizationTemplate' => 'core:RecordRef',
            'residual' => 'accounting:string',
            'amortizationPeriod' => 'accounting:long',
            'isFulfillable' => 'accounting:boolean',
            'currency' => 'accounting:string',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'purchaseTaxCode' => 'core:RecordRef',
            'salesTaxCode' => 'core:RecordRef',
            'translationList' => 'accounting:TranslationList',
            'vendor' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        NonInventorySaleItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'salesDescription' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'incomeAccount' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'taxSchedule' => 'core:RecordRef',
            'shippingCost' => 'accounting:double',
            'shippingCostUnits' => 'accounting:string',
            'handlingCost' => 'accounting:double',
            'handlingCostUnits' => 'accounting:string',
            'weight' => 'accounting:double',
            'weightUnit' => 'accountingTypes:ItemWeightUnit',
            'weightUnits' => 'accounting:string',
            'unitsType' => 'core:RecordRef',
            'saleUnit' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'billingSchedule' => 'core:RecordRef',
            'deferredRevenueAccount' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'stockDescription' => 'accounting:string',
            'producer' => 'accounting:boolean',
            'manufacturer' => 'accounting:string',
            'mpn' => 'accounting:string',
            'manufacturerAddr1' => 'accounting:string',
            'manufacturerCity' => 'accounting:string',
            'manufacturerState' => 'commonTypes:StateAbbreviation',
            'manufacturerZip' => 'accounting:string',
            'countryOfManufacture' => 'commonTypes:Country',
            'manufacturerTaxId' => 'accounting:string',
            'scheduleBNumber' => 'accounting:string',
            'scheduleBQuantity' => 'accounting:long',
            'scheduleBCode' => 'accountingTypes:ScheduleBCode',
            'manufacturerTariff' => 'accounting:string',
            'preferenceCriterion' => 'accountingTypes:ItemPreferenceCriterion',
            'minimumQuantity' => 'accounting:long',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'softDescriptor' => 'accounting:string',
            'shipPackage' => 'core:RecordRef',
            'shipIndividually' => 'accounting:boolean',
            'isFulfillable' => 'accounting:boolean',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'pricingGroup' => 'core:RecordRef',
            'minimumQuantityUnits' => 'accounting:string',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'storeDisplayName' => 'accounting:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'storeDisplayImage' => 'core:RecordRef',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'storeItemTemplate' => 'core:RecordRef',
            'pageTitle' => 'accounting:string',
            'metaTagHtml' => 'accounting:string',
            'searchKeywords' => 'accounting:string',
            'isDonationItem' => 'accounting:boolean',
            'showDefaultDonationAmount' => 'accounting:boolean',
            'maxDonationAmount' => 'accounting:double',
            'dontShowPrice' => 'accounting:boolean',
            'noPriceMessage' => 'accounting:string',
            'onSpecial' => 'accounting:boolean',
            'relatedItemsDescription' => 'accounting:string',
            'specialsDescription' => 'accounting:string',
            'isFeatured' => 'accounting:boolean',
            'featuredDescription' => 'accounting:string',
            'shoppingDotComCategory' => 'accounting:string',
            'shopzillaCategoryId' => 'accounting:long',
            'nexTagCategory' => 'accounting:string',
            'productFeedList' => 'accounting:ProductFeedList',
            'urlComponent' => 'accounting:string',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'purchaseTaxCode' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'siteCategoryList' => 'accounting:SiteCategoryList',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        NonInventoryResaleItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'purchaseDescription' => 'accounting:string',
            'copyDescription' => 'accounting:boolean',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'expenseAccount' => 'core:RecordRef',
            'salesDescription' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'incomeAccount' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'taxSchedule' => 'core:RecordRef',
            'isDropShipItem' => 'accounting:boolean',
            'isSpecialOrderItem' => 'accounting:boolean',
            'shippingCost' => 'accounting:double',
            'shippingCostUnits' => 'accounting:string',
            'handlingCost' => 'accounting:double',
            'handlingCostUnits' => 'accounting:string',
            'weight' => 'accounting:double',
            'weightUnit' => 'accountingTypes:ItemWeightUnit',
            'weightUnits' => 'accounting:string',
            'unitsType' => 'core:RecordRef',
            'purchaseUnit' => 'core:RecordRef',
            'saleUnit' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'billingSchedule' => 'core:RecordRef',
            'deferredRevenueAccount' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'deferralAccount' => 'core:RecordRef',
            'amortizationTemplate' => 'core:RecordRef',
            'residual' => 'accounting:string',
            'amortizationPeriod' => 'accounting:long',
            'stockDescription' => 'accounting:string',
            'producer' => 'accounting:boolean',
            'manufacturer' => 'accounting:string',
            'mpn' => 'accounting:string',
            'countryOfManufacture' => 'commonTypes:Country',
            'manufacturerTaxId' => 'accounting:string',
            'scheduleBNumber' => 'accounting:string',
            'scheduleBQuantity' => 'accounting:long',
            'scheduleBCode' => 'accountingTypes:ScheduleBCode',
            'manufacturerTariff' => 'accounting:string',
            'preferenceCriterion' => 'accountingTypes:ItemPreferenceCriterion',
            'minimumQuantity' => 'accounting:long',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'softDescriptor' => 'accounting:string',
            'shipPackage' => 'core:RecordRef',
            'shipIndividually' => 'accounting:boolean',
            'isFulfillable' => 'accounting:boolean',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'pricingGroup' => 'core:RecordRef',
            'minimumQuantityUnits' => 'accounting:string',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'storeDisplayName' => 'accounting:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'storeDisplayImage' => 'core:RecordRef',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'storeItemTemplate' => 'core:RecordRef',
            'pageTitle' => 'accounting:string',
            'metaTagHtml' => 'accounting:string',
            'searchKeywords' => 'accounting:string',
            'isDonationItem' => 'accounting:boolean',
            'showDefaultDonationAmount' => 'accounting:boolean',
            'maxDonationAmount' => 'accounting:double',
            'dontShowPrice' => 'accounting:boolean',
            'noPriceMessage' => 'accounting:string',
            'onSpecial' => 'accounting:boolean',
            'relatedItemsDescription' => 'accounting:string',
            'specialsDescription' => 'accounting:string',
            'isFeatured' => 'accounting:boolean',
            'featuredDescription' => 'accounting:string',
            'shoppingDotComCategory' => 'accounting:string',
            'shopzillaCategoryId' => 'accounting:long',
            'nexTagCategory' => 'accounting:string',
            'productFeedList' => 'accounting:ProductFeedList',
            'urlComponent' => 'accounting:string',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'currency' => 'accounting:string',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'purchaseTaxCode' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'siteCategoryList' => 'accounting:SiteCategoryList',
            'translationList' => 'accounting:TranslationList',
            'vendor' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        OtherChargeResaleItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'purchaseDescription' => 'accounting:string',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'expenseAccount' => 'core:RecordRef',
            'salesDescription' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'incomeAccount' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'taxSchedule' => 'core:RecordRef',
            'unitsType' => 'core:RecordRef',
            'purchaseUnit' => 'core:RecordRef',
            'saleUnit' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'billingSchedule' => 'core:RecordRef',
            'deferredRevenueAccount' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'deferralAccount' => 'core:RecordRef',
            'amortizationTemplate' => 'core:RecordRef',
            'residual' => 'accounting:string',
            'amortizationPeriod' => 'accounting:long',
            'minimumQuantity' => 'accounting:long',
            'minimumQuantityUnits' => 'accounting:string',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'softDescriptor' => 'accounting:string',
            'isFulfillable' => 'accounting:boolean',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'pricingGroup' => 'core:RecordRef',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'currency' => 'accounting:string',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'purchaseTaxCode' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'translationList' => 'accounting:TranslationList',
            'vendor' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        OtherChargePurchaseItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'purchaseDescription' => 'accounting:string',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'expenseAccount' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'unitsType' => 'core:RecordRef',
            'purchaseUnit' => 'core:RecordRef',
            'includeChildren' => 'accounting:boolean',
            'issueProduct' => 'core:RecordRef',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'location' => 'core:RecordRef',
            'taxSchedule' => 'core:RecordRef',
            'deferralAccount' => 'core:RecordRef',
            'amortizationTemplate' => 'core:RecordRef',
            'residual' => 'accounting:string',
            'amortizationPeriod' => 'accounting:long',
            'isFulfillable' => 'accounting:boolean',
            'currency' => 'accounting:string',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'purchaseTaxCode' => 'core:RecordRef',
            'salesTaxCode' => 'core:RecordRef',
            'translationList' => 'accounting:TranslationList',
            'vendor' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ServiceResaleItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'purchaseDescription' => 'accounting:string',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'expenseAccount' => 'core:RecordRef',
            'salesDescription' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'incomeAccount' => 'core:RecordRef',
            'taxSchedule' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'unitsType' => 'core:RecordRef',
            'purchaseUnit' => 'core:RecordRef',
            'saleUnit' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'billingSchedule' => 'core:RecordRef',
            'deferredRevenueAccount' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'deferralAccount' => 'core:RecordRef',
            'amortizationTemplate' => 'core:RecordRef',
            'residual' => 'accounting:string',
            'amortizationPeriod' => 'accounting:long',
            'minimumQuantity' => 'accounting:long',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'softDescriptor' => 'accounting:string',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'isFulfillable' => 'accounting:boolean',
            'pricingGroup' => 'core:RecordRef',
            'minimumQuantityUnits' => 'accounting:string',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'createjob' => 'accounting:boolean',
            'storeDisplayName' => 'accounting:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'storeDisplayImage' => 'core:RecordRef',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'storeItemTemplate' => 'core:RecordRef',
            'pageTitle' => 'accounting:string',
            'metaTagHtml' => 'accounting:string',
            'searchKeywords' => 'accounting:string',
            'isDonationItem' => 'accounting:boolean',
            'showDefaultDonationAmount' => 'accounting:boolean',
            'maxDonationAmount' => 'accounting:double',
            'dontShowPrice' => 'accounting:boolean',
            'noPriceMessage' => 'accounting:string',
            'onSpecial' => 'accounting:boolean',
            'relatedItemsDescription' => 'accounting:string',
            'specialsDescription' => 'accounting:string',
            'isFeatured' => 'accounting:boolean',
            'featuredDescription' => 'accounting:string',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'currency' => 'accounting:string',
            'billingRatesMatrix' => 'accounting:BillingRatesMatrix',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'purchaseTaxCode' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'siteCategoryList' => 'accounting:SiteCategoryList',
            'translationList' => 'accounting:TranslationList',
            'vendor' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ServicePurchaseItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'purchaseDescription' => 'accounting:string',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'issueProduct' => 'core:RecordRef',
            'includeChildren' => 'accounting:boolean',
            'expenseAccount' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'unitsType' => 'core:RecordRef',
            'purchaseUnit' => 'core:RecordRef',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'taxSchedule' => 'core:RecordRef',
            'deferralAccount' => 'core:RecordRef',
            'amortizationTemplate' => 'core:RecordRef',
            'residual' => 'accounting:string',
            'amortizationPeriod' => 'accounting:long',
            'isFulfillable' => 'accounting:boolean',
            'currency' => 'accounting:string',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'purchaseTaxCode' => 'core:RecordRef',
            'salesTaxCode' => 'core:RecordRef',
            'translationList' => 'accounting:TranslationList',
            'vendor' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ServiceSaleItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'salesDescription' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'incomeAccount' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'taxSchedule' => 'core:RecordRef',
            'unitsType' => 'core:RecordRef',
            'saleUnit' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'billingSchedule' => 'core:RecordRef',
            'deferredRevenueAccount' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'minimumQuantity' => 'accounting:long',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'softDescriptor' => 'accounting:string',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'isFulfillable' => 'accounting:boolean',
            'pricingGroup' => 'core:RecordRef',
            'minimumQuantityUnits' => 'accounting:string',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'createjob' => 'accounting:boolean',
            'storeDisplayName' => 'accounting:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'storeDisplayImage' => 'core:RecordRef',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'storeItemTemplate' => 'core:RecordRef',
            'pageTitle' => 'accounting:string',
            'metaTagHtml' => 'accounting:string',
            'searchKeywords' => 'accounting:string',
            'isDonationItem' => 'accounting:boolean',
            'showDefaultDonationAmount' => 'accounting:boolean',
            'maxDonationAmount' => 'accounting:double',
            'dontShowPrice' => 'accounting:boolean',
            'noPriceMessage' => 'accounting:string',
            'onSpecial' => 'accounting:boolean',
            'relatedItemsDescription' => 'accounting:string',
            'specialsDescription' => 'accounting:string',
            'isFeatured' => 'accounting:boolean',
            'featuredDescription' => 'accounting:string',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'billingRatesMatrix' => 'accounting:BillingRatesMatrix',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'purchaseTaxCode' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'siteCategoryList' => 'accounting:SiteCategoryList',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        OtherChargeSaleItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'salesDescription' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'incomeAccount' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'taxSchedule' => 'core:RecordRef',
            'unitsType' => 'core:RecordRef',
            'saleUnit' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'billingSchedule' => 'core:RecordRef',
            'deferredRevenueAccount' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'minimumQuantity' => 'accounting:long',
            'minimumQuantityUnits' => 'accounting:string',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'softDescriptor' => 'accounting:string',
            'isFulfillable' => 'accounting:boolean',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'pricingGroup' => 'core:RecordRef',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'subsidiaryList' => 'common:SubsidiaryList',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'purchaseTaxCode' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        Currency => {
            'name' => 'accounting:string',
            'symbol' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
            'isBaseCurrency' => 'accounting:boolean',
            'locale' => 'accountingTypes:CurrencyLocale',
            'formatSample' => 'accounting:string',
            'exchangeRate' => 'accounting:double',
            'currencyPrecision' => 'accountingTypes:CurrencyCurrencyPrecision',
        },
    
        ExpenseCategory => {
            'name' => 'accounting:string',
            'description' => 'accounting:string',
            'expenseAcct' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
        },
    
        Account => {
            'acctType' => 'accountingTypes:AccountType',
            'acctNumber' => 'accounting:string',
            'acctName' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'currency' => 'core:RecordRef',
            'exchangeRate' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'billableExpensesAcct' => 'core:RecordRef',
            'deferralAcct' => 'core:RecordRef',
            'description' => 'accounting:string',
            'curDocNum' => 'accounting:long',
            'isInactive' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'inventory' => 'accounting:boolean',
            'subsidiaryList' => 'common:SubsidiaryList',
            'category1099misc' => 'core:RecordRef',
            'incomeStatement' => 'core:RecordRef',
            'balanceSheet' => 'core:RecordRef',
            'cashFlow' => 'core:RecordRef',
            'openingBalance' => 'accounting:double',
            'tranDate' => 'accounting:dateTime',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        Department => {
            'name' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'subsidiaryList' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        Classification => {
            'name' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'subsidiaryList' => 'common:SubsidiaryList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        Location => {
            'name' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'includeChildren' => 'accounting:boolean',
            'subsidiaryList' => 'common:SubsidiaryList',
            'isInactive' => 'accounting:boolean',
            'tranPrefix' => 'accounting:string',
            'attention' => 'accounting:string',
            'addressee' => 'accounting:string',
            'addrPhone' => 'accounting:string',
            'addr1' => 'accounting:string',
            'addr2' => 'accounting:string',
            'city' => 'accounting:string',
            'state' => 'accounting:string',
            'zip' => 'accounting:string',
            'country' => 'commonTypes:Country',
            'addrText' => 'accounting:string',
            'override' => 'accounting:boolean',
            'logo' => 'core:RecordRef',
            'makeInventoryAvailable' => 'accounting:boolean',
            'makeInventoryAvailableStore' => 'accounting:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        UnitsType => {
            'name' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
            'uomList' => 'accounting:UnitsTypeUomList',
        },
    
        UnitsTypeUom => {
            'name' => 'accounting:string',
            'pluralName' => 'accounting:string',
            'abbreviation' => 'accounting:string',
            'pluralAbbreviation' => 'accounting:string',
            'conversionRate' => 'accounting:double',
            'baseUnit' => 'accounting:boolean',
        },
    
        UnitsTypeUomList => {
            'uom' => 'accounting:UnitsTypeUom',
        },
    
        ContactRole => {
            'name' => 'accounting:string',
            'description' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
        },
    
        Bin => {
            'binNumber' => 'accounting:string',
            'location' => 'core:RecordRef',
            'memo' => 'accounting:string',
            'isInactive' => 'accounting:boolean',
        },
    
        SalesTaxItem => {
            'itemId' => 'accounting:string',
            'displayName' => 'accounting:string',
            'description' => 'accounting:string',
            'rate' => 'accounting:string',
            'taxType' => 'core:RecordRef',
            'taxAgency' => 'core:RecordRef',
            'purchaseAccount' => 'core:RecordRef',
            'saleAccount' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'effectiveFrom' => 'accounting:dateTime',
            'validUntil' => 'accounting:dateTime',
            'eccode' => 'accounting:boolean',
            'parent' => 'core:RecordRef',
            'isDefault' => 'accounting:boolean',
            'excludeFromTaxReports' => 'accounting:boolean',
            'available' => 'accountingTypes:SalesTaxItemAvailable',
            'export' => 'accounting:boolean',
            'taxAccount' => 'core:RecordRef',
            'county' => 'accounting:string',
            'city' => 'accounting:string',
            'state' => 'commonTypes:StateAbbreviation',
            'zip' => 'accounting:string',
        },
    
        TaxGroup => {
            'itemId' => 'accounting:string',
            'description' => 'accounting:string',
            'state' => 'commonTypes:StateAbbreviation',
            'taxitem1' => 'core:RecordRef',
            'unitprice1' => 'accounting:string',
            'taxitem2' => 'core:RecordRef',
            'unitprice2' => 'accounting:string',
            'piggyback' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'rate' => 'accounting:double',
            'taxType' => 'core:RecordRef',
            'county' => 'accounting:string',
            'city' => 'accounting:string',
            'zip' => 'accounting:string',
            'isDefault' => 'accounting:boolean',
            'taxItemList' => 'accounting:TaxGroupTaxItemList',
        },
    
        TaxGroupTaxItem => {
            'taxName' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'basis' => 'accounting:double',
            'taxType' => 'accounting:string',
        },
    
        TaxGroupTaxItemList => {
            'taxItem' => 'accounting:TaxGroupTaxItem',
        },
    
        TaxType => {
            'name' => 'accounting:string',
            'description' => 'accounting:string',
            'nexusesTaxList' => 'accounting:TaxTypeNexusesTaxList',
        },
    
        TaxTypeNexusesTax => {
            'nexus' => 'core:RecordRef',
            'description' => 'accounting:string',
            'saleTaxAcct' => 'core:RecordRef',
            'purchTaxAcct' => 'core:RecordRef',
        },
    
        TaxTypeNexusesTaxList => {
            'nexusesTax' => 'accounting:TaxTypeNexusesTax',
        },
    
        SerializedInventoryItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'purchaseDescription' => 'accounting:string',
            'copyDescription' => 'accounting:boolean',
            'issueProduct' => 'core:RecordRef',
            'currency' => 'accounting:string',
            'cogsAccount' => 'core:RecordRef',
            'vendor' => 'core:RecordRef',
            'salesDescription' => 'accounting:string',
            'incomeAccount' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'taxSchedule' => 'core:RecordRef',
            'assetAccount' => 'core:RecordRef',
            'shippingCost' => 'accounting:double',
            'handlingCost' => 'accounting:double',
            'weight' => 'accounting:double',
            'costingMethodDisplay' => 'accounting:string',
            'billingSchedule' => 'core:RecordRef',
            'trackLandedCost' => 'accounting:boolean',
            'isDropShipItem' => 'accounting:boolean',
            'isSpecialOrderItem' => 'accounting:boolean',
            'stockDescription' => 'accounting:string',
            'deferredRevenueAccount' => 'core:RecordRef',
            'producer' => 'accounting:boolean',
            'manufacturer' => 'accounting:string',
            'revRecSchedule' => 'core:RecordRef',
            'mpn' => 'accounting:string',
            'manufacturerAddr1' => 'accounting:string',
            'manufacturerCity' => 'accounting:string',
            'manufacturerState' => 'commonTypes:StateAbbreviation',
            'manufacturerZip' => 'accounting:string',
            'countryOfManufacture' => 'commonTypes:Country',
            'manufacturerTaxId' => 'accounting:string',
            'scheduleBNumber' => 'accounting:string',
            'scheduleBQuantity' => 'accounting:long',
            'scheduleBCode' => 'accountingTypes:ScheduleBCode',
            'manufacturerTariff' => 'accounting:string',
            'preferenceCriterion' => 'accountingTypes:ItemPreferenceCriterion',
            'minimumQuantity' => 'accounting:long',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'shipPackage' => 'core:RecordRef',
            'shipIndividually' => 'accounting:boolean',
            'softDescriptor' => 'core:RecordRef',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'pricingGroup' => 'core:RecordRef',
            'preferredLocation' => 'core:RecordRef',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'quantityReorderUnits' => 'accounting:string',
            'reorderMultiple' => 'accounting:long',
            'totalValue' => 'accounting:double',
            'useBins' => 'accounting:boolean',
            'leadTime' => 'accounting:long',
            'autoLeadTime' => 'accounting:boolean',
            'autoReorderPoint' => 'accounting:boolean',
            'autoPreferredStockLevel' => 'accounting:boolean',
            'preferredStockLevelDays' => 'accounting:double',
            'averageCost' => 'accounting:double',
            'safetyStockLevel' => 'accounting:double',
            'safetyStockLevelDays' => 'accounting:long',
            'seasonalDemand' => 'accounting:boolean',
            'demandModifier' => 'accounting:double',
            'storeDisplayName' => 'accounting:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'weightUnit' => 'accountingTypes:ItemWeightUnit',
            'weightUnits' => 'accounting:string',
            'storeDisplayImage' => 'core:RecordRef',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'storeItemTemplate' => 'core:RecordRef',
            'pageTitle' => 'accounting:string',
            'metaTagHtml' => 'accounting:string',
            'searchKeywords' => 'accounting:string',
            'isDonationItem' => 'accounting:boolean',
            'showDefaultDonationAmount' => 'accounting:boolean',
            'maxDonationAmount' => 'accounting:double',
            'shoppingDotComCategory' => 'accounting:string',
            'shopzillaCategoryId' => 'accounting:long',
            'nexTagCategory' => 'accounting:string',
            'quantityOnHand' => 'accounting:double',
            'onHandValueMli' => 'accounting:double',
            'serialNumbers' => 'accounting:string',
            'reorderPoint' => 'accounting:double',
            'preferredStockLevel' => 'accounting:double',
            'quantityOnOrder' => 'accounting:double',
            'quantityCommitted' => 'accounting:double',
            'quantityAvailable' => 'accounting:double',
            'quantityBackOrdered' => 'accounting:double',
            'purchaseTaxCode' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'onSpecial' => 'accounting:boolean',
            'dontShowPrice' => 'accounting:boolean',
            'noPriceMessage' => 'accounting:string',
            'specialsDescription' => 'accounting:string',
            'isFeatured' => 'accounting:boolean',
            'relatedItemsDescription' => 'accounting:string',
            'featuredDescription' => 'accounting:string',
            'productFeedList' => 'accounting:ProductFeedList',
            'urlComponent' => 'accounting:string',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'numbersList' => 'accounting:SerializedInventoryItemNumbersList',
            'binNumberList' => 'accounting:InventoryItemBinNumberList',
            'siteCategoryList' => 'accounting:SiteCategoryList',
            'locationsList' => 'accounting:SerializedInventoryItemLocationsList',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        SerializedInventoryItemLocations => {
            'location' => 'accounting:string',
            'quantityOnHand' => 'accounting:double',
            'onHandValueMli' => 'accounting:double',
            'serialNumbers' => 'accounting:string',
            'averageCostMli' => 'accounting:double',
            'reorderPoint' => 'accounting:double',
            'preferredStockLevel' => 'accounting:double',
            'quantityOnOrder' => 'accounting:double',
            'quantityCommitted' => 'accounting:double',
            'quantityAvailable' => 'accounting:double',
            'quantityBackOrdered' => 'accounting:double',
            'locationId' => 'core:RecordRef',
        },
    
        SerializedInventoryItemLocationsList => {
            'locations' => 'accounting:SerializedInventoryItemLocations',
        },
    
        SerializedInventoryItemNumbers => {
            'serialNumber' => 'core:RecordRef',
        },
    
        SerializedInventoryItemNumbersList => {
            'numbers' => 'accounting:SerializedInventoryItemNumbers',
        },
    
        LotNumberedInventoryItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'vendorName' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'purchaseDescription' => 'accounting:string',
            'copyDescription' => 'accounting:boolean',
            'currency' => 'accounting:string',
            'cogsAccount' => 'core:RecordRef',
            'vendor' => 'core:RecordRef',
            'salesDescription' => 'accounting:string',
            'incomeAccount' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'taxSchedule' => 'core:RecordRef',
            'isTaxable' => 'accounting:boolean',
            'assetAccount' => 'core:RecordRef',
            'shippingCost' => 'accounting:double',
            'handlingCost' => 'accounting:double',
            'weight' => 'accounting:double',
            'costingMethodDisplay' => 'accounting:string',
            'billingSchedule' => 'core:RecordRef',
            'trackLandedCost' => 'accounting:boolean',
            'isDropShipItem' => 'accounting:boolean',
            'isSpecialOrderItem' => 'accounting:boolean',
            'stockDescription' => 'accounting:string',
            'deferredRevenueAccount' => 'core:RecordRef',
            'producer' => 'accounting:boolean',
            'manufacturer' => 'accounting:string',
            'revRecSchedule' => 'core:RecordRef',
            'mpn' => 'accounting:string',
            'manufacturerAddr1' => 'accounting:string',
            'manufacturerCity' => 'accounting:string',
            'manufacturerState' => 'commonTypes:StateAbbreviation',
            'manufacturerZip' => 'accounting:string',
            'countryOfManufacture' => 'commonTypes:Country',
            'manufacturerTaxId' => 'accounting:string',
            'scheduleBNumber' => 'accounting:string',
            'scheduleBQuantity' => 'accounting:long',
            'scheduleBCode' => 'accountingTypes:ScheduleBCode',
            'manufacturerTariff' => 'accounting:string',
            'preferenceCriterion' => 'accountingTypes:ItemPreferenceCriterion',
            'minimumQuantity' => 'accounting:long',
            'enforceMinQtyInternally' => 'accounting:boolean',
            'shipPackage' => 'core:RecordRef',
            'shipIndividually' => 'accounting:boolean',
            'softDescriptor' => 'core:RecordRef',
            'quantityPricingSchedule' => 'core:RecordRef',
            'useMarginalRates' => 'accounting:boolean',
            'overallQuantityPricingType' => 'accountingTypes:ItemOverallQuantityPricingType',
            'pricingGroup' => 'core:RecordRef',
            'preferredLocation' => 'core:RecordRef',
            'vsoePrice' => 'accounting:double',
            'vsoeDeferral' => 'commonTypes:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTypes:VsoePermitDiscount',
            'vsoeDelivered' => 'accounting:boolean',
            'cost' => 'accounting:double',
            'costUnits' => 'accounting:string',
            'reorderMultiple' => 'accounting:long',
            'quantityReorderUnits' => 'accounting:string',
            'totalValue' => 'accounting:double',
            'useBins' => 'accounting:boolean',
            'averageCost' => 'accounting:double',
            'leadTime' => 'accounting:long',
            'autoLeadTime' => 'accounting:boolean',
            'autoReorderPoint' => 'accounting:boolean',
            'autoPreferredStockLevel' => 'accounting:boolean',
            'preferredStockLevelDays' => 'accounting:double',
            'safetyStockLevel' => 'accounting:double',
            'safetyStockLevelDays' => 'accounting:long',
            'seasonalDemand' => 'accounting:boolean',
            'demandModifier' => 'accounting:double',
            'storeDisplayName' => 'accounting:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'weightUnit' => 'accountingTypes:ItemWeightUnit',
            'weightUnits' => 'accounting:string',
            'storeDisplayImage' => 'core:RecordRef',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'storeItemTemplate' => 'core:RecordRef',
            'pageTitle' => 'accounting:string',
            'metaTagHtml' => 'accounting:string',
            'searchKeywords' => 'accounting:string',
            'isDonationItem' => 'accounting:boolean',
            'showDefaultDonationAmount' => 'accounting:boolean',
            'maxDonationAmount' => 'accounting:double',
            'shoppingDotComCategory' => 'accounting:string',
            'shopzillaCategoryId' => 'accounting:long',
            'nexTagCategory' => 'accounting:string',
            'quantityOnHand' => 'accounting:double',
            'expirationDate' => 'accounting:dateTime',
            'onHandValueMli' => 'accounting:double',
            'serialNumbers' => 'accounting:string',
            'reorderPoint' => 'accounting:double',
            'preferredStockLevel' => 'accounting:double',
            'quantityOnOrder' => 'accounting:double',
            'quantityCommitted' => 'accounting:double',
            'quantityAvailable' => 'accounting:double',
            'quantityBackOrdered' => 'accounting:double',
            'purchaseTaxCode' => 'core:RecordRef',
            'rate' => 'accounting:double',
            'salesTaxCode' => 'core:RecordRef',
            'dontShowPrice' => 'accounting:boolean',
            'noPriceMessage' => 'accounting:string',
            'onSpecial' => 'accounting:boolean',
            'specialsDescription' => 'accounting:string',
            'isFeatured' => 'accounting:boolean',
            'relatedItemsDescription' => 'accounting:string',
            'featuredDescription' => 'accounting:string',
            'productFeedList' => 'accounting:ProductFeedList',
            'urlComponent' => 'accounting:string',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'itemVendorList' => 'accounting:ItemVendorList',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'numbersList' => 'accounting:LotNumberedInventoryItemNumbersList',
            'binNumberList' => 'accounting:InventoryItemBinNumberList',
            'siteCategoryList' => 'accounting:SiteCategoryList',
            'locationsList' => 'accounting:LotNumberedInventoryItemLocationsList',
            'translationList' => 'accounting:TranslationList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        LotNumberedInventoryItemLocations => {
            'location' => 'accounting:string',
            'quantityOnHand' => 'accounting:double',
            'onHandValueMli' => 'accounting:double',
            'serialNumbers' => 'accounting:string',
            'expirationDate' => 'accounting:dateTime',
            'averageCostMli' => 'accounting:double',
            'reorderPoint' => 'accounting:double',
            'preferredStockLevel' => 'accounting:double',
            'quantityOnOrder' => 'accounting:double',
            'quantityCommitted' => 'accounting:double',
            'quantityAvailable' => 'accounting:double',
            'quantityBackOrdered' => 'accounting:double',
            'locationId' => 'core:RecordRef',
        },
    
        LotNumberedInventoryItemLocationsList => {
            'locations' => 'accounting:LotNumberedInventoryItemLocations',
        },
    
        LotNumberedInventoryItemNumbers => {
            'serialNumber' => 'core:RecordRef',
            'quantityOnHand' => 'accounting:double',
            'expirationDate' => 'accounting:dateTime',
        },
    
        LotNumberedInventoryItemNumbersList => {
            'numbers' => 'accounting:LotNumberedInventoryItemNumbers',
        },
    
        GiftCertificateItem => {
            'createdDate' => 'accounting:dateTime',
            'lastModifiedDate' => 'accounting:dateTime',
            'customForm' => 'core:RecordRef',
            'itemId' => 'accounting:string',
            'upcCode' => 'accounting:string',
            'displayName' => 'accounting:string',
            'includeChildren' => 'accounting:boolean',
            'parent' => 'core:RecordRef',
            'isOnline' => 'accounting:boolean',
            'offerSupport' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
            'availableToPartners' => 'accounting:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiaryList' => 'common:SubsidiaryList',
            'salesDescription' => 'accounting:string',
            'incomeAccount' => 'core:RecordRef',
            'liabilityAccount' => 'core:RecordRef',
            'daysBeforeExpiration' => 'accounting:long',
            'isTaxable' => 'accounting:boolean',
            'rate' => 'accounting:double',
            'urlComponent' => 'accounting:string',
            'salesTaxCode' => 'core:RecordRef',
            'taxSchedule' => 'core:RecordRef',
            'billingSchedule' => 'core:RecordRef',
            'issueProduct' => 'core:RecordRef',
            'isFulfillable' => 'accounting:boolean',
            'storeDisplayName' => 'accounting:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'storeDisplayImage' => 'core:RecordRef',
            'storeDescription' => 'accounting:string',
            'storeDetailedDescription' => 'accounting:string',
            'storeItemTemplate' => 'core:RecordRef',
            'pageTitle' => 'accounting:string',
            'metaTagHtml' => 'accounting:string',
            'searchKeywords' => 'accounting:string',
            'isDonationItem' => 'accounting:boolean',
            'showDefaultDonationAmount' => 'accounting:boolean',
            'maxDonationAmount' => 'accounting:double',
            'dontShowPrice' => 'accounting:boolean',
            'noPriceMessage' => 'accounting:string',
            'onSpecial' => 'accounting:boolean',
            'specialsDescription' => 'accounting:string',
            'isFeatured' => 'accounting:boolean',
            'featuredDescription' => 'accounting:string',
            'relatedItemsDescription' => 'accounting:string',
            'pricingMatrix' => 'accounting:PricingMatrix',
            'authCodesList' => 'accounting:GiftCertificateItemAuthCodesList',
            'siteCategoryList' => 'accounting:SiteCategoryList',
            'translationList' => 'accounting:TranslationList',
            'itemOptionsList' => 'accounting:ItemOptionsList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        GiftCertificateItemAuthCodes => {
            'authCode' => 'accounting:string',
        },
    
        GiftCertificateItemAuthCodesList => {
            'authCodes' => 'accounting:GiftCertificateItemAuthCodes',
        },
    
        Subsidiary => {
            'name' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
            'url' => 'accounting:string',
            'logo' => 'core:RecordRef',
            'attention' => 'accounting:string',
            'addressee' => 'accounting:string',
            'addrPhone' => 'accounting:string',
            'addr1' => 'accounting:string',
            'addr2' => 'accounting:string',
            'city' => 'accounting:string',
            'state' => 'accounting:string',
            'zip' => 'accounting:string',
            'country' => 'commonTypes:Country',
            'addrText' => 'accounting:string',
            'override' => 'accounting:boolean',
            'shipAddr' => 'accounting:string',
            'returnAddr' => 'accounting:string',
            'legalName' => 'accounting:string',
            'isElimination' => 'accounting:boolean',
            'allowPayroll' => 'accounting:boolean',
            'currency' => 'core:RecordRef',
            'edition' => 'accounting:string',
            'federalIdNumber' => 'accounting:string',
            'ssnOrTin' => 'accounting:string',
            'state1TaxNumber' => 'accounting:string',
            'incomeStatement' => 'core:RecordRef',
            'balanceSheet' => 'core:RecordRef',
            'cashFlow' => 'core:RecordRef',
            'consolidatedIncomeStatement' => 'core:RecordRef',
            'consolidatedBalanceSheet' => 'core:RecordRef',
            'consolidatedCashFlow' => 'core:RecordRef',
            'nexusList' => 'accounting:SubsidiaryNexusList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        SubsidiaryNexus => {
            'nexusId' => 'core:RecordRef',
            'country' => 'accounting:string',
        },
    
        SubsidiaryNexusList => {
            'nexus' => 'accounting:SubsidiaryNexus',
        },
    
        GiftCertificate => {
            'giftCertCode' => 'accounting:string',
            'sender' => 'accounting:string',
            'name' => 'accounting:string',
            'email' => 'accounting:string',
            'message' => 'accounting:string',
            'expirationDate' => 'accounting:dateTime',
            'originalAmount' => 'accounting:double',
            'amountRemaining' => 'accounting:double',
        },
    
        PartnerCategory => {
            'name' => 'accounting:string',
            'parent' => 'core:RecordRef',
            'isInactive' => 'accounting:boolean',
        },
    
        VendorCategory => {
            'name' => 'accounting:string',
            'isTaxAgency' => 'accounting:boolean',
            'isInactive' => 'accounting:boolean',
        },
    
        Opportunity => {
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'title' => 'sales:string',
            'tranId' => 'sales:string',
            'source' => 'sales:string',
            'salesRep' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'salesGroup' => 'core:RecordRef',
            'syncSalesTeams' => 'sales:boolean',
            'leadSource' => 'core:RecordRef',
            'entityStatus' => 'core:RecordRef',
            'probability' => 'sales:double',
            'tranDate' => 'sales:dateTime',
            'expectedCloseDate' => 'sales:dateTime',
            'forecastType' => 'core:RecordRef',
            'currencyName' => 'sales:string',
            'exchangeRate' => 'sales:double',
            'projectedTotal' => 'sales:double',
            'rangeLow' => 'sales:double',
            'rangeHigh' => 'sales:double',
            'projAltSalesAmt' => 'sales:double',
            'altSalesRangeLow' => 'sales:double',
            'altSalesRangeHigh' => 'sales:double',
            'weightedTotal' => 'sales:double',
            'actionItem' => 'sales:string',
            'winLossReason' => 'core:RecordRef',
            'memo' => 'sales:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'sales:string',
            'shipAddressList' => 'core:RecordRef',
            'shipAddress' => 'sales:string',
            'class' => 'core:RecordRef',
            'closeDate' => 'sales:dateTime',
            'createdDate' => 'sales:dateTime',
            'lastModifiedDate' => 'sales:dateTime',
            'department' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'status' => 'sales:string',
            'vatRegNum' => 'sales:string',
            'salesTeamList' => 'sales:OpportunitySalesTeamList',
            'itemList' => 'sales:OpportunityItemList',
            'competitorsList' => 'sales:OpportunityCompetitorsList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        OpportunitySalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'sales:boolean',
            'contribution' => 'sales:double',
        },
    
        OpportunitySalesTeamList => {
            'salesTeam' => 'sales:OpportunitySalesTeam',
        },
    
        OpportunityItem => {
            'item' => 'core:RecordRef',
            'line' => 'long',
            'quantityAvailable' => 'sales:double',
            'quantityOnHand' => 'sales:double',
            'quantity' => 'sales:double',
            'units' => 'core:RecordRef',
            'description' => 'sales:string',
            'price' => 'core:RecordRef',
            'rate' => 'sales:string',
            'amount' => 'sales:double',
            'altSalesAmt' => 'sales:double',
            'revRecTermInMonths' => 'sales:long',
            'options' => 'core:CustomFieldList',
            'department' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        OpportunityItemList => {
            'item' => 'sales:OpportunityItem',
        },
    
        OpportunityCompetitors => {
            'competitor' => 'core:RecordRef',
            'url' => 'sales:string',
            'notes' => 'sales:string',
            'winner' => 'sales:boolean',
        },
    
        OpportunityCompetitorsList => {
            'competitors' => 'sales:OpportunityCompetitors',
        },
    
        SalesOrder => {
            'createdDate' => 'sales:dateTime',
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'tranDate' => 'sales:dateTime',
            'tranId' => 'sales:string',
            'source' => 'sales:string',
            'createdFrom' => 'core:RecordRef',
            'orderStatus' => 'salesTypes:SalesOrderOrderStatus',
            'opportunity' => 'core:RecordRef',
            'salesRep' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'salesGroup' => 'core:RecordRef',
            'syncSalesTeams' => 'sales:boolean',
            'leadSource' => 'core:RecordRef',
            'startDate' => 'sales:dateTime',
            'endDate' => 'sales:dateTime',
            'otherRefNum' => 'sales:string',
            'memo' => 'sales:string',
            'excludeCommission' => 'sales:boolean',
            'exchangeRate' => 'sales:double',
            'promoCode' => 'core:RecordRef',
            'currencyName' => 'sales:string',
            'discountItem' => 'core:RecordRef',
            'discountRate' => 'sales:string',
            'isTaxable' => 'sales:boolean',
            'taxItem' => 'core:RecordRef',
            'taxRate' => 'sales:double',
            'toBePrinted' => 'sales:boolean',
            'toBeEmailed' => 'sales:boolean',
            'email' => 'sales:string',
            'toBeFaxed' => 'sales:boolean',
            'fax' => 'sales:string',
            'messageSel' => 'core:RecordRef',
            'message' => 'sales:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'sales:string',
            'shipAddressList' => 'core:RecordRef',
            'shipAddress' => 'sales:string',
            'fob' => 'sales:string',
            'shipDate' => 'sales:dateTime',
            'actualShipDate' => 'sales:dateTime',
            'shipMethod' => 'core:RecordRef',
            'shippingCost' => 'sales:double',
            'shippingTax1Rate' => 'sales:double',
            'shippingTaxCode' => 'core:RecordRef',
            'handlingTaxCode' => 'core:RecordRef',
            'handlingTax1Rate' => 'sales:double',
            'handlingCost' => 'sales:double',
            'trackingNumbers' => 'sales:string',
            'linkedTrackingNumbers' => 'sales:string',
            'shipComplete' => 'sales:boolean',
            'paymentMethod' => 'core:RecordRef',
            'creditCard' => 'core:RecordRef',
            'ccNumber' => 'sales:string',
            'ccExpireDate' => 'sales:dateTime',
            'ccName' => 'sales:string',
            'ccStreet' => 'sales:string',
            'ccZipCode' => 'sales:string',
            'payPalStatus' => 'sales:string',
            'creditCardProcessor' => 'core:RecordRef',
            'payPalTranId' => 'sales:string',
            'ccApproved' => 'sales:boolean',
            'getAuth' => 'sales:boolean',
            'authCode' => 'sales:string',
            'ccAvsStreetMatch' => 'commonTypes:AvsMatchCode',
            'ccAvsZipMatch' => 'commonTypes:AvsMatchCode',
            'ccSecurityCodeMatch' => 'commonTypes:AvsMatchCode',
            'altSalesTotal' => 'sales:double',
            'subTotal' => 'sales:double',
            'discountTotal' => 'sales:double',
            'taxTotal' => 'sales:double',
            'altShippingCost' => 'sales:double',
            'altHandlingCost' => 'sales:double',
            'total' => 'sales:double',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'balance' => 'sales:double',
            'billingSchedule' => 'core:RecordRef',
            'ccSecurityCode' => 'sales:string',
            'class' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'debitCardIssueNo' => 'sales:string',
            'lastModifiedDate' => 'sales:dateTime',
            'location' => 'core:RecordRef',
            'pnRefNum' => 'sales:string',
            'status' => 'sales:string',
            'tax2Total' => 'sales:double',
            'terms' => 'core:RecordRef',
            'validFrom' => 'sales:dateTime',
            'vatRegNum' => 'sales:string',
            'giftCert' => 'core:RecordRef',
            'giftCertTotal' => 'sales:double',
            'giftCertApplied' => 'sales:double',
            'giftCertAvailable' => 'sales:double',
            'tranIsVsoeBundle' => 'sales:boolean',
            'vsoeAutoCalc' => 'sales:boolean',
            'salesTeamList' => 'sales:SalesOrderSalesTeamList',
            'itemList' => 'sales:SalesOrderItemList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        SalesOrderSalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'sales:boolean',
            'contribution' => 'sales:double',
        },
    
        SalesOrderSalesTeamList => {
            'salesTeam' => 'sales:SalesOrderSalesTeam',
        },
    
        SalesOrderItem => {
            'item' => 'core:RecordRef',
            'quantityAvailable' => 'sales:double',
            'quantityOnHand' => 'sales:double',
            'quantity' => 'sales:double',
            'units' => 'core:RecordRef',
            'description' => 'sales:string',
            'price' => 'core:RecordRef',
            'rate' => 'sales:string',
            'serialNumbers' => 'sales:string',
            'amount' => 'sales:double',
            'isTaxable' => 'sales:boolean',
            'commitInventory' => 'salesTypes:SalesOrderItemCommitInventory',
            'licenseCode' => 'sales:string',
            'options' => 'core:CustomFieldList',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'createPo' => 'salesTypes:SalesOrderItemCreatePo',
            'createdPo' => 'core:RecordRef',
            'altSalesAmt' => 'sales:double',
            'poVendor' => 'core:RecordRef',
            'poCurrency' => 'sales:string',
            'poRate' => 'sales:double',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecTermInMonths' => 'sales:long',
            'revRecEndDate' => 'sales:dateTime',
            'deferRevRec' => 'sales:boolean',
            'isClosed' => 'sales:boolean',
            'billingSchedule' => 'core:RecordRef',
            'grossAmt' => 'sales:double',
            'line' => 'sales:long',
            'percentComplete' => 'sales:double',
            'quantityBackOrdered' => 'sales:double',
            'quantityBilled' => 'sales:double',
            'quantityCommitted' => 'sales:double',
            'quantityFulfilled' => 'sales:double',
            'quantityPacked' => 'sales:double',
            'quantityPicked' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
            'giftCertFrom' => 'sales:string',
            'giftCertRecipientName' => 'sales:string',
            'giftCertRecipientEmail' => 'sales:string',
            'giftCertMessage' => 'sales:string',
            'giftCertNumber' => 'sales:string',
            'vsoePrice' => 'sales:double',
            'vsoeAmount' => 'sales:double',
            'vsoeAllocation' => 'sales:double',
            'vsoeDeferral' => 'commonTyp:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTyp:VsoePermitDiscount',
            'vsoeDelivered' => 'sales:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        SalesOrderItemList => {
            'item' => 'sales:SalesOrderItem',
        },
    
        ItemFulfillment => {
            'createdDate' => 'sales:dateTime',
            'lastModifiedDate' => 'sales:dateTime',
            'postingPeriod' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'createdFrom' => 'core:RecordRef',
            'shipAddressList' => 'core:RecordRef',
            'shipAddress' => 'sales:string',
            'shipOverride' => 'sales:boolean',
            'shipAttention' => 'sales:string',
            'shipCompany' => 'sales:string',
            'shipAddr1' => 'sales:string',
            'shipAddr2' => 'sales:string',
            'shipCity' => 'sales:string',
            'shipState' => 'sales:string',
            'shipZip' => 'sales:string',
            'shipCountry' => 'commonTypes:Country',
            'shipPhone' => 'sales:string',
            'shipIsResidential' => 'sales:boolean',
            'shipStatus' => 'salesTypes:ItemFulfillmentShipStatus',
            'saturdayDeliveryUps' => 'sales:boolean',
            'sendShipNotifyEmailUps' => 'sales:boolean',
            'sendBackupEmailUps' => 'sales:boolean',
            'shipNotifyEmailAddressUps' => 'sales:string',
            'shipNotifyEmailAddress2Ups' => 'sales:string',
            'backupEmailAddressUps' => 'sales:string',
            'shipNotifyEmailMessageUps' => 'sales:string',
            'thirdPartyAcctUps' => 'sales:string',
            'thirdPartyZipcodeUps' => 'sales:string',
            'thirdPartyCountryUps' => 'commonTypes:Country',
            'thirdPartyTypeUps' => 'salesTypes:ItemFulfillmentThirdPartyTypeUps',
            'partiesToTransactionUps' => 'sales:boolean',
            'exportTypeUps' => 'salesTypes:ItemFulfillmentExportTypeUps',
            'methodOfTransportUps' => 'salesTypes:ItemFulfillmentMethodOfTransportUps',
            'carrierIdUps' => 'sales:string',
            'entryNumberUps' => 'sales:string',
            'inbondCodeUps' => 'sales:string',
            'isRoutedExportTransactionUps' => 'sales:boolean',
            'licenseNumberUps' => 'sales:string',
            'licenseDateUps' => 'sales:dateTime',
            'licenseExceptionUps' => 'salesTypes:ItemFulfillmentLicenseExceptionUps',
            'eccNumberUps' => 'sales:string',
            'recipientTaxIdUps' => 'sales:string',
            'blanketStartDateUps' => 'sales:dateTime',
            'blanketEndDateUps' => 'sales:dateTime',
            'shipmentWeightUps' => 'sales:double',
            'saturdayDeliveryFedEx' => 'sales:boolean',
            'saturdayPickupFedex' => 'sales:boolean',
            'sendShipNotifyEmailFedEx' => 'sales:boolean',
            'sendBackupEmailFedEx' => 'sales:boolean',
            'signatureHomeDeliveryFedEx' => 'sales:boolean',
            'shipNotifyEmailAddressFedEx' => 'sales:string',
            'backupEmailAddressFedEx' => 'sales:string',
            'shipDateFedEx' => 'sales:dateTime',
            'homeDeliveryTypeFedEx' => 'salesTypes:ItemFulfillmentHomeDeliveryTypeFedEx',
            'homeDeliveryDateFedEx' => 'sales:dateTime',
            'bookingConfirmationNumFedEx' => 'sales:string',
            'intlExemptionNumFedEx' => 'sales:string',
            'b13aFilingOptionFedEx' => 'salesTypes:ItemFulfillmentB13AFilingOptionFedEx',
            'b13aStatementDataFedEx' => 'sales:string',
            'thirdPartyAcctFedEx' => 'sales:string',
            'thirdPartyCountryFedEx' => 'commonTypes:Country',
            'thirdPartyTypeFedEx' => 'salesTypes:ItemFulfillmentThirdPartyTypeFedEx',
            'shipmentWeightFedEx' => 'sales:double',
            'termsOfSaleFedEx' => 'salesTypes:ItemFulfillmentTermsOfSaleFedEx',
            'termsFreightChargeFedEx' => 'sales:double',
            'termsInsuranceChargeFedEx' => 'sales:double',
            'tranDate' => 'sales:dateTime',
            'tranId' => 'sales:string',
            'shipMethod' => 'core:RecordRef',
            'generateIntegratedShipperLabel' => 'sales:boolean',
            'shippingCost' => 'sales:double',
            'handlingCost' => 'sales:double',
            'packageList' => 'sales:ItemFulfillmentPackageList',
            'packageUpsList' => 'sales:ItemFulfillmentPackageUpsList',
            'packageFedExList' => 'sales:ItemFulfillmentPackageFedExList',
            'itemList' => 'sales:ItemFulfillmentItemList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ItemFulfillmentItem => {
            'jobName' => 'sales:string',
            'itemReceive' => 'sales:boolean',
            'itemName' => 'sales:string',
            'description' => 'sales:string',
            'location' => 'core:RecordRef',
            'onHand' => 'sales:double',
            'quantity' => 'sales:double',
            'unitsDisplay' => 'sales:string',
            'binNumbers' => 'sales:string',
            'serialNumbers' => 'sales:string',
            'poNum' => 'sales:string',
            'item' => 'core:RecordRef',
            'orderLine' => 'sales:long',
            'quantityRemaining' => 'sales:double',
            'options' => 'core:CustomFieldList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ItemFulfillmentItemList => {
            'item' => 'sales:ItemFulfillmentItem',
        },
    
        ItemFulfillmentPackage => {
            'packageWeight' => 'sales:double',
            'packageDescr' => 'sales:string',
            'packageTrackingNumber' => 'sales:string',
        },
    
        ItemFulfillmentPackageList => {
            'package' => 'sales:ItemFulfillmentPackage',
        },
    
        ItemFulfillmentPackageUps => {
            'packageWeightUps' => 'sales:double',
            'packageDescrUps' => 'sales:string',
            'packageTrackingNumberUps' => 'sales:string',
            'packagingUps' => 'salesTypes:ItemFulfillmentPackageUpsPackagingUps',
            'insuredValueUps' => 'sales:double',
            'reference1Ups' => 'sales:string',
            'reference2Ups' => 'sales:string',
            'packageLengthUps' => 'sales:long',
            'packageWidthUps' => 'sales:long',
            'packageHeightUps' => 'sales:long',
            'additionalHandlingUps' => 'sales:boolean',
            'useCodUps' => 'sales:boolean',
            'codAmountUps' => 'sales:double',
            'codMethodUps' => 'salesTypes:ItemFulfillmentPackageUpsCodMethodUps',
            'deliveryConfUps' => 'salesTypes:ItemFulfillmentPackageUpsDeliveryConfUps',
        },
    
        ItemFulfillmentPackageUpsList => {
            'packageUps' => 'sales:ItemFulfillmentPackageUps',
        },
    
        ItemFulfillmentPackageFedEx => {
            'packageWeightFedEx' => 'sales:double',
            'packageTrackingNumberFedEx' => 'sales:string',
            'packagingFedEx' => 'salesTypes:ItemFulfillmentPackageFedExPackagingFedEx',
            'admPackageTypeFedEx' => 'salesTypes:ItemFulfillmentPackageFedExAdmPackageTypeFedEx',
            'isNonStandardContainerFedEx' => 'sales:boolean',
            'insuredValueFedEx' => 'sales:double',
            'reference1FedEx' => 'sales:string',
            'packageLengthFedEx' => 'sales:long',
            'packageWidthFedEx' => 'sales:long',
            'packageHeightFedEx' => 'sales:long',
            'useCodFedEx' => 'sales:boolean',
            'codAmountFedEx' => 'sales:double',
            'codMethodFedEx' => 'salesTypes:ItemFulfillmentPackageFedExCodMethodFedEx',
            'codFreightTypeFedEx' => 'salesTypes:ItemFulfillmentPackageFedExCodFreightTypeFedEx',
            'deliveryConfFedEx' => 'salesTypes:ItemFulfillmentPackageFedExDeliveryConfFedEx',
            'signatureOptionsFedEx' => 'salesTypes:ItemFulfillmentPackageFedExSignatureOptionsFedEx',
            'signatureReleaseFedEx' => 'sales:string',
            'authorizationNumberFedEx' => 'sales:string',
        },
    
        ItemFulfillmentPackageFedExList => {
            'packageFedEx' => 'sales:ItemFulfillmentPackageFedEx',
        },
    
        Invoice => {
            'createdDate' => 'sales:dateTime',
            'lastModifiedDate' => 'sales:dateTime',
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'tranDate' => 'sales:dateTime',
            'tranId' => 'sales:string',
            'source' => 'sales:string',
            'createdFrom' => 'core:RecordRef',
            'postingPeriod' => 'core:RecordRef',
            'opportunity' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'terms' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'dueDate' => 'sales:dateTime',
            'discountDate' => 'sales:dateTime',
            'discountAmount' => 'sales:double',
            'salesRep' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'leadSource' => 'core:RecordRef',
            'startDate' => 'sales:dateTime',
            'endDate' => 'sales:dateTime',
            'otherRefNum' => 'sales:string',
            'memo' => 'sales:string',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'amountPaid' => 'sales:double',
            'amountRemaining' => 'sales:double',
            'balance' => 'sales:double',
            'account' => 'core:RecordRef',
            'exchangeRate' => 'sales:double',
            'currencyName' => 'sales:string',
            'promoCode' => 'core:RecordRef',
            'discountItem' => 'core:RecordRef',
            'discountRate' => 'sales:string',
            'isTaxable' => 'sales:boolean',
            'taxItem' => 'core:RecordRef',
            'taxRate' => 'sales:double',
            'toBePrinted' => 'sales:boolean',
            'toBeEmailed' => 'sales:boolean',
            'toBeFaxed' => 'sales:boolean',
            'fax' => 'sales:string',
            'messageSel' => 'core:RecordRef',
            'message' => 'sales:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'sales:string',
            'shipAddressList' => 'core:RecordRef',
            'shipAddress' => 'sales:string',
            'fob' => 'sales:string',
            'shipDate' => 'sales:dateTime',
            'shipMethod' => 'core:RecordRef',
            'shippingCost' => 'sales:double',
            'shippingTax1Rate' => 'sales:double',
            'shippingTaxCode' => 'core:RecordRef',
            'handlingTaxCode' => 'core:RecordRef',
            'handlingTax1Rate' => 'sales:double',
            'handlingCost' => 'sales:double',
            'trackingNumbers' => 'sales:string',
            'linkedTrackingNumbers' => 'sales:string',
            'salesGroup' => 'core:RecordRef',
            'subTotal' => 'sales:double',
            'syncSalesTeams' => 'sales:boolean',
            'discountTotal' => 'sales:double',
            'taxTotal' => 'sales:double',
            'altShippingCost' => 'sales:double',
            'altHandlingCost' => 'sales:double',
            'total' => 'sales:double',
            'status' => 'sales:string',
            'billingSchedule' => 'core:RecordRef',
            'email' => 'sales:string',
            'tax2Total' => 'sales:double',
            'vatRegNum' => 'sales:string',
            'expCostDiscount' => 'core:RecordRef',
            'itemCostDiscount' => 'core:RecordRef',
            'timeDiscount' => 'core:RecordRef',
            'expCostDiscRate' => 'sales:string',
            'itemCostDiscRate' => 'sales:string',
            'timeDiscRate' => 'sales:string',
            'expCostDiscAmount' => 'sales:double',
            'itemCostDiscAmount' => 'sales:double',
            'timeDiscAmount' => 'sales:double',
            'expCostDiscTaxable' => 'sales:boolean',
            'itemCostDiscTaxable' => 'sales:boolean',
            'timeDiscTaxable' => 'sales:boolean',
            'expCostDiscPrint' => 'sales:boolean',
            'giftCert' => 'core:RecordRef',
            'giftCertTotal' => 'sales:double',
            'giftCertApplied' => 'sales:double',
            'giftCertAvailable' => 'sales:double',
            'tranIsVsoeBundle' => 'sales:boolean',
            'vsoeAutoCalc' => 'sales:boolean',
            'salesTeamList' => 'sales:InvoiceSalesTeamList',
            'itemList' => 'sales:InvoiceItemList',
            'itemCostList' => 'sales:InvoiceItemCostList',
            'expCostList' => 'sales:InvoiceExpCostList',
            'timeList' => 'sales:InvoiceTimeList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        InvoiceSalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'sales:boolean',
            'contribution' => 'sales:double',
        },
    
        InvoiceSalesTeamList => {
            'salesTeam' => 'sales:InvoiceSalesTeam',
        },
    
        InvoiceItem => {
            'item' => 'core:RecordRef',
            'line' => 'long',
            'description' => 'sales:string',
            'amount' => 'sales:double',
            'isTaxable' => 'sales:boolean',
            'options' => 'core:CustomFieldList',
            'deferRevRec' => 'sales:boolean',
            'quantity' => 'sales:double',
            'currentPercent' => 'sales:double',
            'units' => 'core:RecordRef',
            'serialNumbers' => 'sales:string',
            'binNumbers' => 'sales:string',
            'price' => 'core:RecordRef',
            'rate' => 'sales:string',
            'percentComplete' => 'sales:double',
            'quantityOnHand' => 'sales:double',
            'quantityAvailable' => 'sales:double',
            'quantityOrdered' => 'sales:double',
            'quantityRemaining' => 'sales:double',
            'quantityFulfilled' => 'sales:double',
            'amountOrdered' => 'sales:double',
            'department' => 'core:RecordRef',
            'orderLine' => 'sales:long',
            'licenseCode' => 'sales:string',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
            'giftCertFrom' => 'sales:string',
            'giftCertRecipientName' => 'sales:string',
            'giftCertRecipientEmail' => 'sales:string',
            'giftCertMessage' => 'sales:string',
            'giftCertNumber' => 'sales:string',
            'vsoePrice' => 'sales:double',
            'vsoeAmount' => 'sales:double',
            'vsoeAllocation' => 'sales:double',
            'vsoeDeferral' => 'commonTyp:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTyp:VsoePermitDiscount',
            'vsoeDelivered' => 'sales:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        InvoiceItemList => {
            'item' => 'sales:InvoiceItem',
        },
    
        InvoiceItemCost => {
            'apply' => 'sales:boolean',
            'doc' => 'sales:long',
            'line' => 'sales:long',
            'billedDate' => 'sales:dateTime',
            'itemDisp' => 'sales:string',
            'desc' => 'sales:string',
            'departmentDisp' => 'sales:string',
            'classDisp' => 'sales:string',
            'locationDisp' => 'sales:string',
            'unitDisp' => 'sales:string',
            'options' => 'core:CustomFieldList',
            'count' => 'sales:string',
            'serialNumbers' => 'sales:string',
            'cost' => 'sales:double',
            'amount' => 'sales:double',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
        },
    
        InvoiceItemCostList => {
            'itemCost' => 'sales:InvoiceItemCost',
        },
    
        InvoiceExpCost => {
            'apply' => 'sales:boolean',
            'doc' => 'sales:long',
            'line' => 'sales:long',
            'billedDate' => 'sales:dateTime',
            'employeeDisp' => 'sales:string',
            'categoryDisp' => 'sales:string',
            'memo' => 'sales:string',
            'departmentDisp' => 'sales:string',
            'classDisp' => 'sales:string',
            'locationDisp' => 'sales:string',
            'originalAmount' => 'sales:double',
            'amount' => 'sales:double',
            'taxableDisp' => 'sales:string',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
        },
    
        InvoiceExpCostList => {
            'expCost' => 'sales:InvoiceExpCost',
        },
    
        InvoiceTime => {
            'apply' => 'sales:boolean',
            'doc' => 'sales:long',
            'billedDate' => 'sales:dateTime',
            'employeeDisp' => 'sales:string',
            'itemDisp' => 'sales:string',
            'departmentDisp' => 'sales:string',
            'classDisp' => 'sales:string',
            'locationDisp' => 'sales:string',
            'quantity' => 'sales:string',
            'rate' => 'sales:double',
            'amount' => 'sales:double',
            'desc' => 'sales:string',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
        },
    
        InvoiceTimeList => {
            'time' => 'sales:InvoiceTime',
        },
    
        CashSale => {
            'createdDate' => 'sales:dateTime',
            'lastModifiedDate' => 'sales:dateTime',
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'tranDate' => 'sales:dateTime',
            'tranId' => 'sales:string',
            'source' => 'sales:string',
            'postingPeriod' => 'core:RecordRef',
            'createdFrom' => 'core:RecordRef',
            'opportunity' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'salesRep' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'leadSource' => 'core:RecordRef',
            'startDate' => 'sales:dateTime',
            'endDate' => 'sales:dateTime',
            'otherRefNum' => 'sales:string',
            'memo' => 'sales:string',
            'revRecSchedule' => 'core:RecordRef',
            'undepFunds' => 'sales:boolean',
            'account' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'exchangeRate' => 'sales:double',
            'currencyName' => 'sales:string',
            'promoCode' => 'core:RecordRef',
            'discountItem' => 'core:RecordRef',
            'discountRate' => 'sales:string',
            'isTaxable' => 'sales:boolean',
            'taxItem' => 'core:RecordRef',
            'taxRate' => 'sales:double',
            'toBePrinted' => 'sales:boolean',
            'toBeEmailed' => 'sales:boolean',
            'toBeFaxed' => 'sales:boolean',
            'fax' => 'sales:string',
            'messageSel' => 'core:RecordRef',
            'message' => 'sales:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'sales:string',
            'shipAddressList' => 'core:RecordRef',
            'shipAddress' => 'sales:string',
            'fob' => 'sales:string',
            'shipDate' => 'sales:dateTime',
            'shipMethod' => 'core:RecordRef',
            'shippingCost' => 'sales:double',
            'shippingTax1Rate' => 'sales:double',
            'shippingTaxCode' => 'core:RecordRef',
            'handlingTaxCode' => 'core:RecordRef',
            'handlingTax1Rate' => 'sales:double',
            'handlingCost' => 'sales:double',
            'linkedTrackingNumbers' => 'sales:string',
            'trackingNumbers' => 'sales:string',
            'salesGroup' => 'core:RecordRef',
            'syncSalesTeams' => 'sales:boolean',
            'paymentMethod' => 'core:RecordRef',
            'payPalStatus' => 'sales:string',
            'creditCard' => 'core:RecordRef',
            'ccNumber' => 'sales:string',
            'ccExpireDate' => 'sales:dateTime',
            'ccName' => 'sales:string',
            'ccStreet' => 'sales:string',
            'ccZipCode' => 'sales:string',
            'creditCardProcessor' => 'core:RecordRef',
            'ccApproved' => 'sales:boolean',
            'authCode' => 'sales:string',
            'ccAvsStreetMatch' => 'commonTypes:AvsMatchCode',
            'ccAvsZipMatch' => 'commonTypes:AvsMatchCode',
            'payPalTranId' => 'sales:string',
            'subTotal' => 'sales:double',
            'discountTotal' => 'sales:double',
            'taxTotal' => 'sales:double',
            'altShippingCost' => 'sales:double',
            'altHandlingCost' => 'sales:double',
            'total' => 'sales:double',
            'ccSecurityCode' => 'sales:string',
            'ccSecurityCodeMatch' => 'commonTypes:AvsMatchCode',
            'chargeIt' => 'sales:boolean',
            'debitCardIssueNo' => 'sales:string',
            'pnRefNum' => 'sales:string',
            'status' => 'sales:string',
            'billingSchedule' => 'core:RecordRef',
            'email' => 'sales:string',
            'tax2Total' => 'sales:double',
            'validFrom' => 'sales:dateTime',
            'vatRegNum' => 'sales:string',
            'giftCert' => 'core:RecordRef',
            'giftCertTotal' => 'sales:double',
            'giftCertApplied' => 'sales:double',
            'giftCertAvailable' => 'sales:double',
            'tranIsVsoeBundle' => 'sales:boolean',
            'vsoeAutoCalc' => 'sales:boolean',
            'salesTeamList' => 'sales:CashSaleSalesTeamList',
            'itemList' => 'sales:CashSaleItemList',
            'itemCostList' => 'sales:CashSaleItemCostList',
            'expCostList' => 'sales:CashSaleExpCostList',
            'timeList' => 'sales:CashSaleTimeList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CashSaleSalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'sales:boolean',
            'contribution' => 'sales:double',
        },
    
        CashSaleSalesTeamList => {
            'salesTeam' => 'sales:CashSaleSalesTeam',
        },
    
        CashSaleItem => {
            'item' => 'core:RecordRef',
            'line' => 'long',
            'quantityAvailable' => 'sales:double',
            'quantityOnHand' => 'sales:double',
            'quantity' => 'sales:double',
            'units' => 'core:RecordRef',
            'serialNumbers' => 'sales:string',
            'binNumbers' => 'sales:string',
            'description' => 'sales:string',
            'price' => 'core:RecordRef',
            'rate' => 'sales:string',
            'amount' => 'sales:double',
            'orderLine' => 'sales:long',
            'licenseCode' => 'sales:string',
            'isTaxable' => 'sales:boolean',
            'options' => 'core:CustomFieldList',
            'deferRevRec' => 'sales:boolean',
            'currentPercent' => 'sales:double',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
            'giftCertFrom' => 'sales:string',
            'giftCertRecipientName' => 'sales:string',
            'giftCertRecipientEmail' => 'sales:string',
            'giftCertMessage' => 'sales:string',
            'giftCertNumber' => 'sales:string',
            'vsoePrice' => 'sales:double',
            'vsoeAmount' => 'sales:double',
            'vsoeAllocation' => 'sales:double',
            'vsoeDeferral' => 'commonTyp:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTyp:VsoePermitDiscount',
            'vsoeDelivered' => 'sales:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CashSaleItemList => {
            'item' => 'sales:CashSaleItem',
        },
    
        CashSaleItemCost => {
            'apply' => 'sales:boolean',
            'doc' => 'sales:long',
            'line' => 'sales:long',
            'billedDate' => 'sales:dateTime',
            'itemDisp' => 'sales:string',
            'desc' => 'sales:string',
            'departmentDisp' => 'sales:string',
            'classDisp' => 'sales:string',
            'locationDisp' => 'sales:string',
            'unitDisp' => 'sales:string',
            'options' => 'core:CustomFieldList',
            'count' => 'sales:string',
            'serialNumbers' => 'sales:string',
            'cost' => 'sales:double',
            'amount' => 'sales:double',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
        },
    
        CashSaleItemCostList => {
            'itemCost' => 'sales:CashSaleItemCost',
        },
    
        CashSaleExpCost => {
            'apply' => 'sales:boolean',
            'doc' => 'sales:long',
            'line' => 'sales:long',
            'billedDate' => 'sales:dateTime',
            'employeeDisp' => 'sales:string',
            'categoryDisp' => 'sales:string',
            'memo' => 'sales:string',
            'departmentDisp' => 'sales:string',
            'classDisp' => 'sales:string',
            'locationDisp' => 'sales:string',
            'originalAmount' => 'sales:double',
            'amount' => 'sales:double',
            'taxableDisp' => 'sales:string',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
        },
    
        CashSaleExpCostList => {
            'expCost' => 'sales:CashSaleExpCost',
        },
    
        CashSaleTime => {
            'apply' => 'sales:boolean',
            'doc' => 'sales:long',
            'billedDate' => 'sales:dateTime',
            'employeeDisp' => 'sales:string',
            'itemDisp' => 'sales:string',
            'departmentDisp' => 'sales:string',
            'classDisp' => 'sales:string',
            'locationDisp' => 'sales:string',
            'quantity' => 'sales:string',
            'rate' => 'sales:double',
            'amount' => 'sales:double',
            'desc' => 'sales:string',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'sales:dateTime',
            'revRecEndDate' => 'sales:dateTime',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
        },
    
        CashSaleTimeList => {
            'time' => 'sales:CashSaleTime',
        },
    
        Estimate => {
            'createdDate' => 'sales:dateTime',
            'lastModifiedDate' => 'sales:dateTime',
            'entity' => 'core:RecordRef',
            'job' => 'core:RecordRef',
            'tranDate' => 'sales:dateTime',
            'tranId' => 'sales:string',
            'source' => 'sales:string',
            'customForm' => 'core:RecordRef',
            'entityStatus' => 'core:RecordRef',
            'probability' => 'sales:double',
            'forecastType' => 'core:RecordRef',
            'opportunity' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'terms' => 'core:RecordRef',
            'dueDate' => 'sales:dateTime',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'status' => 'sales:string',
            'salesRep' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'leadSource' => 'core:RecordRef',
            'expectedCloseDate' => 'sales:dateTime',
            'otherRefNum' => 'sales:string',
            'memo' => 'sales:string',
            'endDate' => 'sales:dateTime',
            'startDate' => 'sales:dateTime',
            'createdFrom' => 'core:RecordRef',
            'exchangeRate' => 'sales:double',
            'currencyName' => 'sales:string',
            'promoCode' => 'core:RecordRef',
            'discountItem' => 'core:RecordRef',
            'discountRate' => 'sales:string',
            'isTaxable' => 'sales:boolean',
            'taxItem' => 'core:RecordRef',
            'taxRate' => 'sales:double',
            'vatRegNum' => 'sales:string',
            'toBePrinted' => 'sales:boolean',
            'toBeEmailed' => 'sales:boolean',
            'email' => 'sales:string',
            'toBeFaxed' => 'sales:boolean',
            'fax' => 'sales:string',
            'messageSel' => 'core:RecordRef',
            'message' => 'sales:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'sales:string',
            'shipAddressList' => 'core:RecordRef',
            'shipAddress' => 'sales:string',
            'fob' => 'sales:string',
            'shipDate' => 'sales:dateTime',
            'shipMethod' => 'core:RecordRef',
            'shippingCost' => 'sales:double',
            'shippingTax1Rate' => 'sales:double',
            'shippingTaxCode' => 'core:RecordRef',
            'handlingTaxCode' => 'core:RecordRef',
            'handlingTax1Rate' => 'sales:double',
            'handlingCost' => 'sales:double',
            'trackingNumbers' => 'sales:string',
            'linkedTrackingNumbers' => 'sales:string',
            'salesGroup' => 'core:RecordRef',
            'syncSalesTeams' => 'sales:boolean',
            'altSalesTotal' => 'sales:double',
            'subTotal' => 'sales:double',
            'discountTotal' => 'sales:double',
            'taxTotal' => 'sales:double',
            'altShippingCost' => 'sales:double',
            'altHandlingCost' => 'sales:double',
            'total' => 'sales:double',
            'itemList' => 'sales:EstimateItemList',
            'salesTeamList' => 'sales:EstimateSalesTeamList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        EstimateItem => {
            'item' => 'core:RecordRef',
            'line' => 'long',
            'quantityAvailable' => 'sales:double',
            'quantityOnHand' => 'sales:double',
            'quantity' => 'sales:double',
            'units' => 'core:RecordRef',
            'description' => 'sales:string',
            'serialNumbers' => 'sales:string',
            'price' => 'core:RecordRef',
            'rate' => 'sales:string',
            'amount' => 'sales:double',
            'options' => 'core:CustomFieldList',
            'revRecTermInMonths' => 'sales:long',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'isTaxable' => 'sales:boolean',
            'altSalesAmt' => 'sales:double',
            'grossAmt' => 'sales:double',
            'tax1Amt' => 'sales:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'sales:double',
            'taxRate2' => 'sales:double',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        EstimateItemList => {
            'item' => 'sales:EstimateItem',
        },
    
        EstimateSalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'sales:boolean',
            'contribution' => 'sales:double',
        },
    
        EstimateSalesTeamList => {
            'salesTeam' => 'sales:EstimateSalesTeam',
        },
    
        LandedCost => {
            'category' => 'core:RecordRef',
            'amount' => 'purchases:double',
            'source' => 'purchasesTypes:LandedCostSource',
            'transaction' => 'core:RecordRef',
        },
    
        LandedCostList => {
            'landedCost' => 'purchases:LandedCost',
        },
    
        VendorBill => {
            'createdDate' => 'purchases:dateTime',
            'lastModifiedDate' => 'purchases:dateTime',
            'customForm' => 'core:RecordRef',
            'account' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'vatRegNum' => 'purchases:string',
            'postingPeriod' => 'core:RecordRef',
            'tranDate' => 'purchases:dateTime',
            'currencyName' => 'purchases:string',
            'exchangeRate' => 'purchases:double',
            'terms' => 'core:RecordRef',
            'dueDate' => 'purchases:dateTime',
            'discountDate' => 'purchases:dateTime',
            'tranId' => 'purchases:string',
            'userTotal' => 'purchases:double',
            'discountAmount' => 'purchases:double',
            'memo' => 'purchases:string',
            'creditLimit' => 'purchases:double',
            'class' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'status' => 'purchases:string',
            'landedCostMethod' => 'purchasesTypes:LandedCostMethod',
            'expenseList' => 'purchases:VendorBillExpenseList',
            'itemList' => 'purchases:VendorBillItemList',
            'landedCostsList' => 'purchases:LandedCostList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        VendorBillExpense => {
            'orderLine' => 'purchases:long',
            'line' => 'purchases:long',
            'category' => 'core:RecordRef',
            'account' => 'core:RecordRef',
            'amount' => 'purchases:double',
            'memo' => 'purchases:string',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'customer' => 'core:RecordRef',
            'isBillable' => 'purchases:boolean',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'purchases:double',
            'taxRate2' => 'purchases:double',
            'amortizationSched' => 'core:RecordRef',
            'amortizStartDate' => 'purchases:dateTime',
            'amortizationEndDate' => 'purchases:dateTime',
            'amortizationResidual' => 'purchases:string',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        VendorBillExpenseList => {
            'expense' => 'purchases:VendorBillExpense',
        },
    
        VendorBillItem => {
            'item' => 'core:RecordRef',
            'line' => 'long',
            'orderLine' => 'purchases:long',
            'quantity' => 'purchases:double',
            'units' => 'core:RecordRef',
            'description' => 'purchases:string',
            'serialNumbers' => 'purchases:string',
            'binNumbers' => 'purchases:string',
            'expirationDate' => 'purchases:dateTime',
            'rate' => 'purchases:string',
            'amount' => 'purchases:double',
            'options' => 'core:CustomFieldList',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'customer' => 'core:RecordRef',
            'landedCostCategory' => 'core:RecordRef',
            'isBillable' => 'purchases:boolean',
            'amortizationSched' => 'core:RecordRef',
            'amortizStartDate' => 'purchases:dateTime',
            'amortizationEndDate' => 'purchases:dateTime',
            'amortizationResidual' => 'purchases:string',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        VendorBillItemList => {
            'item' => 'purchases:VendorBillItem',
        },
    
        PurchaseOrder => {
            'createdDate' => 'purchases:dateTime',
            'lastModifiedDate' => 'purchases:dateTime',
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'employee' => 'core:RecordRef',
            'supervisorApproval' => 'purchases:boolean',
            'tranDate' => 'purchases:dateTime',
            'tranId' => 'purchases:string',
            'createdFrom' => 'core:RecordRef',
            'terms' => 'core:RecordRef',
            'dueDate' => 'purchases:dateTime',
            'otherRefNum' => 'purchases:string',
            'memo' => 'purchases:string',
            'exchangeRate' => 'purchases:double',
            'currencyName' => 'purchases:string',
            'toBePrinted' => 'purchases:boolean',
            'toBeEmailed' => 'purchases:boolean',
            'email' => 'purchases:string',
            'toBeFaxed' => 'purchases:boolean',
            'fax' => 'purchases:string',
            'message' => 'purchases:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'purchases:string',
            'shipTo' => 'core:RecordRef',
            'shipAddressList' => 'core:RecordRef',
            'shipAddress' => 'purchases:string',
            'fob' => 'purchases:string',
            'shipDate' => 'purchases:dateTime',
            'shipMethod' => 'core:RecordRef',
            'trackingNumbers' => 'purchases:string',
            'linkedTrackingNumbers' => 'purchases:string',
            'total' => 'purchases:double',
            'class' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'status' => 'purchases:string',
            'itemList' => 'purchases:PurchaseOrderItemList',
            'expenseList' => 'purchases:PurchaseOrderExpenseList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        PurchaseOrderExpense => {
            'line' => 'purchases:long',
            'category' => 'core:RecordRef',
            'account' => 'core:RecordRef',
            'amount' => 'purchases:double',
            'memo' => 'purchases:string',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'customer' => 'core:RecordRef',
            'isBillable' => 'purchases:boolean',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'purchases:double',
            'taxRate2' => 'purchases:double',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        PurchaseOrderExpenseList => {
            'expense' => 'purchases:PurchaseOrderExpense',
        },
    
        PurchaseOrderItem => {
            'item' => 'core:RecordRef',
            'line' => 'long',
            'vendorName' => 'purchases:string',
            'quantityReceived' => 'purchases:double',
            'quantityBilled' => 'purchases:double',
            'quantityAvailable' => 'purchases:double',
            'quantityOnHand' => 'purchases:double',
            'quantity' => 'purchases:double',
            'units' => 'core:RecordRef',
            'serialNumbers' => 'purchases:string',
            'description' => 'purchases:string',
            'rate' => 'purchases:string',
            'amount' => 'purchases:double',
            'options' => 'core:CustomFieldList',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'landedCostCategory' => 'core:RecordRef',
            'customer' => 'core:RecordRef',
            'isBillable' => 'purchases:boolean',
            'isClosed' => 'purchases:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        PurchaseOrderItemList => {
            'item' => 'purchases:PurchaseOrderItem',
        },
    
        ItemReceipt => {
            'createdDate' => 'purchases:dateTime',
            'lastModifiedDate' => 'purchases:dateTime',
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'createdFrom' => 'core:RecordRef',
            'tranDate' => 'purchases:dateTime',
            'postingPeriod' => 'core:RecordRef',
            'tranId' => 'purchases:string',
            'memo' => 'purchases:string',
            'landedCostMethod' => 'purchasesTypes:LandedCostMethod',
            'itemList' => 'purchases:ItemReceiptItemList',
            'expenseList' => 'purchases:ItemReceiptExpenseList',
            'landedCostsList' => 'purchases:LandedCostList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ItemReceiptItem => {
            'itemReceive' => 'purchases:boolean',
            'item' => 'core:RecordRef',
            'orderLine' => 'purchases:long',
            'itemName' => 'purchases:string',
            'description' => 'purchases:string',
            'location' => 'core:RecordRef',
            'onhand' => 'purchases:double',
            'quantityRemaining' => 'purchases:double',
            'quantity' => 'purchases:double',
            'unitsDisplay' => 'purchases:string',
            'serialNumbers' => 'purchases:string',
            'expirationDate' => 'purchases:dateTime',
            'rate' => 'purchases:string',
            'currency' => 'purchases:string',
            'options' => 'core:CustomFieldList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ItemReceiptItemList => {
            'item' => 'purchases:ItemReceiptItem',
        },
    
        ItemReceiptExpense => {
            'markReceived' => 'purchases:boolean',
            'orderLine' => 'purchases:long',
            'account' => 'purchases:string',
            'memo' => 'purchases:string',
            'amount' => 'purchases:double',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ItemReceiptExpenseList => {
            'expense' => 'purchases:ItemReceiptExpense',
        },
    
        CashRefund => {
            'createdDate' => 'customers:dateTime',
            'lastModifiedDate' => 'customers:dateTime',
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'vatRegNum' => 'customers:string',
            'tranDate' => 'customers:dateTime',
            'tranId' => 'customers:string',
            'source' => 'customers:string',
            'createdFrom' => 'core:RecordRef',
            'postingPeriod' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'salesRep' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'otherRefNum' => 'customers:string',
            'memo' => 'customers:string',
            'refundCheck' => 'customers:boolean',
            'toPrint2' => 'customers:boolean',
            'account' => 'core:RecordRef',
            'exchangeRate' => 'customers:double',
            'currencyName' => 'customers:string',
            'promoCode' => 'core:RecordRef',
            'discountItem' => 'core:RecordRef',
            'discountRate' => 'customers:string',
            'isTaxable' => 'customers:boolean',
            'taxItem' => 'core:RecordRef',
            'taxRate' => 'customers:double',
            'toBePrinted' => 'customers:boolean',
            'toBeEmailed' => 'customers:boolean',
            'email' => 'customers:string',
            'toBeFaxed' => 'customers:boolean',
            'fax' => 'customers:string',
            'messageSel' => 'core:RecordRef',
            'message' => 'customers:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'customers:string',
            'shipMethod' => 'core:RecordRef',
            'shippingTaxCode' => 'core:RecordRef',
            'shippingTax1Rate' => 'customers:double',
            'shippingCost' => 'customers:double',
            'handlingTaxCode' => 'core:RecordRef',
            'handlingTax1Rate' => 'customers:double',
            'handlingCost' => 'customers:double',
            'salesGroup' => 'core:RecordRef',
            'syncSalesTeams' => 'customers:boolean',
            'paymentMethod' => 'core:RecordRef',
            'creditCard' => 'core:RecordRef',
            'chargeIt' => 'customers:boolean',
            'ccNumber' => 'customers:string',
            'ccExpireDate' => 'customers:dateTime',
            'ccName' => 'customers:string',
            'ccStreet' => 'customers:string',
            'ccZipCode' => 'customers:string',
            'ccApproved' => 'customers:boolean',
            'creditCardProcessor' => 'core:RecordRef',
            'debitCardIssueNo' => 'customers:string',
            'pnRefNum' => 'customers:string',
            'validFrom' => 'customers:dateTime',
            'subTotal' => 'customers:double',
            'discountTotal' => 'customers:double',
            'taxTotal' => 'customers:double',
            'tax2Total' => 'customers:double',
            'altShippingCost' => 'customers:double',
            'altHandlingCost' => 'customers:double',
            'total' => 'customers:double',
            'status' => 'customers:string',
            'giftCert' => 'core:RecordRef',
            'giftCertTotal' => 'customers:double',
            'giftCertApplied' => 'customers:double',
            'giftCertAvailable' => 'customers:double',
            'tranIsVsoeBundle' => 'customers:boolean',
            'vsoeAutoCalc' => 'customers:boolean',
            'itemList' => 'customers:CashRefundItemList',
            'salesTeamList' => 'customers:CashRefundSalesTeamList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CashRefundItem => {
            'item' => 'core:RecordRef',
            'line' => 'long',
            'orderLine' => 'customers:long',
            'quantity' => 'customers:double',
            'units' => 'core:RecordRef',
            'binNumbers' => 'customers:string',
            'serialNumbers' => 'customers:string',
            'description' => 'customers:string',
            'price' => 'core:RecordRef',
            'rate' => 'customers:string',
            'amount' => 'customers:double',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'customers:string',
            'taxRate2' => 'customers:string',
            'tax1Amt' => 'customers:double',
            'grossAmt' => 'customers:double',
            'isTaxable' => 'customers:boolean',
            'options' => 'core:CustomFieldList',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'customers:dateTime',
            'revRecEndDate' => 'customers:dateTime',
            'giftCertFrom' => 'customers:string',
            'giftCertRecipientName' => 'customers:string',
            'giftCertRecipientEmail' => 'customers:string',
            'giftCertMessage' => 'customers:string',
            'giftCertNumber' => 'customers:string',
            'vsoePrice' => 'customers:double',
            'vsoeAmount' => 'customers:double',
            'vsoeAllocation' => 'customers:double',
            'vsoeDeferral' => 'commonTyp:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTyp:VsoePermitDiscount',
            'vsoeDelivered' => 'customers:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CashRefundItemList => {
            'item' => 'customers:CashRefundItem',
        },
    
        CashRefundSalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'customers:boolean',
            'contribution' => 'customers:double',
        },
    
        CashRefundSalesTeamList => {
            'salesTeam' => 'customers:CashRefundSalesTeam',
        },
    
        CustomerPayment => {
            'createdDate' => 'customers:dateTime',
            'lastModifiedDate' => 'customers:dateTime',
            'arAcct' => 'core:RecordRef',
            'customer' => 'core:RecordRef',
            'balance' => 'customers:double',
            'pending' => 'customers:double',
            'payment' => 'customers:double',
            'autoApply' => 'customers:boolean',
            'tranDate' => 'customers:dateTime',
            'postingPeriod' => 'core:RecordRef',
            'paymentMethod' => 'core:RecordRef',
            'memo' => 'customers:string',
            'checkNum' => 'customers:string',
            'currencyName' => 'customers:string',
            'exchangeRate' => 'customers:double',
            'creditCard' => 'core:RecordRef',
            'chargeIt' => 'customers:boolean',
            'ccNumber' => 'customers:string',
            'ccExpireDate' => 'customers:dateTime',
            'ccName' => 'customers:string',
            'ccStreet' => 'customers:string',
            'ccZipCode' => 'customers:string',
            'ccApproved' => 'customers:boolean',
            'authCode' => 'customers:string',
            'ccAvsStreetMatch' => 'commonTypes:AvsMatchCode',
            'ccAvsZipMatch' => 'commonTypes:AvsMatchCode',
            'ccSecurityCode' => 'customers:string',
            'ccSecurityCodeMatch' => 'commonTypes:AvsMatchCode',
            'pnRefNum' => 'customers:string',
            'creditCardProcessor' => 'core:RecordRef',
            'debitCardIssueNo' => 'customers:string',
            'validFrom' => 'customers:dateTime',
            'undepFunds' => 'customers:boolean',
            'account' => 'core:RecordRef',
            'total' => 'customers:double',
            'applied' => 'customers:double',
            'unapplied' => 'customers:double',
            'class' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'status' => 'customers:string',
            'applyList' => 'customers:CustomerPaymentApplyList',
            'creditList' => 'customers:CustomerPaymentCreditList',
            'depositList' => 'customers:CustomerPaymentDepositList',
        },
    
        CustomerPaymentApply => {
            'apply' => 'customers:boolean',
            'doc' => 'customers:long',
            'date' => 'customers:dateTime',
            'job' => 'customers:string',
            'type' => 'customers:string',
            'refNum' => 'customers:string',
            'total' => 'customers:double',
            'due' => 'customers:double',
            'currency' => 'customers:string',
            'discDate' => 'customers:dateTime',
            'discAmt' => 'customers:double',
            'disc' => 'customers:double',
            'amount' => 'customers:double',
        },
    
        CustomerPaymentApplyList => {
            'apply' => 'customers:CustomerPaymentApply',
        },
    
        CustomerPaymentCredit => {
            'apply' => 'customers:boolean',
            'doc' => 'customers:long',
            'date' => 'customers:dateTime',
            'type' => 'customers:string',
            'refNum' => 'customers:string',
            'total' => 'customers:double',
            'due' => 'customers:double',
            'currency' => 'customers:string',
            'amount' => 'customers:double',
        },
    
        CustomerPaymentCreditList => {
            'credit' => 'customers:CustomerPaymentCredit',
        },
    
        CustomerPaymentDeposit => {
            'apply' => 'customers:boolean',
            'doc' => 'customers:long',
            'date' => 'customers:dateTime',
            'refNum' => 'customers:string',
            'total' => 'customers:double',
            'remaining' => 'customers:double',
            'currency' => 'customers:string',
            'amount' => 'customers:double',
        },
    
        CustomerPaymentDepositList => {
            'deposit' => 'customers:CustomerPaymentDeposit',
        },
    
        ReturnAuthorization => {
            'createdDate' => 'customers:dateTime',
            'lastModifiedDate' => 'customers:dateTime',
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'tranDate' => 'customers:dateTime',
            'tranId' => 'customers:string',
            'source' => 'customers:string',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'otherRefNum' => 'customers:string',
            'memo' => 'customers:string',
            'createdFrom' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'customers:dateTime',
            'revRecEndDate' => 'customers:dateTime',
            'excludeCommission' => 'customers:boolean',
            'exchangeRate' => 'customers:double',
            'currencyName' => 'customers:string',
            'discountItem' => 'core:RecordRef',
            'discountRate' => 'customers:string',
            'taxItem' => 'core:RecordRef',
            'taxRate' => 'customers:double',
            'toBePrinted' => 'customers:boolean',
            'toBeEmailed' => 'customers:boolean',
            'toBeFaxed' => 'customers:boolean',
            'messageSel' => 'core:RecordRef',
            'message' => 'customers:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'customers:string',
            'shipAddressList' => 'core:RecordRef',
            'shipAddress' => 'customers:string',
            'salesGroup' => 'core:RecordRef',
            'syncSalesTeams' => 'customers:boolean',
            'paymentMethod' => 'core:RecordRef',
            'creditCard' => 'core:RecordRef',
            'ccNumber' => 'customers:string',
            'ccExpireDate' => 'customers:dateTime',
            'ccName' => 'customers:string',
            'ccStreet' => 'customers:string',
            'ccZipCode' => 'customers:string',
            'ccApproved' => 'customers:boolean',
            'pnRefNum' => 'customers:string',
            'subTotal' => 'customers:double',
            'discountTotal' => 'customers:double',
            'total' => 'customers:double',
            'creditCardProcessor' => 'core:RecordRef',
            'email' => 'customers:string',
            'fax' => 'customers:string',
            'debitCardIssueNo' => 'customers:string',
            'isTaxable' => 'customers:boolean',
            'promoCode' => 'core:RecordRef',
            'status' => 'customers:string',
            'taxTotal' => 'customers:double',
            'tax2Total' => 'customers:double',
            'validFrom' => 'customers:dateTime',
            'orderStatus' => 'customersTypes:ReturnAuthorizationOrderStatus',
            'salesRep' => 'core:RecordRef',
            'giftCert' => 'core:RecordRef',
            'giftCertTotal' => 'customers:double',
            'giftCertApplied' => 'customers:double',
            'giftCertAvailable' => 'customers:double',
            'tranIsVsoeBundle' => 'customers:boolean',
            'vsoeAutoCalc' => 'customers:boolean',
            'itemList' => 'customers:ReturnAuthorizationItemList',
            'salesTeamList' => 'customers:ReturnAuthorizationSalesTeamList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ReturnAuthorizationItem => {
            'item' => 'core:RecordRef',
            'orderLine' => 'customers:long',
            'line' => 'long',
            'quantity' => 'customers:double',
            'units' => 'core:RecordRef',
            'description' => 'customers:string',
            'serialNumbers' => 'customers:string',
            'price' => 'core:RecordRef',
            'rate' => 'customers:string',
            'amount' => 'customers:double',
            'options' => 'core:CustomFieldList',
            'revRecTermInMonths' => 'customers:long',
            'deferRevRec' => 'customers:boolean',
            'isClosed' => 'customers:boolean',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'customers:dateTime',
            'revRecEndDate' => 'customers:dateTime',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'customers:double',
            'taxRate2' => 'customers:double',
            'tax1Amt' => 'customers:double',
            'grossAmt' => 'customers:double',
            'isTaxable' => 'customers:boolean',
            'giftCertFrom' => 'customers:string',
            'giftCertRecipientName' => 'customers:string',
            'giftCertRecipientEmail' => 'customers:string',
            'giftCertMessage' => 'customers:string',
            'giftCertNumber' => 'customers:string',
            'vsoePrice' => 'customers:double',
            'vsoeAmount' => 'customers:double',
            'vsoeAllocation' => 'customers:double',
            'vsoeDeferral' => 'commonTyp:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTyp:VsoePermitDiscount',
            'vsoeDelivered' => 'customers:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        ReturnAuthorizationItemList => {
            'item' => 'customers:ReturnAuthorizationItem',
        },
    
        ReturnAuthorizationSalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'customers:boolean',
            'contribution' => 'customers:double',
        },
    
        ReturnAuthorizationSalesTeamList => {
            'salesTeam' => 'customers:ReturnAuthorizationSalesTeam',
        },
    
        CreditMemo => {
            'createdDate' => 'customers:dateTime',
            'lastModifiedDate' => 'customers:dateTime',
            'customForm' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'tranDate' => 'customers:dateTime',
            'tranId' => 'customers:string',
            'createdFrom' => 'core:RecordRef',
            'postingPeriod' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'salesRep' => 'core:RecordRef',
            'partner' => 'core:RecordRef',
            'otherRefNum' => 'customers:string',
            'memo' => 'customers:string',
            'balance' => 'customers:double',
            'account' => 'core:RecordRef',
            'exchangeRate' => 'customers:double',
            'currencyName' => 'customers:string',
            'promoCode' => 'core:RecordRef',
            'discountItem' => 'core:RecordRef',
            'discountRate' => 'customers:string',
            'isTaxable' => 'customers:boolean',
            'taxItem' => 'core:RecordRef',
            'taxRate' => 'customers:double',
            'unapplied' => 'customers:double',
            'autoApply' => 'customers:boolean',
            'applied' => 'customers:double',
            'toBePrinted' => 'customers:boolean',
            'toBeEmailed' => 'customers:boolean',
            'email' => 'customers:string',
            'toBeFaxed' => 'customers:boolean',
            'fax' => 'customers:string',
            'messageSel' => 'core:RecordRef',
            'message' => 'customers:string',
            'billAddressList' => 'core:RecordRef',
            'billAddress' => 'customers:string',
            'shipMethod' => 'core:RecordRef',
            'shippingCost' => 'customers:double',
            'shippingTax1Rate' => 'customers:double',
            'shippingTaxCode' => 'core:RecordRef',
            'handlingTaxCode' => 'core:RecordRef',
            'handlingTax1Rate' => 'customers:double',
            'handlingCost' => 'customers:double',
            'subTotal' => 'customers:double',
            'discountTotal' => 'customers:double',
            'taxTotal' => 'customers:double',
            'tax2Total' => 'customers:double',
            'altShippingCost' => 'customers:double',
            'altHandlingCost' => 'customers:double',
            'total' => 'customers:double',
            'salesGroup' => 'core:RecordRef',
            'syncSalesTeams' => 'customers:boolean',
            'status' => 'customers:string',
            'giftCert' => 'core:RecordRef',
            'giftCertTotal' => 'customers:double',
            'giftCertApplied' => 'customers:double',
            'giftCertAvailable' => 'customers:double',
            'tranIsVsoeBundle' => 'customers:boolean',
            'vsoeAutoCalc' => 'customers:boolean',
            'salesTeamList' => 'customers:CreditMemoSalesTeamList',
            'itemList' => 'customers:CreditMemoItemList',
            'applyList' => 'customers:CreditMemoApplyList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CreditMemoSalesTeam => {
            'employee' => 'core:RecordRef',
            'salesRole' => 'core:RecordRef',
            'isPrimary' => 'customers:boolean',
            'contribution' => 'customers:double',
        },
    
        CreditMemoSalesTeamList => {
            'salesTeam' => 'customers:CreditMemoSalesTeam',
        },
    
        CreditMemoItem => {
            'item' => 'core:RecordRef',
            'orderLine' => 'customers:long',
            'line' => 'long',
            'quantity' => 'customers:double',
            'description' => 'customers:string',
            'price' => 'core:RecordRef',
            'rate' => 'customers:string',
            'amount' => 'customers:double',
            'isTaxable' => 'customers:boolean',
            'options' => 'core:CustomFieldList',
            'customFieldList' => 'core:CustomFieldList',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'customers:double',
            'taxRate2' => 'customers:double',
            'tax1Amt' => 'customers:double',
            'grossAmt' => 'customers:double',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'revRecSchedule' => 'core:RecordRef',
            'revRecStartDate' => 'customers:dateTime',
            'revRecTermInMonths' => 'customers:long',
            'revRecEndDate' => 'customers:dateTime',
            'units' => 'core:RecordRef',
            'serialNumbers' => 'core:RecordRef',
            'deferRevRec' => 'customers:boolean',
            'giftCertFrom' => 'customers:string',
            'giftCertRecipientName' => 'customers:string',
            'giftCertRecipientEmail' => 'customers:string',
            'giftCertMessage' => 'customers:string',
            'giftCertNumber' => 'customers:string',
            'vsoePrice' => 'customers:double',
            'vsoeAmount' => 'customers:double',
            'vsoeAllocation' => 'customers:double',
            'vsoeDeferral' => 'commonTyp:VsoeDeferral',
            'vsoePermitDiscount' => 'commonTyp:VsoePermitDiscount',
            'vsoeDelivered' => 'customers:boolean',
        },
    
        CreditMemoItemList => {
            'item' => 'customers:CreditMemoItem',
        },
    
        CreditMemoApply => {
            'apply' => 'customers:boolean',
            'doc' => 'customers:long',
            'date' => 'customers:dateTime',
            'job' => 'customers:string',
            'type' => 'customers:string',
            'refNum' => 'customers:string',
            'total' => 'customers:double',
            'due' => 'customers:double',
            'currency' => 'customers:string',
            'amount' => 'customers:double',
            'line' => 'customers:long',
        },
    
        CreditMemoApplyList => {
            'apply' => 'customers:CreditMemoApply',
        },
    
        CustomerRefund => {
            'createdDate' => 'customers:dateTime',
            'lastModifiedDate' => 'customers:dateTime',
            'status' => 'customers:string',
            'customer' => 'core:RecordRef',
            'balance' => 'customers:double',
            'arAcct' => 'core:RecordRef',
            'currencyName' => 'customers:string',
            'exchangeRate' => 'customers:double',
            'address' => 'customers:string',
            'total' => 'customers:double',
            'tranDate' => 'customers:dateTime',
            'postingPeriod' => 'core:RecordRef',
            'memo' => 'customers:string',
            'paymentMethod' => 'core:RecordRef',
            'account' => 'core:RecordRef',
            'toBePrinted' => 'customers:boolean',
            'tranId' => 'customers:string',
            'debitCardIssueNo' => 'customers:string',
            'creditCardProcessor' => 'core:RecordRef',
            'chargeIt' => 'customers:boolean',
            'pnRefNum' => 'customers:string',
            'validFrom' => 'customers:dateTime',
            'creditCard' => 'core:RecordRef',
            'ccNumber' => 'customers:string',
            'ccExpireDate' => 'customers:dateTime',
            'ccName' => 'customers:string',
            'ccStreet' => 'customers:string',
            'ccZipCode' => 'customers:string',
            'ccApproved' => 'customers:boolean',
            'applyList' => 'customers:CustomerRefundApplyList',
        },
    
        CustomerRefundApply => {
            'apply' => 'customers:boolean',
            'doc' => 'customers:long',
            'date' => 'customers:dateTime',
            'type' => 'customers:string',
            'refNum' => 'customers:string',
            'total' => 'customers:double',
            'due' => 'customers:double',
            'currency' => 'customers:string',
            'amount' => 'customers:double',
        },
    
        CustomerRefundApplyList => {
            'apply' => 'customers:CustomerRefundApply',
        },
    
        CustomerDeposit => {
            'createdDate' => 'customers:dateTime',
            'lastModifiedDate' => 'customers:dateTime',
            'status' => 'customers:string',
            'customer' => 'core:RecordRef',
            'payment' => 'customers:double',
            'tranDate' => 'customers:dateTime',
            'postingPeriod' => 'core:RecordRef',
            'paymentMethod' => 'core:RecordRef',
            'memo' => 'customers:string',
            'currencyName' => 'customers:string',
            'exchangeRate' => 'customers:double',
            'checkNum' => 'customers:string',
            'creditCardProcessor' => 'core:RecordRef',
            'creditCard' => 'core:RecordRef',
            'ccSecurityCode' => 'customers:string',
            'ccNumber' => 'customers:string',
            'ccExpireDate' => 'customers:dateTime',
            'debitCardIssueNo' => 'customers:string',
            'validFrom' => 'customers:dateTime',
            'ccName' => 'customers:string',
            'ccStreet' => 'customers:string',
            'ccZipCode' => 'customers:string',
            'chargeIt' => 'customers:boolean',
            'ccApproved' => 'customers:boolean',
            'pnRefNum' => 'customers:string',
            'authCode' => 'customers:string',
            'ccAvsStreetMatch' => 'commonTypes:AvsMatchCode',
            'softDescriptor' => 'customers:string',
            'ccAvsZipMatch' => 'commonTypes:AvsMatchCode',
            'ccSecurityCodeMatch' => 'commonTypes:AvsMatchCode',
            'account' => 'core:RecordRef',
            'undepFunds' => 'customers:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        DepositApplication => {
            'createdDate' => 'customers:dateTime',
            'lastModifiedDate' => 'customers:dateTime',
            'status' => 'customers:string',
            'customer' => 'core:RecordRef',
            'tranDate' => 'customers:dateTime',
            'postingPeriod' => 'core:RecordRef',
            'deposit' => 'core:RecordRef',
            'depDate' => 'customers:dateTime',
            'currency' => 'core:RecordRef',
            'exchangeRate' => 'customers:double',
            'memo' => 'customers:string',
            'total' => 'customers:double',
            'applied' => 'customers:double',
            'unapplied' => 'customers:double',
            'applyList' => 'customers:DepositApplicationApplyList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        DepositApplicationApply => {
            'doc' => 'customers:long',
            'apply' => 'customers:boolean',
            'date' => 'customers:dateTime',
            'job' => 'customers:string',
            'type' => 'customers:string',
            'refNum' => 'customers:string',
            'total' => 'customers:double',
            'due' => 'customers:double',
            'currency' => 'customers:string',
            'amount' => 'customers:double',
        },
    
        DepositApplicationApplyList => {
            'apply' => 'customers:DepositApplicationApply',
        },
    
        LandedCost => {
            'category' => 'core:RecordRef',
            'amount' => 'bank:double',
            'source' => 'bankTypes:LandedCostSource',
            'transaction' => 'core:RecordRef',
        },
    
        LandedCostList => {
            'landedCost' => 'bank:LandedCost',
        },
    
        Check => {
            'createdDate' => 'bank:dateTime',
            'lastModifiedDate' => 'bank:dateTime',
            'customForm' => 'core:RecordRef',
            'account' => 'core:RecordRef',
            'entity' => 'core:RecordRef',
            'address' => 'bank:string',
            'postingPeriod' => 'core:RecordRef',
            'tranDate' => 'bank:dateTime',
            'currency' => 'core:RecordRef',
            'exchangeRate' => 'bank:double',
            'toBePrinted' => 'bank:boolean',
            'tranId' => 'bank:string',
            'memo' => 'bank:string',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'userTotal' => 'bank:double',
            'landedCostMethod' => 'bankTypes:LandedCostMethod',
            'expenseList' => 'bank:CheckExpenseList',
            'itemList' => 'bank:CheckItemList',
            'landedCostsList' => 'bank:LandedCostList',
            'customFieldList' => 'core:CustomFieldList',
            'billPay' => 'bank:boolean',
        },
    
        CheckExpense => {
            'line' => 'bank:long',
            'category' => 'core:RecordRef',
            'account' => 'core:RecordRef',
            'amount' => 'bank:double',
            'memo' => 'bank:string',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'customer' => 'core:RecordRef',
            'isBillable' => 'bank:boolean',
            'taxCode' => 'core:RecordRef',
            'taxRate1' => 'bank:double',
            'taxRate2' => 'bank:double',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CheckExpenseList => {
            'expense' => 'bank:CheckExpense',
        },
    
        CheckItem => {
            'item' => 'core:RecordRef',
            'line' => 'long',
            'quantity' => 'bank:double',
            'units' => 'core:RecordRef',
            'description' => 'bank:string',
            'binNumbers' => 'bank:string',
            'serialNumbers' => 'bank:string',
            'expirationDate' => 'bank:dateTime',
            'rate' => 'bank:string',
            'amount' => 'bank:double',
            'options' => 'core:CustomFieldList',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'customer' => 'core:RecordRef',
            'isBillable' => 'bank:boolean',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CheckItemList => {
            'item' => 'bank:CheckItem',
        },
    
        InventoryAdjustment => {
            'postingPeriod' => 'core:RecordRef',
            'tranDate' => 'inventory:dateTime',
            'tranId' => 'inventory:string',
            'account' => 'core:RecordRef',
            'estimatedTotalValue' => 'inventory:double',
            'customer' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'memo' => 'inventory:string',
            'inventoryList' => 'inventory:InventoryAdjustmentInventoryList',
        },
    
        InventoryAdjustmentInventory => {
            'item' => 'core:RecordRef',
            'description' => 'inventory:string',
            'location' => 'core:RecordRef',
            'units' => 'core:RecordRef',
            'qtyOnHand' => 'inventory:double',
            'currentValue' => 'inventory:double',
            'adjustQtyBy' => 'inventory:double',
            'binNumbers' => 'inventory:string',
            'serialNumbers' => 'inventory:string',
            'newQty' => 'inventory:double',
            'unitCost' => 'inventory:double',
            'memo' => 'inventory:string',
            'expirationDate' => 'inventory:dateTime',
        },
    
        InventoryAdjustmentInventoryList => {
            'inventory' => 'inventory:InventoryAdjustmentInventory',
        },
    
        JournalEntry => {
            'postingPeriod' => 'core:RecordRef',
            'tranDate' => 'general:dateTime',
            'currency' => 'core:RecordRef',
            'exchangeRate' => 'general:double',
            'tranId' => 'general:string',
            'reversalDate' => 'general:dateTime',
            'reversalDefer' => 'general:boolean',
            'reversalEntry' => 'general:string',
            'createdFrom' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'approved' => 'general:boolean',
            'createdDate' => 'general:dateTime',
            'lastModifiedDate' => 'general:dateTime',
            'lineList' => 'general:JournalEntryLineList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        JournalEntryLine => {
            'account' => 'core:RecordRef',
            'debit' => 'general:double',
            'credit' => 'general:double',
            'memo' => 'general:string',
            'entity' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'schedule' => 'core:RecordRef',
            'startDate' => 'general:dateTime',
            'endDate' => 'general:dateTime',
            'residual' => 'general:string',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        JournalEntryLineList => {
            'line' => 'general:JournalEntryLine',
        },
    
        InterCompanyJournalEntry => {
            'postingPeriod' => 'core:RecordRef',
            'tranDate' => 'general:dateTime',
            'currency' => 'core:RecordRef',
            'exchangeRate' => 'general:double',
            'tranId' => 'general:string',
            'reversalDate' => 'general:dateTime',
            'reversalDefer' => 'general:boolean',
            'parentExpenseAlloc' => 'core:RecordRef',
            'reversalEntry' => 'general:string',
            'createdFrom' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'toSubsidiary' => 'core:RecordRef',
            'approved' => 'general:boolean',
            'createdDate' => 'general:dateTime',
            'lastModifiedDate' => 'general:dateTime',
            'lineList' => 'general:InterCompanyJournalEntryLineList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        InterCompanyJournalEntryLine => {
            'subsidiary' => 'core:RecordRef',
            'account' => 'core:RecordRef',
            'debit' => 'general:double',
            'credit' => 'general:double',
            'memo' => 'general:string',
            'entity' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'amortizationSched' => 'core:RecordRef',
            'amortizStartDate' => 'general:dateTime',
            'amortizationEndDate' => 'general:dateTime',
            'amortizationResidual' => 'general:string',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        InterCompanyJournalEntryLineList => {
            'line' => 'general:InterCompanyJournalEntryLine',
        },
    
        CustomRecord => {
            'customRecordId' => 'customization:string',
            'customForm' => 'core:RecordRef',
            'isInactive' => 'customization:boolean',
            'created' => 'customization:dateTime',
            'lastModified' => 'customization:dateTime',
            'name' => 'customization:string',
            'owner' => 'core:RecordRef',
            'recType' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CustomList => {
            'name' => 'customization:string',
            'isOrdered' => 'customization:boolean',
            'isMatrixOption' => 'customization:boolean',
            'convertToCustomRecord' => 'customization:boolean',
            'isInactive' => 'customization:boolean',
            'customValueList' => 'customization:CustomListCustomValueList',
        },
    
        CustomListCustomValue => {
            'value' => 'customization:string',
            'abbreviation' => 'customization:string',
            'isInactive' => 'customization:boolean',
            'valueId' => 'core:RecordRef',
        },
    
        CustomListCustomValueList => {
            'customValue' => 'customization:CustomListCustomValue',
        },
    
        CustomRecordType => {
            'recordName' => 'customization:string',
            'includeName' => 'customization:boolean',
            'showId' => 'customization:boolean',
            'showCreationDate' => 'customization:boolean',
            'showCreationDateOnList' => 'customization:boolean',
            'showLastModified' => 'customization:boolean',
            'showLastModifiedOnList' => 'customization:boolean',
            'showOwner' => 'customization:boolean',
            'showOwnerOnList' => 'customization:boolean',
            'showOwnerAllowChange' => 'customization:boolean',
            'usePermissions' => 'customization:boolean',
            'allowAttachments' => 'customization:boolean',
            'showNotes' => 'customization:boolean',
            'enableMailMerge' => 'customization:boolean',
            'isOrdered' => 'customization:boolean',
            'allowInlineEditing' => 'customization:boolean',
            'isAvailableOffline' => 'customization:boolean',
            'allowQuickSearch' => 'customization:boolean',
            'isInactive' => 'customization:boolean',
            'disclaimer' => 'customization:string',
            'enableNumbering' => 'customization:boolean',
            'numberingPrefix' => 'customization:string',
            'numberingSuffix' => 'customization:string',
            'numberingMinDigits' => 'customization:long',
            'numberingInit' => 'customization:long',
            'numberingCurrentNumber' => 'customization:long',
            'allowNumberingOverride' => 'customization:boolean',
            'isNumberingUpdateable' => 'customization:boolean',
            'fieldList' => 'customization:CustomRecordTypeFieldList',
            'tabsList' => 'customization:CustomRecordTypeTabsList',
            'formsList' => 'customization:CustomRecordTypeFormsList',
            'onlineFormsList' => 'customization:CustomRecordTypeOnlineFormsList',
            'permissionsList' => 'customization:CustomRecordTypePermissionsList',
            'linksList' => 'customization:CustomRecordTypeLinksList',
            'managersList' => 'customization:CustomRecordTypeManagersList',
            'childrenList' => 'customization:CustomRecordTypeChildrenList',
            'parentsList' => 'customization:CustomRecordTypeParentsList',
        },
    
        CustomRecordTypeFieldList => {
            'customField' => 'customization:CustomRecordCustomField',
        },
    
        CustomRecordTypeTabs => {
            'tabTitle' => 'customization:string',
            'tabParent' => 'core:RecordRef',
        },
    
        CustomRecordTypeTabsList => {
            'tabs' => 'customization:CustomRecordTypeTabs',
        },
    
        CustomRecordTypeForms => {
            'formEdit' => 'customization:string',
            'formName' => 'customization:string',
            'formPref' => 'customization:boolean',
        },
    
        CustomRecordTypeFormsList => {
            'forms' => 'customization:CustomRecordTypeForms',
        },
    
        CustomRecordTypeOnlineForms => {
            'onlineFormName' => 'customization:string',
            'isOnline' => 'customization:string',
            'templateName' => 'customization:string',
        },
    
        CustomRecordTypeOnlineFormsList => {
            'onlineForms' => 'customization:CustomRecordTypeOnlineForms',
        },
    
        CustomRecordTypePermissions => {
            'permittedRole' => 'core:RecordRef',
            'permittedLevel' => 'customizationTypes:CustomRecordTypePermissionsPermittedLevel',
            'restriction' => 'customizationTypes:CustomRecordTypePermissionsRestriction',
            'defaultForm' => 'core:RecordRef',
            'restrictForm' => 'customization:boolean',
            'searchForm' => 'core:RecordRef',
            'listView' => 'core:RecordRef',
            'listViewRestricted' => 'customization:boolean',
            'dashboardView' => 'core:RecordRef',
            'restrictDashboardView' => 'customization:boolean',
            'sublistView' => 'core:RecordRef',
            'restrictSublistView' => 'customization:boolean',
        },
    
        CustomRecordTypePermissionsList => {
            'permissions' => 'customization:CustomRecordTypePermissions',
        },
    
        CustomRecordTypeLinks => {
            'linkCenter' => 'core:RecordRef',
            'linkSection' => 'core:RecordRef',
            'linkLabel' => 'customization:string',
        },
    
        CustomRecordTypeLinksList => {
            'links' => 'customization:CustomRecordTypeLinks',
        },
    
        CustomRecordTypeManagers => {
            'managerEmp' => 'core:RecordRef',
        },
    
        CustomRecordTypeManagersList => {
            'managers' => 'customization:CustomRecordTypeManagers',
        },
    
        CustomRecordTypeChildren => {
            'childDescr' => 'customization:string',
            'childTab' => 'core:RecordRef',
        },
    
        CustomRecordTypeChildrenList => {
            'children' => 'customization:CustomRecordTypeChildren',
        },
    
        CustomRecordTypeParents => {
            'childDescr' => 'customization:string',
        },
    
        CustomRecordTypeParentsList => {
            'parents' => 'customization:CustomRecordTypeParents',
        },
    
        EntityCustomField => {
            'label' => 'customization:string',
            'fieldType' => 'customizationTypes:CustomizationFieldType',
            'selectRecordType' => 'core:RecordRef',
            'storeValue' => 'customization:boolean',
            'showInList' => 'customization:boolean',
            'isParent' => 'customization:boolean',
            'insertBefore' => 'core:RecordRef',
            'subtab' => 'core:RecordRef',
            'displayType' => 'customizationTypes:CustomizationDisplayType',
            'displayWidth' => 'customization:long',
            'displayHeight' => 'customization:long',
            'help' => 'customization:string',
            'parentSubtab' => 'core:RecordRef',
            'linkText' => 'customization:string',
            'isMandatory' => 'customization:boolean',
            'checkSpelling' => 'customization:boolean',
            'maxLength' => 'customization:long',
            'minValue' => 'customization:double',
            'maxValue' => 'customization:double',
            'defaultChecked' => 'customization:boolean',
            'defaultValue' => 'customization:string',
            'isFormula' => 'customization:boolean',
            'defaultSelection' => 'core:RecordRef',
            'dynamicDefault' => 'customizationTypes:CustomizationDynamicDefault',
            'sourceList' => 'core:RecordRef',
            'sourceFrom' => 'core:RecordRef',
            'sourceFilterBy' => 'core:RecordRef',
            'appliesToCustomer' => 'customization:boolean',
            'appliesToProject' => 'customization:boolean',
            'appliesToVendor' => 'customization:boolean',
            'appliesToEmployee' => 'customization:boolean',
            'appliesToOtherName' => 'customization:boolean',
            'appliesToContact' => 'customization:boolean',
            'appliesToPartner' => 'customization:boolean',
            'appliesToWebSite' => 'customization:boolean',
            'appliesToGroup' => 'customization:boolean',
            'availableExternally' => 'customization:boolean',
            'filterList' => 'customization:EntityCustomFieldFilterList',
        },
    
        EntityCustomFieldFilter => {
            'fldFilter' => 'core:RecordRef',
            'fldFilterChecked' => 'customization:boolean',
            'fldFilterCompareType' => 'customizationTypes:CustomizationFilterCompareType',
            'fldFilterVal' => 'customization:string',
            'fldFilterSelList' => 'customization:FldFilterSelList',
            'fldFilterNotNull' => 'customization:boolean',
        },
    
        EntityCustomFieldFilterList => {
            'filter' => 'customization:EntityCustomFieldFilter',
        },
    
        FldFilterSelList => {
            'fldFilterSel' => 'core:RecordRef',
        },
    
        CrmCustomField => {
            'label' => 'customization:string',
            'fieldType' => 'customizationTypes:CustomizationFieldType',
            'selectRecordType' => 'core:RecordRef',
            'storeValue' => 'customization:boolean',
            'showInList' => 'customization:boolean',
            'isParent' => 'customization:boolean',
            'insertBefore' => 'core:RecordRef',
            'subtab' => 'core:RecordRef',
            'displayType' => 'customizationTypes:CustomizationDisplayType',
            'displayWidth' => 'customization:long',
            'displayHeight' => 'customization:long',
            'help' => 'customization:string',
            'parentSubtab' => 'core:RecordRef',
            'linkText' => 'customization:string',
            'isMandatory' => 'customization:boolean',
            'checkSpelling' => 'customization:boolean',
            'maxLength' => 'customization:long',
            'minValue' => 'customization:double',
            'maxValue' => 'customization:double',
            'defaultChecked' => 'customization:boolean',
            'defaultValue' => 'customization:string',
            'isFormula' => 'customization:boolean',
            'defaultSelection' => 'core:RecordRef',
            'dynamicDefault' => 'customizationTypes:CustomizationDynamicDefault',
            'sourceList' => 'core:RecordRef',
            'sourceFrom' => 'core:RecordRef',
            'sourceFilterBy' => 'core:RecordRef',
            'appliesToTask' => 'customization:boolean',
            'appliesToPhoneCall' => 'customization:boolean',
            'appliesToEvent' => 'customization:boolean',
            'appliesToCase' => 'customization:boolean',
            'appliesToCampaign' => 'customization:boolean',
            'appliesPerKeyword' => 'customization:boolean',
            'appliesToSolution' => 'customization:boolean',
            'appliesToIssue' => 'customization:boolean',
            'availableExternally' => 'customization:boolean',
            'filterList' => 'customization:CrmCustomFieldFilterList',
        },
    
        CrmCustomFieldFilter => {
            'fldFilter' => 'core:RecordRef',
            'fldFilterChecked' => 'customization:boolean',
            'fldFilterCompareType' => 'customizationTypes:CustomizationFilterCompareType',
            'fldFilterVal' => 'customization:string',
            'fldFilterSelList' => 'customization:FldFilterSelList',
            'fldFilterNotNull' => 'customization:boolean',
        },
    
        CrmCustomFieldFilterList => {
            'filter' => 'customization:CrmCustomFieldFilter',
        },
    
        OtherCustomField => {
            'recType' => 'core:RecordRef',
            'label' => 'customization:string',
            'fieldType' => 'customizationTypes:CustomizationFieldType',
            'selectRecordType' => 'core:RecordRef',
            'storeValue' => 'customization:boolean',
            'showInList' => 'customization:boolean',
            'insertBefore' => 'core:RecordRef',
            'displayType' => 'customizationTypes:CustomizationDisplayType',
            'displayWidth' => 'customization:long',
            'displayHeight' => 'customization:long',
            'help' => 'customization:string',
            'linkText' => 'customization:string',
            'isMandatory' => 'customization:boolean',
            'checkSpelling' => 'customization:boolean',
            'maxLength' => 'customization:long',
            'minValue' => 'customization:double',
            'maxValue' => 'customization:double',
            'defaultChecked' => 'customization:boolean',
            'defaultValue' => 'customization:string',
            'isFormula' => 'customization:boolean',
            'defaultSelection' => 'core:RecordRef',
            'dynamicDefault' => 'customizationTypes:CustomizationDynamicDefault',
            'sourceList' => 'core:RecordRef',
            'sourceFrom' => 'core:RecordRef',
            'sourceFilterBy' => 'core:RecordRef',
            'filterList' => 'customization:OtherCustomFieldFilterList',
        },
    
        OtherCustomFieldFilter => {
            'fldFilter' => 'core:RecordRef',
            'fldFilterChecked' => 'customization:boolean',
            'fldFilterCompareType' => 'customizationTypes:CustomizationFilterCompareType',
            'fldFilterVal' => 'customization:string',
            'fldFilterSelList' => 'customization:FldFilterSelList',
            'fldFilterNotNull' => 'customization:boolean',
        },
    
        OtherCustomFieldFilterList => {
            'filter' => 'customization:OtherCustomFieldFilter',
        },
    
        ItemCustomField => {
            'label' => 'customization:string',
            'itemMatrix' => 'customization:boolean',
            'fieldType' => 'customizationTypes:CustomizationFieldType',
            'selectRecordType' => 'core:RecordRef',
            'storeValue' => 'customization:boolean',
            'showInList' => 'customization:boolean',
            'isParent' => 'customization:boolean',
            'insertBefore' => 'core:RecordRef',
            'subtab' => 'core:RecordRef',
            'displayType' => 'customizationTypes:CustomizationDisplayType',
            'displayWidth' => 'customization:long',
            'displayHeight' => 'customization:long',
            'help' => 'customization:string',
            'parentSubtab' => 'core:RecordRef',
            'linkText' => 'customization:string',
            'isMandatory' => 'customization:boolean',
            'checkSpelling' => 'customization:boolean',
            'maxLength' => 'customization:long',
            'minValue' => 'customization:double',
            'maxValue' => 'customization:double',
            'defaultChecked' => 'customization:boolean',
            'defaultValue' => 'customization:string',
            'isFormula' => 'customization:boolean',
            'defaultSelection' => 'core:RecordRef',
            'dynamicDefault' => 'customizationTypes:CustomizationDynamicDefault',
            'sourceList' => 'core:RecordRef',
            'sourceFrom' => 'core:RecordRef',
            'sourceFilterBy' => 'core:RecordRef',
            'appliesToInventory' => 'customization:boolean',
            'appliesToNonInventory' => 'customization:boolean',
            'appliesToService' => 'customization:boolean',
            'appliesToOtherCharge' => 'customization:boolean',
            'appliesToGroup' => 'customization:boolean',
            'appliesToKit' => 'customization:boolean',
            'appliesToItemAssembly' => 'customization:boolean',
            'itemSubType' => 'customizationTypes:ItemCustomFieldItemSubType',
            'filterList' => 'customization:ItemCustomFieldFilterList',
        },
    
        ItemCustomFieldFilter => {
            'fldFilter' => 'core:RecordRef',
            'fldFilterChecked' => 'customization:boolean',
            'fldFilterCompareType' => 'customizationTypes:CustomizationFilterCompareType',
            'fldFilterVal' => 'customization:string',
            'fldFilterSelList' => 'customization:FldFilterSelList',
            'fldFilterNotNull' => 'customization:boolean',
        },
    
        ItemCustomFieldFilterList => {
            'filter' => 'customization:ItemCustomFieldFilter',
        },
    
        TransactionBodyCustomField => {
            'label' => 'customization:string',
            'fieldType' => 'customizationTypes:CustomizationFieldType',
            'selectRecordType' => 'core:RecordRef',
            'storeValue' => 'customization:boolean',
            'showInList' => 'customization:boolean',
            'isParent' => 'customization:boolean',
            'insertBefore' => 'core:RecordRef',
            'subtab' => 'core:RecordRef',
            'displayType' => 'customizationTypes:CustomizationDisplayType',
            'displayWidth' => 'customization:long',
            'displayHeight' => 'customization:long',
            'help' => 'customization:string',
            'parentSubtab' => 'core:RecordRef',
            'linkText' => 'customization:string',
            'isMandatory' => 'customization:boolean',
            'checkSpelling' => 'customization:boolean',
            'maxLength' => 'customization:long',
            'minValue' => 'customization:double',
            'maxValue' => 'customization:double',
            'defaultChecked' => 'customization:boolean',
            'defaultValue' => 'customization:string',
            'isFormula' => 'customization:boolean',
            'defaultSelection' => 'core:RecordRef',
            'dynamicDefault' => 'customizationTypes:CustomizationDynamicDefault',
            'sourceList' => 'core:RecordRef',
            'sourceFrom' => 'core:RecordRef',
            'sourceFilterBy' => 'core:RecordRef',
            'bodyPurchase' => 'customization:boolean',
            'bodySale' => 'customization:boolean',
            'bodyOpportunity' => 'customization:boolean',
            'bodyJournal' => 'customization:boolean',
            'bodyExpenseReport' => 'customization:boolean',
            'bodyStore' => 'customization:boolean',
            'bodyItemReceipt' => 'customization:boolean',
            'bodyItemReceiptOrder' => 'customization:boolean',
            'bodyItemFulfillment' => 'customization:boolean',
            'bodyItemFulfillmentOrder' => 'customization:boolean',
            'bodyInventoryAdjustment' => 'customization:boolean',
            'bodyAssemblyBuild' => 'customization:boolean',
            'bodyPrintFlag' => 'customization:boolean',
            'bodyPickingTicket' => 'customization:boolean',
            'bodyPrintPackingSlip' => 'customization:boolean',
            'bodyPrintStatement' => 'customization:boolean',
            'filterList' => 'customization:TransactionBodyCustomFieldFilterList',
        },
    
        TransactionBodyCustomFieldFilter => {
            'fldFilter' => 'core:RecordRef',
            'fldFilterChecked' => 'customization:boolean',
            'fldFilterCompareType' => 'customizationTypes:CustomizationFilterCompareType',
            'fldFilterVal' => 'customization:string',
            'fldFilterSelList' => 'customization:FldFilterSelList',
            'fldFilterNotNull' => 'customization:boolean',
        },
    
        TransactionBodyCustomFieldFilterList => {
            'filter' => 'customization:TransactionBodyCustomFieldFilter',
        },
    
        TransactionColumnCustomField => {
            'label' => 'customization:string',
            'fieldType' => 'customizationTypes:CustomizationFieldType',
            'selectRecordType' => 'core:RecordRef',
            'storeValue' => 'customization:boolean',
            'insertBefore' => 'core:RecordRef',
            'displayType' => 'customizationTypes:CustomizationDisplayType',
            'displayWidth' => 'customization:long',
            'displayHeight' => 'customization:long',
            'help' => 'customization:string',
            'linkText' => 'customization:string',
            'isMandatory' => 'customization:boolean',
            'maxLength' => 'customization:long',
            'minValue' => 'customization:double',
            'maxValue' => 'customization:double',
            'defaultChecked' => 'customization:boolean',
            'defaultValue' => 'customization:string',
            'isFormula' => 'customization:boolean',
            'defaultSelection' => 'core:RecordRef',
            'dynamicDefault' => 'customizationTypes:CustomizationDynamicDefault',
            'sourceList' => 'core:RecordRef',
            'sourceFrom' => 'core:RecordRef',
            'sourceFilterBy' => 'core:RecordRef',
            'colExpense' => 'customization:boolean',
            'colPurchase' => 'customization:boolean',
            'colSale' => 'customization:boolean',
            'colOpportunity' => 'customization:boolean',
            'colStore' => 'customization:boolean',
            'colStoreHidden' => 'customization:boolean',
            'colJournal' => 'customization:boolean',
            'colExpenseReport' => 'customization:boolean',
            'colTime' => 'customization:boolean',
            'colTimeGroup' => 'customization:boolean',
            'colItemReceipt' => 'customization:boolean',
            'colItemReceiptOrder' => 'customization:boolean',
            'colItemFulfillment' => 'customization:boolean',
            'colItemFulfillmentOrder' => 'customization:boolean',
            'colPrintFlag' => 'customization:boolean',
            'colPickingTicket' => 'customization:boolean',
            'colPackingSlip' => 'customization:boolean',
            'colReturnForm' => 'customization:boolean',
            'colStoreWithGroups' => 'customization:boolean',
            'colGroupOnInvoices' => 'customization:boolean',
            'colKitItem' => 'customization:boolean',
            'filterList' => 'customization:TransactionColumnCustomFieldFilterList',
        },
    
        TransactionColumnCustomFieldFilter => {
            'fldFilter' => 'core:RecordRef',
            'fldFilterChecked' => 'customization:boolean',
            'fldFilterCompareType' => 'customizationTypes:CustomizationFilterCompareType',
            'fldFilterVal' => 'customization:string',
            'fldFilterSelList' => 'customization:FldFilterSelList',
            'fldFilterNotNull' => 'customization:boolean',
        },
    
        TransactionColumnCustomFieldFilterList => {
            'filter' => 'customization:TransactionColumnCustomFieldFilter',
        },
    
        ItemOptionCustomField => {
            'label' => 'customization:string',
            'fieldType' => 'customizationTypes:CustomizationFieldType',
            'selectRecordType' => 'core:RecordRef',
            'storeValue' => 'customization:boolean',
            'insertBefore' => 'core:RecordRef',
            'displayType' => 'customizationTypes:CustomizationDisplayType',
            'displayWidth' => 'customization:long',
            'displayHeight' => 'customization:long',
            'help' => 'customization:string',
            'linkText' => 'customization:string',
            'isMandatory' => 'customization:boolean',
            'maxLength' => 'customization:long',
            'minValue' => 'customization:double',
            'maxValue' => 'customization:double',
            'defaultChecked' => 'customization:boolean',
            'defaultValue' => 'customization:string',
            'isFormula' => 'customization:boolean',
            'defaultSelection' => 'core:RecordRef',
            'dynamicDefault' => 'customizationTypes:CustomizationDynamicDefault',
            'sourceList' => 'core:RecordRef',
            'sourceFrom' => 'core:RecordRef',
            'sourceFilterBy' => 'core:RecordRef',
            'colPurchase' => 'customization:boolean',
            'colSale' => 'customization:boolean',
            'colOpportunity' => 'customization:boolean',
            'colStore' => 'customization:boolean',
            'colStoreHidden' => 'customization:boolean',
            'colAllItems' => 'customization:boolean',
            'itemsList' => 'customization:ItemsList',
            'filterList' => 'customization:ItemOptionCustomFieldFilterList',
        },
    
        ItemsList => {
            'items' => 'core:RecordRef',
        },
    
        ItemOptionCustomFieldFilter => {
            'fldFilter' => 'core:RecordRef',
            'fldFilterChecked' => 'customization:boolean',
            'fldFilterCompareType' => 'customizationTypes:CustomizationFilterCompareType',
            'fldFilterVal' => 'customization:string',
            'fldFilterSelList' => 'customization:FldFilterSelList',
            'fldFilterNotNull' => 'customization:boolean',
        },
    
        ItemOptionCustomFieldFilterList => {
            'filter' => 'customization:ItemOptionCustomFieldFilter',
        },
    
        CustomRecordCustomField => {
            'label' => 'customization:string',
            'fieldType' => 'customizationTypes:CustomizationFieldType',
            'selectRecordType' => 'core:RecordRef',
            'storeValue' => 'customization:boolean',
            'showInList' => 'customization:boolean',
            'isParent' => 'customization:boolean',
            'insertBefore' => 'core:RecordRef',
            'subtab' => 'core:RecordRef',
            'displayType' => 'customizationTypes:CustomizationDisplayType',
            'displayWidth' => 'customization:long',
            'displayHeight' => 'customization:long',
            'help' => 'customization:string',
            'parentSubtab' => 'core:RecordRef',
            'linkText' => 'customization:string',
            'isMandatory' => 'customization:boolean',
            'checkSpelling' => 'customization:boolean',
            'maxLength' => 'customization:long',
            'minValue' => 'customization:double',
            'maxValue' => 'customization:double',
            'defaultChecked' => 'customization:boolean',
            'defaultValue' => 'customization:string',
            'isFormula' => 'customization:boolean',
            'defaultSelection' => 'core:RecordRef',
            'dynamicDefault' => 'customizationTypes:CustomizationDynamicDefault',
            'sourceList' => 'core:RecordRef',
            'sourceFrom' => 'core:RecordRef',
            'sourcefilterby' => 'core:RecordRef',
            'recType' => 'customization:string',
            'filterList' => 'customization:CustomRecordCustomFieldFilterList',
        },
    
        CustomRecordCustomFieldFilter => {
            'fldFilter' => 'core:RecordRef',
            'fldFilterChecked' => 'customization:boolean',
            'fldFilterCompareType' => 'customizationTypes:CustomizationFilterCompareType',
            'fldFilterVal' => 'customization:string',
            'fldFilterSelList' => 'customization:FldFilterSelList',
            'fldFilterNotNull' => 'customization:boolean',
        },
    
        CustomRecordCustomFieldFilterList => {
            'filter' => 'customization:CustomRecordCustomFieldFilter',
        },
    
        Employee => {
            'customForm' => 'core:RecordRef',
            'entityId' => 'employees:string',
            'salutation' => 'employees:string',
            'firstName' => 'employees:string',
            'middleName' => 'employees:string',
            'lastName' => 'employees:string',
            'phone' => 'employees:string',
            'fax' => 'employees:string',
            'email' => 'employees:string',
            'defaultAddress' => 'employees:string',
            'isInactive' => 'employees:boolean',
            'phoneticName' => 'employees:string',
            'lastModifiedDate' => 'employees:dateTime',
            'dateCreated' => 'employees:dateTime',
            'initials' => 'employees:string',
            'officePhone' => 'employees:string',
            'homePhone' => 'employees:string',
            'mobilePhone' => 'employees:string',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'subsidiary' => 'core:RecordRef',
            'billingClass' => 'core:RecordRef',
            'accountNumber' => 'employees:string',
            'comments' => 'employees:string',
            'unsubscribe' => 'employees:boolean',
            'image' => 'core:RecordRef',
            'payFrequency' => 'employeesTypes:EmployeePayFrequency',
            'lastPaidDate' => 'employees:dateTime',
            'useTimeData' => 'employees:boolean',
            'usePerquest' => 'employees:boolean',
            'workplace' => 'core:RecordRef',
            'directDeposit' => 'employees:boolean',
            'expenseLimit' => 'employees:double',
            'purchaseOrderLimit' => 'employees:double',
            'purchaseOrderApprovalLimit' => 'employees:double',
            'socialSecurityNumber' => 'employees:string',
            'supervisor' => 'core:RecordRef',
            'approver' => 'core:RecordRef',
            'approvalLimit' => 'employees:double',
            'timeApprover' => 'core:RecordRef',
            'employeeType' => 'core:RecordRef',
            'isSalesRep' => 'employees:boolean',
            'salesRole' => 'core:RecordRef',
            'isSupportRep' => 'employees:boolean',
            'isJobResource' => 'employees:boolean',
            'laborCost' => 'employees:double',
            'birthDate' => 'employees:dateTime',
            'hireDate' => 'employees:dateTime',
            'releaseDate' => 'employees:dateTime',
            'lastReviewDate' => 'employees:dateTime',
            'nextReviewDate' => 'employees:dateTime',
            'title' => 'employees:string',
            'employeeStatus' => 'core:RecordRef',
            'jobDescription' => 'employees:string',
            'purchaseOrderApprover' => 'core:RecordRef',
            'giveAccess' => 'employees:boolean',
            'concurrentWebServicesUser' => 'employees:boolean',
            'sendEmail' => 'employees:boolean',
            'hasOfflineAccess' => 'employees:boolean',
            'password' => 'employees:string',
            'password2' => 'employees:string',
            'requirePwdChange' => 'employees:boolean',
            'inheritIPRules' => 'employees:boolean',
            'IPAddressRule' => 'employees:string',
            'commissionPaymentPreference' => 'employeesTypes:EmployeeCommissionPaymentPreference',
            'subscriptionsList' => 'employees:EmployeeSubscriptionsList',
            'billPay' => 'employees:boolean',
            'addressbookList' => 'employees:EmployeeAddressbookList',
            'rolesList' => 'employees:EmployeeRolesList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        EmployeeSubscriptions => {
            'subscribed' => 'employees:string',
            'subscription' => 'employees:string',
            'lastModifiedDate' => 'employees:dateTime',
        },
    
        EmployeeSubscriptionsList => {
            'subscriptions' => 'employees:EmployeeSubscriptions',
        },
    
        EmployeeAddressbook => {
            'defaultShipping' => 'employees:boolean',
            'defaultBilling' => 'employees:boolean',
            'label' => 'employees:string',
            'attention' => 'employees:string',
            'addressee' => 'employees:string',
            'phone' => 'employees:string',
            'addr1' => 'employees:string',
            'addr2' => 'employees:string',
            'city' => 'employees:string',
            'state' => 'employees:string',
            'zip' => 'employees:string',
            'country' => 'commonTyp:Country',
            'addrText' => 'employees:string',
            'override' => 'employees:boolean',
            'internalId' => 'employees:string',
        },
    
        EmployeeAddressbookList => {
            'addressbook' => 'employees:EmployeeAddressbook',
        },
    
        EmployeeRoles => {
            'selectedRole' => 'core:RecordRef',
        },
    
        EmployeeRolesList => {
            'roles' => 'employees:EmployeeRoles',
        },
    
        File => {
            'name' => 'filecabinet:string',
            'attachFrom' => 'filecabinetTypes:FileAttachFrom',
            'mediaTypeName' => 'filecabinet:string',
            'fileType' => 'filecabinetTypes:MediaType',
            'content' => 'filecabinet:base64Binary',
            'folder' => 'core:RecordRef',
            'fileSize' => 'filecabinet:double',
            'url' => 'filecabinet:string',
            'description' => 'filecabinet:string',
            'altTagCaption' => 'filecabinet:string',
            'isOnline' => 'filecabinet:boolean',
            'isInactive' => 'filecabinet:boolean',
            'class' => 'filecabinet:string',
            'department' => 'filecabinet:string',
            'isPrivate' => 'filecabinet:boolean',
            'owner' => 'core:RecordRef',
            'caption' => 'filecabinet:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'siteDescription' => 'filecabinet:string',
            'isFeatured' => 'filecabinet:boolean',
            'featuredDescription' => 'filecabinet:string',
            'lastModifiedDate' => 'filecabinet:dateTime',
            'createdDate' => 'filecabinet:dateTime',
            'siteCategoryList' => 'filecabinet:FileSiteCategoryList',
        },
    
        FileSiteCategory => {
            'category' => 'core:RecordRef',
            'categoryDescription' => 'filecabinet:string',
        },
    
        FileSiteCategoryList => {
            'siteCategory' => 'filecabinet:FileSiteCategory',
        },
    
        Folder => {
            'name' => 'filecabinet:string',
            'department' => 'core:RecordRef',
            'description' => 'filecabinet:string',
            'isInactive' => 'filecabinet:boolean',
            'isPrivate' => 'filecabinet:boolean',
            'group' => 'core:RecordRef',
            'parent' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
        },
    
        SiteCategory => {
            'website' => 'core:RecordRef',
            'itemId' => 'website:string',
            'parentCategory' => 'core:RecordRef',
            'categoryListLayout' => 'core:RecordRef',
            'itemListLayout' => 'core:RecordRef',
            'relatedItemsListLayout' => 'core:RecordRef',
            'isOnline' => 'website:boolean',
            'isInactive' => 'website:boolean',
            'description' => 'website:string',
            'storeDetailedDescription' => 'website:string',
            'storeDisplayThumbnail' => 'core:RecordRef',
            'storeDisplayImage' => 'core:RecordRef',
            'pageTitle' => 'website:string',
            'metaTagHtml' => 'website:string',
            'urlComponent' => 'website:string',
            'searchKeywords' => 'website:string',
            'presentationItemList' => 'website:SiteCategoryPresentationItemList',
        },
    
        SiteCategoryPresentationItem => {
            'item' => 'core:RecordRef',
            'itemType' => 'websiteTypes:SiteCategoryPresentationItemItemType',
            'description' => 'website:string',
            'onlinePrice' => 'website:double',
            'basePrice' => 'website:double',
        },
    
        SiteCategoryPresentationItemList => {
            'presentationItem' => 'website:SiteCategoryPresentationItem',
        },
    
        TimeBill => {
            'customForm' => 'core:RecordRef',
            'employee' => 'core:RecordRef',
            'tranDate' => 'employees:dateTime',
            'customer' => 'core:RecordRef',
            'caseTaskEvent' => 'core:RecordRef',
            'isBillable' => 'employees:boolean',
            'payrollItem' => 'core:RecordRef',
            'paidExternally' => 'employees:boolean',
            'item' => 'core:RecordRef',
            'department' => 'core:RecordRef',
            'class' => 'core:RecordRef',
            'location' => 'core:RecordRef',
            'hours' => 'employees:string',
            'price' => 'core:RecordRef',
            'rate' => 'employees:double',
            'overrideRate' => 'employees:boolean',
            'memo' => 'employees:string',
            'supervisorApproval' => 'employees:boolean',
            'createdDate' => 'employees:dateTime',
            'lastModifiedDate' => 'employees:dateTime',
            'status' => 'employees:string',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        Campaign => {
            'customForm' => 'core:RecordRef',
            'campaignId' => 'marketing:string',
            'title' => 'marketing:string',
            'category' => 'core:RecordRef',
            'owner' => 'core:RecordRef',
            'startDate' => 'marketing:dateTime',
            'endDate' => 'marketing:dateTime',
            'url' => 'marketing:string',
            'baseCost' => 'marketing:double',
            'cost' => 'marketing:double',
            'expectedRevenue' => 'marketing:double',
            'message' => 'marketing:string',
            'isInactive' => 'marketing:boolean',
            'totalRevenue' => 'marketing:double',
            'roi' => 'marketing:double',
            'profit' => 'marketing:double',
            'costPerCustomer' => 'marketing:double',
            'convCostPerCustomer' => 'marketing:double',
            'conversions' => 'marketing:long',
            'leadsGenerated' => 'marketing:long',
            'uniqueVisitors' => 'marketing:long',
            'vertical' => 'core:RecordRef',
            'audience' => 'core:RecordRef',
            'offer' => 'core:RecordRef',
            'promotionCode' => 'core:RecordRef',
            'itemList' => 'core:RecordRefList',
            'family' => 'core:RecordRef',
            'searchEngine' => 'core:RecordRef',
            'keyword' => 'marketing:string',
            'campaignEmailList' => 'marketing:CampaignEmailList',
            'campaignDirectMailList' => 'marketing:CampaignDirectMailList',
            'campaignEventList' => 'marketing:CampaignEventList',
            'eventResponseList' => 'marketing:CampaignEventResponseList',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CampaignEmail => {
            'internalId' => 'marketing:string',
            'campaignGroup' => 'core:RecordRef',
            'template' => 'core:RecordRef',
            'description' => 'marketing:string',
            'subscription' => 'core:RecordRef',
            'channel' => 'core:RecordRef',
            'cost' => 'marketing:double',
            'status' => 'marketingTypes:CampaignCampaignEmailStatus',
            'dateScheduled' => 'marketing:dateTime',
            'promoCode' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CampaignEmailList => {
            'campaignEmail' => 'marketing:CampaignEmail',
        },
    
        CampaignDirectMail => {
            'internalId' => 'marketing:string',
            'campaignGroup' => 'core:RecordRef',
            'template' => 'core:RecordRef',
            'description' => 'marketing:string',
            'subscription' => 'core:RecordRef',
            'channel' => 'core:RecordRef',
            'cost' => 'marketing:double',
            'status' => 'marketingTypes:CampaignCampaignDirectMailStatus',
            'dateScheduled' => 'marketing:dateTime',
            'promoCode' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CampaignDirectMailList => {
            'campaignDirectMail' => 'marketing:CampaignDirectMail',
        },
    
        CampaignEvent => {
            'internalId' => 'marketing:string',
            'campaignGroup' => 'core:RecordRef',
            'description' => 'marketing:string',
            'subscription' => 'core:RecordRef',
            'channel' => 'core:RecordRef',
            'cost' => 'marketing:double',
            'status' => 'marketingTypes:CampaignCampaignEventStatus',
            'dateScheduled' => 'marketing:dateTime',
            'promoCode' => 'core:RecordRef',
            'customFieldList' => 'core:CustomFieldList',
        },
    
        CampaignEventList => {
            'campaignEvent' => 'marketing:CampaignEvent',
        },
    
        CampaignEventResponse => {
            'name' => 'marketing:string',
            'type' => 'marketing:string',
            'dateSent' => 'marketing:dateTime',
            'sent' => 'marketing:double',
            'opened' => 'marketing:double',
            'openedRatio' => 'marketing:double',
            'clickThru' => 'marketing:double',
            'clickThruRatio' => 'marketing:double',
            'responded' => 'marketing:long',
            'unsubscribed' => 'marketing:long',
        },
    
        CampaignEventResponseList => {
            'eventResponse' => 'marketing:CampaignEventResponse',
        },
    
        CampaignCategory => {
            'name' => 'marketing:string',
            'parent' => 'core:RecordRef',
            'leadSource' => 'core:RecordRef',
            'description' => 'marketing:string',
            'isexternal' => 'marketing:boolean',
            'isInactive' => 'marketing:boolean',
        },
    
        CampaignAudience => {
            'name' => 'marketing:string',
            'description' => 'marketing:string',
            'isInactive' => 'marketing:boolean',
        },
    
        CampaignFamily => {
            'name' => 'marketing:string',
            'description' => 'marketing:string',
            'isInactive' => 'marketing:boolean',
        },
    
        CampaignSearchEngine => {
            'name' => 'marketing:string',
            'description' => 'marketing:string',
            'isInactive' => 'marketing:boolean',
        },
    
        CampaignChannel => {
            'name' => 'marketing:string',
            'eventType' => 'marketingTypes:CampaignChannelEventType',
            'description' => 'marketing:string',
            'isInactive' => 'marketing:boolean',
        },
    
        CampaignOffer => {
            'name' => 'marketing:string',
            'description' => 'marketing:string',
            'isInactive' => 'marketing:boolean',
        },
    
        CampaignResponse => {
            'entity' => 'core:RecordRef',
            'leadSource' => 'core:RecordRef',
            'campaignEvent' => 'core:RecordRef',
            'campaignResponseDate' => 'marketing:dateTime',
            'channel' => 'marketing:string',
            'response' => 'marketingTypes:CampaignResponseResponse',
            'note' => 'marketing:string',
            'responsesList' => 'marketing:CampaignResponseResponsesList',
        },
    
        CampaignResponseResponses => {
            'response' => 'marketing:string',
            'responseDate' => 'marketing:string',
            'author' => 'marketing:string',
            'note' => 'marketing:string',
        },
    
        CampaignResponseResponsesList => {
            'responses' => 'marketing:CampaignResponseResponses',
        },
    
        CampaignVertical => {
            'name' => 'marketing:string',
            'description' => 'marketing:string',
            'isInactive' => 'marketing:boolean',
        },
    
        CampaignSubscription => {
            'name' => 'marketing:string',
            'description' => 'marketing:string',
            'unsubscribed' => 'marketing:boolean',
            'externalName' => 'marketing:string',
            'externalDescription' => 'marketing:string',
            'isInactive' => 'marketing:boolean',
        },
    
    };
    
}

sub RecordNamespaces {

    return {
        'calendarEvent' => 'scheduling',
        'task' => 'scheduling',
        'phoneCall' => 'scheduling',
        'note' => 'communication',
        'message' => 'communication',
        'contact' => 'relationships',
        'customer' => 'relationships',
        'customerStatus' => 'relationships',
        'partner' => 'relationships',
        'vendor' => 'relationships',
        'entityGroup' => 'relationships',
        'job' => 'relationships',
        'jobType' => 'relationships',
        'jobStatus' => 'relationships',
        'supportCase' => 'support',
        'supportCaseStatus' => 'support',
        'supportCaseType' => 'support',
        'supportCaseOrigin' => 'support',
        'supportCaseIssue' => 'support',
        'supportCasePriority' => 'support',
        'solution' => 'support',
        'topic' => 'support',
        'issue' => 'support',
        'contactCategory' => 'accounting',
        'customerCategory' => 'accounting',
        'salesRole' => 'accounting',
        'priceLevel' => 'accounting',
        'winLossReason' => 'accounting',
        'term' => 'accounting',
        'noteType' => 'accounting',
        'paymentMethod' => 'accounting',
        'leadSource' => 'accounting',
        'inventoryItem' => 'accounting',
        'descriptionItem' => 'accounting',
        'discountItem' => 'accounting',
        'markupItem' => 'accounting',
        'paymentItem' => 'accounting',
        'subtotalItem' => 'accounting',
        'nonInventoryPurchaseItem' => 'accounting',
        'nonInventorySaleItem' => 'accounting',
        'nonInventoryResaleItem' => 'accounting',
        'otherChargeResaleItem' => 'accounting',
        'otherChargePurchaseItem' => 'accounting',
        'serviceResaleItem' => 'accounting',
        'servicePurchaseItem' => 'accounting',
        'serviceSaleItem' => 'accounting',
        'otherChargeSaleItem' => 'accounting',
        'currency' => 'accounting',
        'expenseCategory' => 'accounting',
        'account' => 'accounting',
        'department' => 'accounting',
        'classification' => 'accounting',
        'location' => 'accounting',
        'unitsType' => 'accounting',
        'contactRole' => 'accounting',
        'bin' => 'accounting',
        'salesTaxItem' => 'accounting',
        'taxGroup' => 'accounting',
        'taxType' => 'accounting',
        'serializedInventoryItem' => 'accounting',
        'lotNumberedInventoryItem' => 'accounting',
        'giftCertificateItem' => 'accounting',
        'subsidiary' => 'accounting',
        'giftCertificate' => 'accounting',
        'partnerCategory' => 'accounting',
        'vendorCategory' => 'accounting',
        'opportunity' => 'sales',
        'salesOrder' => 'sales',
        'itemFulfillment' => 'sales',
        'invoice' => 'sales',
        'cashSale' => 'sales',
        'estimate' => 'sales',
        'vendorBill' => 'purchases',
        'purchaseOrder' => 'purchases',
        'itemReceipt' => 'purchases',
        'cashRefund' => 'customers',
        'customerPayment' => 'customers',
        'returnAuthorization' => 'customers',
        'creditMemo' => 'customers',
        'customerRefund' => 'customers',
        'customerDeposit' => 'customers',
        'depositApplication' => 'customers',
        'check' => 'bank',
        'inventoryAdjustment' => 'inventory',
        'journalEntry' => 'general',
        'interCompanyJournalEntry' => 'general',
        'customRecord' => 'customization',
        'customList' => 'customization',
        'customRecordType' => 'customization',
        'entityCustomField' => 'customization',
        'crmCustomField' => 'customization',
        'otherCustomField' => 'customization',
        'itemCustomField' => 'customization',
        'transactionBodyCustomField' => 'customization',
        'transactionColumnCustomField' => 'customization',
        'itemOptionCustomField' => 'customization',
        'customRecordCustomField' => 'customization',
        'employee' => 'employees',
        'siteCategory' => 'website',
        'timeBill' => 'employees',
        'campaign' => 'marketing',
        'campaignCategory' => 'marketing',
        'campaignAudience' => 'marketing',
        'campaignFamily' => 'marketing',
        'campaignSearchEngine' => 'marketing',
        'campaignChannel' => 'marketing',
        'campaignOffer' => 'marketing',
        'campaignResponse' => 'marketing',
        'campaignVertical' => 'marketing',
        'campaignSubscription' => 'marketing',
    };

}

sub SearchNamespaces {

    return {
        'CalendarEventSearch' => 'scheduling',
        'TaskSearch' => 'scheduling',
        'PhoneCallSearch' => 'scheduling',
        'NoteSearch' => 'communication',
        'MessageSearch' => 'communication',
        'ContactSearch' => 'relationships',
        'CustomerSearch' => 'relationships',
        'PartnerSearch' => 'relationships',
        'VendorSearch' => 'relationships',
        'EntityGroupSearch' => 'relationships',
        'JobSearch' => 'relationships',
        'SupportCaseSearch' => 'support',
        'SolutionSearch' => 'support',
        'TopicSearch' => 'support',
        'IssueSearch' => 'support',
        'AccountSearch' => 'accounting',
        'DepartmentSearch' => 'accounting',
        'ClassificationSearch' => 'accounting',
        'LocationSearch' => 'accounting',
        'ItemSearch' => 'accounting',
        'BinSearch' => 'accounting',
        'SubsidiarySearch' => 'accounting',
        'GiftCertificateSearch' => 'accounting',
        'OpportunitySearch' => 'sales',
        'TransactionSearch' => 'sales',
        'CustomRecordSearch' => 'customization',
        'EmployeeSearch' => 'employees',
        'FileSearch' => 'filecabinet',
        'FolderSearch' => 'filecabinet',
        'SiteCategorySearch' => 'website',
        'TimeBillSearch' => 'employees',
        'CampaignSearch' => 'marketing',
    };

}

sub SystemNamespaces {

    return {
        'customersTypes' => 'urn:types.customers_2_6.transactions.webservices.netsuite.com',
        'website' => 'urn:website_2_6.lists.webservices.netsuite.com',
        'sales' => 'urn:sales_2_6.transactions.webservices.netsuite.com',
        'purchasesTypes' => 'urn:types.purchases_2_6.transactions.webservices.netsuite.com',
        'purchases' => 'urn:purchases_2_6.transactions.webservices.netsuite.com',
        'employeesTypes' => 'urn:types.employees_2_6.lists.webservices.netsuite.com',
        'schedulingTypes' => 'urn:types.scheduling_2_6.activities.webservices.netsuite.com',
        'messages' => 'urn:messages_2_6.platform.webservices.netsuite.com',
        'scheduling' => 'urn:scheduling_2_6.activities.webservices.netsuite.com',
        'coreTypes' => 'urn:types.core_2_6.platform.webservices.netsuite.com',
        'bank' => 'urn:bank_2_6.transactions.webservices.netsuite.com',
        'marketing' => 'urn:marketing_2_6.lists.webservices.netsuite.com',
        'filecabinetTypes' => 'urn:types.filecabinet_2_6.documents.webservices.netsuite.com',
        'customers' => 'urn:customers_2_6.transactions.webservices.netsuite.com',
        'accountingTypes' => 'urn:types.accounting_2_6.lists.webservices.netsuite.com',
        'accounting' => 'urn:accounting_2_6.lists.webservices.netsuite.com',
        'support' => 'urn:support_2_6.lists.webservices.netsuite.com',
        'general' => 'urn:general_2_6.transactions.webservices.netsuite.com',
        'core' => 'urn:core_2_6.platform.webservices.netsuite.com',
        'employees' => 'urn:employees_2_6.lists.webservices.netsuite.com',
        'relationships' => 'urn:relationships_2_6.lists.webservices.netsuite.com',
        'communicationTypes' => 'urn:types.communication_2_6.general.webservices.netsuite.com',
        'salesTypes' => 'urn:types.sales_2_6.transactions.webservices.netsuite.com',
        'marketingTypes' => 'urn:types.marketing_2_6.lists.webservices.netsuite.com',
        'inventoryTypes' => 'urn:types.inventory_2_6.transactions.webservices.netsuite.com',
        'customizationTypes' => 'urn:types.customization_2_6.setup.webservices.netsuite.com',
        'filecabinet' => 'urn:filecabinet_2_6.documents.webservices.netsuite.com',
        'inventory' => 'urn:inventory_2_6.transactions.webservices.netsuite.com',
        'websiteTypes' => 'urn:types.website_2_6.lists.webservices.netsuite.com',
        'commonTypes' => 'urn:types.common_2_6.platform.webservices.netsuite.com',
        'common' => 'urn:common_2_6.platform.webservices.netsuite.com',
        'faults' => 'urn:faults_2_6.platform.webservices.netsuite.com',
        'customization' => 'urn:customization_2_6.setup.webservices.netsuite.com',
        'supportTypes' => 'urn:types.support_2_6.lists.webservices.netsuite.com',
        'relationshipsTypes' => 'urn:types.relationships_2_6.lists.webservices.netsuite.com',
        'bankTypes' => 'urn:types.bank_2_6.transactions.webservices.netsuite.com',
        'communication' => 'urn:communication_2_6.general.webservices.netsuite.com',
        'faultsTypes' => 'urn:types.faults_2_6.platform.webservices.netsuite.com',
    };

}

sub StateEnumerations {

    return {
        'AL' => 'Alabama', 
        'AK' => 'Alaska', 
        'AB' => 'Alberta', 
        'AR' => 'Arizona', 
        'AZ' => 'Arkansas', 
        'BC' => 'British Columbia', 
        'CA' => 'California', 
        'CO' => 'Colorado', 
        'CT' => 'Connecticut', 
        'DE' => 'Delaware', 
        'DC' => 'District of Columbia', 
        'FL' => 'Florida', 
        'GA' => 'Georgia', 
        'HI' => 'Hawaii', 
        'ID' => 'Idaho', 
        'IL' => 'Illinois', 
        'IN' => 'Indiana', 
        'IA' => 'Iowa', 
        'KS' => 'Kansas', 
        'KY' => 'Kentucky', 
        'LA' => 'Louisiana', 
        'ME' => 'Maine', 
        'MB' => 'Manitoba', 
        'MD' => 'Maryland', 
        'MA' => 'Massachusetts', 
        'MI' => 'Michigan', 
        'MN' => 'Minnesota', 
        'MS' => 'Mississippi', 
        'MO' => 'Missouri', 
        'MT' => 'Montana', 
        'NE' => 'Nebraska', 
        'NV' => 'Nevada', 
        'NB' => 'New Brunswick', 
        'NH' => 'New Hampshire', 
        'NJ' => 'New Jersey', 
        'NM' => 'New Mexico', 
        'NY' => 'New York', 
        'NL' => 'Newfoundland', 
        'NC' => 'North Carolina', 
        'ND' => 'North Dakota', 
        'NT' => 'North West Territories', 
        'NS' => 'Nova Scotia', 
        'NU' => 'Nunavut', 
        'OH' => 'Ohio', 
        'OK' => 'Oklahoma', 
        'ON' => 'Ontario', 
        'OR' => 'Oregon', 
        'PA' => 'Pennsylvania', 
        'PE' => 'Prince Edward Island', 
        'PR' => 'Puertorico', 
        'QC' => 'Quebec', 
        'RI' => 'Rhode Island', 
        'SK' => 'Saskatchewan', 
        'SC' => 'South Carolina', 
        'SD' => 'South Dakota', 
        'TN' => 'Tennessee', 
        'TX' => 'Texas', 
        'UT' => 'Utah', 
        'VT' => 'Vermont', 
        'VA' => 'Virginia', 
        'WA' => 'Washington', 
        'WV' => 'West Virginia', 
        'WI' => 'Wisconsin', 
        'WY' => 'Wyoming', 
        'YT' => 'Yukon'
    };


}

sub CountryEnumerations {

    return {
        '_afghanistan' => 'Afghanistan', 
        '_albania' => 'Albania', 
        '_algeria' => 'Algeria', 
        '_americanSamoa' => 'American Samoa', 
        '_andorra' => 'Andorra', 
        '_angola' => 'Angola', 
        '_anguilla' => 'Anguilla', 
        '_antarctica' => 'Antarctica', 
        '_antiguaAndBarbuda' => 'Antigua and Barbuda', 
        '_argentina' => 'Argentina', 
        '_armenia' => 'Armenia', 
        '_aruba' => 'Aruba', 
        '_australia' => 'Austrailia', 
        '_austria' => 'Austria', 
        '_azerbaijan' => 'Azerbaijan', 
        '_bahamas' => 'Bahamas', 
        '_bahrain' => 'Bahrain', 
        '_bangladesh' => 'Bangladesh', 
        '_barbados' => 'Barbados', 
        '_belarus' => 'Belarus', 
        '_belgium' => 'Belgium', 
        '_belize' => 'Belize', 
        '_benin' => 'Benin', 
        '_bermuda' => 'Bermuda', 
        '_bhutan' => 'Bhutan', 
        '_bolivia' => 'Bolivia', 
        '_bosniaAndHerzegovina' => 'Bosnia and Herzegobina', 
        '_botswana' => 'Botswana', 
        '_bouvetIsland' => 'Bouvet Island', 
        '_brazil' => 'Brazil', 
        '_britishIndianOceanTerritory' => 'British Indian Ocean Territory', 
        '_bruneiDarussalam' => 'Brunei Darussalam', 
        '_bulgaria' => 'Bulgaria', 
        '_burkinaFaso' => 'Burkina Faso', 
        '_burundi' => 'Burundi', 
        '_cambodia' => 'Cambodia', 
        '_cameroon' => 'Cameroon', 
        '_canada' => 'Canada', 
        '_capVerde' => 'Cap Verde', 
        '_caymanIslands' => 'Cayman Islands', 
        '_centralAfricanRepublic' => 'Central African Republic', 
        '_chad' => 'Chad', 
        '_chile' => 'Chile', 
        '_china' => 'China', 
        '_christmasIsland' => 'Christmas Island', 
        '_cocosKeelingIslands' => 'Cocos (Keeling) Islands', 
        '_colombia' => 'Colombia', 
        '_comoros' => 'Comoros', 
        '_congoDemocraticPeoplesRepublic' => 'Congo, Democratic People.s Republic', 
        '_congoRepublicOf' => 'Congo, Republic of', 
        '_cookIslands' => 'Cook Islands', 
        '_costaRica' => 'Costa Rica', 
        '_coteDIvoire' => 'Cote d.Ivoire', 
        '_croatiaHrvatska' => 'Croatia/Hrvatska', 
        '_cuba' => 'Cuba', 
        '_cyprus' => 'Cyprus', 
        '_czechRepublic' => 'Czech Republic', 
        '_denmark' => 'Denmark', 
        '_djibouti' => 'Djibouti', 
        '_dominica' => 'Domenica', 
        '_dominicanRepublic' => 'Dominican Republic', 
        '_eastTimor' => 'East Timor', 
        '_ecuador' => 'Ecuador', 
        '_egypt' => 'Egypt', 
        '_elSalvador' => 'El Salvador', 
        '_equatorialGuinea' => 'Equatorial Guinea', 
        '_eritrea' => 'Eritrea', 
        '_estonia' => 'Estonia', 
        '_ethiopia' => 'Ethiopia', 
        '_falklandIslandsMalvina' => 'Falkland Islands (Malvina)', 
        '_faroeIslands' => 'Faroe Islands', 
        '_fiji' => 'Fiji', 
        '_finland' => 'Finland', 
        '_france' => 'France', 
        '_frenchGuiana' => 'French Guiana', 
        '_frenchPolynesia' => 'French Polynesia', 
        '_frenchSouthernTerritories' => 'French Southern Territories', 
        '_gabon' => 'Gabon', 
        '_gambia' => 'Gambia', 
        '_georgia' => 'Georgia', 
        '_germany' => 'Germany', 
        '_ghana' => 'Ghana', 
        '_gibraltar' => 'Gibraltar', 
        '_greece' => 'Greece', 
        '_greenland' => 'Greenland', 
        '_grenada' => 'Grenada', 
        '_guadeloupe' => 'Guadeloupe', 
        '_guam' => 'Guam', 
        '_guatemala' => 'Guatemala', 
        '_guernsey' => 'Guernsey', 
        '_guinea' => 'Guinea', 
        '_guineaBissau' => 'Guinea-Bissau', 
        '_guyana' => 'Guyana', 
        '_haiti' => 'Haiti', 
        '_heardAndMcDonaldIslands' => 'Heard and McDonald Is.', 
        '_holySeeCityVaticanState' => 'Holy See (City Vatican State)', 
        '_honduras' => 'Honduras', 
        '_hongKong' => 'Hong Kong', 
        '_hungary' => 'Hungary', 
        '_iceland' => 'Iceland', 
        '_india' => 'India', 
        '_indonesia' => 'Indonesia', 
        '_iranIslamicRepublicOf' => 'Iran, Islamic Republic of', 
        '_iraq' => 'Iraq', 
        '_ireland' => 'Ireland', 
        '_isleOfMan' => 'Isle of Man', 
        '_israel' => 'Israel', 
        '_italy' => 'Italy', 
        '_jamaica' => 'Jamaica', 
        '_japan' => 'Japan', 
        '_jersey' => 'Jersey', 
        '_jordan' => 'Jordan', 
        '_kazakhstan' => 'Kazakhstan', 
        '_kenya' => 'Kenya', 
        '_kiribati' => 'Kiribati', 
        '_koreaDemocraticPeoplesRepublic' => 'Korea, Democratic People.s Republic', 
        '_koreaRepublicOf' => 'Korea, Republic of', 
        '_kuwait' => 'Kuwait', 
        '_kyrgyzstan' => 'Krgyzstan', 
        '_laoPeoplesDemocraticRepublic' => 'Lao, People.s Democratic Republic', 
        '_latvia' => 'Latvia', 
        '_lebanon' => 'Lebanon', 
        '_lesotho' => 'Lesotho', 
        '_liberia' => 'Liberia', 
        '_libyanArabJamahiriya' => 'Libyan Arab Jamahiriya', 
        '_liechtenstein' => 'Liechtenstein', 
        '_lithuania' => 'Lithuania', 
        '_luxembourg' => 'Luxembourg', 
        '_macau' => 'Macau', 
        '_macedonia' => 'Macedonia', 
        '_madagascar' => 'Madagascar', 
        '_malawi' => 'Malawi', 
        '_malaysia' => 'Malaysia', 
        '_maldives' => 'Maldives', 
        '_mali' => 'Mali', 
        '_malta' => 'Malta', 
        '_marshallIslands' => 'Marshall Islands', 
        '_martinique' => 'Martinique', 
        '_mauritania' => 'Mauritania', 
        '_mauritius' => 'Mauritius', 
        '_mayotte' => 'Mayotte', 
        '_mexico' => 'Mexico', 
        '_micronesiaFederalStateOf' => 'Micronesia, Federal State of', 
        '_moldovaRepublicOf' => 'Moldova, Republic of', 
        '_monaco' => 'Monaco', 
        '_mongolia' => 'Mongolia', 
        '_montserrat' => 'Montserrat', 
        '_morocco' => 'Morocco', 
        '_mozambique' => 'Mozambique', 
        '_myanmar' => 'Myanmar', 
        '_namibia' => 'Namibia', 
        '_nauru' => 'Nauru', 
        '_nepal' => 'Nepal', 
        '_netherlands' => 'Netherlands', 
        '_netherlandsAntilles' => 'Netherlands Antilles', 
        '_newCaledonia' => 'New Caledonia', 
        '_newZealand' => 'New Zealand', 
        '_nicaragua' => 'Nicaragua', 
        '_niger' => 'Niger', 
        '_nigeria' => 'Nigeria', 
        '_niue' => 'Niue', 
        '_norfolkIsland' => 'Norfolk Island', 
        '_northernMarianaIslands' => 'Northern Mariana Islands', 
        '_norway' => 'Norway', 
        '_oman' => 'Oman', 
        '_pakistan' => 'Pakistan', 
        '_palau' => 'Palau', 
        '_palestinianTerritories' => 'Palestinian Territories', 
        '_panama' => 'Panama', 
        '_papuaNewGuinea' => 'Papua New Guinea', 
        '_paraguay' => 'Paraguay', 
        '_peru' => 'Peru', 
        '_philippines' => 'Philppines', 
        '_pitcairnIsland' => 'Pitcairn Island', 
        '_poland' => 'Poland', 
        '_portugal' => 'Portugal', 
        '_puertoRico' => 'Puerto Rico', 
        '_qatar' => 'Qatar', 
        '_reunionIsland' => 'Reunion Island', 
        '_romania' => 'Romania', 
        '_russianFederation' => 'Russian Federation', 
        '_rwanda' => 'Rwanda', 
        '_saintKittsAndNevis' => 'Saint Kitts and Nevis', 
        '_saintLucia' => 'Saint Lucia', 
        '_saintVincentAndTheGrenadines' => 'Saint Vincent and the Grenadines', 
        '_sanMarino' => 'San Marino', 
        '_saoTomeAndPrincipe' => 'Sao Tome and Principe', 
        '_saudiArabia' => 'Saudi Arabia', 
        '_senegal' => 'Senegal', 
        '_serbiaAndMontenegro' => 'Serbia And Montenegro', 
        '_seychelles' => 'Seychelles', 
        '_sierraLeone' => 'Sierra Leone', 
        '_singapore' => 'Singapore', 
        '_slovakRepublic' => 'Slovak Republic', 
        '_slovenia' => 'Slovenia', 
        '_solomonIslands' => 'Solomon Islands', 
        '_somalia' => 'Somalia', 
        '_southAfrica' => 'South Africa', 
        '_southGeorgia' => 'South Georgia', 
        '_spain' => 'Spain', 
        '_sriLanka' => 'Sri Lanka', 
        '_stHelena' => 'St. Helena', 
        '_stPierreAndMiquelon' => 'St. Pierre and Miquelon', 
        '_sudan' => 'Sudan', 
        '_suriname' => 'Suriname', 
        '_svalbardAndJanMayenIslands' => 'Svalbard and Jan Mayen Islands', 
        '_swaziland' => 'Swaziland', 
        '_sweden' => 'Sweden', 
        '_switzerland' => 'Switzerland', 
        '_syrianArabRepublic' => 'Syrian Arab Republic', 
        '_taiwan' => 'Taiwan', 
        '_tajikistan' => 'Tajikistan', 
        '_tanzania' => 'Tanzania', 
        '_thailand' => 'Thailand', 
        '_togo' => 'Togo', 
        '_tokelau' => 'Tokelau', 
        '_tonga' => 'Tonga', 
        '_trinidadAndTobago' => 'Trinidad and Tobago', 
        '_tunisia' => 'Tunisia', 
        '_turkey' => 'Turkey', 
        '_turkmenistan' => 'Turkmenistan', 
        '_turksAndCiacosIslands' => 'Turks and Ciacos Islands', 
        '_tuvalu' => 'Tuvalu', 
        '_uganda' => 'Uganda', 
        '_ukraine' => 'Ukraine', 
        '_unitedArabEmirates' => 'United Arab Emirates', 
        '_unitedKingdom' => 'United Kingdom', 
        '_unitedKingdomGB' => 'United Kingdom (GB)', 
        '_unitedStates' => 'United States', 
        '_uruguay' => 'Uruguay', 
        '_uSMinorOutlyingIslands' => 'US Minor Outlying Islands', 
        '_uzbekistan' => 'Uzbekistan', 
        '_vanuatu' => 'Vanuatu', 
        '_venezuela' => 'Venezuela', 
        '_vietnam' => 'Vietnam', 
        '_virginIslandsBritish' => 'Virgin Islands, British', 
        '_virginIslandsUSA' => 'Virgin Islands, USA', 
        '_wallisAndFutunaIslands' => 'Wallis and Futuna Islands', 
        '_westernSahara' => 'Western Sahara', 
        '_westernSamoa' => 'Western Samoa', 
        '_yemen' => 'Yemen', 
        '_yugoslavia' => 'Yugoslavia', 
        '_zambia' => 'Zambia', 
        '_zimbabwe' => 'Zimbabwe'
    };

}
1;
