use lib '.';
use t::Util;
use App::git::ship::perl;

t::Util->goto_workdir('perl-changelogmd', 0);
my $app = App::git::ship->new;

my $upload_file = '';
eval <<'DUMMY' or die $@;
package CPAN::Uploader;
sub new { bless $_[1], $_[0] }
sub read_config_file { {} }
sub upload_file { $upload_file = $_[1] }
$INC{'CPAN/Uploader.pm'} = 'dummy';
DUMMY

{
  $app = $app->start('Perl/Changelogmd.pm', 0);
  ok -e 'Changes', 'Changes was generated by start';
  unlink 'Changes';
  write_alien_files();

  diag 'Build';
  $app->config(new_version_format => '## %v (%F)');
  eval { $app->ship };
  like $@, qr{Project built}, 'Project built';
  is $upload_file, '', 'CPAN::Uploader did not upload anything';

  local @ARGV = ('CHANGELOG.md');
  my $changes = do { local $/; <>; };

  like $changes, qr{^\#\#\s0\.04\s\(\w+}s, 'changes was updated with timestamp';
}

{
  diag 'Ship';
  $upload_file = '';
  eval { $app->ship };
  is $@, '', 'no ship error';
  like $upload_file, qr{\bPerl-Changelogmd-0\.04\.tar\.gz$}, 'CPAN::Uploader uploaded version 0.04';

  ok !-e 'Changes', 'Changes is not here';
  ok !-e 'README',  'README is not here';
}

done_testing;

sub write_alien_files {
  diag 'Init alien files';

  open my $CHANGES, '>', 'CHANGELOG.md';
  print $CHANGES "## 0.04\n- Some changes\n";

  open my $README, '>', 'README.md';
  print $README "Too cool project!\n";

  open my $MAIN_MODULE, '>', File::Spec->catfile(qw(lib Perl Changelogmd.pm)) or die $!;
  print $MAIN_MODULE "package Perl::Changelogmd;\n=head1 NAME\n\nPerl::Changelogmd\n\n=head1 VERSION\n\n0.00\n\n=cut\n\nour \$VERSION = '42';\n\n1";
}
