#!/usr/bin/perl -w

BEGIN {
    if( $ENV{PERL_CORE} ) {
        chdir 't';
        @INC = ('../lib', 'lib');
    }
    else {
        unshift @INC, 't/lib';
    }
}

use File::Spec::Functions;

my $SAMPLE_TESTS = $ENV{PERL_CORE}
    ? catdir(curdir(), 'lib', 'sample-tests')
    : catdir(curdir(), 't', 'sample-tests');

use Test::More;

%samples = (
            bailout     => [qw( header test test test bailout )],
            combined    => ['header', ('test') x 10],
            descriptive => ['header', ('test') x 5 ],
            duplicates  => ['header', ('test') x 11 ],
            head_end    => [qw( other test test test test 
                                other header other other )],
            head_fail   => [qw( other test test test test
                                other header other other )],
            no_nums     => ['header', ('test') x 5 ],
            out_of_order=> [('test') x 10, 'header', ('test') x 5],
            simple      => [qw( header test test test test test )],
            simple_fail => [qw( header test test test test test )],
            'skip'      => [qw( header test test test test test )],
            skipall     => [qw( header )],
            skipall_nomsg => [qw( header )],
            skip_nomsg  => [qw( header test )],
            taint       => [qw( header test )],
            'todo'      => [qw( header test test test test test )],
            todo_inline => [qw( header test test test )],
            vms_nit     => [qw( header other test test )],
            with_comments => [qw( other header other test other test test
                                  test other other test other )],
           );

plan tests => scalar keys %samples;

use Test::Harness::Straps;
my $strap = Test::Harness::Straps->new;
$strap->{callback} = sub {
    my($self, $line, $type, $totals) = @_;
    push @out, $type;
};
                            
$SAMPLE_TESTS = VMS::Filespec::unixify($SAMPLE_TESTS) if $^O eq 'VMS';

while( my($test, $expect) = each %samples ) {
    local @out = ();

    $strap->analyze_file($^O eq 'macos' ?
			 catfile($SAMPLE_TESTS, $test) :
			 "$SAMPLE_TESTS/$test");

    is_deeply(\@out, $expect,   "$test callback");
}
