package Locale::CLDR::Mn;
# This file auto generated from Data\common\main\mn.xml
#	on Thu  2 Oct 12:58:11 pm GMT
# XML file generated 2014-08-14 15:10:07 -0500 (Thu, 14 Aug 2014)

use version;

our $VERSION = version->declare('v0.26.0');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'абхаз',
 				'af' => 'африк',
 				'agq' => 'агем',
 				'ak' => 'акан',
 				'am' => 'амхар',
 				'ar' => 'араб',
 				'ar_001' => 'стандарт араб',
 				'arn' => 'мапүчи',
 				'as' => 'ассам',
 				'asa' => 'асу',
 				'az' => 'азербайжан',
 				'az@alt=short' => 'азери',
 				'ba' => 'башкир',
 				'be' => 'беларусь',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bg' => 'болгар',
 				'bm' => 'бамбара',
 				'bn' => 'бенгал',
 				'bo' => 'төвд',
 				'br' => 'бретон',
 				'brx' => 'бодо',
 				'bs' => 'босни',
 				'ca' => 'каталан',
 				'cgg' => 'чига',
 				'chr' => 'чироки',
 				'ckb' => 'сорани күрд',
 				'co' => 'корсик',
 				'cs' => 'чех',
 				'cy' => 'уэлс',
 				'da' => 'дани',
 				'dav' => 'тайта',
 				'de' => 'герман',
 				'de_AT' => 'австри герман',
 				'de_CH' => 'швейцари дээр герман',
 				'dje' => 'зарма',
 				'dsb' => 'ловер-сорби',
 				'dua' => 'дуала',
 				'dyo' => 'жола-фони',
 				'dz' => 'жонха',
 				'ebu' => 'эмбу',
 				'ee' => 'эвэ',
 				'el' => 'грек',
 				'en' => 'англи',
 				'en_AU' => 'австрали англи',
 				'en_CA' => 'канад англи',
 				'en_GB' => 'британийн англи',
 				'en_GB@alt=short' => 'их британийн англи',
 				'en_US' => 'америкийн англи',
 				'en_US@alt=short' => 'америкийн нэгдсэн улсын англи',
 				'eo' => 'эсперанто',
 				'es' => 'испани',
 				'es_419' => 'латин америкийн испани',
 				'es_ES' => 'европын испани',
 				'es_MX' => 'мексикийн испани',
 				'et' => 'эстони',
 				'eu' => 'баск',
 				'fa' => 'перс',
 				'fi' => 'финлянд',
 				'fil' => 'филиппин',
 				'fj' => 'фижи',
 				'fo' => 'фарер',
 				'fr' => 'франц',
 				'fr_CA' => 'канад франц',
 				'fr_CH' => 'швейцари франц',
 				'fy' => 'баруун фризын',
 				'ga' => 'ирланд',
 				'gag' => 'гагуз',
 				'gd' => 'шотланд келт',
 				'gl' => 'галик',
 				'gn' => 'гуарани',
 				'gsw' => 'швейцари герман',
 				'gu' => 'гужарати',
 				'guz' => 'гузы',
 				'gv' => 'манкс',
 				'ha' => 'хауса',
 				'haw' => 'хавай',
 				'he' => 'еврей',
 				'hi' => 'хинди',
 				'hr' => 'хорват',
 				'hsb' => 'дээд сорби',
 				'ht' => 'гаити',
 				'hu' => 'унгар',
 				'hy' => 'армен',
 				'ia' => 'интерлингво',
 				'id' => 'индонези',
 				'ie' => 'нэгдмэл хэл',
 				'ig' => 'игбо',
 				'ii' => 'шичуан еи',
 				'is' => 'исланд',
 				'it' => 'итали',
 				'iu' => 'инуктитут',
 				'ja' => 'япон',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачамэ',
 				'jv' => 'ява',
 				'ka' => 'гүрж',
 				'kab' => 'кабиле',
 				'kam' => 'камба',
 				'kde' => 'маконде',
 				'kea' => 'кабүвердиану',
 				'khq' => 'койра чини',
 				'ki' => 'кикуюү',
 				'kk' => 'хасаг',
 				'kl' => 'калалисут',
 				'kln' => 'каленжин',
 				'km' => 'камбож',
 				'kn' => 'каннада',
 				'ko' => 'солонгос',
 				'koi' => 'коми-пермяк',
 				'kok' => 'конкани',
 				'ks' => 'кашмир',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафиа',
 				'ku' => 'күрд',
 				'kw' => 'корны',
 				'ky' => 'киргиз',
 				'la' => 'латин',
 				'lag' => 'ланги',
 				'lb' => 'люксембург',
 				'lg' => 'ганда',
 				'lkt' => 'лакота',
 				'ln' => 'лингала',
 				'lo' => 'лаос',
 				'lt' => 'литва',
 				'lu' => 'луба-катанга',
 				'luo' => 'луо',
 				'luy' => 'луяа',
 				'lv' => 'латви',
 				'mas' => 'масай',
 				'mer' => 'меру',
 				'mfe' => 'морисен',
 				'mg' => 'малагаси',
 				'mgh' => 'макува-мито',
 				'mgo' => 'мета',
 				'mi' => 'маори',
 				'mk' => 'македон',
 				'ml' => 'малайлам',
 				'mn' => 'монгол',
 				'moh' => 'мохаук',
 				'mr' => 'марати',
 				'ms' => 'малай',
 				'mt' => 'малти',
 				'mua' => 'мунданг',
 				'my' => 'бирм',
 				'naq' => 'нама',
 				'nb' => 'норвегийн букмол',
 				'nd' => 'хойд ндебеле',
 				'ne' => 'балба',
 				'nl' => 'голланд',
 				'nl_BE' => 'фламанд',
 				'nmg' => 'квазио',
 				'nn' => 'норвегийн нинорск',
 				'no' => 'норвеги',
 				'nqo' => 'нко',
 				'nus' => 'нуер',
 				'nyn' => 'нянколе',
 				'oc' => 'францын окситан',
 				'om' => 'оромо',
 				'or' => 'ория',
 				'pa' => 'панжаб',
 				'pl' => 'польш',
 				'ps' => 'пашто',
 				'pt' => 'португал',
 				'pt_BR' => 'португал (бразил)',
 				'pt_PT' => 'европын португал',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'rm' => 'романш',
 				'rn' => 'рунди',
 				'ro' => 'румын',
 				'ro_MD' => 'молдав',
 				'rof' => 'ромбо',
 				'ru' => 'орос',
 				'rw' => 'кинярванда',
 				'rwk' => 'рва',
 				'sa' => 'санскрит',
 				'saq' => 'самбүрү',
 				'sbp' => 'сангү',
 				'sd' => 'синдхи',
 				'se' => 'хойд сами',
 				'seh' => 'сена',
 				'ses' => 'кёраборо сени',
 				'sg' => 'санго',
 				'sh' => 'хорватын серб',
 				'shi' => 'тачелхит',
 				'si' => 'синхала',
 				'sk' => 'словак',
 				'sl' => 'словен',
 				'sma' => 'өмнөд сами',
 				'smj' => 'люле сами',
 				'smn' => 'инари сами',
 				'sms' => 'сколт сами',
 				'sn' => 'шона',
 				'so' => 'сомали',
 				'sq' => 'албани',
 				'sr' => 'серб',
 				'st' => 'сесото',
 				'su' => 'сундан',
 				'sv' => 'швед',
 				'sw' => 'свахили',
 				'swc' => 'конго свахили',
 				'ta' => 'тамил',
 				'te' => 'тэлүгү',
 				'teo' => 'тэсо',
 				'tg' => 'тажик',
 				'th' => 'тай',
 				'ti' => 'тигрина',
 				'tk' => 'туркмен',
 				'tlh' => 'клингон хэл',
 				'to' => 'тонга',
 				'tr' => 'турк',
 				'tt' => 'татар',
 				'tw' => 'тви',
 				'twq' => 'тасавак',
 				'tzm' => 'төв атласын тамазайт',
 				'ug' => 'уйгар',
 				'uk' => 'украйн',
 				'und' => 'тодорхойгүй хэл',
 				'ur' => 'урду',
 				'uz' => 'узбек',
 				'vai' => 'вай',
 				'vi' => 'вьетнам',
 				'vun' => 'вунжо',
 				'wo' => 'волоф',
 				'xh' => 'хоса',
 				'xog' => 'сога',
 				'yi' => 'иддиш',
 				'yo' => 'ёруба',
 				'zgh' => 'тамазит',
 				'zh' => 'хятад',
 				'zh_Hans' => 'хялбаршуулсан хятад',
 				'zh_Hant' => 'уламжлалт хятад',
 				'zu' => 'зулу',
 				'zxx' => 'хэл зүйн агуулга байхгүй',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'араб',
 			'Armn' => 'армен',
 			'Beng' => 'бенгал',
 			'Bopo' => 'вопомофо',
 			'Brai' => 'брайл',
 			'Cyrl' => 'кирил',
 			'Deva' => 'деванагари',
 			'Ethi' => 'этиоп',
 			'Geor' => 'гүрж',
 			'Grek' => 'грек',
 			'Gujr' => 'гүжарати',
 			'Guru' => 'гурмукхи',
 			'Hang' => 'хангул',
 			'Hani' => 'хан',
 			'Hans' => 'хялбаршуулсан',
 			'Hans@alt=stand-alone' => 'хялбаршуулсан ханз',
 			'Hant' => 'уламжлалт',
 			'Hant@alt=stand-alone' => 'уламжлалт ханз',
 			'Hebr' => 'еврей',
 			'Hira' => 'хирагана',
 			'Jpan' => 'япон',
 			'Kana' => 'катакана',
 			'Khmr' => 'кхмер',
 			'Knda' => 'каннада',
 			'Kore' => 'солонгос',
 			'Laoo' => 'лаос',
 			'Latn' => 'латин',
 			'Mlym' => 'малаялам',
 			'Mong' => 'монгол бичиг',
 			'Mymr' => 'мьянмар',
 			'Orya' => 'ория',
 			'Sinh' => 'синхала',
 			'Taml' => 'тамил',
 			'Telu' => 'тэлүгү',
 			'Thaa' => 'тана',
 			'Thai' => 'тай',
 			'Tibt' => 'төвд',
 			'Zsym' => 'тэмдэг',
 			'Zxxx' => 'бичигдээгүй',
 			'Zyyy' => 'нийтлэг',
 			'Zzzz' => 'тодорхойгүй бичиг',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Дэлхий',
 			'002' => 'Африк',
 			'003' => 'Хойд Америк',
 			'005' => 'Өмнөд Америк',
 			'009' => 'Номхон далайн орнууд',
 			'011' => 'Баруун Африк',
 			'013' => 'Төв Америк',
 			'014' => 'Зүүн Африк',
 			'015' => 'Хойд Африк',
 			'017' => 'Төв Африк',
 			'018' => 'Өмнөд Африк',
 			'019' => 'Америк',
 			'021' => 'Хойд Америк тив',
 			'029' => 'Карибын',
 			'030' => 'Зүүн Ази',
 			'034' => 'Өмнөд Ази',
 			'035' => 'Зүүн Өмнөд Ази',
 			'039' => 'Өмнөд Европ',
 			'053' => 'Австралиази',
 			'054' => 'Меланези',
 			'057' => 'Микронезийн бүс',
 			'061' => 'Полинез',
 			'142' => 'Ази',
 			'143' => 'Төв Ази',
 			'145' => 'Баруун Ази',
 			'150' => 'Европ',
 			'151' => 'Зүүн Европ',
 			'154' => 'Хойд Европ',
 			'155' => 'Баруун Европ',
 			'419' => 'Латин Америк',
 			'AC' => 'Аскенсион Арал',
 			'AD' => 'Андорра',
 			'AE' => 'Арабын Нэгдсэн Эмират',
 			'AF' => 'Афганистан',
 			'AG' => 'Антигуа ба Барбуда',
 			'AI' => 'Ангила',
 			'AL' => 'Албани',
 			'AM' => 'Армен',
 			'AO' => 'Ангол',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентин',
 			'AS' => 'Америкийн Самоа',
 			'AT' => 'Австри',
 			'AU' => 'Австрали',
 			'AW' => 'Аруба',
 			'AX' => 'Аландын Арлууд',
 			'AZ' => 'Азербайжан',
 			'BA' => 'Босни Херцеговин',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белги',
 			'BF' => 'Буркина фасо',
 			'BG' => 'Болгар',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сент Бартельми',
 			'BM' => 'Бермуд',
 			'BN' => 'Бруней',
 			'BO' => 'Боливи',
 			'BQ' => 'Карибын Нидерланд',
 			'BR' => 'Бразил',
 			'BS' => 'Багам',
 			'BT' => 'Бутан',
 			'BV' => 'Буветын Арлууд',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларус',
 			'BZ' => 'Белиз',
 			'CA' => 'Канад',
 			'CC' => 'Кокос (Кийлинг) Арлууд',
 			'CD' => 'Конго-Киншаса',
 			'CD@alt=variant' => 'Конго (БНУ)',
 			'CF' => 'Төв Африкийн Бүгд Найрамдах Улс',
 			'CG' => 'Конго Браззавиль',
 			'CG@alt=variant' => 'Конго (Бүгд Найрамдах улс)',
 			'CH' => 'Швейцари',
 			'CI' => 'Кот д’Ивуар',
 			'CI@alt=variant' => 'Зааны Ясан Эрэг',
 			'CK' => 'Күүкийн Арлууд',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Хятад',
 			'CO' => 'Колумб',
 			'CP' => 'Клиппертон Арал',
 			'CR' => 'Коста Рика',
 			'CU' => 'Куба',
 			'CV' => 'Капе Верде',
 			'CW' => 'Куракао',
 			'CX' => 'Зул Сарын Арал',
 			'CY' => 'Кипр',
 			'CZ' => 'Бүгд Найрамдах Чех Улс',
 			'DE' => 'Герман',
 			'DG' => 'Диего Гарсиа',
 			'DJ' => 'Джибути',
 			'DK' => 'Дани',
 			'DM' => 'Доминик',
 			'DO' => 'Бүгд Найрамдах Доминикан',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута ба Мелилья',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстон',
 			'EG' => 'Египет',
 			'EH' => 'Баруун Сахар',
 			'ER' => 'Эритри',
 			'ES' => 'Испани',
 			'ET' => 'Этиоп',
 			'EU' => 'Европын Холбоо',
 			'FI' => 'Финланд',
 			'FJ' => 'Фижи',
 			'FK' => 'Фолькландын Арлууд',
 			'FK@alt=variant' => 'Фолькландын Арлууд (Ислас Мальвинас)',
 			'FM' => 'Микронези',
 			'FO' => 'Фароэ Арлууд',
 			'FR' => 'Франц',
 			'GA' => 'Габон',
 			'GB' => 'Их Британи',
 			'GB@alt=short' => 'ИБ',
 			'GD' => 'Гренада',
 			'GE' => 'Гүрж',
 			'GF' => 'Францын Гайана',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамби',
 			'GN' => 'Гвиней',
 			'GP' => 'Гваделуп',
 			'GQ' => 'Экваторын Гвиней',
 			'GR' => 'Грек',
 			'GS' => 'Өмнөд Жоржиа ба Өмнөд Сэндвичийн Арлууд',
 			'GT' => 'Гватемал',
 			'GU' => 'Гуам',
 			'GW' => 'Гвиней-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'БНХАУ-ын Тусгай захиргааны бүс Хонг Конг',
 			'HK@alt=short' => 'Хонг Конг',
 			'HM' => 'Хэрд болон Макдоналд Арлууд',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорват',
 			'HT' => 'Гаити',
 			'HU' => 'Унгар',
 			'IC' => 'Канарын арлууд',
 			'ID' => 'Индонези',
 			'IE' => 'Ирланд',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн Арал',
 			'IN' => 'Энэтхэг',
 			'IO' => 'Британийн харьяа Энэтхэгийн далай дахь нутаг дэвсгэрүүд',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Итали',
 			'JE' => 'Жерси',
 			'JM' => 'Ямайк',
 			'JO' => 'Йордан',
 			'JP' => 'Япон',
 			'KE' => 'Кени',
 			'KG' => 'Кыргызстан',
 			'KH' => 'Камбож',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморос',
 			'KN' => 'Сент-Киттс ба Невис',
 			'KP' => 'Хойд Солонгос',
 			'KR' => 'Өмнөд Солонгос',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайманы Арлууд',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент Люсиа',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либери',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латви',
 			'LY' => 'Ливи',
 			'MA' => 'Марокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдав',
 			'ME' => 'Монтенегро',
 			'MF' => 'Сент-Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршаллын Арлууд',
 			'MK' => 'Македон',
 			'MK@alt=variant' => 'Македон (Хуучин Югославын бүрэлдэхүүний Македон)',
 			'ML' => 'Мали',
 			'MM' => 'Мьянмар (Бурма)',
 			'MN' => 'Монгол',
 			'MO' => 'БНХАУ-ын Тусгай захиргааны бүс Макао',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Хойд Марианы Арлууд',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мавритани',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Мавритус',
 			'MV' => 'Мальдив',
 			'MW' => 'Малави',
 			'MX' => 'Мексик',
 			'MY' => 'Малайз',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намиби',
 			'NC' => 'Шинэ Каледони',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк Арлууд',
 			'NG' => 'Нигери',
 			'NI' => 'Никарагуа',
 			'NL' => 'Голланд',
 			'NO' => 'Норвеги',
 			'NP' => 'Балба',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Шинэ Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панам',
 			'PE' => 'Перу',
 			'PF' => 'Францын Полинез',
 			'PG' => 'Папуа Шинэ Гвиней',
 			'PH' => 'Филиппин',
 			'PK' => 'Пакистан',
 			'PL' => 'Польш',
 			'PM' => 'Сэнт Пьер ба Микелон',
 			'PN' => 'Питкэрн Арлууд',
 			'PR' => 'Пуэрто Рико',
 			'PS' => 'Палестины нутаг дэвсгэрүүд',
 			'PS@alt=short' => 'Палестин',
 			'PT' => 'Португал',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Номхон далайг тойрсон улс орнууд',
 			'RE' => 'Реюньон',
 			'RO' => 'Румын',
 			'RS' => 'Серби',
 			'RU' => 'Орос',
 			'RW' => 'Руанда',
 			'SA' => 'Саудын Араб',
 			'SB' => 'Соломоны Арлууд',
 			'SC' => 'Сейшел',
 			'SD' => 'Судан',
 			'SE' => 'Швед',
 			'SG' => 'Сингапур',
 			'SH' => 'Сент Хелена',
 			'SI' => 'Словени',
 			'SJ' => 'Свалбард ба Ян Майен',
 			'SK' => 'Словак',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Өмнөд Судан',
 			'ST' => 'Сан-Томе ба Принсипи',
 			'SV' => 'Эль Сальвадор',
 			'SX' => 'Синт Мартен',
 			'SY' => 'Сири',
 			'SZ' => 'Свазиланд',
 			'TA' => 'Тристан да Кунья',
 			'TC' => 'Турк ба Кайкосын Арлууд',
 			'TD' => 'Чад',
 			'TF' => 'Францын өмнөд газар нутаг',
 			'TG' => 'Того',
 			'TH' => 'Тайланд',
 			'TJ' => 'Тажикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Зүүн Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турк',
 			'TT' => 'Тринидад ба Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайван',
 			'TZ' => 'Танзани',
 			'UA' => 'Украйн',
 			'UG' => 'Уганда',
 			'UM' => 'АНУ-ын тойрсон арлууд',
 			'US' => 'Америкийн Нэгдсэн Улс',
 			'US@alt=short' => 'АНУ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан хот улс',
 			'VC' => 'Сэнт Винсэнт ба Гренадин',
 			'VE' => 'Венесуэл',
 			'VG' => 'Британийн Виржиний Арлууд',
 			'VI' => 'АНУ-ын Виржиний Арлууд',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис ба Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотте',
 			'ZA' => 'Өмнөд Африк тив',
 			'ZM' => 'Замби',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Тодорхойгүй',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'хуанли',
 			'collation' => 'Захиалга ялгах',
 			'currency' => 'мөнгөн тэмдэгт',
 			'numbers' => 'Тоо',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{буддын хуанли},
 				'chinese' => q{хятад хуанли},
 				'dangi' => q{данги хуанли},
 				'ethiopic' => q{этиоп хуанли},
 				'gregorian' => q{грегорийн хуанли},
 				'hebrew' => q{еврей хуанли},
 				'islamic' => q{исламын хуанли},
 				'iso8601' => q{ISO-8601 хуанли},
 				'japanese' => q{япон хуанли},
 				'persian' => q{перс хуанли},
 				'roc' => q{минго хуанли},
 			},
 			'collation' => {
 				'ducet' => q{юникодын үндсэн эрэмбэлэх дараалал},
 				'search' => q{ерөнхий зорилготой хайлт},
 				'standard' => q{стандарт эрэмбэлэх дараалал},
 			},
 			'numbers' => {
 				'arab' => q{араб-энэтхэг тоо},
 				'arabext' => q{өргөтгөсөн араб-энэтхэг тоо},
 				'armn' => q{армен тоо},
 				'armnlow' => q{жижиг армен тоо},
 				'beng' => q{бенгал тоо},
 				'deva' => q{деванагари тоо},
 				'ethi' => q{этиоп тоо},
 				'fullwide' => q{бүрэн хэмжээтэй тоо},
 				'geor' => q{гүрж тоо},
 				'grek' => q{грек тоо},
 				'greklow' => q{жижиг грек тоо},
 				'gujr' => q{гүжарати тоо},
 				'guru' => q{гүрмүкхи тоо},
 				'hanidec' => q{хятад аравтын тоо},
 				'hans' => q{хялбаршуулсан хятад тоо},
 				'hansfin' => q{хялбаршуулсан хятад санхүүгийн тоо},
 				'hant' => q{уламжлалт хятад тоо},
 				'hantfin' => q{уламжлалт хятад санхүүгийн тоо},
 				'hebr' => q{еврей тоо},
 				'jpan' => q{япон тоо},
 				'jpanfin' => q{япон санхүүгийн тоо},
 				'khmr' => q{кхмер тоо},
 				'knda' => q{каннада тоо},
 				'laoo' => q{лаос тоо},
 				'latn' => q{араб тоо},
 				'mlym' => q{малаялам тоо},
 				'mong' => q{монгол тоо},
 				'mymr' => q{мьянмар тоо},
 				'orya' => q{ория тоо},
 				'roman' => q{ром тоо},
 				'romanlow' => q{жижиг ром тоо},
 				'taml' => q{уламжлалт тамил тоо},
 				'tamldec' => q{тамил тоо},
 				'telu' => q{телүгү тоо},
 				'thai' => q{тай тоо},
 				'tibt' => q{тибет тоо},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{метрийн},
 			'UK' => q{ИБ},
 			'US' => q{АНУ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '{0}',
 			'script' => '{0}',
 			'territory' => '{0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[ә җ ӊ һ])},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{(?^u:[а б в г д е ё ж з и й к л м н о ө п р с т у ү ф х ц ч ш щ ъ ы ь э ю я])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″])},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'' => q(акр-фүүт),
						'one' => q({0} акр-фүүт),
						'other' => q({0} акр-фүүт),
					},
					'ampere' => {
						'' => q(ампер),
						'one' => q({0} ампер),
						'other' => q({0} ампер),
					},
					'arc-minute' => {
						'' => q(аркминут),
						'one' => q({0} аркминут),
						'other' => q({0} аркминут),
					},
					'arc-second' => {
						'' => q(арксекунд),
						'one' => q({0} арксекунд),
						'other' => q({0} арксекунд),
					},
					'astronomical-unit' => {
						'' => q(сансрын нэгж),
						'one' => q({0} сансрын нэгж),
						'other' => q({0} сансрын нэгж),
					},
					'bit' => {
						'' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'' => q(калори),
						'one' => q({0} калори),
						'other' => q({0} калори),
					},
					'carat' => {
						'' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'celsius' => {
						'' => q(Цельсийн хэм),
						'one' => q({0} Цельсийн хэм),
						'other' => q({0} Цельсийн хэм),
					},
					'centiliter' => {
						'' => q(центилитр),
						'one' => q({0} центилитр),
						'other' => q({0} центилитр),
					},
					'centimeter' => {
						'' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметр),
					},
					'cubic-centimeter' => {
						'' => q(сантиметр куб),
						'one' => q({0} сантиметр куб),
						'other' => q({0} сантиметр куб),
					},
					'cubic-foot' => {
						'' => q(фүүт куб),
						'one' => q({0} фүүт куб),
						'other' => q({0} фүүт куб),
					},
					'cubic-inch' => {
						'' => q(инч куб),
						'one' => q({0} инч куб),
						'other' => q({0} инч куб),
					},
					'cubic-kilometer' => {
						'' => q(километр куб),
						'one' => q({0} километр куб),
						'other' => q({0} километр куб),
					},
					'cubic-meter' => {
						'' => q(метр куб),
						'one' => q({0} метр куб),
						'other' => q({0} метр куб),
					},
					'cubic-mile' => {
						'' => q(миль куб),
						'one' => q({0} миль куб),
						'other' => q({0} миль куб),
					},
					'cubic-yard' => {
						'' => q(ярд куб),
						'one' => q({0} ярд куб),
						'other' => q({0} ярд куб),
					},
					'cup' => {
						'' => q(аяга),
						'one' => q({0} аяга),
						'other' => q({0} аяга),
					},
					'day' => {
						'' => q(өдөр),
						'one' => q({0} өдөр),
						'other' => q({0} өдөр),
					},
					'deciliter' => {
						'' => q(децилитр),
						'one' => q({0} децилитр),
						'other' => q({0} децилитр),
					},
					'decimeter' => {
						'' => q(дециметр),
						'one' => q({0} дециметр),
						'other' => q({0} дециметр),
					},
					'degree' => {
						'' => q(хэм),
						'one' => q({0} хэм),
						'other' => q({0} хэм),
					},
					'fahrenheit' => {
						'' => q(Фаренгейтын хэм),
						'one' => q({0} Фаренгейтын хэм),
						'other' => q({0} Фаренгейтын хэм),
					},
					'fluid-ounce' => {
						'' => q(шингэн унц),
						'one' => q({0} ш унц),
						'other' => q({0} ш унц),
					},
					'foodcalorie' => {
						'' => q(Калори),
						'one' => q({0} Калори),
						'other' => q({0} Калори),
					},
					'foot' => {
						'' => q(фүүт),
						'one' => q({0} фүүт),
						'other' => q({0} фүүт),
					},
					'g-force' => {
						'' => q(жи-хүч),
						'one' => q({0} жи-хүч),
						'other' => q({0} жи-хүч),
					},
					'gallon' => {
						'' => q(галлон),
						'one' => q({0} галлон),
						'other' => q({0} галлон),
					},
					'gigabit' => {
						'' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					'gigabyte' => {
						'' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					'gigahertz' => {
						'' => q(гигагерц),
						'one' => q({0} гигагерц),
						'other' => q({0} гигагерц),
					},
					'gigawatt' => {
						'' => q(гигаватт),
						'one' => q({0} гигаватт),
						'other' => q({0} гигаватт),
					},
					'gram' => {
						'' => q(грам),
						'one' => q({0} грам),
						'other' => q({0} грам),
					},
					'hectare' => {
						'' => q(гектар),
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					'hectoliter' => {
						'' => q(хектолитр),
						'one' => q({0} хектолитр),
						'other' => q({0} хектолитр),
					},
					'hectopascal' => {
						'' => q(гектопаскал),
						'one' => q({0} гектопаскал),
						'other' => q({0} гектопаскал),
					},
					'hertz' => {
						'' => q(герц),
						'one' => q({0} герц),
						'other' => q({0} герц),
					},
					'horsepower' => {
						'' => q(морины хүч),
						'one' => q({0} морины хүч),
						'other' => q({0} морины хүч),
					},
					'hour' => {
						'' => q({0} цагт),
						'one' => q({0} цаг),
						'other' => q({0} цаг),
					},
					'inch' => {
						'' => q(инч),
						'one' => q({0} инч),
						'other' => q({0} инч),
					},
					'inch-hg' => {
						'' => q(мөнгөн усны инч),
						'one' => q({0} мөнгөн усны инч),
						'other' => q({0} мөнгөн усны инч),
					},
					'joule' => {
						'' => q(жоуль),
						'one' => q({0} жоуль),
						'other' => q({0} жоуль),
					},
					'karat' => {
						'' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'kelvin' => {
						'' => q(келвиний хэм),
						'one' => q({0} келвиний хэм),
						'other' => q({0} келвиний хэм),
					},
					'kilobit' => {
						'' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					'kilobyte' => {
						'' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					'kilocalorie' => {
						'' => q(килокалори),
						'one' => q({0} килокалори),
						'other' => q({0} килокалори),
					},
					'kilogram' => {
						'' => q(килограм),
						'one' => q({0} килограм),
						'other' => q({0} килограм),
					},
					'kilohertz' => {
						'' => q(килогерц),
						'one' => q({0} килогерц),
						'other' => q({0} килогерц),
					},
					'kilojoule' => {
						'' => q(киложоуль),
						'one' => q({0} киложоуль),
						'other' => q({0} киложоуль),
					},
					'kilometer' => {
						'' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} километр),
					},
					'kilometer-per-hour' => {
						'' => q(километр/цаг),
						'one' => q({0} километр/цаг),
						'other' => q({0} километр/цаг),
					},
					'kilowatt' => {
						'' => q(киловатт),
						'one' => q({0} киловатт),
						'other' => q({0} киловатт),
					},
					'kilowatt-hour' => {
						'' => q(киловатт цаг),
						'one' => q({0} киловатт цаг),
						'other' => q({0} киловатт цаг),
					},
					'light-year' => {
						'' => q(гэрлийн жил),
						'one' => q({0} гэрлийн жил),
						'other' => q({0} гэрлийн жил),
					},
					'liter' => {
						'' => q(литр),
						'one' => q({0} литр),
						'other' => q({0} литр),
					},
					'liter-per-kilometer' => {
						'' => q(литр/километр),
						'one' => q({0} литр/километр),
						'other' => q({0} литр/километр),
					},
					'lux' => {
						'' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					'megabit' => {
						'' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					'megabyte' => {
						'' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					'megahertz' => {
						'' => q(мегагерц),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерц),
					},
					'megaliter' => {
						'' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					'megawatt' => {
						'' => q(мегаватт),
						'one' => q({0} мегаватт),
						'other' => q({0} мегаватт),
					},
					'meter' => {
						'' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
					},
					'meter-per-second' => {
						'' => q(метр/секунд),
						'one' => q({0} метр/секунд),
						'other' => q({0} метр/секунд),
					},
					'meter-per-second-squared' => {
						'' => q(метр сек кв),
						'one' => q({0} метр сек кв),
						'other' => q({0} метр сек кв),
					},
					'metric-ton' => {
						'' => q(метрийн тонн),
						'one' => q({0} метрийн тонн),
						'other' => q({0} метрийн тонн),
					},
					'microgram' => {
						'' => q(микрограм),
						'one' => q({0} микрограм),
						'other' => q({0} микрограм),
					},
					'micrometer' => {
						'' => q(микрометр),
						'one' => q({0} микрометр),
						'other' => q({0} микрометр),
					},
					'microsecond' => {
						'' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					'mile' => {
						'' => q(миль),
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					'mile-per-gallon' => {
						'' => q(миль/галлон),
						'one' => q({0} миль/галлон),
						'other' => q({0} миль/галлон),
					},
					'mile-per-hour' => {
						'' => q(миль/цаг),
						'one' => q({0} миль/цаг),
						'other' => q({0} миль/цаг),
					},
					'milliampere' => {
						'' => q(милиампер),
						'one' => q({0} милиампер),
						'other' => q({0} милиампер),
					},
					'millibar' => {
						'' => q(милибар),
						'one' => q({0} милибар),
						'other' => q({0} милибар),
					},
					'milligram' => {
						'' => q(милиграм),
						'one' => q({0} милиграм),
						'other' => q({0} милиграм),
					},
					'milliliter' => {
						'' => q(милилитр),
						'one' => q({0} милилитр),
						'other' => q({0} милилитр),
					},
					'millimeter' => {
						'' => q(милиметр),
						'one' => q({0} милиметр),
						'other' => q({0} милиметр),
					},
					'millimeter-of-mercury' => {
						'' => q(мөнгөн усны милиметр),
						'one' => q({0} мөнгөн усны милиметр),
						'other' => q({0} мөнгөн усны милиметр),
					},
					'millisecond' => {
						'' => q(милисекунд),
						'one' => q({0} милисекунд),
						'other' => q({0} милисекунд),
					},
					'milliwatt' => {
						'' => q(миливатт),
						'one' => q({0} миливатт),
						'other' => q({0} миливатт),
					},
					'minute' => {
						'' => q(минут),
						'one' => q({0} минут),
						'other' => q({0} минут),
					},
					'month' => {
						'' => q(сар),
						'one' => q({0} сар),
						'other' => q({0} сар),
					},
					'nanometer' => {
						'' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					'nanosecond' => {
						'' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					'nautical-mile' => {
						'' => q(далайн миль),
						'one' => q({0} далайн миль),
						'other' => q({0} далайн миль),
					},
					'ohm' => {
						'' => q(ом),
						'one' => q({0} ом),
						'other' => q({0} ом),
					},
					'ounce' => {
						'' => q(унц),
						'one' => q({0} унц),
						'other' => q({0} унц),
					},
					'ounce-troy' => {
						'' => q(трой унц),
						'one' => q({0} трой унц),
						'other' => q({0} трой унц),
					},
					'parsec' => {
						'' => q(парсек),
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					'pint' => {
						'' => q(пайнт),
						'one' => q({0} пайнт),
						'other' => q({0} пайнт),
					},
					'pound' => {
						'' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					'pound-per-square-inch' => {
						'' => q(фунт инч квадрат),
						'one' => q({0} фунт инч квадрат),
						'other' => q({0} фунт инч квадрат),
					},
					'quart' => {
						'' => q(кварц),
						'one' => q({0} кварц),
						'other' => q({0} кварц),
					},
					'radian' => {
						'' => q(радиан),
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					'second' => {
						'' => q({0} секундэд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
					},
					'square-centimeter' => {
						'' => q(сантиметр квадрат),
						'one' => q({0} сантиметр квадрат),
						'other' => q({0} сантиметр квадрат),
					},
					'square-foot' => {
						'' => q(фүүт квадрат),
						'one' => q({0} фүүт квадрат),
						'other' => q({0} фүүт квадрат),
					},
					'square-inch' => {
						'' => q(инч квадрат),
						'one' => q({0} инч квадрат),
						'other' => q({0} инч квадрат),
					},
					'square-kilometer' => {
						'' => q(километр квадрат),
						'one' => q({0} километр квадрат),
						'other' => q({0} километр квадрат),
					},
					'square-meter' => {
						'' => q(метр квадрат),
						'one' => q({0} метр квадрат),
						'other' => q({0} метр квадрат),
					},
					'square-mile' => {
						'' => q(миль квадрат),
						'one' => q({0} миль квадрат),
						'other' => q({0} миль квадрат),
					},
					'square-yard' => {
						'' => q(ярд квадрат),
						'one' => q({0} ярд квадрат),
						'other' => q({0} ярд квадрат),
					},
					'tablespoon' => {
						'' => q(хоолны халбага),
						'one' => q({0} хоолны халбага),
						'other' => q({0} хоолны халбага),
					},
					'teaspoon' => {
						'' => q(цайны халбага),
						'one' => q({0} цайны халбага),
						'other' => q({0} цайны халбага),
					},
					'terabit' => {
						'' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					'terabyte' => {
						'' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					'ton' => {
						'' => q(тонн),
						'one' => q({0} тонн),
						'other' => q({0} тонн),
					},
					'volt' => {
						'' => q(вольт),
						'one' => q({0} вольт),
						'other' => q({0} вольт),
					},
					'watt' => {
						'' => q(ватт),
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					'week' => {
						'' => q(долоо хоног),
						'one' => q({0} долоо хоног),
						'other' => q({0} долоо хоног),
					},
					'yard' => {
						'' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'' => q(жил),
						'one' => q({0} жил),
						'other' => q({0} жил),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'cubic-kilometer' => {
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-mile' => {
						'one' => q({0} миль куб),
						'other' => q({0} миль куб),
					},
					'day' => {
						'' => q(өдөр),
						'one' => q({0} ө),
						'other' => q({0} ө),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} фт),
						'other' => q({0} фт),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'' => q(грам),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'hectare' => {
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectopascal' => {
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'horsepower' => {
						'one' => q({0} м.х.),
						'other' => q({0} м.х.),
					},
					'hour' => {
						'' => q(цаг),
						'one' => q({0} ц),
						'other' => q({0} ц),
					},
					'inch' => {
						'one' => q({0} инч),
						'other' => q({0} инч),
					},
					'inch-hg' => {
						'one' => q({0} муб),
						'other' => q({0} муб),
					},
					'kilogram' => {
						'' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'' => q(км/ц),
						'one' => q({0} км/ц),
						'other' => q({0} км/ц),
					},
					'kilowatt' => {
						'one' => q({0} кватт),
						'other' => q({0} кватт),
					},
					'light-year' => {
						'one' => q({0} гэр/жил),
						'other' => q({0} гэр/жил),
					},
					'liter' => {
						'' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'meter' => {
						'' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'one' => q({0} м/сек),
						'other' => q({0} м/сек),
					},
					'mile' => {
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					'mile-per-hour' => {
						'one' => q({0} миль/цаг),
						'other' => q({0} миль/цаг),
					},
					'millibar' => {
						'one' => q({0} милбар),
						'other' => q({0} милбар),
					},
					'millimeter' => {
						'' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millisecond' => {
						'' => q(мсек),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'' => q(мин),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'month' => {
						'' => q(сар),
						'one' => q({0} ср),
						'other' => q({0} ср),
					},
					'ounce' => {
						'one' => q({0} унц),
						'other' => q({0} унц),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pound' => {
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					'second' => {
						'' => q(сек),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					'square-foot' => {
						'one' => q({0} фт²),
						'other' => q({0} фт²),
					},
					'square-kilometer' => {
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'one' => q({0} миль²),
						'other' => q({0} миль²),
					},
					'watt' => {
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					'week' => {
						'' => q(д/х),
						'one' => q({0} д/х),
						'other' => q({0} д/х),
					},
					'yard' => {
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'' => q(ж),
						'one' => q({0} ж),
						'other' => q({0} ж),
					},
				},
				'short' => {
					'acre' => {
						'' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'' => q(акр фүүт),
						'one' => q({0} ак фт),
						'other' => q({0} ак фт),
					},
					'ampere' => {
						'' => q(амп),
						'one' => q({0} А),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'' => q(аркмин),
						'one' => q({0} аркмин),
						'other' => q({0} аркмин),
					},
					'arc-second' => {
						'' => q(арксек),
						'one' => q({0} арксек),
						'other' => q({0} арксек),
					},
					'astronomical-unit' => {
						'' => q(сн),
						'one' => q({0} сн),
						'other' => q({0} сн),
					},
					'bit' => {
						'' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					'carat' => {
						'' => q(карат),
						'one' => q({0} крт),
						'other' => q({0} крт),
					},
					'celsius' => {
						'' => q(C хэм),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'' => q(цЛ),
						'one' => q({0} цЛ),
						'other' => q({0} цЛ),
					},
					'centimeter' => {
						'' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'cubic-centimeter' => {
						'' => q(см³),
						'one' => q({0} cм³),
						'other' => q({0} cм³),
					},
					'cubic-foot' => {
						'' => q(фүүт³),
						'one' => q({0} фт³),
						'other' => q({0} фт³),
					},
					'cubic-inch' => {
						'' => q(инч³),
						'one' => q({0} ин³),
						'other' => q({0} ин³),
					},
					'cubic-kilometer' => {
						'' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
					},
					'cubic-mile' => {
						'' => q(ми³),
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					'cubic-yard' => {
						'' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					'cup' => {
						'' => q(аяга),
						'one' => q({0} а),
						'other' => q({0} а),
					},
					'day' => {
						'' => q(өдөр),
						'one' => q({0} өдөр),
						'other' => q({0} өдөр),
					},
					'deciliter' => {
						'' => q(дЛ),
						'one' => q({0} дЛ),
						'other' => q({0} дЛ),
					},
					'decimeter' => {
						'' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'' => q(хэм),
						'one' => q({0} хэм),
						'other' => q({0} хэм),
					},
					'fahrenheit' => {
						'' => q(F хэм),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'' => q(ш унц),
						'one' => q({0} ш унц),
						'other' => q({0} ш унц),
					},
					'foodcalorie' => {
						'' => q(Кал),
						'one' => q({0} Кал),
						'other' => q({0} Кал),
					},
					'foot' => {
						'' => q(фүүт),
						'one' => q({0} фт),
						'other' => q({0} фт),
					},
					'g-force' => {
						'' => q(Жи),
						'one' => q({0} Жи),
						'other' => q({0} Жи),
					},
					'gallon' => {
						'' => q(гал),
						'one' => q({0} гал),
						'other' => q({0} гал),
					},
					'gigabit' => {
						'' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					'gigabyte' => {
						'' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					'gigahertz' => {
						'' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					'gigawatt' => {
						'' => q(ГВ),
						'one' => q({0} ГВ),
						'other' => q({0} ГВ),
					},
					'gram' => {
						'' => q(грам),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'hectare' => {
						'' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectoliter' => {
						'' => q(хЛ),
						'one' => q({0} хЛ),
						'other' => q({0} хЛ),
					},
					'hectopascal' => {
						'' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'hertz' => {
						'' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					'horsepower' => {
						'' => q(мх),
						'one' => q({0} мх),
						'other' => q({0} мх),
					},
					'hour' => {
						'' => q({0} цгт),
						'one' => q({0} цаг),
						'other' => q({0} цаг),
					},
					'inch' => {
						'' => q(инч),
						'one' => q({0} ин),
						'other' => q({0} ин),
					},
					'inch-hg' => {
						'' => q(МөУсИн),
						'one' => q({0} МөУсИн),
						'other' => q({0} МөУсИн),
					},
					'joule' => {
						'' => q(жоуль),
						'one' => q({0} жо),
						'other' => q({0} жо),
					},
					'karat' => {
						'' => q(карат),
						'one' => q({0} кт),
						'other' => q({0} кт),
					},
					'kelvin' => {
						'' => q(К хэм),
						'one' => q({0}°К),
						'other' => q({0}°К),
					},
					'kilobit' => {
						'' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					'kilobyte' => {
						'' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					'kilocalorie' => {
						'' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					'kilogram' => {
						'' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilohertz' => {
						'' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					'kilojoule' => {
						'' => q(киложоуль),
						'one' => q({0} кж),
						'other' => q({0} кж),
					},
					'kilometer' => {
						'' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'' => q(км/цаг),
						'one' => q({0} км/ц),
						'other' => q({0} км/ц),
					},
					'kilowatt' => {
						'' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'kilowatt-hour' => {
						'' => q(кВ-цаг),
						'one' => q({0} кВц),
						'other' => q({0} кВц),
					},
					'light-year' => {
						'' => q(гэр жил),
						'one' => q({0} гж),
						'other' => q({0} гж),
					},
					'liter' => {
						'' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'liter-per-kilometer' => {
						'' => q(литр/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					'lux' => {
						'' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					'megabit' => {
						'' => q(Мбит),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					'megabyte' => {
						'' => q(Мбайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					'megahertz' => {
						'' => q(МГц),
						'one' => q({0} МГц),
						'other' => q({0} МГц),
					},
					'megaliter' => {
						'' => q(МЛ),
						'one' => q({0} МЛ),
						'other' => q({0} МЛ),
					},
					'megawatt' => {
						'' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					'meter' => {
						'' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'' => q(метр/сек),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'meter-per-second-squared' => {
						'' => q(метр/сек²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					'metric-ton' => {
						'' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'microgram' => {
						'' => q(µг),
						'one' => q({0} µг),
						'other' => q({0} µг),
					},
					'micrometer' => {
						'' => q(µметр),
						'one' => q({0} µм),
						'other' => q({0} µм),
					},
					'microsecond' => {
						'' => q(μs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'' => q(миль),
						'one' => q({0} ми),
						'other' => q({0} ми),
					},
					'mile-per-gallon' => {
						'' => q(миль/гал),
						'one' => q(ми/гал),
						'other' => q({0} ми/гал),
					},
					'mile-per-hour' => {
						'' => q(миль/цаг),
						'one' => q({0} ми/ц),
						'other' => q({0} ми/ц),
					},
					'milliampere' => {
						'' => q(милиамп),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					'millibar' => {
						'' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбар),
					},
					'milligram' => {
						'' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					'milliliter' => {
						'' => q(мЛ),
						'one' => q({0} мЛ),
						'other' => q({0} мЛ),
					},
					'millimeter' => {
						'' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'' => q(МөУс мм),
						'one' => q({0} МөУс мм),
						'other' => q({0} МөУс мм),
					},
					'millisecond' => {
						'' => q(милисек),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'milliwatt' => {
						'' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					'minute' => {
						'' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
					},
					'month' => {
						'' => q(сар),
						'one' => q({0} сар),
						'other' => q({0} сар),
					},
					'nanometer' => {
						'' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					'nanosecond' => {
						'' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'nautical-mile' => {
						'' => q(дмиль),
						'one' => q({0} дмиль),
						'other' => q({0} дмиль),
					},
					'ohm' => {
						'' => q(ом),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'' => q(унц),
						'one' => q({0} унц),
						'other' => q({0} унц),
					},
					'ounce-troy' => {
						'' => q(трой унц),
						'one' => q({0} т унц),
						'other' => q({0} т унц),
					},
					'parsec' => {
						'' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pint' => {
						'' => q(пайнт),
						'one' => q({0} пнт),
						'other' => q({0} пнт),
					},
					'pound' => {
						'' => q(фунт),
						'one' => q({0} фнт),
						'other' => q({0} фнт),
					},
					'pound-per-square-inch' => {
						'' => q(ф ин кв),
						'one' => q({0} ф ин кв),
						'other' => q({0} ф ин кв),
					},
					'quart' => {
						'' => q(крц),
						'one' => q({0} крц),
						'other' => q({0} крц),
					},
					'radian' => {
						'' => q(радиан),
						'one' => q({0} рад),
						'other' => q({0} рад),
					},
					'second' => {
						'' => q({0} секд),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-centimeter' => {
						'' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
					},
					'square-foot' => {
						'' => q(фүүт кв),
						'one' => q({0} фт кв),
						'other' => q({0} фт кв),
					},
					'square-inch' => {
						'' => q(инч²),
						'one' => q({0} ин²),
						'other' => q({0} ин²),
					},
					'square-kilometer' => {
						'' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'' => q(миль кв),
						'one' => q({0} миль кв),
						'other' => q({0} миль кв),
					},
					'square-yard' => {
						'' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					'tablespoon' => {
						'' => q(ххалбага),
						'one' => q({0} ххалбага),
						'other' => q({0} ххалбага),
					},
					'teaspoon' => {
						'' => q(цхалбага),
						'one' => q({0} цхалбага),
						'other' => q({0} цхалбага),
					},
					'terabit' => {
						'' => q(Тбит),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					'terabyte' => {
						'' => q(Тбайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					'ton' => {
						'' => q(тонн),
						'one' => q({0} тн),
						'other' => q({0} тн),
					},
					'volt' => {
						'' => q(вольт),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					'watt' => {
						'' => q(ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'' => q(дол/хон),
						'one' => q({0} дол/хон),
						'other' => q({0} дол/хон),
					},
					'yard' => {
						'' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'' => q(жил),
						'one' => q({0} жил),
						'other' => q({0} жил),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:тийм|т|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:үгүй|ү|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0М',
					'other' => '0М',
				},
				'10000' => {
					'one' => '00М',
					'other' => '00М',
				},
				'100000' => {
					'one' => '000М',
					'other' => '000М',
				},
				'1000000' => {
					'one' => '0С',
					'other' => '0С',
				},
				'10000000' => {
					'one' => '00С',
					'other' => '00С',
				},
				'100000000' => {
					'one' => '000С',
					'other' => '000С',
				},
				'1000000000' => {
					'one' => '0Т',
					'other' => '0Т',
				},
				'10000000000' => {
					'one' => '00Т',
					'other' => '00Т',
				},
				'100000000000' => {
					'one' => '000Т',
					'other' => '000Т',
				},
				'1000000000000' => {
					'one' => '0ИН',
					'other' => '0ИН',
				},
				'10000000000000' => {
					'one' => '00ИН',
					'other' => '00ИН',
				},
				'100000000000000' => {
					'one' => '000ИН',
					'other' => '000ИН',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 мянга',
					'other' => '0 мянга',
				},
				'10000' => {
					'one' => '00 мянга',
					'other' => '00 мянга',
				},
				'100000' => {
					'one' => '000 мянга',
					'other' => '000 мянга',
				},
				'1000000' => {
					'one' => '0 сая',
					'other' => '0 сая',
				},
				'10000000' => {
					'one' => '00 сая',
					'other' => '00 сая',
				},
				'100000000' => {
					'one' => '000 сая',
					'other' => '000 сая',
				},
				'1000000000' => {
					'one' => '0 тэрбум',
					'other' => '0 тэрбум',
				},
				'10000000000' => {
					'one' => '00 тэрбум',
					'other' => '00 тэрбум',
				},
				'100000000000' => {
					'one' => '000 тэрбум',
					'other' => '000 тэрбум',
				},
				'1000000000000' => {
					'one' => '0 их наяд',
					'other' => '0 их наяд',
				},
				'10000000000000' => {
					'one' => '00 их наяд',
					'other' => '00 их наяд',
				},
				'100000000000000' => {
					'one' => '000 их наяд',
					'other' => '000 их наяд',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0М',
					'other' => '0М',
				},
				'10000' => {
					'one' => '00М',
					'other' => '00М',
				},
				'100000' => {
					'one' => '000М',
					'other' => '000М',
				},
				'1000000' => {
					'one' => '0С',
					'other' => '0С',
				},
				'10000000' => {
					'one' => '00С',
					'other' => '00С',
				},
				'100000000' => {
					'one' => '000С',
					'other' => '000С',
				},
				'1000000000' => {
					'one' => '0Т',
					'other' => '0Т',
				},
				'10000000000' => {
					'one' => '00Т',
					'other' => '00Т',
				},
				'100000000000' => {
					'one' => '000Т',
					'other' => '000Т',
				},
				'1000000000000' => {
					'one' => '0ИН',
					'other' => '0ИН',
				},
				'10000000000000' => {
					'one' => '00ИН',
					'other' => '00ИН',
				},
				'100000000000000' => {
					'one' => '000ИН',
					'other' => '000ИН',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '¤ #,##0.00',
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'negative' => '¤ #,##0.00',
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(арабын нэгдсэн эмиратын дирхам),
				'one' => q(арабын нэгдсэн эмиратын дирхам),
				'other' => q(арабын нэгдсэн эмиратын дирхам),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(афганистаний афгани),
				'one' => q(афганистаний афгани),
				'other' => q(афганистаний афгани),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(албанийн лек),
				'one' => q(албанийн лек),
				'other' => q(албанийн лек),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(арменийн драм),
				'one' => q(арменийн драм),
				'other' => q(арменийн драм),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(нидерландын антиллъя гулдер),
				'one' => q(нидерландын антиллъя гулдер),
				'other' => q(нидерландын антиллъя гулдер),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Ангол кванза),
				'one' => q(ангол кванза),
				'other' => q(ангол кванза),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(аргентин песо),
				'one' => q(аргентин песо),
				'other' => q(аргентин песо),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(австрали доллар),
				'one' => q(австрали доллар),
				'other' => q(австрали доллар),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(арубын флорин),
				'one' => q(арубын флорин),
				'other' => q(арубын флорин),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(азербайжаны манат),
				'one' => q(азербайжаны манат),
				'other' => q(азербайжаны манат),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(босни-герцеговин хөрвөгч марк),
				'one' => q(босни-герцеговин хөрвөгч марк),
				'other' => q(босни-герцеговин хөрвөгч марк),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(барбадос доллар),
				'one' => q(барбадос доллар),
				'other' => q(барбадос доллар),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(бангладешийн така),
				'one' => q(бангладешийн така),
				'other' => q(бангладешийн така),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(болгарийн лев),
				'one' => q(болгарийн лев),
				'other' => q(болгарийн лев),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(бахрейн динар),
				'one' => q(бахрейн динар),
				'other' => q(бахрейн динар),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Бурунд франк),
				'one' => q(бурунд франк),
				'other' => q(бурунд франк),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(бермуд доллар),
				'one' => q(бермуд доллар),
				'other' => q(бермуд доллар),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(бруней доллар),
				'one' => q(бруней доллар),
				'other' => q(бруней доллар),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(боливи боливиано),
				'one' => q(боливи боливиано),
				'other' => q(боливи боливиано),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(бразилийн рил),
				'one' => q(бразилийн рил),
				'other' => q(бразилийн рил),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(багам доллар),
				'one' => q(багам доллар),
				'other' => q(багам доллар),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(бутаны нгултрум),
				'one' => q(бутаны нгултрум),
				'other' => q(бутаны нгултрум),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Ботсвани пула),
				'one' => q(Ботсвани пула),
				'other' => q(Ботсвани пула),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(беларус рубль),
				'one' => q(беларус рубль),
				'other' => q(беларус рубль),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(белиз доллар),
				'one' => q(белиз доллар),
				'other' => q(белиз доллар),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(канад доллар),
				'one' => q(канад доллар),
				'other' => q(канад доллар),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Конго франк),
				'one' => q(конго франк),
				'other' => q(конго франк),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(швейцарь франк),
				'one' => q(швейцарь франк),
				'other' => q(швейцарь франк),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(чилийн песо),
				'one' => q(чилийн песо),
				'other' => q(чилийн песо),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(хятад юань),
				'one' => q(хятад юань),
				'other' => q(хятад юань),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(колумбын песо),
				'one' => q(колумбын песо),
				'other' => q(колумбын песо),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(коста рикагийн колон),
				'one' => q(коста рикагийн колон),
				'other' => q(коста рикагийн колон),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(кубийн хөрвөгч песо),
				'one' => q(кубийн хөрвөгч песо),
				'other' => q(кубийн хөрвөгч песо),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(кубийн песо),
				'one' => q(кубийн песо),
				'other' => q(кубийн песо),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Кабо-Верде эскудо),
				'one' => q(кабо-верде эскудо),
				'other' => q(кабо-верде эскудо),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(чехийн коруна),
				'one' => q(чехийн коруна),
				'other' => q(чехийн коруна),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Жибоути франк),
				'one' => q(жибоути франк),
				'other' => q(жибоути франк),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(данийн крон),
				'one' => q(данийн крон),
				'other' => q(данийн крон),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(доминикын песо),
				'one' => q(доминикын песо),
				'other' => q(доминикын песо),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(алжир доллар),
				'one' => q(алжир доллар),
				'other' => q(алжир доллар),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(египет паунд),
				'one' => q(египет паунд),
				'other' => q(египет паунд),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Эритрей накфа),
				'one' => q(эритрей накфа),
				'other' => q(эритрей накфа),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Этиоп бирр),
				'one' => q(этиоп бирр),
				'other' => q(этиоп бирр),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(евро),
				'one' => q(евро),
				'other' => q(евро),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(фижи доллар),
				'one' => q(фижи доллар),
				'other' => q(фижи доллар),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(фолклэнд арлын паунд),
				'one' => q(фолклэнд арлын паунд),
				'other' => q(фолклэнд арлын паунд),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(британийн фунт стерлинг),
				'one' => q(британийн фунт стерлинг),
				'other' => q(британийн фунт стерлинг),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(гүржийн лари),
				'one' => q(гүржийн лари),
				'other' => q(гүржийн лари),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Гана седи),
				'one' => q(гана седи),
				'other' => q(гана седи),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(гибралтар паунд),
				'one' => q(гибралтар паунд),
				'other' => q(гибралтар паунд),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамби даласи),
				'one' => q(гамби даласи),
				'other' => q(гамби даласи),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гвиней франк),
				'one' => q(гвиней франк),
				'other' => q(гвиней франк),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(гватемалийн кецал),
				'one' => q(гватемалийн кецал),
				'other' => q(гватемалийн кецал),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(гайана доллар),
				'one' => q(гайана доллар),
				'other' => q(гайана доллар),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(хонгконг доллар),
				'one' => q(хонгконг доллар),
				'other' => q(хонгконг доллар),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(гондурасын лемпира),
				'one' => q(гондурасын лемпира),
				'other' => q(гондурасын лемпира),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(хорватын куна),
				'one' => q(хорватын куна),
				'other' => q(хорватын куна),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(гайтийн гоурд),
				'one' => q(гайтийн гоурд),
				'other' => q(гайтийн гоурд),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(унгарийн форинт),
				'one' => q(унгарийн форинт),
				'other' => q(унгарийн форинт),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(индонези рупи),
				'one' => q(индонези рупи),
				'other' => q(индонези рупи),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(израйлийн шинэ шекел),
				'one' => q(израйлийн шинэ шекел),
				'other' => q(израйлийн шинэ шекел),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(энэтхэг рупи),
				'one' => q(энэтхэг рупи),
				'other' => q(энэтхэг рупи),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ирак динар),
				'one' => q(ирак динар),
				'other' => q(ирак динар),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(иран риал),
				'one' => q(иран риал),
				'other' => q(иран риал),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(исландийн крон),
				'one' => q(исландийн крон),
				'other' => q(исландийн крон),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ямайк доллар),
				'one' => q(ямайк доллар),
				'other' => q(ямайк доллар),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(йордан динар),
				'one' => q(йордан динар),
				'other' => q(йордан динар),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(япон иен),
				'one' => q(япон иен),
				'other' => q(япон иен),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Кени шиллинг),
				'one' => q(кени шиллинг),
				'other' => q(Кени шиллинг),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(кыргызын сом),
				'one' => q(кыргызын сом),
				'other' => q(кыргызын сом),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(камбож риел),
				'one' => q(камбож риел),
				'other' => q(камбож риел),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Комор франк),
				'one' => q(комор франк),
				'other' => q(комор франк),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(хойд солонгос вон),
				'one' => q(хойд солонгос вон),
				'other' => q(хойд солонгос вон),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(өмнөд солонгос вон),
				'one' => q(өмнөд солонгос вон),
				'other' => q(өмнөд солонгос вон),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(кувейт динар),
				'one' => q(кувейт динар),
				'other' => q(кувейт динар),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(кайман арлын доллар),
				'one' => q(кайман арлын доллар),
				'other' => q(кайман арлын доллар),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(казахын тэнгэ),
				'one' => q(казахын тэнгэ),
				'other' => q(казахын тэнгэ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(лаосын кип),
				'one' => q(лаосын кип),
				'other' => q(лаосын кип),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ливан паунд),
				'one' => q(ливан паунд),
				'other' => q(ливан паунд),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(шри-ланк рупи),
				'one' => q(шри-ланк рупи),
				'other' => q(шри-ланк рупи),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либери доллар),
				'one' => q(либери доллар),
				'other' => q(либери доллар),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(литвийн литас),
				'one' => q(литвийн литас),
				'other' => q(литвийн литас),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(латвийн лац),
				'one' => q(латвийн лац),
				'other' => q(латвийн лац),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ливи доллар),
				'one' => q(ливи доллар),
				'other' => q(ливи доллар),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(мароккогийн дирхам),
				'one' => q(мароккогийн дирхам),
				'other' => q(мароккогийн дирхам),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(молдавийн леу),
				'one' => q(молдавийн леу),
				'other' => q(молдавийн леу),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Малайн ариари),
				'one' => q(малайн ариари),
				'other' => q(малайн ариари),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(македони динар),
				'one' => q(македони динар),
				'other' => q(македони динар),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(мьянмарын киат),
				'one' => q(мьянмарын киат),
				'other' => q(мьянмарын киат),
			},
		},
		'MNT' => {
			symbol => '₮',
			display_name => {
				'currency' => q(төгрөг),
				'one' => q(төгрөг),
				'other' => q(төгрөг),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(макаогийн патака),
				'one' => q(макаогийн патака),
				'other' => q(макаогийн патака),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мавритан угия),
				'one' => q(мавритан угия),
				'other' => q(мавритан угия),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Мавритын рупи),
				'one' => q(мавритын рупи),
				'other' => q(мавритын рупи),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(мальдив руфия),
				'one' => q(мальдив руфия),
				'other' => q(мальдив руфия),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Малави квача),
				'one' => q(малави квача),
				'other' => q(Малави квача),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(мексикийн песо),
				'one' => q(мексикийн песо),
				'other' => q(мексикийн песо),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(малайзын рингит),
				'one' => q(малайзын рингит),
				'other' => q(малайзын рингит),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Мозамбик метикал),
				'one' => q(мозамбик метикал),
				'other' => q(мозамбик метикал),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Намиби доллар),
				'one' => q(Намиби доллар),
				'other' => q(Намиби доллар),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигери найра),
				'one' => q(нигери найра),
				'other' => q(нигери найра),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(никарагуагийн кордоба),
				'one' => q(никарагуагийн кордоба),
				'other' => q(никарагуагийн кордоба),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(норвегийн крон),
				'one' => q(норвегийн крон),
				'other' => q(норвегийн крон),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(балба рупи),
				'one' => q(балба рупи),
				'other' => q(балба рупи),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(шинэ зеланд доллар),
				'one' => q(шинэ зеланд доллар),
				'other' => q(шинэ зеланд доллар),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(омани риал),
				'one' => q(омани риал),
				'other' => q(омани риал),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(панамын бальбоа),
				'one' => q(панамын бальбоа),
				'other' => q(панамын бальбоа),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(перугийн невосоль),
				'one' => q(перугийн невосоль),
				'other' => q(перугийн невосоль),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(папуа-шинэ гвинейн кина),
				'one' => q(папуа-шинэ гвинейн кина),
				'other' => q(папуа-шинэ гвинейн кина),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(филиппин песо),
				'one' => q(филиппин песо),
				'other' => q(филиппин песо),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(пакистан рупи),
				'one' => q(пакистан рупи),
				'other' => q(пакистан рупи),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(польшийн злот),
				'one' => q(польшийн злот),
				'other' => q(польшийн злот),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(парагвайн гуарани),
				'one' => q(парагвайн гуарани),
				'other' => q(парагвайн гуарани),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(катар риал),
				'one' => q(катар риал),
				'other' => q(катар риал),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(румыны леу),
				'one' => q(румыны леу),
				'other' => q(румыны леу),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(серб динар),
				'one' => q(серб динар),
				'other' => q(серб динар),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(орос рубль),
				'one' => q(орос рубль),
				'other' => q(орос рубль),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Руанд франк),
				'one' => q(руанд франк),
				'other' => q(руанд франк),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(сауди риал),
				'one' => q(сауди риал),
				'other' => q(сауди риал),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(соломон арлын доллар),
				'one' => q(соломон арлын доллар),
				'other' => q(соломон арлын доллар),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Сейшел рупи),
				'one' => q(сейшел рупи),
				'other' => q(сейшел рупи),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(судан паунд),
				'one' => q(судан паунд),
				'other' => q(судан паунд),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(шведийн крон),
				'one' => q(шведийн крон),
				'other' => q(шведийн крон),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(сингапур доллар),
				'one' => q(сингапур доллар),
				'other' => q(сингапур доллар),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Сент Хелена паунд),
				'one' => q(сент хелена паунд),
				'other' => q(сент хелена паунд),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Сьерра Леоне леоне),
				'one' => q(сьерра леоне леоне),
				'other' => q(сьерра леоне леоне),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Сомали шиллинг),
				'one' => q(сомали шиллинг),
				'other' => q(сомали шиллинг),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(суринам доллар),
				'one' => q(суринам доллар),
				'other' => q(суринам доллар),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(өмнөд судан паунд),
				'one' => q(өмнөд судан паунд),
				'other' => q(өмнөд судан паунд),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Сан-Томе ба Принсипи добра),
				'one' => q(сан-томе ба принсипи добра),
				'other' => q(сан-томе ба принсипи добра),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(сири паунд),
				'one' => q(сири паунд),
				'other' => q(сири паунд),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Свазиланд лилангени),
				'one' => q(Свазиланд лилангени),
				'other' => q(Свазиланд лилангени),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(тайландын бат),
				'one' => q(тайландын бат),
				'other' => q(тайландын бат),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(тажикийн сомон),
				'one' => q(тажикийн сомон),
				'other' => q(тажикийн сомон),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(туркмен манат),
				'one' => q(туркмен манат),
				'other' => q(туркмен манат),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(тунис доллар),
				'one' => q(тунис доллар),
				'other' => q(тунис доллар),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(тонгагийн панга),
				'one' => q(тонгагийн панга),
				'other' => q(тонгагийн панга),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(туркийн лира),
				'one' => q(туркийн лира),
				'other' => q(туркийн лира),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(тринидад ба тобаго доллар),
				'one' => q(тринидад ба тобаго доллар),
				'other' => q(тринидад ба тобаго доллар),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(шинэ тайван доллар),
				'one' => q(шинэ тайван доллар),
				'other' => q(шинэ тайван доллар),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Танзани шиллинг),
				'one' => q(танзани шиллинг),
				'other' => q(танзани шиллинг),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(украйны гривня),
				'one' => q(украйны гривня),
				'other' => q(украйны гривня),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Уганд шиллинг),
				'one' => q(Уганд шиллинг),
				'other' => q(Уганд шиллинг),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(америк доллар),
				'one' => q(америк доллар),
				'other' => q(америк доллар),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(уругвайн песо),
				'one' => q(уругвайн песо),
				'other' => q(уругвайн песо),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(узбекын сом),
				'one' => q(узбекын сом),
				'other' => q(узбекын сом),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(венесуэлийн боливар),
				'one' => q(венесуэлийн боливар),
				'other' => q(венесуэлийн боливар),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(вьетнамын донг),
				'one' => q(вьетнамын донг),
				'other' => q(вьетнамын донг),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(вануатугийн вату),
				'one' => q(вануатугийн вату),
				'other' => q(вануатугийн вату),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(самоагийн тала),
				'one' => q(самоагийн тала),
				'other' => q(самоагийн тала),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(Франк КФА BEAC),
				'one' => q(франк КФА BEAC),
				'other' => q(франк КФА BEAC),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(зүүн карибийн доллар),
				'one' => q(зүүн карибийн доллар),
				'other' => q(зүүн карибийн доллар),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(Франк КФА BCЕАО),
				'one' => q(франк КФА BCЕАО),
				'other' => q(франк КФА BCЕАО),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP франк),
				'one' => q(CFP франк),
				'other' => q(CFP франк),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Тодорхойгүй мөнгөн тэмдэгт),
				'one' => q(\(тодорхойгүй мөнгөн тэмдэгтийн нэгж\)),
				'other' => q(\(тодорхойгүй мөнгөн тэмдэгт\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(йемен риал),
				'one' => q(йемен риал),
				'other' => q(йемен риал),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Өмнөд Африкийн ранд),
				'one' => q(Өмнөд Африкийн ранд),
				'other' => q(Өмнөд Африкийн ранд),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замби квача \(1968–2012\)),
				'one' => q(Замби квача \(1968–2012\)),
				'other' => q(Замби квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Замби квача),
				'one' => q(Замби квача),
				'other' => q(Замби квача),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1-р сар',
							'2-р сар',
							'3-р сар',
							'4-р сар',
							'5-р сар',
							'6-р сар',
							'7-р сар',
							'8-р сар',
							'9-р сар',
							'10-р сар',
							'11-р сар',
							'12-р сар'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Нэгдүгээр сар',
							'Хоёрдугаар сар',
							'Гуравдугаар сар',
							'Дөрөвдүгээр сар',
							'Тавдугаар сар',
							'Зургадугаар сар',
							'Долдугаар сар',
							'Наймдугаар сар',
							'Есдүгээр сар',
							'Аравдугаар сар',
							'Арван нэгдүгээр сар',
							'Арван хоёрдугаар сар'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'1-р сар',
							'2-р сар',
							'3-р сар',
							'4-р сар',
							'5-р сар',
							'6-р сар',
							'7-р сар',
							'8-р сар',
							'9-р сар',
							'10-р сар',
							'11-р сар',
							'12-р сар'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Нэгдүгээр сар',
							'Хоёрдугаар сар',
							'Гуравдугаар сар',
							'Дөрөвдүгээр сар',
							'Тавдугаар сар',
							'Зургадугаар сар',
							'Долдугаар сар',
							'Наймдугаар сар',
							'Есдүгээр сар',
							'Аравдугаар сар',
							'Арван нэгдүгээр сар',
							'Арван хоёрдугаар сар'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					narrow => {
						mon => '2',
						tue => '3',
						wed => '4',
						thu => '5',
						fri => '6',
						sat => '7',
						sun => '1'
					},
					short => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					wide => {
						mon => 'даваа',
						tue => 'мягмар',
						wed => 'лхагва',
						thu => 'пүрэв',
						fri => 'баасан',
						sat => 'бямба',
						sun => 'ням'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					narrow => {
						mon => '2',
						tue => '3',
						wed => '4',
						thu => '5',
						fri => '6',
						sat => '7',
						sun => '1'
					},
					short => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					wide => {
						mon => 'даваа',
						tue => 'мягмар',
						wed => 'лхагва',
						thu => 'пүрэв',
						fri => 'баасан',
						sat => 'бямба',
						sun => 'ням'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'У1',
						1 => 'У2',
						2 => 'У3',
						3 => 'У4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-р улирал',
						1 => '2-р улирал',
						2 => '3-р улирал',
						3 => '4-р улирал'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'У1',
						1 => 'У2',
						2 => 'У3',
						3 => 'У4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1-р улирал',
						1 => '2-р улирал',
						2 => '3-р улирал',
						3 => '4-р улирал'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'am' => q{үө},
					'noon' => q{үд},
					'pm' => q{үх},
				},
				'wide' => {
					'am' => q{ҮӨ},
					'noon' => q{үд дунд},
					'pm' => q{ҮХ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'МЭӨ',
				'1' => 'МЭ'
			},
			narrow => {
				'0' => 'м.э.ө',
				'1' => 'м.э.'
			},
			wide => {
				'0' => 'манай эриний өмнөх',
				'1' => 'манай эриний'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, G y 'оны' MM 'сарын' dd},
			'long' => q{G y 'оны' MM 'сарын' d},
			'medium' => q{G y MM d},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{EEEE, y 'оны' MM 'сарын' d},
			'long' => q{y 'оны' MM 'сарын' d},
			'medium' => q{y MMM d},
			'short' => q{y-MM-dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{dd E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{E, G y MMM d},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, M-d},
			MMM => q{LLL},
			MMMEd => q{E MMM d},
			MMMd => q{MMM d},
			Md => q{M-d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{y-M},
			yMEd => q{E, y-M-d},
			yMMM => q{y MMM},
			yMMMEd => q{E, y MMM d},
			yMMMd => q{y MMM d},
			yMd => q{y-M-d},
			yQQQ => q{y QQQ},
			yQQQQ => q{y 'оны' QQQQ},
		},
		'generic' => {
			Ed => q{dd E},
			Gy => q{G y},
			GyMMM => q{G y MM},
			GyMMMEd => q{E, G y MMM d},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, M-d},
			MMM => q{LLL},
			MMMEd => q{E MMM d},
			MMMd => q{MMM d},
			Md => q{M-d},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{G y-M},
			yyyyMEd => q{E, G y-M-d},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{E, G y MMM d},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{G y-M-d},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y 'оны' QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, MM/dd - E, MM/dd},
				d => q{E, MM/dd - E, MM/dd},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, MM/dd - E, MM/dd},
				d => q{E, MM/dd - E, MM/dd},
			},
			MMMd => {
				M => q{MM/d - MM/d},
				d => q{MM/d-d},
			},
			Md => {
				M => q{MM/dd-MM/dd},
				d => q{MM/dd-MM/dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{y/MM-MM},
				y => q{y/MM - y/MM},
			},
			yMEd => {
				M => q{E, y/MM/dd – E, y/MM/dd},
				d => q{E, y/MM/dd – E, y/MM/dd},
				y => q{E, y/MM/dd – E, y/MM/dd},
			},
			yMMM => {
				M => q{y/MM-MM},
				y => q{y/MM - y/MM},
			},
			yMMMEd => {
				M => q{E, y/MM/dd – E, y/MM/dd},
				d => q{E, y/MM/dd – E, y/MM/dd},
				y => q{E, y/MM/dd – E, y/MM/dd},
			},
			yMMMM => {
				M => q{y 'оны' MM-MM-'р' 'сар'},
				y => q{y/MM -y/MM},
			},
			yMMMd => {
				M => q{y/MM/dd - MM/dd},
				d => q{y/MM/d-d},
				y => q{y/MM/dd - y/MM/dd},
			},
			yMd => {
				M => q{y/MM/dd -MM/dd},
				d => q{y/MM/dd-dd},
				y => q{y/MM/dd - y/MM/dd},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, MM/dd - E, MM/dd},
				d => q{E, MM/dd - E, MM/dd},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{E, MM/dd - E, MM/dd},
				d => q{E, MM/dd - E, MM/dd},
			},
			MMMd => {
				M => q{MM/d - MM/d},
				d => q{MM/d-d},
			},
			Md => {
				M => q{MM/dd-MM/dd},
				d => q{MM/dd-MM/dd},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{G y/MM-MM},
				y => q{G y/MM - y/MM},
			},
			yMEd => {
				M => q{E, G y/MM/dd – E, y/MM/dd},
				d => q{E, G y/MM/dd – E, y/MM/dd},
				y => q{E, G y/MM/dd – E, y/MM/dd},
			},
			yMMM => {
				M => q{G y/MM-MM},
				y => q{G y/MM - y/MM},
			},
			yMMMEd => {
				M => q{E, G y/MM/dd – E, y/MM/dd},
				d => q{E, G y/MM/dd – E, y/MM/dd},
				y => q{E, G y/MM/dd – E, y/MM/dd},
			},
			yMMMM => {
				M => q{G y 'оны' MM-MM-'р' 'сар'},
				y => q{G y/MM -y/MM},
			},
			yMMMd => {
				M => q{G y/MM/dd - MM/dd},
				d => q{G y/MM/d-d},
				y => q{G y/MM/dd - y/MM/dd},
			},
			yMd => {
				M => q{G y/MM/dd -MM/dd},
				d => q{G y/MM/dd-dd},
				y => q{G y/MM/dd - y/MM/dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0}-н цагаар),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(Афганистаны цаг),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абижан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуй#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Биссау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавиль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-эс-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Жибоути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эль-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Жуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревиль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монрова#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нжамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Том#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Төв Африкийн цаг),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Зүүн Африкийн цаг),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Өмнөд Африкийн стандарт цаг),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Баруун Африкийн зуны цаг),
				'generic' => q(Баруун Африкийн цаг),
				'standard' => q(Баруун Африкийн стандарт цаг),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Аляскийн зуны цаг),
				'generic' => q(Аляскийн цаг),
				'standard' => q(Аляскийн стандарт цаг),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Амазоны зуны цаг),
				'generic' => q(Амазоны цаг),
				'standard' => q(Амазоны стандарт цаг),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкораж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилла#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио-Гальегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуайя#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Байя#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Бахья Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Боисе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кэмбриж бэй#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо-Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайенна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Атикокан#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Куракао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмаркшавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Эль Сальвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс бэй#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нүүк#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гуус бэй#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделуп#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемал#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякиль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гуяана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Хермосилло#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивей, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсенес, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичелло, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендик#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анжелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Ловер Принсес Квартер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Маригот#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико хот#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норона#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Била, Хойд Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Төв, Хойд Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем, Хойд Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Ожинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Принс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Рэнкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио-Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Изабель#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санта Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорсбисунн#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент Бартельми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент Жонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Киттс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент Люсиа#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Сандер Бэй#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорз#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Йелоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Төв зуны цаг),
				'generic' => q(Төв цаг),
				'standard' => q(Төв стандарт цаг),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Зүүн эргийн зуны цаг),
				'generic' => q(Зүүн эргийн цаг),
				'standard' => q(Зүүн эргийн стандарт цаг),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Уулын зуны цаг),
				'generic' => q(Уулын цаг),
				'standard' => q(Уулын стандарт цаг),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Номхон далайн зуны цаг),
				'generic' => q(Номхон далайн цаг),
				'standard' => q(Номхон далайн стандарт цаг),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кэсей#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дэвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон д’Юрвиль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мёрдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сьёва#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q(Апиагийн зуны цаг),
				'generic' => q(Апиагийн цаг),
				'standard' => q(Апиагийн стандарт цаг),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Арабын зуны цаг),
				'generic' => q(Арабын цаг),
				'standard' => q(Арабын стандарт цаг),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгирбюен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Аргентины зуны цаг),
				'generic' => q(Аргентины цаг),
				'standard' => q(Аргентины стандарт цаг),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Баруун Аргентины зуны цаг),
				'generic' => q(Баруун Аргентины цаг),
				'standard' => q(Баруун Аргентины стандарт цаг),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Арменийн зуны цаг),
				'generic' => q(Арменийн цаг),
				'standard' => q(Арменийн стандарт цаг),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадыр#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актөбе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#Чунцин#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#Харбин#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Эрхүү#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Жакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Жайпур#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Ерусалем#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#Кашгар#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Кандяга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучин#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макассар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхеньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызылорд#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Рияд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сөүл#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайпей#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхимпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улаанбаатар#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Үрүмчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вьентьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Атлантын зуны цаг),
				'generic' => q(Атлантын цаг),
				'standard' => q(Атлантын стандарт цаг),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азор#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канари#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кейп Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фароэ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рекьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Өмнөд Жоржиа#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Сент Хелена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнлей#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделэйд#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбэн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хилл#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Кюрри#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Еукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдемэн#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перс#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Төв Австралийн зуны цаг),
				'generic' => q(Төв Австралийн цаг),
				'standard' => q(Төв Австралийн стандарт цаг),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Австралийн төв баруун эргийн зуны цаг),
				'generic' => q(Австралийн төв баруун эргийн цаг),
				'standard' => q(Австралийн төв баруун эргийн стандарт цаг),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Австралийн зүүн эргийн зуны цаг),
				'generic' => q(Зүүн Австралийн цаг),
				'standard' => q(Австралийн зүүн эргийн стандарт цаг),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Австралийн баруун эргийн зуны цаг),
				'generic' => q(Баруун Австралийн цаг),
				'standard' => q(Австралийн баруун эргийн стандарт цаг),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Азербайжаны зуны цаг),
				'generic' => q(Азербайжаны цаг),
				'standard' => q(Азербайжаны стандарт цаг),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Азорын зуны цаг),
				'generic' => q(Азорын цаг),
				'standard' => q(Азорын стандарт цаг),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Бангладешийн зуны цаг),
				'generic' => q(Бангладешийн цаг),
				'standard' => q(Бангладешийн стандарт цаг),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Бутаны цаг),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Боливийн цаг),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Бразилийн зуны цаг),
				'generic' => q(Бразилийн цаг),
				'standard' => q(Бразилийн стандарт цаг),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Бруней Дарассаламын цаг),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Кэйп Вердийн зуны цаг),
				'generic' => q(Кэйп Вердийн цаг),
				'standard' => q(Кэйп Вердийн стандарт цаг),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Чаморрогийн цаг),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Чэтамын зуны цаг),
				'generic' => q(Чэтамын цаг),
				'standard' => q(Чэтамын стандарт цаг),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Чилийн зуны цаг),
				'generic' => q(Чилийн цаг),
				'standard' => q(Чилийн стандарт цаг),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Хятадын зуны цаг),
				'generic' => q(Хятадын цаг),
				'standard' => q(Хятадын стандарт цаг),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Чойбалсангийн зуны цаг),
				'generic' => q(Чойбалсангийн цаг),
				'standard' => q(Чойбалсангийн стандарт цаг),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Крисмас арлын цаг),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Кокос арлын цаг),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Колумбын зуны цаг),
				'generic' => q(Колумбын цаг),
				'standard' => q(Колумбын стандарт цаг),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Күүк арлын хагас зуны цаг),
				'generic' => q(Күүк арлын цаг),
				'standard' => q(Күүк арлын стандарт цаг),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Кубын зуны цаг),
				'generic' => q(Кубын цаг),
				'standard' => q(Кубын стандарт цаг),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Дэвисийн цаг),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Дюмон д’Юрвилийн цаг),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Зүүн Тиморын цаг),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Истерын Арлын зуны цаг),
				'generic' => q(Истерын Арлын цаг),
				'standard' => q(Истерын Арлын стандарт цаг),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Эквадорын цаг),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Тодорхойгүй хот#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афин#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислав#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бусинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинёв#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q(Ирландын стандарт цаг),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хельсинк#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн Арал#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Жерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисбон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(Британийн зуны цаг),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Парис#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Ром#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопье#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшав#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожье#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Төв Европын зуны цаг),
				'generic' => q(Төв Европын цаг),
				'standard' => q(Төв Европын стандарт цаг),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Зүүн Европын зуны цаг),
				'generic' => q(Зүүн Европын цаг),
				'standard' => q(Зүүн Европын стандарт цаг),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(Алс дорнод Европын цаг),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Баруун Европын зуны цаг),
				'generic' => q(Баруун Европын цаг),
				'standard' => q(Баруун Европын стандарт цаг),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Фолькландын Арлуудын зуны цаг),
				'generic' => q(Фолькландын Арлуудын цаг),
				'standard' => q(Фолькландын Арлуудын стандарт цаг),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Фижигийн зуны цаг),
				'generic' => q(Фижигийн цаг),
				'standard' => q(Фижигийн стандарт цаг),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Францын Гияанагийн цаг),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Францын Өмнөд ба Антарктик цаг),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Гринвичийн үндсэн цаг),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Галапагосын цаг),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Гамбьегийн цаг),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Гүржийн зуны цаг),
				'generic' => q(Гүржийн цаг),
				'standard' => q(Гүржийн стандарт цаг),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Жильбер арлын цаг),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Зүүн Гринландын зуны цаг),
				'generic' => q(Зүүн Гринландын цаг),
				'standard' => q(Зүүн Гринландын стандарт цаг),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Баруун Гринландын зуны цаг),
				'generic' => q(Баруун Гринландын цаг),
				'standard' => q(Баруун Гринландын стандарт цаг),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Гольфийн стандарт цаг),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Гуяанагийн цаг),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Хавай-Алеутын зуны цаг),
				'generic' => q(Хавай-Алеутын цаг),
				'standard' => q(Хавай-Алеутын стандарт цаг),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Хонг Конгын зуны цаг),
				'generic' => q(Хонг Конгын цаг),
				'standard' => q(Хонг Конгын стандарт цаг),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Ховдын зуны цаг),
				'generic' => q(Ховдын цаг),
				'standard' => q(Ховдын стандарт цаг),
			},
		},
		'India' => {
			long => {
				'standard' => q(Энэтхэгийн цаг),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Крисмас#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдив#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Мавриту#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюньон#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Энэтхэгийн далайн цаг),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Энэтхэг-Хятадын хойгийн цаг),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Төв Индонезийн цаг),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Зүүн Индонезийн цаг),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Баруун Индонезийн цаг),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Ираны зуны цаг),
				'generic' => q(Ираны цаг),
				'standard' => q(Ираны стандарт цаг),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Эрхүүгийн зуны цаг),
				'generic' => q(Эрхүүгийн цаг),
				'standard' => q(Эрхүүгийн стандарт цаг),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Израилийн зуны цаг),
				'generic' => q(Израилийн цаг),
				'standard' => q(Израилийн стандарт цаг),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Японы зуны цаг),
				'generic' => q(Японы цаг),
				'standard' => q(Японы стандарт цаг),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Зүүн Казахстаны цаг),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Баруун Казахстаны цаг),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Солонгосын зуны цаг),
				'generic' => q(Солонгосын цаг),
				'standard' => q(Солонгосын стандарт цаг),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Косраегийн цаг),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Красноярскийн зуны цаг),
				'generic' => q(Красноярскийн цаг),
				'standard' => q(Красноярскийн стандарт цаг),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Кыргызстаны цаг),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Лайн арлын цаг),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Лорд Хаугийн зуны цаг),
				'generic' => q(Лорд Хаугийн цаг),
				'standard' => q(Лорд Хаугийн стандарт цаг),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Маккуори Арлын цаг),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Магаданы зуны цаг),
				'generic' => q(Магаданы цаг),
				'standard' => q(Магаданы стандарт цаг),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Малайзийн цаг),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Мальдивийн цаг),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Маркесасын цаг),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Маршаллын арлын цаг),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Мавритусын зуны цаг),
				'generic' => q(Мавритусын цаг),
				'standard' => q(Мавритусын стандарт цаг),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Моусоны цаг),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(Баруун хойд Мексикийн зуны цаг),
				'generic' => q(Баруун хойд Мексикийн цаг),
				'standard' => q(Баруун хойд Мексикийн стандарт цаг),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(Мексикийн номхон далайн зуны цаг),
				'generic' => q(Мексикийн номхон далайн цаг),
				'standard' => q(Мексикийн номхон далайн стандарт цаг),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Улаанбаатарын зуны цаг),
				'generic' => q(Улаанбаатарын цаг),
				'standard' => q(Улаанбаатарын стандарт цаг),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Москвагийн зуны цаг),
				'generic' => q(Москвагийн цаг),
				'standard' => q(Москвагийн стандарт цаг),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Мьянмарын цаг),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Науругийн цаг),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Балбын цаг),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Шинэ Каледонийн зуны цаг),
				'generic' => q(Шинэ Каледонийн цаг),
				'standard' => q(Шинэ Каледонийн стандарт цаг),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Шинэ Зеландын зуны цаг),
				'generic' => q(Шинэ Зеландын цаг),
				'standard' => q(Шинэ Зеландын стандарт цаг),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Нью-Фаундлендын зуны цаг),
				'generic' => q(Нью-Фаундлендын цаг),
				'standard' => q(Нью-Фаундлендын стандарт цаг),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Ниуэгийн цаг),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Норфолк Арлын цаг),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Фернандо де Норонагийн зуны цаг),
				'generic' => q(Фернандо де Норонагийн цаг),
				'standard' => q(Фернандо де Норонагийн стандарт цаг),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Новосибирскийн зуны цаг),
				'generic' => q(Новосибирскийн цаг),
				'standard' => q(Новосибирскийн стандарт цаг),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Омскийн зуны цаг),
				'generic' => q(Омскийн цаг),
				'standard' => q(Омскийн стандарт цаг),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Оклэнд#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Истер#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фижи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбьер#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Жонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косраэ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кважалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мажуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркизас#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвей#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкейрн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпей#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чүүк#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уэйк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Пакистаны зуны цаг),
				'generic' => q(Пакистаны цаг),
				'standard' => q(Пакистаны стандарт цаг),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Палаугийн цаг),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Папуа Шинэ Гвинейн цаг),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Парагвайн зуны цаг),
				'generic' => q(Парагвайн цаг),
				'standard' => q(Парагвайн стандарт цаг),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Перугийн зуны цаг),
				'generic' => q(Перугийн цаг),
				'standard' => q(Перугийн стандарт цаг),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Филиппины зуны цаг),
				'generic' => q(Филиппины цаг),
				'standard' => q(Филиппины стандарт цаг),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Феникс арлын цаг),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Сент-Пьерре ба Микелоны зуны цаг),
				'generic' => q(Сент-Пьерре ба Микелоны цаг),
				'standard' => q(Сент-Пьерре ба Микелоны стандарт цаг),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Питкернийн цаг),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Понапегийн цаг),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Реюньоны цаг),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Ротерагийн цаг),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Сахалины зуны цаг),
				'generic' => q(Сахалины цаг),
				'standard' => q(Сахалины стандарт цаг),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Самоагийн зуны цаг),
				'generic' => q(Самоагийн цаг),
				'standard' => q(Самоагийн стандарт цаг),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Сейшелийн цаг),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Сингапурын цаг),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Соломоны Арлуудын цаг),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Өмнөд Жоржийн цаг),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Суринамын цаг),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Сёвагийн цаг),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Таитигийн цаг),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Тайпейн зуны цаг),
				'generic' => q(Тайпейн цаг),
				'standard' => q(Тайпейн стандарт цаг),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Тажикистаны цаг),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Токелаугийн цаг),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Тонгагийн зуны цаг),
				'generic' => q(Тонгагийн цаг),
				'standard' => q(Тонгагийн стандарт цаг),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Чүүкийн цаг),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Туркменистаны зуны цаг),
				'generic' => q(Туркменистаны цаг),
				'standard' => q(Туркменистаны стандарт цаг),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Тувалугийн цаг),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Уругвайн зуны цаг),
				'generic' => q(Уругвайн цаг),
				'standard' => q(Уругвайн стандарт цаг),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Узбекистаны зуны цаг),
				'generic' => q(Узбекистаны цаг),
				'standard' => q(Узбекистаны стандарт цаг),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Вануатугийн зуны цаг),
				'generic' => q(Вануатугийн цаг),
				'standard' => q(Вануатугийн стандарт цаг),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Венесуэлийн цаг),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Владивостокийн зуны цаг),
				'generic' => q(Владивостокийн цаг),
				'standard' => q(Владивостокийн стандарт цаг),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Волгоградын зуны цаг),
				'generic' => q(Волгоградын цаг),
				'standard' => q(Волгоградын стандарт цаг),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Востокийн цаг),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Вейк арлын цаг),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Уоллис ба Футунагийн цаг),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Якутын зуны цаг),
				'generic' => q(Якутын цаг),
				'standard' => q(Якутын стандарт цаг),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Екатеринбургийн зуны цаг),
				'generic' => q(Екатеринбургийн цаг),
				'standard' => q(Екатеринбургийн стандарт цаг),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
