package Locale::CLDR::Ur;
# This file auto generated from Data\common\main\ur.xml
#	on Sun 18 May 12:40:30 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use version;

our $VERSION = version->declare('v0.25.1');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}،{1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'ابقازیان',
 				'ach' => 'اکولی',
 				'af' => 'ایفریکانز',
 				'ak' => 'اکان',
 				'am' => 'امہاری',
 				'ar' => 'عربی',
 				'ar_001' => 'ماڈرن اسٹینڈرڈ عربی',
 				'as' => 'آسامی',
 				'ay' => 'ایمارا',
 				'az' => 'آزربائیجانی',
 				'az@alt=short' => 'ازیری',
 				'be' => 'بیلاروسی',
 				'bem' => 'بیمبا',
 				'bg' => 'بلغاری',
 				'bn' => 'بنگالی',
 				'bo' => 'تبتی',
 				'br' => 'بریٹن',
 				'bs' => 'بوسنی',
 				'ca' => 'کاٹالانین',
 				'chr' => 'چیروکی',
 				'ckb' => 'سورانی کردش',
 				'co' => 'کوراسیکن',
 				'cs' => 'چیک',
 				'cy' => 'ویلش',
 				'da' => 'ڈینش',
 				'de' => 'جرمن',
 				'de_AT' => 'آسٹریائی جرمن',
 				'de_CH' => 'سوئس ہائی جرمن',
 				'dv' => 'ڈیویہی',
 				'dz' => 'ژونگکھا',
 				'ee' => 'ایو',
 				'efi' => 'ایفِک',
 				'el' => 'یونانی',
 				'en' => 'انگریزی',
 				'en_AU' => 'آسٹریلیائی انگریزی',
 				'en_CA' => 'کینیڈین انگریزی',
 				'en_GB' => 'برطانوی انگریزی',
 				'en_GB@alt=short' => 'برطانوی انگلش',
 				'en_US' => 'امریکی انگریزی',
 				'en_US@alt=short' => 'امریکی انگلش',
 				'eo' => 'ایسپرانٹو',
 				'es' => 'ہسپانوی',
 				'es_419' => 'لاطینی امریکی ہسپانوی',
 				'es_ES' => 'یورپی ہسپانوی',
 				'es_MX' => 'میکسیکن ہسپانوی',
 				'et' => 'اسٹونین',
 				'eu' => 'باسکی',
 				'fa' => 'فارسی',
 				'fi' => 'فینیش',
 				'fil' => 'فلیپینو',
 				'fj' => 'فجی کا باشندہ',
 				'fo' => 'فیروئیز',
 				'fr' => 'فرانسیسی',
 				'fr_CA' => 'کینیڈین فرانسیسی',
 				'fr_CH' => 'سوئس فرینچ',
 				'fy' => 'مغربی فریسیئن',
 				'ga' => 'آئیرِش',
 				'gaa' => 'گا',
 				'gd' => 'سکاٹ گیلِک',
 				'gl' => 'گالیشیائی',
 				'gn' => 'گُارانی',
 				'gsw' => 'سوئس جرمن',
 				'gu' => 'گجراتی',
 				'ha' => 'ہؤسا',
 				'haw' => 'ہوائی کا باشندہ',
 				'he' => 'عبرانی',
 				'hi' => 'ہندی',
 				'hr' => 'کراتی',
 				'ht' => 'ہیتی',
 				'hu' => 'ہنگیرین',
 				'hy' => 'ارمینی',
 				'ia' => 'بین لسانیات',
 				'id' => 'انڈونیثیائی',
 				'ig' => 'اِگبو',
 				'is' => 'آئس لینڈ کا باشندہ',
 				'it' => 'اطالوی',
 				'ja' => 'جاپانی',
 				'jv' => 'جاوی',
 				'ka' => 'جارجی',
 				'kg' => 'کانگو',
 				'kk' => 'قزاخ',
 				'km' => 'خمیر',
 				'kn' => 'کنّاڈا',
 				'ko' => 'کورین',
 				'ks' => 'کشمیری',
 				'ku' => 'کردش',
 				'ky' => 'کرغیزی',
 				'la' => 'لاطینی',
 				'lb' => 'لگژمبرگ کا باشندہ',
 				'lg' => 'گینڈا',
 				'ln' => 'لِنگَلا',
 				'lo' => 'لاؤ',
 				'loz' => 'لوزی',
 				'lt' => 'لتھُواینین',
 				'lua' => 'لیوبا لولوآ',
 				'lv' => 'لیٹوین',
 				'mfe' => 'موریسیین',
 				'mg' => 'ملاگاسی',
 				'mi' => 'ماؤری',
 				'mk' => 'مقدونیائی',
 				'ml' => 'مالایالم',
 				'mn' => 'منگؤلی',
 				'mr' => 'مراٹهی',
 				'ms' => 'مالائی',
 				'mt' => 'مالٹی',
 				'my' => 'برمی',
 				'nb' => 'نارویجین بوکمل',
 				'nd' => 'شمالی دبیل',
 				'ne' => 'نیپالی',
 				'nl' => 'ڈچ',
 				'nl_BE' => 'فلیمِش',
 				'nn' => 'نورویجینی نینورسک',
 				'no' => 'نارویجین',
 				'nso' => 'شمالی سوتھو',
 				'ny' => 'نیانجا',
 				'nyn' => 'نینکول',
 				'oc' => 'آکسیٹان',
 				'om' => 'اورومو',
 				'or' => 'اورِیا',
 				'os' => 'اوسیٹک',
 				'pa' => 'پنجابی',
 				'pl' => 'پولستانی',
 				'ps' => 'پشتو',
 				'pt' => 'پُرتگالی',
 				'pt_BR' => 'برازیلی پرتگالی',
 				'pt_PT' => 'یورپی پرتگالی',
 				'qu' => 'کویچوآ',
 				'rm' => 'رومانش',
 				'rn' => 'رونڈی',
 				'ro' => 'رومنی',
 				'ru' => 'روسی',
 				'rw' => 'کینیاروانڈا',
 				'sa' => 'سَنسکرِت',
 				'sd' => 'سندھی',
 				'se' => 'شمالی سامی',
 				'sg' => 'سانگو',
 				'sh' => 'سربو-کروئیشین',
 				'si' => 'سنہالا',
 				'sk' => 'سلوواک',
 				'sl' => 'سلووینیائی',
 				'sm' => 'ساموآن',
 				'sn' => 'شونا',
 				'so' => 'صومالی',
 				'sq' => 'البانی',
 				'sr' => 'صربی',
 				'ss' => 'سواتی',
 				'st' => 'جنوبی سوتھو',
 				'su' => 'سنڈانیز',
 				'sv' => 'سویڈش',
 				'sw' => 'سواحلی',
 				'ta' => 'تمل',
 				'te' => 'تیلگو',
 				'tet' => 'ٹیٹم',
 				'tg' => 'تاجک',
 				'th' => 'تھائی',
 				'ti' => 'ٹگرینیا',
 				'tk' => 'ترکمان',
 				'tl' => 'ٹیگا لوگ',
 				'tlh' => 'کلنگن',
 				'tn' => 'سوانا',
 				'to' => 'ٹونگن',
 				'tpi' => 'ٹوک پِسِن',
 				'tr' => 'ترکی',
 				'ts' => 'زونگا',
 				'tt' => 'تاتار',
 				'tum' => 'ٹمبوکا',
 				'tw' => 'توی',
 				'ty' => 'تاہیتی',
 				'ug' => 'یوئگہر',
 				'uk' => 'یوکرینیائی',
 				'und' => 'نامعلوم زبان',
 				'ur' => 'اردو',
 				'uz' => 'ازبیک',
 				've' => 'وینڈا',
 				'vi' => 'ویتنامی',
 				'wo' => 'وولوف',
 				'xh' => 'ژوسا',
 				'yi' => 'یدش',
 				'yo' => 'یوروبا',
 				'zgh' => 'اسٹینڈرڈ مغربی امازیقی',
 				'zh' => 'چینی',
 				'zh_Hans' => 'چینی (آسان کردہ)',
 				'zh_Hant' => 'روایتی چینی',
 				'zu' => 'زولو',
 				'zxx' => 'کوئی لسانی مواد نہیں',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'عربی',
 			'Arab@alt=variant' => 'فارسی عربی',
 			'Armn' => 'آرمینیائی',
 			'Beng' => 'بنگالی',
 			'Bopo' => 'بوپوموفو',
 			'Brai' => 'بریل',
 			'Cyrl' => 'کریلِک',
 			'Deva' => 'دیوناگری',
 			'Ethi' => 'ایتھوپیا کا باشندہ',
 			'Geor' => 'جارجیا کا باشندہ',
 			'Grek' => 'یونانی',
 			'Gujr' => 'گجراتی',
 			'Guru' => 'گرمکھی',
 			'Hang' => 'ہنگول',
 			'Hani' => 'ہان',
 			'Hans' => 'آسان',
 			'Hans@alt=stand-alone' => 'آسان ہان',
 			'Hant' => 'روایتی',
 			'Hant@alt=stand-alone' => 'روایتی ہان',
 			'Hebr' => 'عبرانی',
 			'Hira' => 'ہیراگینا',
 			'Jpan' => 'جاپانی',
 			'Kana' => 'کٹاکانا',
 			'Khmr' => 'خمیر',
 			'Knda' => 'کنڑ',
 			'Kore' => 'کوریائی',
 			'Laoo' => 'لاؤ',
 			'Latn' => 'لاطینی',
 			'Mlym' => 'ملیالم',
 			'Mong' => 'منگولیائی',
 			'Mymr' => 'میانمار',
 			'Orya' => 'اڑیہ',
 			'Sinh' => 'سنہالا',
 			'Taml' => 'تمل',
 			'Telu' => 'تیلگو',
 			'Thaa' => 'تھانا',
 			'Thai' => 'تھائی',
 			'Tibt' => 'تبتی',
 			'Zsym' => 'علامات',
 			'Zxxx' => 'غیر تحریر شدہ',
 			'Zyyy' => 'عام',
 			'Zzzz' => 'نامعلوم رسم الخط',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'دنیا',
 			'002' => 'افریقہ',
 			'003' => 'شمالی امریکہ',
 			'005' => 'جنوبی امریکہ',
 			'009' => 'اوشیانیا',
 			'011' => 'مغربی افریقہ',
 			'013' => 'وسطی امریکہ',
 			'014' => 'مشرقی افریقہ',
 			'015' => 'شمالی افریقہ',
 			'017' => 'وسطی افریقہ',
 			'018' => 'جنوبی افریقہ کے علاقہ',
 			'019' => 'امیریکاز',
 			'021' => 'شمالی امریکہ کا علاقہ',
 			'029' => 'کریبیائی',
 			'030' => 'مشرقی ایشیا',
 			'034' => 'جنوبی ایشیا',
 			'035' => 'جنوب مشرقی ایشیا',
 			'039' => 'جنوبی یورپ',
 			'053' => 'آسٹریلیشیا',
 			'054' => 'مالینیشیا',
 			'057' => 'مائکرونیشیائی علاقہ',
 			'061' => 'پولینیشیا',
 			'142' => 'ایشیا',
 			'143' => 'وسطی ایشیا',
 			'145' => 'مغربی ایشیا',
 			'150' => 'یوروپ',
 			'151' => 'مشرقی یورپ',
 			'154' => 'شمالی یورپ',
 			'155' => 'مغربی یورپ',
 			'419' => 'لاطینی امریکہ',
 			'AC' => 'اسکینسیئن آئلینڈ',
 			'AD' => 'انڈورا',
 			'AE' => 'متحدہ عرب امارات',
 			'AF' => 'افغانستان',
 			'AG' => 'انٹیگوا اور باربودا',
 			'AI' => 'انگوئیلا',
 			'AL' => 'البانیہ',
 			'AM' => 'آرمینیا',
 			'AN' => 'نیدرلینڈز انٹیلیز',
 			'AO' => 'انگولا',
 			'AQ' => 'انٹارکٹیکا',
 			'AR' => 'ارجنٹینا',
 			'AS' => 'امریکی ساموآ',
 			'AT' => 'آسٹریا',
 			'AU' => 'آسٹریلیا',
 			'AW' => 'اروبا',
 			'AX' => 'آلینڈ آئلینڈز',
 			'AZ' => 'آذربائجان',
 			'BA' => 'بوسنیا اور ہرزیگووینا',
 			'BB' => 'باربادوس',
 			'BD' => 'بنگلہ دیش',
 			'BE' => 'بیلجیم',
 			'BF' => 'برکینا فاسو',
 			'BG' => 'بلغاریہ',
 			'BH' => 'بحرین',
 			'BI' => 'برونڈی',
 			'BJ' => 'بینن',
 			'BL' => 'سینٹ برتھلیمی',
 			'BM' => 'برمودا',
 			'BN' => 'برونئی',
 			'BO' => 'بولیویا',
 			'BQ' => 'کریبیائی نیدرلینڈز',
 			'BR' => 'برازیلی',
 			'BS' => 'بہاماس',
 			'BT' => 'بھوٹان',
 			'BV' => 'بؤویٹ آئلینڈ',
 			'BW' => 'بوتسوانا',
 			'BY' => 'بیلاروس',
 			'BZ' => 'بیلائز',
 			'CA' => 'کینیڈا',
 			'CC' => 'کوکوس (کیلنگ) جزائر',
 			'CD' => 'کانگو - کنشاسا',
 			'CD@alt=variant' => 'کانگو (DRC)',
 			'CF' => 'وسط افریقی جمہوریہ',
 			'CG' => 'کانگو - برازاویلے',
 			'CG@alt=variant' => 'کانگو (جمہوریہ)',
 			'CH' => 'سوئٹزر لینڈ',
 			'CI' => 'کوٹ ڈی آئیوری',
 			'CI@alt=variant' => 'آئیوری کوسٹ',
 			'CK' => 'کک آئلینڈز',
 			'CL' => 'چلی',
 			'CM' => 'کیمرون',
 			'CN' => 'چین',
 			'CO' => 'کولمبیا',
 			'CP' => 'کلپّرٹن آئلینڈ',
 			'CR' => 'کوسٹا ریکا',
 			'CU' => 'کیوبا',
 			'CV' => 'کیپ ورڈی',
 			'CW' => 'کیوراکاؤ',
 			'CX' => 'کرسمس آئلینڈ',
 			'CY' => 'قبرص',
 			'CZ' => 'چیک جمہوریہ',
 			'DE' => 'جرمنی',
 			'DG' => 'ڈائجو گارسیا',
 			'DJ' => 'جبوتی',
 			'DK' => 'ڈنمارک',
 			'DM' => 'ڈومنیکا',
 			'DO' => 'ڈومنیکن جمہوریہ',
 			'DZ' => 'الجیریا',
 			'EA' => 'سیئوٹا اور میلیلا',
 			'EC' => 'ایکواڈور',
 			'EE' => 'اسٹونیا',
 			'EG' => 'مصر',
 			'EH' => 'مغربی صحارا',
 			'ER' => 'اریٹیریا',
 			'ES' => 'ہسپانیہ',
 			'ET' => 'ایتھوپیا',
 			'EU' => 'یوروپی یونین',
 			'FI' => 'فن لینڈ',
 			'FJ' => 'فجی',
 			'FK' => 'فاکلینڈ جزائر',
 			'FK@alt=variant' => 'فاکلینڈ جزائر (مالویناس)',
 			'FM' => 'مائکرونیشیا',
 			'FO' => 'فروئی آئلینڈز',
 			'FR' => 'فرانس',
 			'GA' => 'گیبون',
 			'GB' => 'سلطنت متحدہ',
 			'GB@alt=short' => 'یو کے',
 			'GD' => 'غرناطہ',
 			'GE' => 'جارجیا',
 			'GF' => 'فرینچ گیانا',
 			'GG' => 'گوئرنسی',
 			'GH' => 'گھانا',
 			'GI' => 'جبل الطارق',
 			'GL' => 'گرین لینڈ',
 			'GM' => 'گامبیا',
 			'GN' => 'گنی',
 			'GP' => 'گواڈیلوپ',
 			'GQ' => 'استوائی گیانا',
 			'GR' => 'یونان',
 			'GS' => 'جنوبی جارجیا اور جنوبی سینڈوچ جزائر',
 			'GT' => 'گواٹے مالا',
 			'GU' => 'گوآم',
 			'GW' => 'گنی بساؤ',
 			'GY' => 'گیانا',
 			'HK' => 'ہانگ کانگ SAR چین',
 			'HK@alt=short' => 'ہانگ کانگ',
 			'HM' => 'ہیئرڈ آئلینڈ اور میکڈونالڈ آئلینڈز',
 			'HN' => 'ہونڈاروس',
 			'HR' => 'کروشیا',
 			'HT' => 'ہیتی',
 			'HU' => 'ہنگری',
 			'IC' => 'کینری آئلینڈز',
 			'ID' => 'انڈونیشیا',
 			'IE' => 'آئرلینڈ',
 			'IL' => 'اسرائیل',
 			'IM' => 'آئل آف مین',
 			'IN' => 'بھارت',
 			'IO' => 'برطانوی ہندوستانی سمندری خطہ',
 			'IQ' => 'عراق',
 			'IR' => 'ایران',
 			'IS' => 'آئس لینڈ',
 			'IT' => 'اٹلی',
 			'JE' => 'جرسی',
 			'JM' => 'جمائیکا',
 			'JO' => 'اردن',
 			'JP' => 'جاپان',
 			'KE' => 'کینیا',
 			'KG' => 'کرغزستان',
 			'KH' => 'کمبوڈیا',
 			'KI' => 'کریباتی',
 			'KM' => 'کوموروس',
 			'KN' => 'سینٹ کٹس اور نیویس',
 			'KP' => 'شمالی کوریا',
 			'KR' => 'جنوبی کوریا',
 			'KW' => 'کویت',
 			'KY' => 'کیمین آئلینڈز',
 			'KZ' => 'قزاخستان',
 			'LA' => 'لاؤس',
 			'LB' => 'لبنان',
 			'LC' => 'سینٹ لوسیا',
 			'LI' => 'لیشٹنسٹائن',
 			'LK' => 'سری لنکا',
 			'LR' => 'لائبیریا',
 			'LS' => 'لیسوتھو',
 			'LT' => 'لتھوانیا',
 			'LU' => 'لگژمبرگ',
 			'LV' => 'لٹویا',
 			'LY' => 'لیبیا',
 			'MA' => 'مراقش',
 			'MC' => 'موناکو',
 			'MD' => 'مالدووا',
 			'ME' => 'مونٹے نیگرو',
 			'MF' => 'سینٹ مارٹن',
 			'MG' => 'مڈغاسکر',
 			'MH' => 'مارشل آئلینڈز',
 			'MK' => 'مقدونیہ',
 			'MK@alt=variant' => 'مقدونیہ (FYROM)',
 			'ML' => 'مالی',
 			'MM' => 'میانمار (برما)',
 			'MN' => 'منگولیا',
 			'MO' => 'مکاؤ SAR چین',
 			'MO@alt=short' => 'مکاؤ',
 			'MP' => 'شمالی ماریانا آئلینڈز',
 			'MQ' => 'مارٹینک',
 			'MR' => 'موریطانیہ',
 			'MS' => 'مونٹسیراٹ',
 			'MT' => 'مالٹا',
 			'MU' => 'ماریشس',
 			'MV' => 'مالدیو',
 			'MW' => 'ملاوی',
 			'MX' => 'میکسیکو',
 			'MY' => 'ملیشیا',
 			'MZ' => 'موزمبیق',
 			'NA' => 'نامیبیا',
 			'NC' => 'نیو کلیڈونیا',
 			'NE' => 'نائجر',
 			'NF' => 'نار فاک آئلینڈ',
 			'NG' => 'نائجیریا',
 			'NI' => 'نکاراگووا',
 			'NL' => 'نیدر لینڈز',
 			'NO' => 'ناروے',
 			'NP' => 'نیپال',
 			'NR' => 'نؤرو',
 			'NU' => 'نیئو',
 			'NZ' => 'نیوزی ینڈ',
 			'OM' => 'عمان',
 			'PA' => 'پنامہ',
 			'PE' => 'پیرو',
 			'PF' => 'فرانسیسی پولینیشیا',
 			'PG' => 'پاپوآ نیو گنی',
 			'PH' => 'فلپائنی',
 			'PK' => 'پاکستان',
 			'PL' => 'پولینڈ',
 			'PM' => 'سینٹ پیئر اور میکلیئون',
 			'PN' => 'پٹکائرن جزائر',
 			'PR' => 'پیورٹو ریکو',
 			'PS' => 'فلسطینی خطے',
 			'PS@alt=short' => 'فلسطین',
 			'PT' => 'پرتگال',
 			'PW' => 'پلاؤ',
 			'PY' => 'پیراگوئے',
 			'QA' => 'قطر',
 			'QO' => 'بیرونی اوشیانیا',
 			'RE' => 'ری یونین',
 			'RO' => 'رومانیا',
 			'RS' => 'سربیا',
 			'RU' => 'روسی',
 			'RW' => 'روانڈا',
 			'SA' => 'سعودی عرب',
 			'SB' => 'سولومن آئلینڈز',
 			'SC' => 'سشلیز',
 			'SD' => 'سوڈان',
 			'SE' => 'سویڈن',
 			'SG' => 'سنگاپور',
 			'SH' => 'سینٹ ہیلینا',
 			'SI' => 'سلووینیا',
 			'SJ' => 'سوالبرڈ اور جان ماین',
 			'SK' => 'سلوواکیہ',
 			'SL' => 'سیئر لیون',
 			'SM' => 'سان مارینو',
 			'SN' => 'سینیگل',
 			'SO' => 'صومالیہ',
 			'SR' => 'سورینام',
 			'SS' => 'جنوبی سوڈان',
 			'ST' => 'ساؤ ٹوم اور پرنسپے',
 			'SV' => 'ال سلواڈور',
 			'SX' => 'سنٹ مارٹن',
 			'SY' => 'شام',
 			'SZ' => 'سوازی لینڈ',
 			'TA' => 'ٹرسٹن ڈا کیونہا',
 			'TC' => 'ترکس اور کیکاؤس جزائر',
 			'TD' => 'چاڈ',
 			'TF' => 'فرانسیسی جنوبی خطے',
 			'TG' => 'ٹوگو',
 			'TH' => 'تھائی لینڈ',
 			'TJ' => 'تاجکستان',
 			'TK' => 'ٹوکیلاؤ',
 			'TL' => 'تیمور لیسٹ',
 			'TL@alt=variant' => 'مشرقی تیمور',
 			'TM' => 'ترکمانستان',
 			'TN' => 'تیونیسیا',
 			'TO' => 'ٹونگا',
 			'TR' => 'ترکی',
 			'TT' => 'ترینیداد اور ٹوباگو',
 			'TV' => 'ٹووالو',
 			'TW' => 'تائیوان',
 			'TZ' => 'تنزانیہ',
 			'UA' => 'یوکرین',
 			'UG' => 'یوگانڈا',
 			'UM' => 'امریکہ سے باہر کے چھوٹے جزائز',
 			'US' => 'ریاستہائے متحدہ',
 			'US@alt=short' => 'امریکا',
 			'UY' => 'یوروگوئے',
 			'UZ' => 'ازبکستان',
 			'VA' => 'واٹیکن سٹی',
 			'VC' => 'سینٹ ونسنٹ اور گرینیڈائنز',
 			'VE' => 'وینزوئیلا',
 			'VG' => 'برٹش ورجن آئلینڈز',
 			'VI' => 'امریکی ورجن آئلینڈز',
 			'VN' => 'ویتنام',
 			'VU' => 'وینوآٹو',
 			'WF' => 'ویلیز اور فیوٹیونا',
 			'WS' => 'ساموآ',
 			'XK' => 'کوسووو',
 			'YE' => 'یمن',
 			'YT' => 'مایوٹ',
 			'ZA' => 'جنوبی افریقہ',
 			'ZM' => 'زامبیا',
 			'ZW' => 'زمبابوے',
 			'ZZ' => 'نامعلوم علاقہ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'کیلنڈر',
 			'colalternate' => 'علامات کی چھٹائی نظرانداز کریں',
 			'colbackwards' => 'معکوس تلفظ کی چھٹائی',
 			'colcasefirst' => 'بڑے حروف/ چھوٹے حروف کی ترتیب بندی',
 			'colcaselevel' => 'حروف کے تئیں حساس چھٹائی',
 			'colhiraganaquaternary' => 'Kena چھٹائی',
 			'collation' => 'چھٹائی کی ترتیب',
 			'colnormalization' => 'معمول کی چھٹائی',
 			'colnumeric' => 'عددی چھٹائی',
 			'colstrength' => 'چھٹائی کی قوت',
 			'currency' => 'کرنسی',
 			'numbers' => 'اعداد',
 			'timezone' => 'منطقۂ وقت',
 			'va' => 'مقام کا متغیرہ',
 			'variabletop' => 'بطور علامات چھٹائی کریں',
 			'x' => 'نجی-استعمال',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{بودھ کلینڈر},
 				'chinese' => q{چینی کیلنڈر},
 				'coptic' => q{کاپٹک کیلنڈر},
 				'ethiopic' => q{ایتھوپیائی کیلنڈر},
 				'ethiopic-amete-alem' => q{ایتھوپک امیٹ الیم کیلنڈر},
 				'gregorian' => q{جارجیائی کیلنڈر},
 				'hebrew' => q{عبرانی کیلنڈر},
 				'indian' => q{ہندوستانی قومی کیلنڈر},
 				'islamic' => q{اسلامی کیلنڈر},
 				'islamic-civil' => q{اسلامی شہری کیلنڈر},
 				'japanese' => q{جاپانی کیلنڈر},
 				'persian' => q{فارسی کیلنڈر},
 				'roc' => q{منگوو کیلنڈر},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{علامات کی چھٹائی کریں},
 				'shifted' => q{علامات کو نظرانداز کرکے چھٹائی کریں},
 			},
 			'colbackwards' => {
 				'no' => q{لہجوں کی چھٹائی معمول کے انداز میں کریں},
 				'yes' => q{لہجوں کی معکوس چھٹائی کریں},
 			},
 			'colcasefirst' => {
 				'lower' => q{پہلے چھوٹے حروف کی چھٹائی کریں},
 				'no' => q{معمول کے حروف کی ترتیب کی چھٹائی کریں},
 				'upper' => q{پہلے بالائی حروف کی چھٹائی کریں},
 			},
 			'colcaselevel' => {
 				'no' => q{حروف کی عدم حساسیت کی چھٹائی کریں},
 				'yes' => q{حروف کے تئیں حساس کی چھٹائی کریں},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{Kana کی چھٹائی الگ الگ کریں},
 				'yes' => q{Kana کی مختلف طریقے سے چھٹائی کریں},
 			},
 			'collation' => {
 				'big5han' => q{روایتی چینی کی چھٹائی کی ترتیب - Big5},
 				'dictionary' => q{لغت کی چھٹنی کی ترتیب},
 				'ducet' => q{ڈیفالٹ یونیکوڈ کی چھٹنی کی ترتیب},
 				'gb2312han' => q{آسان چینی کی چھٹائی کی ترتیب - GB2312},
 				'phonebook' => q{فون بک کی چھٹنی کی ترتیب},
 				'phonetic' => q{صوتی چھٹائی کی ترتیب},
 				'pinyin' => q{پن ین کی چھٹنی کی ترتیب},
 				'reformed' => q{دوبارہ تشکیل شدہ چھٹنی کی ترتیب},
 				'search' => q{عام-مقصد کی تلاش},
 				'searchjl' => q{Hangul Initial Consonant کے لحاظ سے تلاش کریں},
 				'standard' => q{معیاری چھنٹائی کی ترتیب},
 				'stroke' => q{سٹروک کی چھٹنی کی ترتیب},
 				'traditional' => q{روایتی چھٹنی کی ترتیب},
 				'unihan' => q{اساسی-سٹروک کی چھٹنی کی ترتیب},
 			},
 			'colnormalization' => {
 				'no' => q{حسب معمول بنائے بغیر چھٹائی کریں},
 				'yes' => q{معمول کے یونیکوڈ کی چھٹائی کریں},
 			},
 			'colnumeric' => {
 				'no' => q{انفرادی طور پر ہندسوں کی چھٹائی کریں},
 				'yes' => q{اعداد کے لحاظ سے ہندسوں کی چھٹائی کریں},
 			},
 			'colstrength' => {
 				'identical' => q{سبھی کی چھٹائی کریں},
 				'primary' => q{صرف اساسی حروف کی چھٹائی کریں},
 				'quaternary' => q{لہجہ/ بڑے چھوٹے حروف/چوڑائی/Kana کی چھٹائی کریں},
 				'secondary' => q{لہجوں کی چھٹائی کریں},
 				'tertiary' => q{لہجوں/حروف/چوڑائی کی چھٹائی کریں},
 			},
 			'numbers' => {
 				'arab' => q{عربی ہندی ہندسے},
 				'arabext' => q{توسیع شدہ عربی ہندی ہندسے},
 				'armn' => q{آرمینیائی اعداد},
 				'armnlow' => q{آرمینیائی زیریں اعداد},
 				'beng' => q{ہنگالی ہندسے},
 				'deva' => q{دیوناگری ہندسے},
 				'ethi' => q{ایتھوپیائی اعداد},
 				'finance' => q{مالیاتی ہندسے},
 				'fullwide' => q{پورے عرض والے ہندسے},
 				'geor' => q{جارجیائی اعداد},
 				'grek' => q{یونانی اعداد},
 				'greklow' => q{یونانی زیریں اعداد},
 				'gujr' => q{گجراتی ہندسے},
 				'guru' => q{گرمکھی ہندسے},
 				'hanidec' => q{چینی اعشاری اعداد},
 				'hans' => q{آسان چینی اعداد},
 				'hansfin' => q{آسان چینی مالی اعداد},
 				'hant' => q{روایتی چینی اعداد},
 				'hantfin' => q{روایتی چینی مالی اعداد},
 				'hebr' => q{عبرانی اعداد},
 				'jpan' => q{جاپانی اعداد},
 				'jpanfin' => q{جاپانی مالی اعداد},
 				'khmr' => q{خمیر ہندسے},
 				'knda' => q{کنڑ ہندسے},
 				'laoo' => q{لاؤ ہندسے},
 				'latn' => q{مغربی ہندسے},
 				'mlym' => q{ملیالم ہندسے},
 				'mong' => q{منگولیائی ہندسے},
 				'mymr' => q{میانمار کے ہندسے},
 				'native' => q{اصل ہندسے},
 				'orya' => q{اڑیہ ہندسے},
 				'roman' => q{رومن اعداد},
 				'romanlow' => q{رومن زیریں اعداد},
 				'taml' => q{تمل اعداد},
 				'tamldec' => q{تمل اعداد},
 				'telu' => q{تیلگو ہندسے},
 				'thai' => q{تھائی ہندسے},
 				'tibt' => q{تبتی اعداد},
 				'traditional' => q{روایتی اعداد},
 				'vaii' => q{وائی ہندسے},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{پیمانہ},
 			'UK' => q{سلطنت متحدہ},
 			'US' => q{ریاستہائے متحدہ},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'عددی',
 			'tone' => 'ٹون',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'لہجے',
 			'x-fullwidth' => 'پورا عرض',
 			'x-halfwidth' => 'نصف عرض',
 			'x-jamo' => 'جامو',
 			'x-pinyin' => 'پن یِن',
 			'x-publishing' => 'اشاعت',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'زبان:{0}',
 			'script' => 'رسم الخط:{0}',
 			'territory' => 'خطہ:{0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { return {
			lines => '',
			characters => 'right-to-left',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[؀؁؂؃‌‍‎‏ ً ٌ ٍ َ ُ ِ ّ ْ ٔ ٖ ٗ ٘ ٰ ۃ ٻ ٺ ټ ٽ ي])},
			index => ['ا', 'ب', 'پ', 'ت', 'ٹ', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ڈ', 'ذ', 'ر', 'ڑ', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ہ', 'ھ', 'ء', 'ی', 'ے'],
			main => qr{(?^u:[ا أ آ ب پ ت ٹ ث ج چ ح خ د ڈ ذ ر ڑ ز ژ س ش ص ض ط ظ ع غ ف ق ک گ ل م ن ں و ؤ ہ ۂ ھ ء ی ئ ے ة ه])},
			punctuation => qr{(?^u:[، ؍ ٫ ٬ ؛ \: ؟ . ۔ ( ) \[ \]])},
		};
	},
EOT
: sub {
		return { index => ['ا', 'ب', 'پ', 'ت', 'ٹ', 'ث', 'ج', 'چ', 'ح', 'خ', 'د', 'ڈ', 'ذ', 'ر', 'ڑ', 'ز', 'ژ', 'س', 'ش', 'ص', 'ض', 'ط', 'ظ', 'ع', 'غ', 'ف', 'ق', 'ک', 'گ', 'ل', 'م', 'ن', 'و', 'ہ', 'ھ', 'ء', 'ی', 'ے'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{؟},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					'arc-minute' => {
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
					},
					'arc-second' => {
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
					},
					'celsius' => {
						'one' => q({0} ڈگری سیلسیس),
						'other' => q({0} ڈگری سیلسیس),
					},
					'centimeter' => {
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
					},
					'cubic-kilometer' => {
						'one' => q({0} کیوبک کلو میٹر),
						'other' => q({0} کیوبک کلو میٹر),
					},
					'cubic-mile' => {
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					'day' => {
						'one' => q({0} دن),
						'other' => q({0} دن),
					},
					'degree' => {
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					'fahrenheit' => {
						'one' => q({0}ڈگری فارن ہائیٹ),
						'other' => q({0} ڈگری فارن ہائیٹ),
					},
					'foot' => {
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
					},
					'g-force' => {
						'one' => q({0} جی-فورس),
						'other' => q({0} جی-فورس),
					},
					'gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرام),
					},
					'hectare' => {
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					'hectopascal' => {
						'one' => q({0} ہیکٹو پاسکل),
						'other' => q({0} ہیکٹو پاسکل),
					},
					'horsepower' => {
						'one' => q({0} ہارس پاور),
						'other' => q({0} ہارس پاور),
					},
					'hour' => {
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
					},
					'inch' => {
						'one' => q({0} انچ),
						'other' => q({0} انچ),
					},
					'inch-hg' => {
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					'kilogram' => {
						'one' => q({0} کلو گرام),
						'other' => q({0} کلو گرام),
					},
					'kilometer' => {
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
					},
					'kilometer-per-hour' => {
						'one' => q({0} کلومیٹر فی گھنٹہ),
						'other' => q({0} کلومیٹر فی گھنٹہ),
					},
					'kilowatt' => {
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					'light-year' => {
						'one' => q({0} روشنی سال),
						'other' => q({0} روشنی سال),
					},
					'liter' => {
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
					},
					'meter' => {
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
					},
					'meter-per-second' => {
						'one' => q({0} میٹر فی سیکنڈ),
						'other' => q({0} میٹر فی سیکنڈ),
					},
					'mile' => {
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					'mile-per-hour' => {
						'one' => q({0}میل فی گھنٹہ),
						'other' => q({0} میل فی گھنٹہ),
					},
					'millibar' => {
						'one' => q({0} ملی بار),
						'other' => q({0} ملی بار),
					},
					'millimeter' => {
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					'millisecond' => {
						'one' => q({0} ملی سیکنڈ),
						'other' => q({0} میل سیکنڈ),
					},
					'minute' => {
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
					},
					'month' => {
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
					},
					'ounce' => {
						'one' => q({0} ونس),
						'other' => q({0} ونس),
					},
					'per' => {
						'' => q({0} فی {1}),
					},
					'picometer' => {
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					'pound' => {
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
					},
					'second' => {
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
					},
					'square-foot' => {
						'one' => q({0} سکویر فٹ),
						'other' => q({0} سکویر فٹ),
					},
					'square-kilometer' => {
						'one' => q({0} سکویر کلو میٹر),
						'other' => q({0} سکویر کلو میٹر),
					},
					'square-meter' => {
						'one' => q({0} سکویر میٹر),
						'other' => q({0} سکویر میٹر),
					},
					'square-mile' => {
						'one' => q({0} سکویر میل),
						'other' => q({0} سکویر میل),
					},
					'watt' => {
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					'week' => {
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
					},
					'yard' => {
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					'year' => {
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					'arc-minute' => {
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}‎°),
						'other' => q({0}‎°),
					},
					'centimeter' => {
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					'day' => {
						'one' => q({0} دن),
						'other' => q({0} دن),
					},
					'degree' => {
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					'fahrenheit' => {
						'one' => q({0}‎°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q('{0}),
						'other' => q({0}′),
					},
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}G),
					},
					'gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرام),
					},
					'hectare' => {
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					'hectopascal' => {
						'one' => q({0}hPa),
						'other' => q({0}hPa),
					},
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0}hp),
					},
					'hour' => {
						'one' => q({0} گھنٹے),
						'other' => q({0} گھنٹے),
					},
					'inch' => {
						'one' => q({0} انچ),
						'other' => q({0} انچ),
					},
					'inch-hg' => {
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					'kilogram' => {
						'one' => q({0}kg),
						'other' => q({0}kg),
					},
					'kilometer' => {
						'one' => q({0}km),
						'other' => q({0}km),
					},
					'kilometer-per-hour' => {
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					'light-year' => {
						'one' => q({0}ly),
						'other' => q({0}ly),
					},
					'liter' => {
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
					},
					'meter' => {
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
					},
					'meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					'mile' => {
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'millibar' => {
						'one' => q({0}mb),
						'other' => q({0}mb),
					},
					'millimeter' => {
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					'millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'ounce' => {
						'one' => q({0} ونس),
						'other' => q({0} ونس),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0}pm),
						'other' => q({0}pm),
					},
					'pound' => {
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
					},
					'second' => {
						'one' => q({0}s),
						'other' => q({0}s),
					},
					'square-foot' => {
						'one' => q({0}ft²),
						'other' => q({0}ft²),
					},
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0}mi²),
						'other' => q({0}mi²),
					},
					'watt' => {
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					'week' => {
						'one' => q({0} ہفتے),
						'other' => q({0} ہفتے),
					},
					'yard' => {
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					'year' => {
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} ایکڑ),
						'other' => q({0} ایکڑ),
					},
					'arc-minute' => {
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
					},
					'arc-second' => {
						'one' => q({0}سیکنڈ),
						'other' => q({0} سیکنڈ),
					},
					'celsius' => {
						'one' => q({0}‎°C),
						'other' => q({0}‎°C),
					},
					'centimeter' => {
						'one' => q({0} سینٹی میٹر),
						'other' => q({0} سینٹی میٹر),
					},
					'cubic-kilometer' => {
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'one' => q({0} کیوبک میل),
						'other' => q({0} کیوبک میل),
					},
					'day' => {
						'one' => q({0} دن),
						'other' => q({0} دن),
					},
					'degree' => {
						'one' => q({0} ڈگری),
						'other' => q({0} ڈگری),
					},
					'fahrenheit' => {
						'one' => q({0}‎°F),
						'other' => q({0}‎°F),
					},
					'foot' => {
						'one' => q({0} فیٹ),
						'other' => q({0} فیٹ),
					},
					'g-force' => {
						'one' => q({0} جی-فورس),
						'other' => q({0} جی-فورس),
					},
					'gram' => {
						'one' => q({0} گرام),
						'other' => q({0} گرام),
					},
					'hectare' => {
						'one' => q({0} ہیکٹر),
						'other' => q({0} ہیکٹر),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} ہارس پاور),
						'other' => q({0} ہارس پاور),
					},
					'hour' => {
						'one' => q({0} گھنٹہ),
						'other' => q({0} گھنٹے),
					},
					'inch' => {
						'one' => q({0} انچ),
						'other' => q({0} انچ),
					},
					'inch-hg' => {
						'one' => q({0} انچ مرکری),
						'other' => q({0} انچ مرکری),
					},
					'kilogram' => {
						'one' => q({0} کلو گرام),
						'other' => q({0} کلو گرام),
					},
					'kilometer' => {
						'one' => q({0} کلو میٹر),
						'other' => q({0} کلو میٹر),
					},
					'kilometer-per-hour' => {
						'one' => q({0} kph),
						'other' => q({0} kph),
					},
					'kilowatt' => {
						'one' => q({0} کلو واٹ),
						'other' => q({0} کلو واٹ),
					},
					'light-year' => {
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					'liter' => {
						'one' => q({0} لیٹر),
						'other' => q({0} لیٹر),
					},
					'meter' => {
						'one' => q({0} میٹر),
						'other' => q({0} میٹر),
					},
					'meter-per-second' => {
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'one' => q({0} میل),
						'other' => q({0} میل),
					},
					'mile-per-hour' => {
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					'millibar' => {
						'one' => q({0} ملی بار),
						'other' => q({0} ملی بار),
					},
					'millimeter' => {
						'one' => q({0} ملیمیٹر),
						'other' => q({0} ملیمیٹر),
					},
					'millisecond' => {
						'one' => q({0} میل سیکنڈ),
						'other' => q({0} میل سیکنڈ),
					},
					'minute' => {
						'one' => q({0} منٹ),
						'other' => q({0} منٹ),
					},
					'month' => {
						'one' => q({0} مہینہ),
						'other' => q({0} مہینے),
					},
					'ounce' => {
						'one' => q({0} ونس),
						'other' => q({0} ونس),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} پیکو میٹر),
						'other' => q({0} پیکو میٹر),
					},
					'pound' => {
						'one' => q({0} پونڈ),
						'other' => q({0} پونڈ),
					},
					'second' => {
						'one' => q({0} سیکنڈ),
						'other' => q({0} سیکنڈ),
					},
					'square-foot' => {
						'one' => q({0} سکویر فٹ),
						'other' => q({0} سکویر فٹ),
					},
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0} سکویر میل),
						'other' => q({0} سکویر میل),
					},
					'watt' => {
						'one' => q({0} واٹ),
						'other' => q({0} واٹ),
					},
					'week' => {
						'one' => q({0} ہفتہ),
						'other' => q({0} ہفتے),
					},
					'yard' => {
						'one' => q({0} یارڈ),
						'other' => q({0} یارڈ),
					},
					'year' => {
						'one' => q({0} سال),
						'other' => q({0} سال),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ہاں|ہاں|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:نہیں|نہیں|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}، اور {1}),
				2 => q({0} اور {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'arabext',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'decimal' => q(.),
			'exponential' => q(ق),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(‎-‎),
			'nan' => q(یہ عدد نہیں),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+‎),
			'superscriptingExponent' => q(),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(‎-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(‎+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ہزار',
					'other' => '0 ہزار',
				},
				'10000' => {
					'one' => '00 ہزار',
					'other' => '00 ہزار',
				},
				'100000' => {
					'one' => '0 لاکھ',
					'other' => '0 لاکھ',
				},
				'1000000' => {
					'one' => '00 لاکھ',
					'other' => '00 لاکھ',
				},
				'10000000' => {
					'one' => '0 کروڑ',
					'other' => '0 کروڑ',
				},
				'100000000' => {
					'one' => '00 کروڑ',
					'other' => '00 کروڑ',
				},
				'1000000000' => {
					'one' => '0 ارب',
					'other' => '0 ارب',
				},
				'10000000000' => {
					'one' => '00 ارب',
					'other' => '00 ارب',
				},
				'100000000000' => {
					'one' => '0 کھرب',
					'other' => '0 کھرب',
				},
				'1000000000000' => {
					'one' => '00 کھرب',
					'other' => '00 کھرب',
				},
				'10000000000000' => {
					'one' => '00T',
					'other' => '00T',
				},
				'100000000000000' => {
					'one' => '000T',
					'other' => '000T',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '¤#,##0.00‎',
						'positive' => '¤#,##0.00‎',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(متحدہ عرب اماراتی درہم),
				'one' => q(متحدہ عرب اماراتی درہم),
				'other' => q(متحدہ عرب اماراتی درہم),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(افغان افغانی),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(البانیا کا لیک),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(آرمینیائی ڈرم),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(نیدر لینڈز انٹیلیئن گلڈر),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(انگولا کا کوانزا),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ارجنٹائن پیسہ),
				'one' => q(ارجنٹائن پیسہ),
				'other' => q(ارجنٹائن پیسہ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(آسٹریلین ڈالر),
				'one' => q(آسٹریلین ڈالر),
				'other' => q(آسٹریلین ڈالر),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(اروبن فلورِن),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(آذربائجانی منات),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(بوسنیا ہرزیگووینا کا قابل منتقلی نشان),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(باربیڈین ڈالر),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(بنگلہ دیشی ٹکا),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(بلغارین لیو),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(بحرینی دینار),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(برونڈیئن فرینک),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(برمودا کا ڈالر),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(برونئی ڈالر),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(بولیوین بولیویانو),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(برازیلی ریئل),
				'one' => q(برازیلی ریئل),
				'other' => q(برازیلی ریئل),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(بہامانی ڈالر),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(بھوٹانی گُلٹرم),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(بوتسوانا کا پولا),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(بیلاروسی روبل),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(بیلائز ڈالر),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(کنیڈین ڈالر),
				'one' => q(کنیڈین ڈالر),
				'other' => q(کنیڈین ڈالر),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(کانگولیز فرینک),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(سوئس فرانکس),
				'one' => q(سوئس فرانکس),
				'other' => q(سوئس فرانکس),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(چلّین پیسہ),
				'one' => q(چلّین پیسہ),
				'other' => q(چلّین پیسہ),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(چینی یوآن),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(کولمبین پیسہ),
				'one' => q(کولمبین پیسہ),
				'other' => q(کولمبین پیسہ),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(کوسٹا ریکا کا کولن),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(کیوبا کا قابل منتقلی پیسو),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(کیوبا کا پیسو),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(کیپ ورڈی کا اسکیوڈو),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(جمہوریہ چیک کرونا),
				'one' => q(جمہوریہ چیک کرونا),
				'other' => q(جمہوریہ چیک کروناز),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ڈچ مارکس),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(جبوتی کا فرینک),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ڈنمارک کرونر),
				'one' => q(ڈنمارک کرونر),
				'other' => q(ڈنمارک کرونر),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ڈومنیکن پیسو),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(الجیریائی دینار),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(ایسٹونین کرون),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(مصری پائونڈ),
				'one' => q(مصری پائونڈ),
				'other' => q(مصری پائونڈ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(اریٹیریا کا نافکا),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ایتھوپیائی بِرّ),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(یورو),
				'one' => q(یورو),
				'other' => q(یورو),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(فجی کا ڈالر),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(فاکلینڈ آئلینڈز پونڈ),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(فرانسیسی فرانک),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(انگلستانی پاونڈ سٹرلنگ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(جارجیائی لاری),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(گھانا کا سیڈی),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(جبل الطارق پونڈ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(گامبیا کا ڈلاسی),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(گنی کا فرینک),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(گواٹے مالا کا کوئٹزل),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(گویانیز ڈالر),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(ھانگ کانگ ڈالر),
				'one' => q(ھانگ کانگ ڈالر),
				'other' => q(ھانگ کانگ ڈالر),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ہونڈوران لیمپیرا),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(کروشین کونا),
				'one' => q(کروشین کونا),
				'other' => q(کروشین کونا),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ہیتی کا گؤرڈی),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ہنگرین فورنٹ),
				'one' => q(ہنگرین فورنٹ),
				'other' => q(ہنگرین فورنٹ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(انڈونیشین روپیہ),
				'one' => q(انڈونیشین روپیہ),
				'other' => q(انڈونیشین روپیہ),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(اسرائیلی نیا شیکل),
				'one' => q(اسرائیلی نیا شیکل),
				'other' => q(اسرائیلی نیا شیکلز),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(انڈین روپیہ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(عراقی دینار),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ایرانی ریال),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(آئس لینڈ کا کرونا),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(جمائیکن ڈالر),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(اردنی دینار),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(جاپانی ین),
				'one' => q(جاپانی ین),
				'other' => q(جاپانی ین),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(کینیائی شلنگ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(کرغستانی سوم),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(کمبوڈیائی ریئل),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(کوموریئن فرینک),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(شمالی کوریائی وون),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(جنوبی کوریائی وون),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(کویتی دینار),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(کیمین آئلینڈز ڈالر),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(قزاخستانی ٹینگ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(لاؤشیائی کِپ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(لبانی پونڈ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(سری لنکائی روپیہ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(لائبریائی ڈالر),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(لیسوتھو لوٹی),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(لیتھوینیائی لیٹاس),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(لاتویائی لیٹس),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(لیبیائی دینار),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(مراکشی درہم),
				'one' => q(مراکشی درہم),
				'other' => q(مراکشی درہم),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(مالدیپ کا لیو),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ملاگاسی اریاری),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(مقدونیائی دینار),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(میانما کیاٹ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(منگولیائی ٹگرِ),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(میکانیز پٹاکا),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(موریطانیائی اوگوئیا),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(ماریشس کا روپیہ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(مالدیپ کا روفیہ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(ملاوی کواچا),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(میکسیکی پیسہ),
				'one' => q(میکسیکی پیسہ),
				'other' => q(میکسیکی پیسہ),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(ملیشیائی رنگِٹ),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(موزامبیقی میٹیکل),
				'one' => q(موزامبیقی میٹیکل),
				'other' => q(موزامبیقی میٹیکلز),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(نامیبیائی ڈالر),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(نائیجیریائی نائرا),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(نکارا گوا کا کورڈوبا),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(ناروے کرونر),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(نیپالی روپیہ),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(نیوزی لینڈ ڈالر),
				'one' => q(نیوزی لینڈ ڈالر),
				'other' => q(نیوزی لینڈ ڈالر),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(عمانی ریال),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(پنامہ کا بالبوآ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(پیروین نیووسول),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(پاپوآ نیو گنی کا کینا),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(فلپائینی پیسہ),
				'one' => q(فلپائینی پیسہ),
				'other' => q(فلپائینی پیسہ),
			},
		},
		'PKR' => {
			symbol => 'Rs',
			display_name => {
				'currency' => q(پاکستانی روپیہ),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(پولش نیو زلوٹی),
				'one' => q(پولش نیو زلوٹی),
				'other' => q(پولش نیو زلوٹی),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(پیراگوئے کا گوآرنی),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(قطری ریال),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(رومانیائی لیو),
				'one' => q(رومانیائی لیو),
				'other' => q(رومانیائی لی),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(سربین دینار),
				'one' => q(سربین دینار),
				'other' => q(سربین دینار),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(روسی روبل),
				'one' => q(روسی روبل),
				'other' => q(روسی روبل),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(روانڈا کا فرینک),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(سعودی ریال),
				'one' => q(سعودی ریال),
				'other' => q(سعودی ریال),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(سولومن آئلینڈز ڈالر),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(سشلی کا روپیہ),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(سوڈانی پونڈ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(سویڈن کرونا),
				'one' => q(سویڈن کرونا),
				'other' => q(سویڈن کرونر),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(سنگا پور ڈالر),
				'one' => q(سنگا پور ڈالر),
				'other' => q(سنگا پور ڈالر),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(سینٹ ہیلینا پونڈ),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(سلوانین ٹولر),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(سلووک کرونا),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(سیئرا لیون لیون),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(صومالی شلنگ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(سورینامی ڈالر),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(جنوبی سوڈانی پاؤنڈ),
				'one' => q(جنوبی سوڈانی پاؤنڈ),
				'other' => q(جنوبی سوڈانی پاؤنڈز),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(ساؤ ٹوم اور پرنسپے ڈوبرا),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(شامی پونڈ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(سوازی لیلانجینی),
			},
		},
		'THB' => {
			display_name => {
				'currency' => q(تھائی باہت),
				'one' => q(تھائی باہت),
				'other' => q(تھائی باہت),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(تاجکستانی سومونی),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(ترکمانستانی منات),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(تیونیسیائی دینار),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ٹونگن پانگا),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ترکی لیرا),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ترینیداد اور ٹوباگو کا ڈالر),
			},
		},
		'TWD' => {
			display_name => {
				'currency' => q(نیو تائیوان ڈالر),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(تنزانیائی شلنگ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(یوکرینیائی ہریونیا),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(یوگانڈا شلنگ),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(امریکی ڈالر),
				'one' => q(امریکی ڈالر),
				'other' => q(امریکی ڈالر),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(یوروگویان پیسو),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ازبکستان سوم),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(وینزویلا بولیور \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(وینزویلا بولیور),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(ویتنامی ڈانگ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(وینوواتو واتو),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ساموآ کا ٹالا),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(CFA فرانک BEAC),
				'one' => q(CFA فرانک BEAC),
				'other' => q(CFA فرانکس BEAC),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(مشرقی کریبیا کا ڈالر),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(CFA فرانک BCEAO),
				'one' => q(CFA فرانک BCEAO),
				'other' => q(CFA فرانکس BCEAO),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(CFP فرانک),
				'one' => q(CFP فرانک),
				'other' => q(CFP فرانکس),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(نامعلوم کرنسی),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(یمنی ریال),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(جنوبی افریقی رانڈ),
				'one' => q(جنوبی افریقی رانڈ),
				'other' => q(جنوبی افریقی رانڈ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(زامبیائی کواچا \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(زامبیائی کواچا),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'J',
							'F',
							'M',
							'A',
							'M',
							'J',
							'J',
							'A',
							'S',
							'O',
							'N',
							'D'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'جنوری',
							'فروری',
							'مارچ',
							'اپریل',
							'مئی',
							'جون',
							'جولائی',
							'اگست',
							'ستمبر',
							'اکتوبر',
							'نومبر',
							'دسمبر'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'محرم',
							'صفر',
							'ر بیع الاول',
							'ر بیع الثانی',
							'جمادی الاول',
							'جمادی الثانی',
							'رجب',
							'شعبان',
							'رمضان',
							'شوال',
							'ذوالقعدۃ',
							'ذوالحجۃ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'سوموار',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					narrow => {
						mon => 'M',
						tue => 'T',
						wed => 'W',
						thu => 'T',
						fri => 'F',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'سوموار',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					wide => {
						mon => 'سوموار',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'سوموار',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					narrow => {
						mon => 'M',
						tue => 'T',
						wed => 'W',
						thu => 'T',
						fri => 'F',
						sat => 'S',
						sun => 'S'
					},
					short => {
						mon => 'سوموار',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
					wide => {
						mon => 'سوموار',
						tue => 'منگل',
						wed => 'بدھ',
						thu => 'جمعرات',
						fri => 'جمعہ',
						sat => 'ہفتہ',
						sun => 'اتوار'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'پہلی سہ ماہی',
						1 => 'دوسری سہ ماہی',
						2 => 'تیسری سہ ماہی',
						3 => 'چوتهی سہ ماہی'
					},
				},
				'stand-alone' => {
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'pm' => q{بعد دوپہر},
					'am' => q{قبل دوپہر},
				},
				'wide' => {
					'pm' => q{بعد دوپہر},
					'am' => q{قبل دوپہر},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ق م',
				'1' => 'عیسوی سن'
			},
			wide => {
				'0' => 'قبل مسیح',
				'1' => 'عیسوی سن'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ق م',
				'1' => 'عیسوی سن'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE، d MMMM، y G},
			'long' => q{d MMMM، y G},
			'medium' => q{d MMM، y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE، d MMMM، y},
			'long' => q{d MMMM، y},
			'medium' => q{d MMM، y},
			'short' => q{d/M/yy},
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، d MMM، y G},
			GyMMMd => q{d MMM، y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E، d/M},
			MMM => q{LLL},
			MMMEd => q{E، d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E، d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E، d MMM، y},
			yMMMd => q{d MMM، y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'generic' => {
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E، d MMM، y G},
			GyMMMd => q{d MMM، y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E، d/M},
			MMM => q{LLL},
			MMMEd => q{E، d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E، d/M/y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E، d MMM، y G},
			yyyyMMMd => q{d MMM، y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E، d/M – E، d/M},
				d => q{E، d/M – E، d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E، d MMM – E، d MMM},
				d => q{E، d MMM – E، d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E، d/M/y – E، d/M/y},
				d => q{E، d/M/y – E، d/M/y},
				y => q{E، d/M/y – E، d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E، d MMM – E، d MMM، y},
				d => q{E، d MMM – E، d MMM، y},
				y => q{E، d MMM، y – E، d MMM، y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM، y},
				d => q{d-d MMM، y},
				y => q{d MMM، y – d MMM، y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y - d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E، d/M – E، d/M},
				d => q{E، d/M – E، d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E، d MMM – E، d MMM},
				d => q{E، d MMM – E، d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E، d/M/y – E، d/M/y G},
				d => q{E، d/M/y – E، d/M/y G},
				y => q{E، d/M/y – E، d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E، d MMM – E، d MMM، y G},
				d => q{E، d MMM – E، d MMM، y G},
				y => q{E، d MMM، y – E، d MMM، y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM، y G},
				d => q{d-d MMM، y G},
				y => q{d MMM، y – d MMM، y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y - d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT {0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} وقت),
		regionFormat => q({0} (+1)),
		regionFormat => q({0} (+0)),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(افغانستان کا وقت),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#عابدجان#,
		},
		'Africa/Accra' => {
			exemplarCity => q#اکّرا#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#عدیس ابابا#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#الجیئرس#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#اسمارا#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#بماکو#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#بنگوئی#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#بنجول#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#بِساؤ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#بلینٹائر#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#برازاویلے#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#بجمبرا#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#قاہرہ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#کیسا بلانکا#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#سیوٹا#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#کونکری#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ڈکار#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#دار السلام#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#جبوتی#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ڈوآلا#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#العیون#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#فری ٹاؤن#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#جیبورون#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ہرارے#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#جوہانسبرگ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#جوبا#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#کیمپالا#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#خرطوم#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#کگالی#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#کنشاسا#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#لاگوس#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#لبرے ویلے#,
		},
		'Africa/Lome' => {
			exemplarCity => q#لوم#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#لوانڈا#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#لوبمباشی#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#لیوساکا#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ملابو#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#مپوٹو#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#مسیرو#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#مبابین#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#موگادیشو#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#مونروویا#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#نیروبی#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ڈجامینا#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#نیامی#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#نؤآک چاٹ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#اؤگاڈؤگوو#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#پورٹو نووا#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ساؤ ٹوم#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ٹریپولی#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#تیونس#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ونڈہوک#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(وسطی افریقہ کا وقت),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(مشرقی افریقہ کا وقت),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(جنوبی افریقہ کا معیاری وقت),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(مغربی افریقہ کا موسم گرما کا وقت),
				'generic' => q(مغربی افریقہ کا وقت),
				'standard' => q(مغربی افریقہ کا معیاری وقت),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(الاسکا ڈے لائٹ ٹائم),
				'generic' => q(الاسکا ٹائم),
				'standard' => q(الاسکا اسٹینڈرڈ ٹائم),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(امیزون کا موسم گرما کا وقت),
				'generic' => q(امیزون ٹائم),
				'standard' => q(امیزن اسٹینڈرڈ ٹائم),
			},
		},
		'America/Adak' => {
			exemplarCity => q#اداک#,
		},
		'America/Anchorage' => {
			exemplarCity => q#اینکریج#,
		},
		'America/Anguilla' => {
			exemplarCity => q#انگویلا#,
		},
		'America/Antigua' => {
			exemplarCity => q#انٹیگوا#,
		},
		'America/Araguaina' => {
			exemplarCity => q#اراگویانا#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#لا ریئوجا#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ریو گالیگوس#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#سالٹا#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#سان جوآن#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#سان لوئس#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ٹوکومین#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#اوشوآئیا#,
		},
		'America/Aruba' => {
			exemplarCity => q#اروبا#,
		},
		'America/Asuncion' => {
			exemplarCity => q#اسنسیئن#,
		},
		'America/Bahia' => {
			exemplarCity => q#باہیا#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#بہیا بندراز#,
		},
		'America/Barbados' => {
			exemplarCity => q#باربادوس#,
		},
		'America/Belem' => {
			exemplarCity => q#بیلیم#,
		},
		'America/Belize' => {
			exemplarCity => q#بیلائز#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#بلانک سبلون#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#بوآ وسٹا#,
		},
		'America/Bogota' => {
			exemplarCity => q#بگوٹا#,
		},
		'America/Boise' => {
			exemplarCity => q#بوائس#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#بیونس آئرس#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#کیمبرج کی کھاڑی#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#کیمپو گرینڈ#,
		},
		'America/Cancun' => {
			exemplarCity => q#کنکیون#,
		},
		'America/Caracas' => {
			exemplarCity => q#کراکاس#,
		},
		'America/Catamarca' => {
			exemplarCity => q#کیٹامارکا#,
		},
		'America/Cayenne' => {
			exemplarCity => q#کیینّی#,
		},
		'America/Cayman' => {
			exemplarCity => q#کیمین#,
		},
		'America/Chicago' => {
			exemplarCity => q#شکاگو#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#چیہوآہوآ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#اٹیکوکن#,
		},
		'America/Cordoba' => {
			exemplarCity => q#کورڈوبا#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#کوسٹا ریکا#,
		},
		'America/Creston' => {
			exemplarCity => q#کریسٹون#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#کوئیابا#,
		},
		'America/Curacao' => {
			exemplarCity => q#کیوراکاؤ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ڈنمارک شاون#,
		},
		'America/Dawson' => {
			exemplarCity => q#ڈاؤسن#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ڈاؤسن کریک#,
		},
		'America/Denver' => {
			exemplarCity => q#ڈینور#,
		},
		'America/Detroit' => {
			exemplarCity => q#ڈیٹرائٹ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ڈومنیکا#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ایڈمونٹن#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ایرونیپ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ال سلواڈور#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#فورٹالیزا#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#گلیس کی کھاڑی#,
		},
		'America/Godthab' => {
			exemplarCity => q#گاڈتھیب#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#گوس کی کھاڑی#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#عظیم ترک#,
		},
		'America/Grenada' => {
			exemplarCity => q#غرناطہ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#گواڈیلوپ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#گواٹے مالا#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#گوآیاکوئل#,
		},
		'America/Guyana' => {
			exemplarCity => q#گیانا#,
		},
		'America/Halifax' => {
			exemplarCity => q#ہیلیفیکس#,
		},
		'America/Havana' => {
			exemplarCity => q#ہوانا#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ہرموسیلو#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#کنوکس، انڈیانا#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#مرینگو، انڈیانا#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#پیٹرزبرگ، انڈیانا#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ٹیل سٹی، انڈیانا#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ویوے، انڈیانا#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ونسینیز، انڈیانا#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#وینامیک، انڈیانا#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#انڈیاناپولس#,
		},
		'America/Inuvik' => {
			exemplarCity => q#انووِک#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ایکالوئٹ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#جمائیکا#,
		},
		'America/Jujuy' => {
			exemplarCity => q#جوجوئی#,
		},
		'America/Juneau' => {
			exemplarCity => q#جونیئو#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#مونٹیسیلو، کینٹوکی#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#کرالینڈیجک#,
		},
		'America/La_Paz' => {
			exemplarCity => q#لا پاز#,
		},
		'America/Lima' => {
			exemplarCity => q#لیما#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#لاس اینجلس#,
		},
		'America/Louisville' => {
			exemplarCity => q#لوئس ویلے#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#لوور پرنسس کوارٹر#,
		},
		'America/Maceio' => {
			exemplarCity => q#میسیئو#,
		},
		'America/Managua' => {
			exemplarCity => q#مناگوآ#,
		},
		'America/Manaus' => {
			exemplarCity => q#مناؤس#,
		},
		'America/Marigot' => {
			exemplarCity => q#میریگوٹ#,
		},
		'America/Martinique' => {
			exemplarCity => q#مارٹینک#,
		},
		'America/Matamoros' => {
			exemplarCity => q#میٹاموروس#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#میزٹلان#,
		},
		'America/Mendoza' => {
			exemplarCity => q#مینڈوزا#,
		},
		'America/Menominee' => {
			exemplarCity => q#مینومینی#,
		},
		'America/Merida' => {
			exemplarCity => q#میریڈا#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#میٹلا کاٹلا#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#میکسیکو سٹی#,
		},
		'America/Miquelon' => {
			exemplarCity => q#میکلیئون#,
		},
		'America/Moncton' => {
			exemplarCity => q#مونکٹن#,
		},
		'America/Monterrey' => {
			exemplarCity => q#مونٹیری#,
		},
		'America/Montevideo' => {
			exemplarCity => q#مونٹی ویڈیو#,
		},
		'America/Montserrat' => {
			exemplarCity => q#مونٹسیراٹ#,
		},
		'America/Nassau' => {
			exemplarCity => q#نساؤ#,
		},
		'America/New_York' => {
			exemplarCity => q#نیو یارک#,
		},
		'America/Nipigon' => {
			exemplarCity => q#نپیگون#,
		},
		'America/Nome' => {
			exemplarCity => q#نوم#,
		},
		'America/Noronha' => {
			exemplarCity => q#نورونہا#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#بیولاہ، شمالی ڈکوٹا#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#وسط، شمالی ڈکوٹا#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#نیو سلیم، شمالی ڈکوٹا#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#اوجیناگا#,
		},
		'America/Panama' => {
			exemplarCity => q#پنامہ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#پینگنِرٹنگ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#پراماریبو#,
		},
		'America/Phoenix' => {
			exemplarCity => q#فینکس#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#پورٹ او پرنس#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#پورٹ آف اسپین#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#پورٹو ویلہو#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#پیورٹو ریکو#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#برساتی ندی#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#رینکن انلیٹ#,
		},
		'America/Recife' => {
			exemplarCity => q#ریسائف#,
		},
		'America/Regina' => {
			exemplarCity => q#ریجینا#,
		},
		'America/Resolute' => {
			exemplarCity => q#ریزولیوٹ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ریئو برینکو#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#سانتا ایزابیل#,
		},
		'America/Santarem' => {
			exemplarCity => q#سنٹارین#,
		},
		'America/Santiago' => {
			exemplarCity => q#سنٹیاگو#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#سانتو ڈومنگو#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ساؤ پالو#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#اسکورز بائی سنڈ#,
		},
		'America/Sitka' => {
			exemplarCity => q#سیٹکا#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#سینٹ برتھیلمی#,
		},
		'America/St_Johns' => {
			exemplarCity => q#سینٹ جانز#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#سینٹ کٹس#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#سینٹ لوسیا#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#سینٹ تھامس#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#سینٹ ونسنٹ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#سوِفٹ کرنٹ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ٹیگوسیگالپے#,
		},
		'America/Thule' => {
			exemplarCity => q#تھولو#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#تھنڈر بے#,
		},
		'America/Tijuana' => {
			exemplarCity => q#تیجوآنا#,
		},
		'America/Toronto' => {
			exemplarCity => q#ٹورنٹو#,
		},
		'America/Tortola' => {
			exemplarCity => q#ٹورٹولا#,
		},
		'America/Vancouver' => {
			exemplarCity => q#وینکوور#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#وہائٹ ہارس#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ونّیپیگ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#یکوٹیٹ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ایلو نائف#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(سنٹرل ڈے لائٹ ٹائم),
				'generic' => q(سنٹرل ٹائم),
				'standard' => q(سنٹرل اسٹینڈرڈ ٹائم),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(ایسٹرن ڈے لائٹ ٹائم),
				'generic' => q(ایسٹرن ٹائم),
				'standard' => q(ایسٹرن اسٹینڈرڈ ٹائم),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(ماؤنٹین ڈے لائٹ ٹائم),
				'generic' => q(ماؤنٹین ٹائم),
				'standard' => q(ماؤنٹین اسٹینڈرڈ ٹائم),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(پیسفک ڈے لائٹ ٹائم),
				'generic' => q(پیسفک ٹائم),
				'standard' => q(پیسفک اسٹینڈرڈ ٹائم),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(انیدر سمر ٹائم),
				'generic' => q(انیدر ٹائم),
				'standard' => q(انیدر اسٹینڈرڈ ٹائم),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#کیسی#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ڈیوس#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ڈومونٹ ڈی ارویلے#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#میکواری#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ماؤسن#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#میک مرڈو#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#پلمیر#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#روتھیرا#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#سیووا#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ووستوک#,
		},
		'Arabian' => {
			long => {
				'daylight' => q(عرب کا دن کا وقت),
				'generic' => q(عرب کا وقت),
				'standard' => q(عرب کا معیاری وقت),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#لانگ ایئر بین#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(ارجنٹینا سمر ٹائم),
				'generic' => q(ارجنٹینا ٹائم),
				'standard' => q(ارجنٹینا کا معیاری وقت),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(مغربی ارجنٹینا کا موسم گرما کا وقت),
				'generic' => q(مغربی ارجنٹینا کا وقت),
				'standard' => q(مغربی ارجنٹینا کا معیاری وقت),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(آرمینیا کا موسم گرما کا وقت),
				'generic' => q(آرمینیا کا وقت),
				'standard' => q(آرمینیا کا معیاری وقت),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#عدن#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#الماٹی#,
		},
		'Asia/Amman' => {
			exemplarCity => q#امّان#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#انیدر#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#اکتاؤ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#اکٹوب#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#اشغبت#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#بغداد#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#بحرین#,
		},
		'Asia/Baku' => {
			exemplarCity => q#باکو#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#بنکاک#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#بیروت#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#بشکیک#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#برونئی#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#کولکاتا#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#کوائبلسان#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#چانگ کنگ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#کولمبو#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#دمشق#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ڈھاکہ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ڈلی#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#دوبئی#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#دوشانبے#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#غزہ#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#ہربِن#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ہیبرون#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ہانگ کانگ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ہووارڈ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ارکتسک#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#جکارتہ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#جے پورہ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#یروشلم#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#کابل#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#کیمچٹکا#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#کراچی#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#کاشغر#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#کاٹھمنڈو#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#خندیگا#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#کریسنویارسک#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#کوالا لمپور#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#کیوچنگ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#کویت#,
		},
		'Asia/Macau' => {
			exemplarCity => q#مکاؤ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#میگیدن#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#مکاسر#,
		},
		'Asia/Manila' => {
			exemplarCity => q#منیلا#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#مسقط#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#نکوسیا#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#نوووکوزنیتسک#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#نوووسِبِرسک#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#اومسک#,
		},
		'Asia/Oral' => {
			exemplarCity => q#زبانی#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#نام پنہ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#پونٹیانک#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#پیونگ یانگ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#قطر#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#کیزیلورڈا#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#رنگون#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ریاض#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ہو چی منہ سٹی#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#سخالین#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#سمرقند#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#سیئول#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#شنگھائی#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#سنگاپور#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#تائپے#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#تاشقند#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#طبلیسی#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#تہران#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#تھمپو#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ٹوکیو#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#اولان باتار#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#یورومکی#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#اوسٹ-نیرا#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#وینٹیانا#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ولادی ووستک#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#یکوتسک#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#یکاٹیرِنبرگ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#یریوان#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(اٹلانٹک ڈے لائٹ ٹائم),
				'generic' => q(اٹلانٹک ٹائم),
				'standard' => q(اٹلانٹک اسٹینڈرڈ ٹائم),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ازوریس#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#برمودا#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#کینری#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#کیپ ورڈی#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#فروئی#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#مڈیئرا#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ریکجاوک#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#جنوبی جارجیا#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#سینٹ ہیلینا#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#اسٹینلے#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#اڈیلائڈ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#برسبین#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#بروکن ہِل#,
		},
		'Australia/Currie' => {
			exemplarCity => q#کیوری#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ڈارون#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ایوکلا#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ہوبارٹ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#لِنڈمین#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#لارڈ ہووے#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ملبورن#,
		},
		'Australia/Perth' => {
			exemplarCity => q#پرتھ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#سڈنی#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(آسٹریلین سنٹرل ڈے لائٹ ٹائم),
				'generic' => q(سنٹرل آسٹریلیا ٹائم),
				'standard' => q(آسٹریلین سنٹرل اسٹینڈرڈ ٹائم),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(آسٹریلین سنٹرل ویسٹرن ڈے لائٹ ٹائم),
				'generic' => q(آسٹریلین سنٹرل ویسٹرن ٹائم),
				'standard' => q(آسٹریلین سنٹرل ویسٹرن اسٹینڈرڈ ٹائم),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(آسٹریلین ایسٹرن ڈے لائٹ ٹائم),
				'generic' => q(ایسٹرن آسٹریلیا ٹائم),
				'standard' => q(آسٹریلین ایسٹرن اسٹنڈرڈ ٹائم),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(آسٹریلین ویسٹرن ڈے لائٹ ٹائم),
				'generic' => q(ویسٹرن آسٹریلیا ٹائم),
				'standard' => q(آسٹریلیا ویسٹرن اسٹینڈرڈ ٹائم),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(آذربائیجان کا موسم گرما کا وقت),
				'generic' => q(آذربائیجان کا وقت),
				'standard' => q(آذربائیجان کا معیاری وقت),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(ازوریس کا موسم گرما کا وقت),
				'generic' => q(ازوریس کا وقت),
				'standard' => q(ازوریس کا معیاری وقت),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(بنگلہ دیش کا موسم گرما کا وقت),
				'generic' => q(بنگلہ دیش کا وقت),
				'standard' => q(بنگلہ دیش کا معیاری وقت),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(بھوٹان کا وقت),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(بولیویا کا وقت),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(برازیلیا سمر ٹائم),
				'generic' => q(برازیلیا ٹائم),
				'standard' => q(برازیلیا اسٹینڈرڈ ٹائم),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(برونئی دارالسلام کا وقت),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(کیپ ورڈی کا موسم گرما کا وقت),
				'generic' => q(کیپ ورڈی کا وقت),
				'standard' => q(کیپ ورڈی کا معیاری وقت),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(شمورو کا معیاری وقت),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(چیتھم کا دن کا وقت),
				'generic' => q(چیتھم کا وقت),
				'standard' => q(چیتھم کا موسم گرما کا وقت),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(چلی کا موسم گرما کا وقت),
				'generic' => q(چلی کا وقت),
				'standard' => q(چلی کا معیاری وقت),
			},
		},
		'China' => {
			long => {
				'daylight' => q(چین کا دن کا وقت),
				'generic' => q(چین کا وقت),
				'standard' => q(چین کا معیاری وقت),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(کوائبلسان سمر ٹائم),
				'generic' => q(کوئبلسان ٹائم),
				'standard' => q(کوئبلسان کا معیاری وقت),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(کرسمس آئلینڈ کا وقت),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(کوکوس آئلینڈز کا وقت),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(کولمبیا کا موسم گرما کا وقت),
				'generic' => q(کولمبیا کا وقت),
				'standard' => q(کولمبیا کا معیاری وقت),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(کک آئلینڈز کا نصف موسم گرما کا وقت),
				'generic' => q(کک آئلینڈز کا وقت),
				'standard' => q(کک آئلینڈز کا معیاری وقت),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(کیوبا کا دن کا وقت),
				'generic' => q(کیوبا کا وقت),
				'standard' => q(کیوبا کا معیاری وقت),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ڈیوس کا وقت),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ڈومونٹ-ڈی'ارویلے کا وقت),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(مشرقی تیمور کا وقت),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ایسٹر آئلینڈ کا موسم گرما کا وقت),
				'generic' => q(ایسٹر آئلینڈ کا وقت),
				'standard' => q(ایسٹر آئلینڈ کا معیاری وقت),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ایکواڈور کا وقت),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#نامعلوم شہر#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ایمسٹرڈم#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#انڈورا#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ایتھنز#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#بلغراد#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#برلن#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#بریٹِسلاوا#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#برسلز#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#بخارسٹ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#بدھاپیسٹ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#بزنجن#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#چیسیناؤ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#کوپن ہیگن#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ڈبلن#,
			long => {
				'daylight' => q(آئرش کا گرما کے وقت),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#جبل الطارق#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#گوئرنسی#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ہیلسنکی#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#آئل آف مین#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#استنبول#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#جرسی#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#لینن گراد#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#کیوو#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#لسبن#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#جبجانا#,
		},
		'Europe/London' => {
			exemplarCity => q#لندن#,
			long => {
				'daylight' => q(برطانوی کا گرما کے وقت),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#لگژمبرگ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#میڈرڈ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#مالٹا#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#میریہام#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#مِنسک#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#موناکو#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ماسکو#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#اوسلو#,
		},
		'Europe/Paris' => {
			exemplarCity => q#پیرس#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#پوڈگورسیا#,
		},
		'Europe/Prague' => {
			exemplarCity => q#پراگ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ریگا#,
		},
		'Europe/Rome' => {
			exemplarCity => q#روم#,
		},
		'Europe/Samara' => {
			exemplarCity => q#سمارا#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#سان ماریانو#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#سراجیوو#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#سمفروپول#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#اسکوپجے#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#صوفیہ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#اسٹاک ہوم#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#تالِّن#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ٹیرانی#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ازگوروڈ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ویڈوز#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#واٹیکن#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ویانا#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#وِلنیئس#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#وولگوگراد#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#وارسا#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#زیگریب#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#زیپوروزائی#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#زیورخ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(وسطی یورپ کا موسم گرما کا وقت),
				'generic' => q(وسط یورپ کا وقت),
				'standard' => q(وسطی یورپ کا معیاری وقت),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(مشرقی یورپ کا موسم گرما کا وقت),
				'generic' => q(مشرقی یورپ کا وقت),
				'standard' => q(مشرقی یورپ کا معیاری وقت),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(مغربی یورپ کا موسم گرما کا وقت),
				'generic' => q(مغربی یورپ کا وقت),
				'standard' => q(مغربی یورپ کا معیاری وقت),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(فاک لینڈ آئلینڈز کا موسم گرما کا وقت),
				'generic' => q(فاک لینڈ آئلینڈز کا وقت),
				'standard' => q(فاک لینڈ آئلینڈز کا معیاری وقت),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(فجی کا موسم گرما کا وقت),
				'generic' => q(فجی کا وقت),
				'standard' => q(فجی کا معیاری وقت),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(فرینچ گیانا کا وقت),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(فرینچ سدرن اور انٹارکٹک کا وقت),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(گرین وچ کا اصل وقت),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(گالاپاگوز کا وقت),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(گیمبیئر کا وقت),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(جارجیا کا موسم گرما کا وقت),
				'generic' => q(جارجیا کا وقت),
				'standard' => q(جارجیا کا معیاری وقت),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(جلبرٹ آئلینڈز کا وقت),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(مشرقی گرین لینڈ کا موسم گرما کا وقت),
				'generic' => q(مشرقی گرین لینڈ کا وقت),
				'standard' => q(مشرقی گرین لینڈ کا معیاری وقت),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(مغربی گرین لینڈ کا موسم گرما کا وقت),
				'generic' => q(مغربی گرین لینڈ کا وقت),
				'standard' => q(مغربی گرین لینڈ کا معیاری وقت),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(خلیج کا معیاری وقت),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(گیانا کا وقت),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ہوائی الیوٹیئن ڈے لائٹ ٹائم),
				'generic' => q(ہوائی الیوٹیئن ٹائم),
				'standard' => q(ہوائی الیوٹیئن اسٹینڈرڈ ٹائم),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ہانگ کانگ کا موسم گرما کا وقت),
				'generic' => q(ہانگ کانگ کا وقت),
				'standard' => q(ہانگ کانگ کا معیاری وقت),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ہووارڈ سمر ٹائم),
				'generic' => q(ہووارڈ ٹائم),
				'standard' => q(ہاورڈ کا معیاری وقت),
			},
		},
		'India' => {
			long => {
				'standard' => q(ہندوستان کا معیاری وقت),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#انٹاناناریوو#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#چاگوس#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#کرسمس#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#کوکوس#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#کومورو#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#کرگیولین#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ماہی#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#مالدیپ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ماریشس#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#مایوٹ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ری یونین#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(بحر ہند کا وقت),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ہند چین کا وقت),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(وسطی انڈونیشیا کا وقت),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(مشرقی انڈونیشیا کا وقت),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(مغربی انڈونیشیا کا وقت),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ایران کا دن کا وقت),
				'generic' => q(ایران کا وقت),
				'standard' => q(ایران کا معیاری وقت),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ارکتسک سمر ٹائم),
				'generic' => q(ارکتسک ٹائم),
				'standard' => q(ارکتسک کا معیاری وقت),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(اسرائیل کا دن کا وقت),
				'generic' => q(اسرائیل کا وقت),
				'standard' => q(اسرائیل کا معیاری وقت),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(جاپان کا دن کا وقت),
				'generic' => q(جاپان کا وقت),
				'standard' => q(جاپان کا معیاری وقت),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(پیٹروپاؤلووسک-کیمچسکی سمر ٹائم),
				'generic' => q(پیٹروپاؤلووسک-کیمچسکی ٹائم),
				'standard' => q(پیٹروپاؤلووسک-کیمچسکی اسٹینڈرڈ ٹائم),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(مشرقی قزاخستان کا وقت),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(مغربی قزاخستان کا وقت),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(کوریا کا دن کا وقت),
				'generic' => q(کوریا کا وقت),
				'standard' => q(کوریا کا معیاری وقت),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(کوسرے کا وقت),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(کریسنویارسک سمر ٹائم),
				'generic' => q(کریسنویارسک ٹائم),
				'standard' => q(کرسنویارسک کا معیاری وقت),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(کرغستان کا وقت),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(لائن آئلینڈز کا وقت),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(لارڈ ہووے ڈے لائٹ ٹائم),
				'generic' => q(لارڈ ہووے ٹائم),
				'standard' => q(لارڈ ہووے اسٹینڈرڈ ٹائم),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(مکوآری آئلینڈ کا وقت),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(میگیدن سمر ٹائم),
				'generic' => q(میگیدن ٹائم),
				'standard' => q(میگدان کا معیاری وقت),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(ملیشیا کا وقت),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(مالدیپ کا وقت),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(مارکیسس کا وقت),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(مارشل آئلینڈز کا وقت),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(ماریشس کا موسم گرما کا وقت),
				'generic' => q(ماریشس کا وقت),
				'standard' => q(ماریشس کا معیاری وقت),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(ماؤسن کا وقت),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(یولان بیٹور سمر ٹائم),
				'generic' => q(یولان بیتور کا وقت),
				'standard' => q(یولان بیتور کا معیاری وقت),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(ماسکو سمر ٹائم),
				'generic' => q(ماسکو ٹائم),
				'standard' => q(ماسکو اسٹینڈرڈ ٹائم),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(میانمار کا وقت),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(ناؤرو کا وقت),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(نیپال کا وقت),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(نیو کیلیڈونیا کا موسم گرما کا وقت),
				'generic' => q(نیو کیلیڈونیا کا وقت),
				'standard' => q(نیو کیلیڈونیا کا معیاری وقت),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(نیوزی لینڈ کا دن کا وقت),
				'generic' => q(نیوزی لینڈ کا وقت),
				'standard' => q(نیوزی لینڈ کا معیاری وقت),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(نیو فاؤنڈ لینڈ ڈے لائٹ ٹائم),
				'generic' => q(نیو فاؤنڈ لینڈ ٹائم),
				'standard' => q(نیو فاؤنڈ لینڈ اسٹینڈرڈ ٹائم),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(نیئو کا وقت),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(نارفوک آئلینڈز کا وقت),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(فرنانڈو ڈی نورونہا سمر ٹائم),
				'generic' => q(فرنانڈو ڈی نورنہا کا وقت),
				'standard' => q(فرنانڈو ڈی نورنہا کا معیاری وقت),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(نوووسِبِرسک سمر ٹائم),
				'generic' => q(نوووسیبرسک ٹائم),
				'standard' => q(نوووسیبرسک کا معیاری وقت),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(اومسک سمر ٹائم),
				'generic' => q(اومسک ٹائم),
				'standard' => q(اومسک کا معیاری وقت),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#اپیا#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#آکلینڈ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#چیتھم#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ایسٹر#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ایفیٹ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#اینڈربری#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#فکاؤفو#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#فجی#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#فیونافیوٹی#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#گیلاپیگوس#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#گامبیئر#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#گواڈل کینال#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#گوآم#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ہونولولو#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#جانسٹن#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#کریتیماٹی#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#کوسرائی#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#کواجیلین#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#مجورو#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#مارکیساس#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#وسط دن#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ناؤرو#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#نیئو#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#نورفوک#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#نؤمیا#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#پاگو پاگو#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#پلاؤ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#پٹکائرن#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#پونپیئی#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#پورٹ موریسبی#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#راروٹونگا#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#سائپین#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#تاہیتی#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ٹراوا#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ٹونگاٹاپو#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#چیوک#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#بیدار#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ولّیس#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(پاکستان کا موسم گرما کا وقت),
				'generic' => q(پاکستان کا وقت),
				'standard' => q(پاکستان کا معیاری وقت),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(پلاؤ کا وقت),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(پاپوآ نیو گنی کا وقت),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(پیراگوئے کا موسم گرما کا وقت),
				'generic' => q(پیراگوئے کا وقت),
				'standard' => q(پیراگوئے کا معیاری وقت),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(پیرو کا موسم گرما کا وقت),
				'generic' => q(پیرو کا وقت),
				'standard' => q(پیرو کا معیاری وقت),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(فلپائن کا موسم گرما کا وقت),
				'generic' => q(فلپائن کا وقت),
				'standard' => q(فلپائن کا معیاری وقت),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(فینکس آئلینڈز کا وقت),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(سینٹ پیئر اور مکلیئون کا دن کا وقت),
				'generic' => q(سینٹ پیئر اور مکلیئون کا وقت),
				'standard' => q(سینٹ پیئر اور مکلیئون کا معیاری وقت),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(پٹکائرن کا وقت),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(پوناپے کا وقت),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(ری یونین کا وقت),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(روتھیرا کا وقت),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(سخالین سمر ٹائم),
				'generic' => q(سخالین ٹائم),
				'standard' => q(سخالین کا معیاری وقت),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(سمارا سمر ٹائم),
				'generic' => q(سمارا ٹائم),
				'standard' => q(سمارا اسٹینڈرڈ ٹائم),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(ساموآ سمر وقت),
				'generic' => q(ساموآ وقت),
				'standard' => q(ساموآ کا معیاری وقت),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(سیشلیز کا وقت),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(سنگاپور کا معیاری وقت),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(سولمن آئلینڈز کا وقت),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(جنوبی جارجیا کا وقت),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(سورینام کا وقت),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(سیووا کا وقت),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(تاہیتی کا وقت),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(تائیپے کا دن کا وقت),
				'generic' => q(تائیپے کا وقت),
				'standard' => q(تائیپے کا معیاری وقت),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(تاجکستان کا وقت),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(ٹوکیلاؤ کا وقت),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(ٹونگا کا موسم گرما کا وقت),
				'generic' => q(ٹونگا کا وقت),
				'standard' => q(ٹونگا کا معیاری وقت),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(چوک کا وقت),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(ترکمانستان کا موسم گرما کا وقت),
				'generic' => q(ترکمانستان کا وقت),
				'standard' => q(ترکمانستان کا معیاری وقت),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ٹوالو کا وقت),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(یوروگوئے کا موسم گرما کا وقت),
				'generic' => q(یوروگوئے کا وقت),
				'standard' => q(یوروگوئے کا معیاری وقت),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ازبکستان کا موسم گرما کا وقت),
				'generic' => q(ازبکستان کا وقت),
				'standard' => q(ازبکستان کا معیاری وقت),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(وانوآٹو کا موسم گرما کا وقت),
				'generic' => q(وانوآٹو کا وقت),
				'standard' => q(وانوآٹو کا معیاری وقت),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(وینزوئیلا کا وقت),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ولادی ووستک سمر ٹائم),
				'generic' => q(ولادی ووستک ٹائم),
				'standard' => q(ولادی ووستک کا معیاری وقت),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(وولگوگراد سمر ٹائم),
				'generic' => q(وولگوگراد ٹائم),
				'standard' => q(بلغراد کا معیاری وقت),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ووسٹاک کا وقت),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ویک آئلینڈ کا وقت),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(والیز اور فٹونا کا وقت),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(یکوتسک سمر ٹائم),
				'generic' => q(یکوتسک ٹائم),
				'standard' => q(یاکتسک کا معیاری وقت),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(یکاٹیرِنبرگ سمر ٹائم),
				'generic' => q(یکاٹیرِنبرگ ٹائم),
				'standard' => q(یکیترنگبرگ کا معیاری وقت),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
