package Locale::CLDR::Transformations::Ungegn::Grek::Latn;
# This file auto generated from Data\common\transforms\Greek_Latin_UNGEGN.xml
#	on Sun  7 Jan  2:30:41 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^umi:\G(?:[\p{Greek}\p{Mn}\p{Me}]|[\:-\;?·;·]))/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFD),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(\:),
					result  => q(\:̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(\?),
					result  => q(\?̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(·),
					result  => q(\:),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(͂),
					result  => q(́),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̂),
					result  => q(́),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̀),
					result  => q(́),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̓),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(̔),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ͅ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ͺ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(η),
					result  => q(i̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Η),
					result  => q(I̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([\p{Mn} \p{Me}] * (?:(?=[\p{Ll}])[\p{latin}\p{greek}])),
					replace => q(Ψ),
					result  => q(Ps),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ψ),
					result  => q(PS),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ψ),
					result  => q(ps),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ω),
					result  => q(o̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ω),
					result  => q(O̱),
					revisit => 0,
				},
				{
					before  => q((?:(?!(?:[\p{L}]|[\p{Mn}\p{Me}]))(?s:.))),
					after   => q(),
					replace => q(μπ),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:(?!(?:[\p{L}]|[\p{Mn}\p{Me}]))(?s:.))),
					replace => q(μπ),
					result  => q(b),
					revisit => 0,
				},
				{
					before  => q((?:(?!(?:[\p{L}]|[\p{Mn}\p{Me}]))(?s:.))),
					after   => q(),
					replace => q([Μμ][Ππ]),
					result  => q(B),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:(?!(?:[\p{L}]|[\p{Mn}\p{Me}]))(?s:.))),
					replace => q([Μμ][Ππ]),
					result  => q(B),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ου),
					result  => q(ou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ΟΥ),
					result  => q(OU),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ου),
					result  => q(Ou),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(οΥ),
					result  => q(oU),
					revisit => 0,
				},
				{
					before  => q([aeiAEI] ̱ ?),
					after   => q((?:[βΒγΓδΔζΖλΛμΜνΝρΡ]|(?:[αεηιουω]|[ΑΕΗΙΟΥΩ]))),
					replace => q(υ((?:(?![̈])[\p{Mn}]))*),
					result  => q($1v̱),
					revisit => 0,
				},
				{
					before  => q([aeiAEI] ̱ ?),
					after   => q(),
					replace => q(υ((?:(?![̈])[\p{Mn}]))*),
					result  => q($1f̱),
					revisit => 0,
				},
				{
					before  => q([aeiAEI] ̱ ?),
					after   => q((?:[βΒγΓδΔζΖλΛμΜνΝρΡ]|(?:[αεηιουω]|[ΑΕΗΙΟΥΩ]))),
					replace => q(Υ),
					result  => q(V̱),
					revisit => 0,
				},
				{
					before  => q([aeiAEI] ̱ ?),
					after   => q(),
					replace => q(Υ),
					result  => q(U̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(υ),
					result  => q(y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Υ),
					result  => q(Y),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(α),
					result  => q(a),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Α),
					result  => q(A),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(β),
					result  => q(v),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Β),
					result  => q(V),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ΓΚΞΧγκξχϰ]),
					replace => q(γ),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(γ),
					result  => q(g),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ΓΚΞΧγκξχϰ]),
					replace => q(Γ),
					result  => q(N),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Γ),
					result  => q(G),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(δ),
					result  => q(d),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Δ),
					result  => q(D),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ε),
					result  => q(e),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ε),
					result  => q(E),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ζ),
					result  => q(z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ζ),
					result  => q(Z),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(θ),
					result  => q(th),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([\p{Mn} \p{Me}] * (?:(?=[\p{Ll}])[\p{latin}\p{greek}])),
					replace => q(Θ),
					result  => q(Th),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Θ),
					result  => q(TH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ι),
					result  => q(i),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ι),
					result  => q(I),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(κ),
					result  => q(k),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Κ),
					result  => q(K),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(λ),
					result  => q(l),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Λ),
					result  => q(L),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(μ),
					result  => q(m),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Μ),
					result  => q(M),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ΓΚΞΧγκξχϰ]),
					replace => q(ν),
					result  => q(n\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ν),
					result  => q(n),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([ΓΚΞΧγκξχϰ]),
					replace => q(Ν),
					result  => q(N\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ν),
					result  => q(N),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ξ),
					result  => q(x),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ξ),
					result  => q(X),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ο),
					result  => q(o),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ο),
					result  => q(O),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(π),
					result  => q(p),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Π),
					result  => q(P),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ρ),
					result  => q(r),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ρ),
					result  => q(R),
					revisit => 0,
				},
				{
					before  => q([Pp]),
					after   => q([ςσΣϷϸϺϻ]),
					replace => q(),
					result  => q(\'),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ϸ),
					result  => q(Š),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϸ),
					result  => q(š),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ϻ),
					result  => q(Ŝ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϻ),
					result  => q(ŝ),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[\']|[\p{Mn}\p{Me}]) * \p{L}),
					replace => q(ς),
					result  => q(s̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q((?:[\']|[\p{Mn}\p{Me}]) * \p{L}),
					replace => q(σ),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(\p{L} (?:[\']|[\p{Mn}\p{Me}]) *),
					after   => q(),
					replace => q(σ),
					result  => q(s̱),
					revisit => 0,
				},
				{
					before  => q(\p{L} (?:[\']|[\p{Mn}\p{Me}]) *),
					after   => q(),
					replace => q(ς),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ς),
					result  => q(s̱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(σ),
					result  => q(s),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Σ),
					result  => q(S),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(τ),
					result  => q(t),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Τ),
					result  => q(T),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(φ),
					result  => q(f),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Φ),
					result  => q(F),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(χ),
					result  => q(ch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([\p{Mn} \p{Me}] * (?:(?=[\p{Ll}])[\p{latin}\p{greek}])),
					replace => q(Χ),
					result  => q(Ch),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Χ),
					result  => q(CH),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϐ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϑ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϒ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϕ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϖ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϰ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϱ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϲ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(Ϲ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϳ),
					result  => q(j),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϴ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ϵ),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(µ),
					result  => q(),
					revisit => 1,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
