=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ia - Package for language Interlingua

=cut

package Locale::CLDR::Locales::Ia;
# This file auto generated from Data\common\main\ia.xml
#	on Sun  7 Jan  2:30:41 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.40.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'afar',
 				'ab' => 'abkhazo',
 				'ace' => 'acehnese',
 				'ada' => 'adangme',
 				'ady' => 'adygeano',
 				'af' => 'afrikaans',
 				'agq' => 'aghem',
 				'ain' => 'ainu',
 				'ak' => 'akan',
 				'ale' => 'aleuto',
 				'alt' => 'altai del sud',
 				'am' => 'amharico',
 				'an' => 'aragonese',
 				'anp' => 'angika',
 				'ar' => 'arabe',
 				'ar_001' => 'arabe standard moderne',
 				'arn' => 'mapuche',
 				'arp' => 'arapaho',
 				'as' => 'assamese',
 				'asa' => 'asu',
 				'ast' => 'asturiano',
 				'av' => 'avaro',
 				'awa' => 'awadhi',
 				'ay' => 'aymara',
 				'az' => 'azerbaidzhano',
 				'az@alt=short' => 'azeri',
 				'ba' => 'bashkir',
 				'ban' => 'balinese',
 				'bas' => 'basaa',
 				'be' => 'bielorusso',
 				'bem' => 'bemba',
 				'bez' => 'bena',
 				'bg' => 'bulgaro',
 				'bho' => 'bhojpuri',
 				'bi' => 'bislama',
 				'bin' => 'bini',
 				'bla' => 'siksika',
 				'bm' => 'bambara',
 				'bn' => 'bengalese',
 				'bo' => 'tibetano',
 				'br' => 'breton',
 				'brx' => 'bodo',
 				'bs' => 'bosniaco',
 				'bug' => 'buginese',
 				'byn' => 'blin',
 				'ca' => 'catalano',
 				'ccp' => 'chakma',
 				'ce' => 'checheno',
 				'ceb' => 'cebuano',
 				'cgg' => 'chiga',
 				'ch' => 'chamorro',
 				'chk' => 'chuukese',
 				'chm' => 'mari',
 				'cho' => 'choctaw',
 				'chr' => 'cherokee',
 				'chy' => 'cheyenne',
 				'ckb' => 'kurdo central',
 				'ckb@alt=variant' => 'kurdo sorani',
 				'co' => 'corso',
 				'crs' => 'creolo seychellese',
 				'cs' => 'checo',
 				'cu' => 'slavo ecclesiastic',
 				'cv' => 'chuvash',
 				'cy' => 'gallese',
 				'da' => 'danese',
 				'dak' => 'dakota',
 				'dar' => 'dargwa',
 				'dav' => 'taita',
 				'de' => 'germano',
 				'de_AT' => 'germano austriac',
 				'de_CH' => 'alte germano suisse',
 				'dgr' => 'dogrib',
 				'dje' => 'zarma',
 				'doi' => 'dogri',
 				'dsb' => 'basse sorabo',
 				'dua' => 'duala',
 				'dv' => 'divehi',
 				'dyo' => 'jola-fonyi',
 				'dz' => 'dzongkha',
 				'dzg' => 'dazaga',
 				'ebu' => 'embu',
 				'ee' => 'ewe',
 				'efi' => 'efik',
 				'eka' => 'ekajuk',
 				'el' => 'greco',
 				'en' => 'anglese',
 				'en_AU' => 'anglese australian',
 				'en_CA' => 'anglese canadian',
 				'en_GB' => 'anglese britannic',
 				'en_GB@alt=short' => 'anglese (GB)',
 				'en_US' => 'anglese american',
 				'eo' => 'esperanto',
 				'es' => 'espaniol',
 				'es_419' => 'espaniol latinoamerican',
 				'es_ES' => 'espaniol europee',
 				'es_MX' => 'espaniol mexican',
 				'et' => 'estoniano',
 				'eu' => 'basco',
 				'ewo' => 'ewondo',
 				'fa' => 'persa',
 				'fa_AF' => 'dari',
 				'ff' => 'fula',
 				'fi' => 'finnese',
 				'fil' => 'filipino',
 				'fj' => 'fijiano',
 				'fo' => 'feroese',
 				'fon' => 'fon',
 				'fr' => 'francese',
 				'fr_CA' => 'francese canadian',
 				'fr_CH' => 'francese suisse',
 				'fur' => 'friulano',
 				'fy' => 'frison occidental',
 				'ga' => 'irlandese',
 				'gaa' => 'ga',
 				'gd' => 'gaelico scotese',
 				'gez' => 'ge’ez',
 				'gil' => 'gilbertese',
 				'gl' => 'galleco',
 				'gn' => 'guarani',
 				'gor' => 'gorontalo',
 				'gsw' => 'germano suisse',
 				'gu' => 'gujarati',
 				'guz' => 'gusii',
 				'gv' => 'mannese',
 				'gwi' => 'gwich’in',
 				'ha' => 'hausa',
 				'haw' => 'hawaiano',
 				'he' => 'hebreo',
 				'hi' => 'hindi',
 				'hil' => 'hiligaynon',
 				'hmn' => 'hmong',
 				'hr' => 'croato',
 				'hsb' => 'alte sorabo',
 				'ht' => 'creolo haitian',
 				'hu' => 'hungaro',
 				'hup' => 'hupa',
 				'hy' => 'armenio',
 				'hz' => 'herero',
 				'ia' => 'interlingua',
 				'iba' => 'iban',
 				'ibb' => 'ibibio',
 				'id' => 'indonesiano',
 				'ie' => 'Interlingue',
 				'ig' => 'igbo',
 				'ii' => 'yi de Sichuan',
 				'ilo' => 'ilocano',
 				'inh' => 'ingush',
 				'io' => 'ido',
 				'is' => 'islandese',
 				'it' => 'italiano',
 				'iu' => 'inuktitut',
 				'ja' => 'japonese',
 				'jbo' => 'lojban',
 				'jgo' => 'ngomba',
 				'jmc' => 'machame',
 				'jv' => 'javanese',
 				'ka' => 'georgiano',
 				'kab' => 'kabylo',
 				'kac' => 'kachin',
 				'kaj' => 'jju',
 				'kam' => 'kamba',
 				'kbd' => 'cabardiano',
 				'kcg' => 'tyap',
 				'kde' => 'makonde',
 				'kea' => 'capoverdiano',
 				'kfo' => 'koro',
 				'kha' => 'khasi',
 				'khq' => 'koyra chiini',
 				'ki' => 'kikuyu',
 				'kj' => 'kuanyama',
 				'kk' => 'kazakh',
 				'kkj' => 'kako',
 				'kl' => 'groenlandese',
 				'kln' => 'kalenjin',
 				'km' => 'khmer',
 				'kmb' => 'kimbundu',
 				'kn' => 'kannada',
 				'ko' => 'coreano',
 				'kok' => 'konkani',
 				'kpe' => 'kpelle',
 				'kr' => 'kanuri',
 				'krc' => 'karachay-balkaro',
 				'krl' => 'careliano',
 				'kru' => 'kurukh',
 				'ks' => 'kashmiri',
 				'ksb' => 'shambala',
 				'ksf' => 'bafia',
 				'ksh' => 'coloniese',
 				'ku' => 'kurdo',
 				'kum' => 'kumyko',
 				'kv' => 'komi',
 				'kw' => 'cornico',
 				'ky' => 'kirghizo',
 				'la' => 'latino',
 				'lad' => 'ladino',
 				'lag' => 'langi',
 				'lb' => 'luxemburgese',
 				'lez' => 'lezghiano',
 				'lg' => 'luganda',
 				'li' => 'limburgese',
 				'lkt' => 'lakota',
 				'ln' => 'lingala',
 				'lo' => 'laotiano',
 				'loz' => 'lozi',
 				'lrc' => 'luri del nord',
 				'lt' => 'lithuano',
 				'lu' => 'luba-katanga',
 				'lua' => 'luba-lulua',
 				'lun' => 'lunda',
 				'luo' => 'luo',
 				'lus' => 'mizo',
 				'luy' => 'luyia',
 				'lv' => 'letton',
 				'mad' => 'madurese',
 				'mag' => 'magahi',
 				'mai' => 'maithili',
 				'mak' => 'macassarese',
 				'mas' => 'masai',
 				'mdf' => 'moksha',
 				'men' => 'mende',
 				'mer' => 'meri',
 				'mfe' => 'creolo mauritian',
 				'mg' => 'malgache',
 				'mgh' => 'makhuwa-meetto',
 				'mgo' => 'metaʼ',
 				'mh' => 'marshallese',
 				'mi' => 'maori',
 				'mic' => 'micmac',
 				'min' => 'minangkabau',
 				'mk' => 'macedone',
 				'ml' => 'malayalam',
 				'mn' => 'mongol',
 				'mni' => 'manipuri',
 				'moh' => 'mohawk',
 				'mos' => 'mossi',
 				'mr' => 'marathi',
 				'ms' => 'malay',
 				'mt' => 'maltese',
 				'mua' => 'mundang',
 				'mul' => 'plure linguas',
 				'mus' => 'creek',
 				'mwl' => 'mirandese',
 				'my' => 'birmano',
 				'myv' => 'erzya',
 				'mzn' => 'mazanderani',
 				'na' => 'nauru',
 				'nap' => 'napolitano',
 				'naq' => 'nama',
 				'nb' => 'norvegiano bokmål',
 				'nd' => 'ndebele del nord',
 				'nds' => 'basse germano',
 				'ne' => 'nepalese',
 				'new' => 'newari',
 				'ng' => 'ndonga',
 				'nia' => 'nias',
 				'niu' => 'nieuano',
 				'nl' => 'nederlandese',
 				'nl_BE' => 'flamingo',
 				'nmg' => 'kwasio',
 				'nn' => 'norvegiano nynorsk',
 				'nnh' => 'ngiemboon',
 				'no' => 'norvegiano',
 				'nog' => 'nogai',
 				'nqo' => 'n’ko',
 				'nr' => 'ndebele del sud',
 				'nso' => 'sotho del nord',
 				'nus' => 'nuer',
 				'nv' => 'navajo',
 				'ny' => 'nyanja',
 				'nyn' => 'nyankole',
 				'oc' => 'occitano',
 				'om' => 'oromo',
 				'or' => 'oriya',
 				'os' => 'osseto',
 				'pa' => 'punjabi',
 				'pag' => 'pangasinan',
 				'pam' => 'pampanga',
 				'pap' => 'papiamento',
 				'pau' => 'palauano',
 				'pcm' => 'pidgin nigerian',
 				'pl' => 'polonese',
 				'prg' => 'prussiano',
 				'ps' => 'pashto',
 				'pt' => 'portugese',
 				'pt_BR' => 'portugese de Brasil',
 				'pt_PT' => 'portugese de Portugal',
 				'qu' => 'quechua',
 				'quc' => 'kʼicheʼ',
 				'rap' => 'rapanui',
 				'rar' => 'rarotongano',
 				'rhg' => 'rohingya',
 				'rm' => 'romanche',
 				'rn' => 'rundi',
 				'ro' => 'romaniano',
 				'ro_MD' => 'moldavo',
 				'rof' => 'rombo',
 				'ru' => 'russo',
 				'rup' => 'aromaniano',
 				'rw' => 'kinyarwanda',
 				'rwk' => 'rwa',
 				'sa' => 'sanscrito',
 				'sad' => 'sandawe',
 				'sah' => 'yakuto',
 				'saq' => 'samburu',
 				'sat' => 'santali',
 				'sba' => 'ngambay',
 				'sbp' => 'sangu',
 				'sc' => 'sardo',
 				'scn' => 'siciliano',
 				'sco' => 'scotese',
 				'sd' => 'sindhi',
 				'se' => 'sami del nord',
 				'seh' => 'sena',
 				'ses' => 'koyraboro senni',
 				'sg' => 'sango',
 				'sh' => 'serbocroate',
 				'shi' => 'tachelhit',
 				'shn' => 'shan',
 				'si' => 'cingalese',
 				'sk' => 'slovaco',
 				'sl' => 'sloveno',
 				'sm' => 'samoano',
 				'sma' => 'sami del sud',
 				'smj' => 'sami de Lule',
 				'smn' => 'sami de Inari',
 				'sms' => 'sami skolt',
 				'sn' => 'shona',
 				'snk' => 'soninke',
 				'so' => 'somali',
 				'sq' => 'albanese',
 				'sr' => 'serbo',
 				'srn' => 'sranan tongo',
 				'ss' => 'swati',
 				'ssy' => 'saho',
 				'st' => 'sotho del sud',
 				'su' => 'sundanese',
 				'suk' => 'sukuma',
 				'sv' => 'svedese',
 				'sw' => 'swahili',
 				'sw_CD' => 'swahili del Congo',
 				'swb' => 'comoriano',
 				'syr' => 'syriaco',
 				'ta' => 'tamil',
 				'te' => 'telugu',
 				'tem' => 'temne',
 				'teo' => 'teso',
 				'tet' => 'tetum',
 				'tg' => 'tajiko',
 				'th' => 'thai',
 				'ti' => 'tigrinya',
 				'tig' => 'tigre',
 				'tk' => 'turkmeno',
 				'tlh' => 'klingon',
 				'tn' => 'tswana',
 				'to' => 'tongano',
 				'tpi' => 'tok pisin',
 				'tr' => 'turco',
 				'trv' => 'taroko',
 				'ts' => 'tsonga',
 				'tt' => 'tataro',
 				'tum' => 'tumbuka',
 				'tvl' => 'tuvaluano',
 				'tw' => 'twi',
 				'twq' => 'tasawaq',
 				'ty' => 'tahitiano',
 				'tyv' => 'tuvano',
 				'tzm' => 'tamazight del Atlas Central',
 				'udm' => 'udmurto',
 				'ug' => 'uighur',
 				'uk' => 'ukrainiano',
 				'umb' => 'umbundu',
 				'und' => 'lingua incognite',
 				'ur' => 'urdu',
 				'uz' => 'uzbeko',
 				'vai' => 'vai',
 				've' => 'venda',
 				'vi' => 'vietnamese',
 				'vo' => 'volapük',
 				'vun' => 'vunjo',
 				'wa' => 'wallon',
 				'wae' => 'walser',
 				'wal' => 'wolaytta',
 				'war' => 'waray',
 				'wo' => 'wolof',
 				'xal' => 'calmuco',
 				'xh' => 'xhosa',
 				'xog' => 'soga',
 				'yav' => 'yangben',
 				'ybb' => 'yemba',
 				'yi' => 'yiddish',
 				'yo' => 'yoruba',
 				'yue' => 'cantonese',
 				'yue@alt=menu' => 'chinese cantonese',
 				'zgh' => 'tamazight marocchin standard',
 				'zh' => 'chinese',
 				'zh@alt=menu' => 'chinese mandarin',
 				'zh_Hans' => 'chinese simplificate',
 				'zh_Hans@alt=long' => 'chinese mandarin simplificate',
 				'zh_Hant' => 'chinese traditional',
 				'zh_Hant@alt=long' => 'chinese mandarin traditional',
 				'zu' => 'zulu',
 				'zun' => 'zuni',
 				'zxx' => 'sin contento linguistic',
 				'zza' => 'zaza',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'arabe',
 			'Armn' => 'armenie',
 			'Beng' => 'bengalese',
 			'Bopo' => 'bopomofo',
 			'Brai' => 'braille',
 			'Cyrl' => 'cyrillic',
 			'Deva' => 'devanagari',
 			'Ethi' => 'ethiope',
 			'Geor' => 'georgian',
 			'Grek' => 'grec',
 			'Gujr' => 'gujarati',
 			'Guru' => 'gurmukhi',
 			'Hanb' => 'han con bopomofo',
 			'Hang' => 'hangul',
 			'Hani' => 'han',
 			'Hans' => 'simplificate',
 			'Hans@alt=stand-alone' => 'han simplificate',
 			'Hant' => 'traditional',
 			'Hant@alt=stand-alone' => 'han traditional',
 			'Hebr' => 'hebraic',
 			'Hira' => 'hiragana',
 			'Hrkt' => 'syllabarios japonese',
 			'Jamo' => 'jamo',
 			'Jpan' => 'japonese',
 			'Kana' => 'katakana',
 			'Khmr' => 'khmer',
 			'Knda' => 'kannada',
 			'Kore' => 'corean',
 			'Laoo' => 'lao',
 			'Latn' => 'latin',
 			'Mlym' => 'malayalam',
 			'Mong' => 'mongol',
 			'Mymr' => 'birman',
 			'Orya' => 'orya',
 			'Sinh' => 'cingalese',
 			'Taml' => 'tamil',
 			'Telu' => 'telugu',
 			'Thaa' => 'thaana',
 			'Thai' => 'thailandese',
 			'Tibt' => 'tibetan',
 			'Zmth' => 'notation mathematic',
 			'Zsye' => 'emoji',
 			'Zsym' => 'symbolos',
 			'Zxxx' => 'non scripte',
 			'Zyyy' => 'commun',
 			'Zzzz' => 'scriptura incognite',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'Mundo',
 			'002' => 'Africa',
 			'003' => 'America del Nord',
 			'005' => 'America del Sud',
 			'009' => 'Oceania',
 			'011' => 'Africa occidental',
 			'013' => 'America central',
 			'014' => 'Africa oriental',
 			'015' => 'Africa septentrional',
 			'017' => 'Africa central',
 			'018' => 'Africa meridional',
 			'019' => 'Americas',
 			'021' => 'America septentrional',
 			'029' => 'Caribes',
 			'030' => 'Asia oriental',
 			'034' => 'Asia meridional',
 			'035' => 'Asia del sud-est',
 			'039' => 'Europa meridional',
 			'053' => 'Australasia',
 			'054' => 'Melanesia',
 			'057' => 'Region micronesian',
 			'061' => 'Polynesia',
 			'142' => 'Asia',
 			'143' => 'Asia central',
 			'145' => 'Asia occidental',
 			'150' => 'Europa',
 			'151' => 'Europa oriental',
 			'154' => 'Europa septentrional',
 			'155' => 'Europa occidental',
 			'202' => 'Africa subsaharian',
 			'419' => 'America latin',
 			'AC' => 'Insula del Ascension',
 			'AD' => 'Andorra',
 			'AE' => 'Emiratos Arabe Unite',
 			'AF' => 'Afghanistan',
 			'AG' => 'Antigua e Barbuda',
 			'AI' => 'Anguilla',
 			'AL' => 'Albania',
 			'AM' => 'Armenia',
 			'AO' => 'Angola',
 			'AQ' => 'Antarctica',
 			'AR' => 'Argentina',
 			'AS' => 'Samoa american',
 			'AT' => 'Austria',
 			'AU' => 'Australia',
 			'AW' => 'Aruba',
 			'AX' => 'Insulas Åland',
 			'AZ' => 'Azerbaidzhan',
 			'BA' => 'Bosnia e Herzegovina',
 			'BB' => 'Barbados',
 			'BD' => 'Bangladesh',
 			'BE' => 'Belgica',
 			'BF' => 'Burkina Faso',
 			'BG' => 'Bulgaria',
 			'BH' => 'Bahrain',
 			'BI' => 'Burundi',
 			'BJ' => 'Benin',
 			'BL' => 'Sancte Bartholomeo',
 			'BM' => 'Bermuda',
 			'BN' => 'Brunei',
 			'BO' => 'Bolivia',
 			'BQ' => 'Paises Basse caribe',
 			'BR' => 'Brasil',
 			'BS' => 'Bahamas',
 			'BT' => 'Bhutan',
 			'BV' => 'Insula de Bouvet',
 			'BW' => 'Botswana',
 			'BY' => 'Bielorussia',
 			'BZ' => 'Belize',
 			'CA' => 'Canada',
 			'CC' => 'Insulas Cocos (Keeling)',
 			'CD' => 'Congo - Kinshasa',
 			'CD@alt=variant' => 'Congo (RDC)',
 			'CF' => 'Republica African Central',
 			'CG' => 'Congo - Brazzaville',
 			'CG@alt=variant' => 'Congo (Republica)',
 			'CH' => 'Suissa',
 			'CI' => 'Costa de Ebore',
 			'CI@alt=variant' => 'Republica de Côte d’Ivoire',
 			'CK' => 'Insulas Cook',
 			'CL' => 'Chile',
 			'CM' => 'Camerun',
 			'CN' => 'China',
 			'CO' => 'Colombia',
 			'CP' => 'Insula Clipperton',
 			'CR' => 'Costa Rica',
 			'CU' => 'Cuba',
 			'CV' => 'Capo Verde',
 			'CW' => 'Curaçao',
 			'CX' => 'Insula de Natal',
 			'CY' => 'Cypro',
 			'CZ' => 'Chechia',
 			'CZ@alt=variant' => 'Republica Chec',
 			'DE' => 'Germania',
 			'DG' => 'Diego Garcia',
 			'DJ' => 'Djibuti',
 			'DK' => 'Danmark',
 			'DM' => 'Dominica',
 			'DO' => 'Republica Dominican',
 			'DZ' => 'Algeria',
 			'EA' => 'Ceuta e Melilla',
 			'EC' => 'Ecuador',
 			'EE' => 'Estonia',
 			'EG' => 'Egypto',
 			'EH' => 'Sahara occidental',
 			'ER' => 'Eritrea',
 			'ES' => 'Espania',
 			'ET' => 'Ethiopia',
 			'EU' => 'Union Europee',
 			'EZ' => 'Zona euro',
 			'FI' => 'Finlandia',
 			'FJ' => 'Fiji',
 			'FK' => 'Insulas Falkland',
 			'FK@alt=variant' => 'Insulas Falkland (Malvinas)',
 			'FM' => 'Micronesia',
 			'FO' => 'Insulas Feroe',
 			'FR' => 'Francia',
 			'GA' => 'Gabon',
 			'GB' => 'Regno Unite',
 			'GB@alt=short' => 'RU',
 			'GD' => 'Grenada',
 			'GE' => 'Georgia',
 			'GF' => 'Guyana francese',
 			'GG' => 'Guernsey',
 			'GH' => 'Ghana',
 			'GI' => 'Gibraltar',
 			'GL' => 'Groenlandia',
 			'GM' => 'Gambia',
 			'GN' => 'Guinea',
 			'GP' => 'Guadeloupe',
 			'GQ' => 'Guinea equatorial',
 			'GR' => 'Grecia',
 			'GS' => 'Georgia del Sud e Insulas Sandwich Austral',
 			'GT' => 'Guatemala',
 			'GU' => 'Guam',
 			'GW' => 'Guinea-Bissau',
 			'GY' => 'Guyana',
 			'HK' => 'Hongkong, R.A.S. de China',
 			'HK@alt=short' => 'Hongkong',
 			'HM' => 'Insulas Heard e McDonald',
 			'HN' => 'Honduras',
 			'HR' => 'Croatia',
 			'HT' => 'Haiti',
 			'HU' => 'Hungaria',
 			'IC' => 'Insulas Canari',
 			'ID' => 'Indonesia',
 			'IE' => 'Irlanda',
 			'IL' => 'Israel',
 			'IM' => 'Insula de Man',
 			'IN' => 'India',
 			'IO' => 'Territorio oceanic britanno-indian',
 			'IQ' => 'Irak',
 			'IR' => 'Iran',
 			'IS' => 'Islanda',
 			'IT' => 'Italia',
 			'JE' => 'Jersey',
 			'JM' => 'Jamaica',
 			'JO' => 'Jordania',
 			'JP' => 'Japon',
 			'KE' => 'Kenya',
 			'KG' => 'Kirghizistan',
 			'KH' => 'Cambodgia',
 			'KI' => 'Kiribati',
 			'KM' => 'Comoros',
 			'KN' => 'Sancte Christophoro e Nevis',
 			'KP' => 'Corea del Nord',
 			'KR' => 'Corea del Sud',
 			'KW' => 'Kuwait',
 			'KY' => 'Insulas de Caiman',
 			'KZ' => 'Kazakhstan',
 			'LA' => 'Laos',
 			'LB' => 'Libano',
 			'LC' => 'Sancte Lucia',
 			'LI' => 'Liechtenstein',
 			'LK' => 'Sri Lanka',
 			'LR' => 'Liberia',
 			'LS' => 'Lesotho',
 			'LT' => 'Lituania',
 			'LU' => 'Luxemburg',
 			'LV' => 'Lettonia',
 			'LY' => 'Libya',
 			'MA' => 'Marocco',
 			'MC' => 'Monaco',
 			'MD' => 'Moldavia',
 			'ME' => 'Montenegro',
 			'MF' => 'Sancte Martino francese',
 			'MG' => 'Madagascar',
 			'MH' => 'Insulas Marshall',
 			'MK' => 'Macedonia del Nord',
 			'ML' => 'Mali',
 			'MM' => 'Myanmar (Birmania)',
 			'MN' => 'Mongolia',
 			'MO' => 'Macao, R.A.S. de China',
 			'MO@alt=short' => 'Macao',
 			'MP' => 'Insulas Marianna del Nord',
 			'MQ' => 'Martinica',
 			'MR' => 'Mauritania',
 			'MS' => 'Montserrat',
 			'MT' => 'Malta',
 			'MU' => 'Mauritio',
 			'MV' => 'Maldivas',
 			'MW' => 'Malawi',
 			'MX' => 'Mexico',
 			'MY' => 'Malaysia',
 			'MZ' => 'Mozambique',
 			'NA' => 'Namibia',
 			'NC' => 'Nove Caledonia',
 			'NE' => 'Niger',
 			'NF' => 'Insula Norfolk',
 			'NG' => 'Nigeria',
 			'NI' => 'Nicaragua',
 			'NL' => 'Nederlandia',
 			'NO' => 'Norvegia',
 			'NP' => 'Nepal',
 			'NR' => 'Nauru',
 			'NU' => 'Niue',
 			'NZ' => 'Nove Zelanda',
 			'OM' => 'Oman',
 			'PA' => 'Panama',
 			'PE' => 'Peru',
 			'PF' => 'Polynesia francese',
 			'PG' => 'Papua Nove Guinea',
 			'PH' => 'Philippinas',
 			'PK' => 'Pakistan',
 			'PL' => 'Polonia',
 			'PM' => 'St. Pierre e Miquelon',
 			'PN' => 'Insulas Pitcairn',
 			'PR' => 'Porto Rico',
 			'PS' => 'Territorios palestin',
 			'PS@alt=short' => 'Palestina',
 			'PT' => 'Portugal',
 			'PW' => 'Palau',
 			'PY' => 'Paraguay',
 			'QA' => 'Qatar',
 			'QO' => 'Oceania remote',
 			'RE' => 'Reunion',
 			'RO' => 'Romania',
 			'RS' => 'Serbia',
 			'RU' => 'Russia',
 			'RW' => 'Ruanda',
 			'SA' => 'Arabia Saudita',
 			'SB' => 'Insulas Solomon',
 			'SC' => 'Seychelles',
 			'SD' => 'Sudan',
 			'SE' => 'Svedia',
 			'SG' => 'Singapur',
 			'SH' => 'Sancte Helena',
 			'SI' => 'Slovenia',
 			'SJ' => 'Svalbard e Jan Mayen',
 			'SK' => 'Slovachia',
 			'SL' => 'Sierra Leone',
 			'SM' => 'San Marino',
 			'SN' => 'Senegal',
 			'SO' => 'Somalia',
 			'SR' => 'Suriname',
 			'SS' => 'Sudan del Sud',
 			'ST' => 'São Tomé e Príncipe',
 			'SV' => 'El Salvador',
 			'SX' => 'Sancte Martino nederlandese',
 			'SY' => 'Syria',
 			'SZ' => 'Eswatini',
 			'SZ@alt=variant' => 'Swazilandia',
 			'TA' => 'Tristan da Cunha',
 			'TC' => 'Insulas Turcos e Caicos',
 			'TD' => 'Tchad',
 			'TF' => 'Territorios meridional francese',
 			'TG' => 'Togo',
 			'TH' => 'Thailandia',
 			'TJ' => 'Tadzhikistan',
 			'TK' => 'Tokelau',
 			'TL' => 'Timor del Est',
 			'TM' => 'Turkmenistan',
 			'TN' => 'Tunisia',
 			'TO' => 'Tonga',
 			'TR' => 'Turchia',
 			'TT' => 'Trinidad e Tobago',
 			'TV' => 'Tuvalu',
 			'TW' => 'Taiwan',
 			'TZ' => 'Tanzania',
 			'UA' => 'Ukraina',
 			'UG' => 'Uganda',
 			'UM' => 'Insulas peripheric del SUA',
 			'UN' => 'Nationes Unite',
 			'US' => 'Statos Unite',
 			'US@alt=short' => 'SUA',
 			'UY' => 'Uruguay',
 			'UZ' => 'Uzbekistan',
 			'VA' => 'Citate del Vaticano',
 			'VC' => 'Sancte Vincente e le Grenadinas',
 			'VE' => 'Venezuela',
 			'VG' => 'Insulas Virgine britannic',
 			'VI' => 'Insulas Virgine statounitese',
 			'VN' => 'Vietnam',
 			'VU' => 'Vanuatu',
 			'WF' => 'Wallis e Futuna',
 			'WS' => 'Samoa',
 			'XA' => 'Pseudo-accentos',
 			'XB' => 'Pseudo-bidi',
 			'XK' => 'Kosovo',
 			'YE' => 'Yemen',
 			'YT' => 'Mayotte',
 			'ZA' => 'Africa del Sud',
 			'ZM' => 'Zambia',
 			'ZW' => 'Zimbabwe',
 			'ZZ' => 'Region incognite',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'calendario',
 			'cf' => 'formato de moneta',
 			'collation' => 'ordinamento',
 			'currency' => 'moneta',
 			'hc' => 'cyclo horari (12 o 24)',
 			'lb' => 'stilo de salto de linea',
 			'ms' => 'systema de mesura',
 			'numbers' => 'numeros',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{calendario buddhista},
 				'chinese' => q{calendario chinese},
 				'dangi' => q{calendario dangi},
 				'ethiopic' => q{calendario ethiope},
 				'gregorian' => q{calendario gregorian},
 				'hebrew' => q{calendario hebraic},
 				'islamic' => q{calendario islamic},
 				'iso8601' => q{calendario ISO-8601},
 				'japanese' => q{calendario japonese},
 				'persian' => q{calendario persa},
 				'roc' => q{calendario del Republica de China},
 			},
 			'cf' => {
 				'account' => q{formato de moneta pro contabilitate},
 				'standard' => q{formato de moneta standard},
 			},
 			'collation' => {
 				'ducet' => q{ordinamento Unicode predefinite},
 				'search' => q{recerca generic},
 				'standard' => q{ordinamento standard},
 			},
 			'hc' => {
 				'h11' => q{systema de 12 horas (0–11)},
 				'h12' => q{systema de 12 horas (1–12)},
 				'h23' => q{systema de 24 horas (0–23)},
 				'h24' => q{systema de 24 horas (1–24)},
 			},
 			'lb' => {
 				'loose' => q{stilo de salto de linea flexibile},
 				'normal' => q{stilo de salto de linea normal},
 				'strict' => q{stilo de salto de linea stricte},
 			},
 			'ms' => {
 				'metric' => q{systema metric},
 				'uksystem' => q{systema de mesura imperial},
 				'ussystem' => q{systema de mesura statounitese},
 			},
 			'numbers' => {
 				'arab' => q{cifras indo-arabe},
 				'arabext' => q{cifras indo-arabe extendite},
 				'armn' => q{cifras armenie},
 				'armnlow' => q{cifras armenie minuscule},
 				'beng' => q{cifras bengalese},
 				'deva' => q{cifras devanagari},
 				'ethi' => q{cifras ethiope},
 				'fullwide' => q{cifras a latitude integre},
 				'geor' => q{cifras georgian},
 				'grek' => q{cifras grec},
 				'greklow' => q{cifras grec minuscule},
 				'gujr' => q{cifras gujarati},
 				'guru' => q{cifras gurmukhi},
 				'hanidec' => q{cifras decimal chinese},
 				'hans' => q{cifras chinese simplificate},
 				'hansfin' => q{cifras financiari chinese simplificate},
 				'hant' => q{cifras chinese traditional},
 				'hantfin' => q{cifras financiari chinese traditional},
 				'hebr' => q{cifras hebraic},
 				'jpan' => q{cifras japonese},
 				'jpanfin' => q{cifras financiari japonese},
 				'khmr' => q{cifras khmer},
 				'knda' => q{cifras kannada},
 				'laoo' => q{cifras lao},
 				'latn' => q{cifras occidental},
 				'mlym' => q{cifras malayalam},
 				'mymr' => q{cifras birman},
 				'orya' => q{cifras oriya},
 				'roman' => q{cifras roman},
 				'romanlow' => q{cifras roman minuscule},
 				'taml' => q{cifras tamil traditional},
 				'tamldec' => q{cifras tamil},
 				'telu' => q{cifras telugu},
 				'thai' => q{cifras thailandese},
 				'tibt' => q{cifras tibetan},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{metric},
 			'UK' => q{britannic},
 			'US' => q{statounitese},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Lingua: {0}',
 			'script' => 'Scriptura: {0}',
 			'region' => 'Region: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[á à ă â å ä ã ā æ ç é è ĕ ê ë ē í ì ĭ î ï ī ñ ó ò ŏ ô ö ø ō œ ú ù ŭ û ü ū ÿ]},
			index => ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'],
			main => qr{[a b c d e f g h i j k l m n o p q r s t u v w x y z]},
			punctuation => qr{[\- ‐ ‑ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'hh:mm',
				hms => 'hh:mm:ss',
				ms => 'mm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(direction cardinal),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(direction cardinal),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(deci{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(deci{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(pico{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(pico{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(centi{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(centi{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(milli{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(milli{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(micro{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(micro{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(nano{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(nano{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(tera{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(tera{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(peta{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(peta{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(hecto{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(hecto{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(kilo{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(kilo{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(mega{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(mega{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(giga{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(giga{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(fortia g),
						'one' => q({0} fortia g),
						'other' => q({0} fortia g),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(fortia g),
						'one' => q({0} fortia g),
						'other' => q({0} fortia g),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(metros per secunda quadrate),
						'one' => q({0} metro per secunda quadrate),
						'other' => q({0} metros per secunda quadrate),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(metros per secunda quadrate),
						'one' => q({0} metro per secunda quadrate),
						'other' => q({0} metros per secunda quadrate),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(minutas de arco),
						'one' => q({0} minuta de arco),
						'other' => q({0} minutas de arco),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(minutas de arco),
						'one' => q({0} minuta de arco),
						'other' => q({0} minutas de arco),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(secundas de arco),
						'one' => q({0} secunda de arco),
						'other' => q({0} secundas de arco),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(secundas de arco),
						'one' => q({0} secunda de arco),
						'other' => q({0} secundas de arco),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(grados),
						'one' => q({0} grado),
						'other' => q({0} grados),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(grados),
						'one' => q({0} grado),
						'other' => q({0} grados),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(radianos),
						'one' => q({0} radiano),
						'other' => q({0} radianos),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(radianos),
						'one' => q({0} radiano),
						'other' => q({0} radianos),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(revolutiones),
						'one' => q({0} revolution),
						'other' => q({0} revolutiones),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(revolutiones),
						'one' => q({0} revolution),
						'other' => q({0} revolutiones),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(acres),
						'one' => q({0} acre),
						'other' => q({0} acres),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(acres),
						'one' => q({0} acre),
						'other' => q({0} acres),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(hectares),
						'one' => q({0} hectare),
						'other' => q({0} hectares),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(hectares),
						'one' => q({0} hectare),
						'other' => q({0} hectares),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(centimetros quadrate),
						'one' => q({0} centimetro quadrate),
						'other' => q({0} centimetros quadrate),
						'per' => q({0} per centimetro quadrate),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(centimetros quadrate),
						'one' => q({0} centimetro quadrate),
						'other' => q({0} centimetros quadrate),
						'per' => q({0} per centimetro quadrate),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(pedes quadrate),
						'one' => q({0} pede quadrate),
						'other' => q({0} pedes quadrate),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(pedes quadrate),
						'one' => q({0} pede quadrate),
						'other' => q({0} pedes quadrate),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(pollices quadrate),
						'one' => q({0} pollice quadrate),
						'other' => q({0} pollices quadrate),
						'per' => q({0} per pollice quadrate),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(pollices quadrate),
						'one' => q({0} pollice quadrate),
						'other' => q({0} pollices quadrate),
						'per' => q({0} per pollice quadrate),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(kilometros quadrate),
						'one' => q({0} kilometro quadrate),
						'other' => q({0} kilometros quadrate),
						'per' => q({0} per kilometro quadrate),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(kilometros quadrate),
						'one' => q({0} kilometro quadrate),
						'other' => q({0} kilometros quadrate),
						'per' => q({0} per kilometro quadrate),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(metros quadrate),
						'one' => q({0} metro quadrate),
						'other' => q({0} metros quadrate),
						'per' => q({0} per metro quadrate),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(metros quadrate),
						'one' => q({0} metro quadrate),
						'other' => q({0} metros quadrate),
						'per' => q({0} per metro quadrate),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(millias quadrate),
						'one' => q({0} millia quadrate),
						'other' => q({0} millias quadrate),
						'per' => q({0} per millia quadrate),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(millias quadrate),
						'one' => q({0} millia quadrate),
						'other' => q({0} millias quadrate),
						'per' => q({0} per millia quadrate),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yards quadrate),
						'one' => q({0} yard quadrate),
						'other' => q({0} yards quadrate),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yards quadrate),
						'one' => q({0} yard quadrate),
						'other' => q({0} yards quadrate),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(carates),
						'one' => q({0} carat),
						'other' => q({0} carates),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(carates),
						'one' => q({0} carat),
						'other' => q({0} carates),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(milligrammas per decilitro),
						'one' => q({0} milligramma per decilitro),
						'other' => q({0} milligrammas per decilitro),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(milligrammas per decilitro),
						'one' => q({0} milligramma per decilitro),
						'other' => q({0} milligrammas per decilitro),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(millimoles per litro),
						'one' => q({0} millimol per litro),
						'other' => q({0} millimoles per litro),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(millimoles per litro),
						'one' => q({0} millimol per litro),
						'other' => q({0} millimoles per litro),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(per cento),
						'one' => q({0} per cento),
						'other' => q({0} per cento),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(per cento),
						'one' => q({0} per cento),
						'other' => q({0} per cento),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(per mille),
						'one' => q({0} per mille),
						'other' => q({0} per mille),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(per mille),
						'one' => q({0} per mille),
						'other' => q({0} per mille),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(partes per million),
						'one' => q({0} parte per million),
						'other' => q({0} partes per million),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(partes per million),
						'one' => q({0} parte per million),
						'other' => q({0} partes per million),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(litros per 100 kilometros),
						'one' => q({0} litro per 100 kilometros),
						'other' => q({0} litros per 100 kilometros),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(litros per 100 kilometros),
						'one' => q({0} litro per 100 kilometros),
						'other' => q({0} litros per 100 kilometros),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(litros per kilometro),
						'one' => q({0} litro per kilometro),
						'other' => q({0} litros per kilometro),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(litros per kilometro),
						'one' => q({0} litro per kilometro),
						'other' => q({0} litros per kilometro),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(millias per gallon),
						'one' => q({0} millia per gallon),
						'other' => q({0} millias per gallon),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(millias per gallon),
						'one' => q({0} millia per gallon),
						'other' => q({0} millias per gallon),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(millias per gallon imperial),
						'one' => q({0} millia per gallon imperial),
						'other' => q({0} millias per gallon imperial),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(millias per gallon imperial),
						'one' => q({0} millia per gallon imperial),
						'other' => q({0} millias per gallon imperial),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} est),
						'north' => q({0} nord),
						'south' => q({0} sud),
						'west' => q({0} west),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} est),
						'north' => q({0} nord),
						'south' => q({0} sud),
						'west' => q({0} west),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(bits),
						'one' => q({0} bit),
						'other' => q({0} bits),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(bits),
						'one' => q({0} bit),
						'other' => q({0} bits),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(bytes),
						'one' => q({0} byte),
						'other' => q({0} bytes),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(bytes),
						'one' => q({0} byte),
						'other' => q({0} bytes),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(gigabits),
						'one' => q({0} gigabit),
						'other' => q({0} gigabits),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(gigabits),
						'one' => q({0} gigabit),
						'other' => q({0} gigabits),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(gigabytes),
						'one' => q({0} gigabyte),
						'other' => q({0} gigabytes),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(gigabytes),
						'one' => q({0} gigabyte),
						'other' => q({0} gigabytes),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kilobits),
						'one' => q({0} kilobit),
						'other' => q({0} kilobits),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kilobits),
						'one' => q({0} kilobit),
						'other' => q({0} kilobits),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kilobytes),
						'one' => q({0} kilobyte),
						'other' => q({0} kilobytes),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kilobytes),
						'one' => q({0} kilobyte),
						'other' => q({0} kilobytes),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(megabits),
						'one' => q({0} megabit),
						'other' => q({0} megabits),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(megabits),
						'one' => q({0} megabit),
						'other' => q({0} megabits),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(megabytes),
						'one' => q({0} megabyte),
						'other' => q({0} megabytes),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(megabytes),
						'one' => q({0} megabyte),
						'other' => q({0} megabytes),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(petabytes),
						'one' => q({0} petabyte),
						'other' => q({0} petabytes),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(petabytes),
						'one' => q({0} petabyte),
						'other' => q({0} petabytes),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(terabits),
						'one' => q({0} terabit),
						'other' => q({0} terabits),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(terabits),
						'one' => q({0} terabit),
						'other' => q({0} terabits),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(terabytes),
						'one' => q({0} terabyte),
						'other' => q({0} terabytes),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(terabytes),
						'one' => q({0} terabyte),
						'other' => q({0} terabytes),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(seculos),
						'one' => q({0} seculo),
						'other' => q({0} seculos),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(seculos),
						'one' => q({0} seculo),
						'other' => q({0} seculos),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(dies),
						'one' => q({0} die),
						'other' => q({0} dies),
						'per' => q({0} per die),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(dies),
						'one' => q({0} die),
						'other' => q({0} dies),
						'per' => q({0} per die),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(horas),
						'one' => q({0} hora),
						'other' => q({0} horas),
						'per' => q({0} per hora),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(horas),
						'one' => q({0} hora),
						'other' => q({0} horas),
						'per' => q({0} per hora),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(microsecundas),
						'one' => q({0} microsecunda),
						'other' => q({0} microsecundas),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(microsecundas),
						'one' => q({0} microsecunda),
						'other' => q({0} microsecundas),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(millisecundas),
						'one' => q({0} millisecunda),
						'other' => q({0} millisecundas),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(millisecundas),
						'one' => q({0} millisecunda),
						'other' => q({0} millisecundas),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(minutas),
						'one' => q({0} minuta),
						'other' => q({0} minutas),
						'per' => q({0} per minuta),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(minutas),
						'one' => q({0} minuta),
						'other' => q({0} minutas),
						'per' => q({0} per minuta),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(menses),
						'one' => q({0} mense),
						'other' => q({0} menses),
						'per' => q({0} per mense),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(menses),
						'one' => q({0} mense),
						'other' => q({0} menses),
						'per' => q({0} per mense),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(nanosecundas),
						'one' => q({0} nanosecunda),
						'other' => q({0} nanosecundas),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(nanosecundas),
						'one' => q({0} nanosecunda),
						'other' => q({0} nanosecundas),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(secundas),
						'one' => q({0} secunda),
						'other' => q({0} secundas),
						'per' => q({0} per secunda),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(secundas),
						'one' => q({0} secunda),
						'other' => q({0} secundas),
						'per' => q({0} per secunda),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(septimanas),
						'one' => q({0} septimana),
						'other' => q({0} septimanas),
						'per' => q({0} per septimana),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(septimanas),
						'one' => q({0} septimana),
						'other' => q({0} septimanas),
						'per' => q({0} per septimana),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(annos),
						'one' => q({0} anno),
						'other' => q({0} annos),
						'per' => q({0} per anno),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(annos),
						'one' => q({0} anno),
						'other' => q({0} annos),
						'per' => q({0} per anno),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(amperes),
						'one' => q({0} ampere),
						'other' => q({0} amperes),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(amperes),
						'one' => q({0} ampere),
						'other' => q({0} amperes),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(milliamperes),
						'one' => q({0} milliampere),
						'other' => q({0} milliamperes),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(milliamperes),
						'one' => q({0} milliampere),
						'other' => q({0} milliamperes),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ohms),
						'one' => q({0} ohm),
						'other' => q({0} ohms),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ohms),
						'one' => q({0} ohm),
						'other' => q({0} ohms),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(volts),
						'one' => q({0} volt),
						'other' => q({0} volts),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(volts),
						'one' => q({0} volt),
						'other' => q({0} volts),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(calorias),
						'one' => q({0} caloria),
						'other' => q({0} calorias),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(calorias),
						'one' => q({0} caloria),
						'other' => q({0} calorias),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(kilocalorias),
						'one' => q({0} kilocaloria),
						'other' => q({0} kilocalorias),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(kilocalorias),
						'one' => q({0} kilocaloria),
						'other' => q({0} kilocalorias),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(joules),
						'one' => q({0} joule),
						'other' => q({0} joules),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(joules),
						'one' => q({0} joule),
						'other' => q({0} joules),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(kilocalorias),
						'one' => q({0} kilocaloria),
						'other' => q({0} kilocalorias),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(kilocalorias),
						'one' => q({0} kilocaloria),
						'other' => q({0} kilocalorias),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(kilojoules),
						'one' => q({0} kilojoule),
						'other' => q({0} kilojoules),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(kilojoules),
						'one' => q({0} kilojoule),
						'other' => q({0} kilojoules),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kilowatthoras),
						'one' => q({0} kilowatthora),
						'other' => q({0} kilowatthoras),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kilowatthoras),
						'one' => q({0} kilowatthora),
						'other' => q({0} kilowatthoras),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(gigahertz),
						'one' => q({0} gigahertz),
						'other' => q({0} gigahertz),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(gigahertz),
						'one' => q({0} gigahertz),
						'other' => q({0} gigahertz),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(hertz),
						'one' => q({0} hertz),
						'other' => q({0} hertz),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(hertz),
						'one' => q({0} hertz),
						'other' => q({0} hertz),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(kilohertz),
						'one' => q({0} kilohertz),
						'other' => q({0} kilohertz),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(kilohertz),
						'one' => q({0} kilohertz),
						'other' => q({0} kilohertz),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(megahertz),
						'one' => q({0} megahertz),
						'other' => q({0} megahertz),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(megahertz),
						'one' => q({0} megahertz),
						'other' => q({0} megahertz),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(unitates astronomic),
						'one' => q({0} unitate astronomic),
						'other' => q({0} unitates astronomic),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(unitates astronomic),
						'one' => q({0} unitate astronomic),
						'other' => q({0} unitates astronomic),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(centimetros),
						'one' => q({0} centimetro),
						'other' => q({0} centimetros),
						'per' => q({0} per centimetro),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(centimetros),
						'one' => q({0} centimetro),
						'other' => q({0} centimetros),
						'per' => q({0} per centimetro),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(decimetros),
						'one' => q({0} decimetro),
						'other' => q({0} decimetros),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(decimetros),
						'one' => q({0} decimetro),
						'other' => q({0} decimetros),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(pedes),
						'one' => q({0} pede),
						'other' => q({0} pedes),
						'per' => q({0} per pede),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(pedes),
						'one' => q({0} pede),
						'other' => q({0} pedes),
						'per' => q({0} per pede),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(pollices),
						'one' => q({0} pollice),
						'other' => q({0} pollices),
						'per' => q({0} per pollice),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(pollices),
						'one' => q({0} pollice),
						'other' => q({0} pollices),
						'per' => q({0} per pollice),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(kilometros),
						'one' => q({0} kilometro),
						'other' => q({0} kilometros),
						'per' => q({0} per kilometro),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(kilometros),
						'one' => q({0} kilometro),
						'other' => q({0} kilometros),
						'per' => q({0} per kilometro),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(annos lumine),
						'one' => q({0} anno lumine),
						'other' => q({0} annos lumine),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(annos lumine),
						'one' => q({0} anno lumine),
						'other' => q({0} annos lumine),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(metros),
						'one' => q({0} metro),
						'other' => q({0} metros),
						'per' => q({0} per metro),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(metros),
						'one' => q({0} metro),
						'other' => q({0} metros),
						'per' => q({0} per metro),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(micrometros),
						'one' => q({0} micrometro),
						'other' => q({0} micrometros),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(micrometros),
						'one' => q({0} micrometro),
						'other' => q({0} micrometros),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(millias),
						'one' => q({0} millia),
						'other' => q({0} millias),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(millias),
						'one' => q({0} millia),
						'other' => q({0} millias),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(millias scandinave),
						'one' => q({0} millia scandinave),
						'other' => q({0} millias scandinave),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(millias scandinave),
						'one' => q({0} millia scandinave),
						'other' => q({0} millias scandinave),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(millimetros),
						'one' => q({0} millimetro),
						'other' => q({0} millimetros),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(millimetros),
						'one' => q({0} millimetro),
						'other' => q({0} millimetros),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(nanometros),
						'one' => q({0} nanometro),
						'other' => q({0} nanometros),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(nanometros),
						'one' => q({0} nanometro),
						'other' => q({0} nanometros),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(millias nautic),
						'one' => q({0} millia nautic),
						'other' => q({0} millias nautic),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(millias nautic),
						'one' => q({0} millia nautic),
						'other' => q({0} millias nautic),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(parsecs),
						'one' => q({0} parsec),
						'other' => q({0} parsecs),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(parsecs),
						'one' => q({0} parsec),
						'other' => q({0} parsecs),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(picometros),
						'one' => q({0} picometro),
						'other' => q({0} picometros),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(picometros),
						'one' => q({0} picometro),
						'other' => q({0} picometros),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(punctos),
						'one' => q({0} puncto),
						'other' => q({0} punctos),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(punctos),
						'one' => q({0} puncto),
						'other' => q({0} punctos),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(yards),
						'one' => q({0} yard),
						'other' => q({0} yards),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(yards),
						'one' => q({0} yard),
						'other' => q({0} yards),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lux),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lux),
						'one' => q({0} lux),
						'other' => q({0} lux),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(carates),
						'one' => q({0} carat),
						'other' => q({0} carates),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(carates),
						'one' => q({0} carat),
						'other' => q({0} carates),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(grammas),
						'one' => q({0} gramma),
						'other' => q({0} grammas),
						'per' => q({0} per gramma),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(grammas),
						'one' => q({0} gramma),
						'other' => q({0} grammas),
						'per' => q({0} per gramma),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kilogrammas),
						'one' => q({0} kilogramma),
						'other' => q({0} kilogrammas),
						'per' => q({0} per kilogramma),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kilogrammas),
						'one' => q({0} kilogramma),
						'other' => q({0} kilogrammas),
						'per' => q({0} per kilogramma),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(tonnas),
						'one' => q({0} tonna),
						'other' => q({0} tonnas),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(tonnas),
						'one' => q({0} tonna),
						'other' => q({0} tonnas),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(microgrammas),
						'one' => q({0} microgramma),
						'other' => q({0} microgrammas),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(microgrammas),
						'one' => q({0} microgramma),
						'other' => q({0} microgrammas),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(milligrammas),
						'one' => q({0} milligramma),
						'other' => q({0} milligrammas),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(milligrammas),
						'one' => q({0} milligramma),
						'other' => q({0} milligrammas),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(uncias),
						'one' => q({0} uncia),
						'other' => q({0} uncias),
						'per' => q({0} per uncia),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(uncias),
						'one' => q({0} uncia),
						'other' => q({0} uncias),
						'per' => q({0} per uncia),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(uncias troy),
						'one' => q({0} uncia troy),
						'other' => q({0} uncias troy),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(uncias troy),
						'one' => q({0} uncia troy),
						'other' => q({0} uncias troy),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(libras),
						'one' => q({0} libra),
						'other' => q({0} libras),
						'per' => q({0} per libra),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(libras),
						'one' => q({0} libra),
						'other' => q({0} libras),
						'per' => q({0} per libra),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(tonnas curte),
						'one' => q({0} tonna curte),
						'other' => q({0} tonnas curte),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(tonnas curte),
						'one' => q({0} tonna curte),
						'other' => q({0} tonnas curte),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} per {1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} per {1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(gigawatts),
						'one' => q({0} gigawatt),
						'other' => q({0} gigawatts),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(gigawatts),
						'one' => q({0} gigawatt),
						'other' => q({0} gigawatts),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(cavallos-vapor),
						'one' => q({0} cavallo-vapor),
						'other' => q({0} cavallos-vapor),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(cavallos-vapor),
						'one' => q({0} cavallo-vapor),
						'other' => q({0} cavallos-vapor),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(kilowatts),
						'one' => q({0} kilowatt),
						'other' => q({0} kilowatts),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(kilowatts),
						'one' => q({0} kilowatt),
						'other' => q({0} kilowatts),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(megawatts),
						'one' => q({0} megawatt),
						'other' => q({0} megawatts),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(megawatts),
						'one' => q({0} megawatt),
						'other' => q({0} megawatts),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(milliwatts),
						'one' => q({0} milliwatt),
						'other' => q({0} milliwatts),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(milliwatts),
						'one' => q({0} milliwatt),
						'other' => q({0} milliwatts),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(watts),
						'one' => q({0} watt),
						'other' => q({0} watts),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(watts),
						'one' => q({0} watt),
						'other' => q({0} watts),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q({0} quadrate),
						'other' => q({0} quadrate),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q({0} quadrate),
						'other' => q({0} quadrate),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q({0} cubic),
						'other' => q({0} cubic),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q({0} cubic),
						'other' => q({0} cubic),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(atmospheras),
						'one' => q({0} atmosphera),
						'other' => q({0} atmospheras),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(atmospheras),
						'one' => q({0} atmosphera),
						'other' => q({0} atmospheras),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hectopascales),
						'one' => q({0} hectopascal),
						'other' => q({0} hectopascales),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hectopascales),
						'one' => q({0} hectopascal),
						'other' => q({0} hectopascales),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(pollices de mercurio),
						'one' => q({0} pollice de mercurio),
						'other' => q({0} pollices de mercurio),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(pollices de mercurio),
						'one' => q({0} pollice de mercurio),
						'other' => q({0} pollices de mercurio),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(millibares),
						'one' => q({0} millibar),
						'other' => q({0} millibares),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(millibares),
						'one' => q({0} millibar),
						'other' => q({0} millibares),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(milimetros de mercurio),
						'one' => q({0} millimetro de mercurio),
						'other' => q({0} millimetros de mercurio),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(milimetros de mercurio),
						'one' => q({0} millimetro de mercurio),
						'other' => q({0} millimetros de mercurio),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(libras-fortia per pollice quadrate),
						'one' => q({0} libra-fortia per pollice quadrate),
						'other' => q({0} libras-fortia per pollice quadrate),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(libras-fortia per pollice quadrate),
						'one' => q({0} libra-fortia per pollice quadrate),
						'other' => q({0} libras-fortia per pollice quadrate),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(kilometros per hora),
						'one' => q({0} kilometro per hora),
						'other' => q({0} kilometros per hora),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(kilometros per hora),
						'one' => q({0} kilometro per hora),
						'other' => q({0} kilometros per hora),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(nodos),
						'one' => q({0} nodo),
						'other' => q({0} nodos),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(nodos),
						'one' => q({0} nodo),
						'other' => q({0} nodos),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(metros per secunda),
						'one' => q({0} metro per secunda),
						'other' => q({0} metros per secunda),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(metros per secunda),
						'one' => q({0} metro per secunda),
						'other' => q({0} metros per secunda),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(millias per hora),
						'one' => q({0} millia per hora),
						'other' => q({0} millias per hora),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(millias per hora),
						'one' => q({0} millia per hora),
						'other' => q({0} millias per hora),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(grados Celcius),
						'one' => q({0} grado Celcius),
						'other' => q({0} grados Celcius),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(grados Celcius),
						'one' => q({0} grado Celcius),
						'other' => q({0} grados Celcius),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(grados Fahrenheit),
						'one' => q({0} grado Fahrenheit),
						'other' => q({0} grados Fahrenheit),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(grados Fahrenheit),
						'one' => q({0} grado Fahrenheit),
						'other' => q({0} grados Fahrenheit),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(grados),
						'one' => q({0} grado),
						'other' => q({0} grados),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(grados),
						'one' => q({0} grado),
						'other' => q({0} grados),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(kelvin),
						'one' => q({0} kelvin),
						'other' => q({0} kelvin),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(kelvin),
						'one' => q({0} kelvin),
						'other' => q({0} kelvin),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(acre-pedes),
						'one' => q({0} acre-pede),
						'other' => q({0} acre-pedes),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(acre-pedes),
						'one' => q({0} acre-pede),
						'other' => q({0} acre-pedes),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(barriles),
						'one' => q({0} barriles),
						'other' => q({0} barriles),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(barriles),
						'one' => q({0} barriles),
						'other' => q({0} barriles),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(bushels),
						'one' => q({0} bushel),
						'other' => q({0} bushels),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(bushels),
						'one' => q({0} bushel),
						'other' => q({0} bushels),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(centilitros),
						'one' => q({0} centilitro),
						'other' => q({0} centilitros),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(centilitros),
						'one' => q({0} centilitro),
						'other' => q({0} centilitros),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(centimetros cubic),
						'one' => q({0} centimetro cubic),
						'other' => q({0} centimetros cubic),
						'per' => q({0} per centimetro cubic),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(centimetros cubic),
						'one' => q({0} centimetro cubic),
						'other' => q({0} centimetros cubic),
						'per' => q({0} per centimetro cubic),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(pedes cubic),
						'one' => q({0} pede cubic),
						'other' => q({0} pedes cubic),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(pedes cubic),
						'one' => q({0} pede cubic),
						'other' => q({0} pedes cubic),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(inches cubic),
						'one' => q({0} inch cubic),
						'other' => q({0} inches cubic),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(inches cubic),
						'one' => q({0} inch cubic),
						'other' => q({0} inches cubic),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(kilometros cubic),
						'one' => q({0} kilometro cubic),
						'other' => q({0} kilometros cubic),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(kilometros cubic),
						'one' => q({0} kilometro cubic),
						'other' => q({0} kilometros cubic),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(metros cubic),
						'one' => q({0} metro cubic),
						'other' => q({0} metros cubic),
						'per' => q({0} per metro cubic),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(metros cubic),
						'one' => q({0} metro cubic),
						'other' => q({0} metros cubic),
						'per' => q({0} per metro cubic),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(millias cubic),
						'one' => q({0} millia cubic),
						'other' => q({0} millias cubic),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(millias cubic),
						'one' => q({0} millia cubic),
						'other' => q({0} millias cubic),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yards cubic),
						'one' => q({0} yard cubic),
						'other' => q({0} yards cubic),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yards cubic),
						'one' => q({0} yard cubic),
						'other' => q({0} yards cubic),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(tassas),
						'one' => q({0} tassa),
						'other' => q({0} tassas),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(tassas),
						'one' => q({0} tassa),
						'other' => q({0} tassas),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(tassas metric),
						'one' => q({0} tassa metric),
						'other' => q({0} tassas metric),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(tassas metric),
						'one' => q({0} tassa metric),
						'other' => q({0} tassas metric),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(decilitros),
						'one' => q({0} decilitro),
						'other' => q({0} decilitros),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(decilitros),
						'one' => q({0} decilitro),
						'other' => q({0} decilitros),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(coclearatas a dessert),
						'one' => q({0} coclearata a dessert),
						'other' => q({0} coclearatas a dessert),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(coclearatas a dessert),
						'one' => q({0} coclearata a dessert),
						'other' => q({0} coclearatas a dessert),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(coclearatas a dessert imperial),
						'one' => q({0} coclearata a dessert imperial),
						'other' => q({0} coclearatas a dessert imperial),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(coclearatas a dessert imperial),
						'one' => q({0} coclearata a dessert imperial),
						'other' => q({0} coclearatas a dessert imperial),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(drachmas liquide),
						'one' => q({0} drachma liquide),
						'other' => q({0} drachmas liquide),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(drachmas liquide),
						'one' => q({0} drachma liquide),
						'other' => q({0} drachmas liquide),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(guttas),
						'one' => q({0} gutta),
						'other' => q({0} guttas),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(guttas),
						'one' => q({0} gutta),
						'other' => q({0} guttas),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(uncias liquide),
						'one' => q({0} uncia liquide),
						'other' => q({0} uncias liquide),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(uncias liquide),
						'one' => q({0} uncia liquide),
						'other' => q({0} uncias liquide),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(uncias liquide imperial),
						'one' => q({0} uncia liquide imperial),
						'other' => q({0} uncias liquide imperial),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(uncias liquide imperial),
						'one' => q({0} uncia liquide imperial),
						'other' => q({0} uncias liquide imperial),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gallones),
						'one' => q({0} gallon),
						'other' => q({0} gallones),
						'per' => q({0} per gallon),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gallones),
						'one' => q({0} gallon),
						'other' => q({0} gallones),
						'per' => q({0} per gallon),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(gallones imp.),
						'one' => q({0} gallon imp.),
						'other' => q({0} gallones imp.),
						'per' => q({0} per gallon imp.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(gallones imp.),
						'one' => q({0} gallon imp.),
						'other' => q({0} gallones imp.),
						'per' => q({0} per gallon imp.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hectolitros),
						'one' => q({0} hectolitro),
						'other' => q({0} hectolitros),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hectolitros),
						'one' => q({0} hectolitro),
						'other' => q({0} hectolitros),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(litros),
						'one' => q({0} litro),
						'other' => q({0} litros),
						'per' => q({0} per litro),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(litros),
						'one' => q({0} litro),
						'other' => q({0} litros),
						'per' => q({0} per litro),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(megalitros),
						'one' => q({0} megalitro),
						'other' => q({0} megalitros),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(megalitros),
						'one' => q({0} megalitro),
						'other' => q({0} megalitros),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(millilitros),
						'one' => q({0} millilitro),
						'other' => q({0} millilitros),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(millilitros),
						'one' => q({0} millilitro),
						'other' => q({0} millilitros),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(pinciatas),
						'one' => q({0} pinciata),
						'other' => q({0} pinciatas),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(pinciatas),
						'one' => q({0} pinciata),
						'other' => q({0} pinciatas),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pintas),
						'one' => q({0} pinta),
						'other' => q({0} pintas),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pintas),
						'one' => q({0} pinta),
						'other' => q({0} pintas),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(pintas metric),
						'one' => q({0} pinta metric),
						'other' => q({0} pintas metric),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(pintas metric),
						'one' => q({0} pinta metric),
						'other' => q({0} pintas metric),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(quartos),
						'one' => q({0} quarto),
						'other' => q({0} quartos),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(quartos),
						'one' => q({0} quarto),
						'other' => q({0} quartos),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(coclearatas a suppa),
						'one' => q({0} coclearata a suppa),
						'other' => q({0} coclearatas a suppa),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(coclearatas a suppa),
						'one' => q({0} coclearata a suppa),
						'other' => q({0} coclearatas a suppa),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(coclearatas a the),
						'one' => q({0} coclearata a the),
						'other' => q({0} coclearatas a the),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(coclearatas a the),
						'one' => q({0} coclearata a the),
						'other' => q({0} coclearatas a the),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'' => {
						'name' => q(dir.),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(dir.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}E),
						'north' => q({0}N),
						'south' => q({0}S),
						'west' => q({0}W),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(die),
						'one' => q({0}d),
						'other' => q({0}d),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(die),
						'one' => q({0}d),
						'other' => q({0}d),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(hora),
						'one' => q({0}h),
						'other' => q({0}h),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(hora),
						'one' => q({0}h),
						'other' => q({0}h),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'one' => q({0} μs),
						'other' => q({0}μs),
					},
					# Core Unit Identifier
					'microsecond' => {
						'one' => q({0} μs),
						'other' => q({0}μs),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(millisec),
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(millisec),
						'one' => q({0}ms),
						'other' => q({0}ms),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(min),
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(min),
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(mense),
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(mense),
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(s),
						'one' => q({0}s),
						'other' => q({0}s),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(s),
						'one' => q({0}s),
						'other' => q({0}s),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(sept.),
						'one' => q({0}sept),
						'other' => q({0}sept),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(sept.),
						'one' => q({0}sept),
						'other' => q({0}sept),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(an),
						'one' => q({0}an),
						'other' => q({0}an),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(an),
						'one' => q({0}an),
						'other' => q({0}an),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(cm),
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(cm),
						'one' => q({0}cm),
						'other' => q({0}cm),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(km),
						'one' => q({0}km),
						'other' => q({0}km),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(km),
						'one' => q({0}km),
						'other' => q({0}km),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(m),
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(m),
						'one' => q({0}m),
						'other' => q({0}m),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(mm),
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(mm),
						'one' => q({0}mm),
						'other' => q({0}mm),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kg),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(acre pd),
						'one' => q({0}acpd),
						'other' => q({0}acpd),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(acre pd),
						'one' => q({0}acpd),
						'other' => q({0}acpd),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(bbl),
						'one' => q({0}bbl),
						'other' => q({0}bbl),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(bbl),
						'one' => q({0}bbl),
						'other' => q({0}bbl),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(bushel),
						'one' => q({0}bu),
						'other' => q({0}bu),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(bushel),
						'one' => q({0}bu),
						'other' => q({0}bu),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'one' => q({0}cl),
						'other' => q({0}cl),
					},
					# Core Unit Identifier
					'centiliter' => {
						'one' => q({0}cl),
						'other' => q({0}cl),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'one' => q({0}cm³),
						'other' => q({0}cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'one' => q({0}cm³),
						'other' => q({0}cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'one' => q({0}pd³),
						'other' => q({0}pd³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'one' => q({0}pd³),
						'other' => q({0}pd³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'one' => q({0}in³),
						'other' => q({0}in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'one' => q({0}in³),
						'other' => q({0}in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'one' => q({0}m³),
						'other' => q({0}m³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'one' => q({0}m³),
						'other' => q({0}m³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'one' => q({0}yd³),
						'other' => q({0}yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'one' => q({0}yd³),
						'other' => q({0}yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0}t),
						'other' => q({0}t),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0}t),
						'other' => q({0}t),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'one' => q({0}tm),
						'other' => q({0}tm),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'one' => q({0}tm),
						'other' => q({0}tm),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'one' => q({0}dl),
						'other' => q({0}dl),
					},
					# Core Unit Identifier
					'deciliter' => {
						'one' => q({0}dl),
						'other' => q({0}dl),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(c. a dessert),
						'one' => q({0}CaD),
						'other' => q({0}CaD),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(c. a dessert),
						'one' => q({0}CaD),
						'other' => q({0}CaD),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(c. a dsrt imp.),
						'one' => q({0}CaDi),
						'other' => q({0}CaDi),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(c. a dsrt imp.),
						'one' => q({0}CaDi),
						'other' => q({0}CaDi),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(dr.liq.),
						'one' => q({0}drliq),
						'other' => q({0}drliq),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(dr.liq.),
						'one' => q({0}drliq),
						'other' => q({0}drliq),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(gutta),
						'one' => q({0}gt),
						'other' => q({0}gt),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(gutta),
						'one' => q({0}gt),
						'other' => q({0}gt),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'one' => q({0}ozliq),
						'other' => q({0}ozliq),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'one' => q({0}ozliq),
						'other' => q({0}ozliq),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(oz liq imp),
						'one' => q({0}ozli),
						'other' => q({0}ozli),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(oz liq imp),
						'one' => q({0}ozli),
						'other' => q({0}ozli),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'one' => q({0}gal),
						'other' => q({0}gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'one' => q({0}gal),
						'other' => q({0}gal),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'one' => q({0}galim),
						'other' => q({0}galim),
						'per' => q({0}/galim),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'one' => q({0}galim),
						'other' => q({0}galim),
						'per' => q({0}/galim),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hl),
						'one' => q({0}hl),
						'other' => q({0}hl),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hl),
						'one' => q({0}hl),
						'other' => q({0}hl),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'one' => q({0}jigger),
						'other' => q({0}jigger),
					},
					# Core Unit Identifier
					'jigger' => {
						'one' => q({0}jigger),
						'other' => q({0}jigger),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(Ml),
						'one' => q({0}Ml),
						'other' => q({0}Ml),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(Ml),
						'one' => q({0}Ml),
						'other' => q({0}Ml),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'one' => q({0}ml),
						'other' => q({0}ml),
					},
					# Core Unit Identifier
					'milliliter' => {
						'one' => q({0}ml),
						'other' => q({0}ml),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Core Unit Identifier
					'pint' => {
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(pt),
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(pt),
						'one' => q({0}pt),
						'other' => q({0}pt),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'one' => q({0}qt),
						'other' => q({0}qt),
					},
					# Core Unit Identifier
					'quart' => {
						'one' => q({0}qt),
						'other' => q({0}qt),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(c. a suppa),
						'one' => q({0}CaS),
						'other' => q({0}CaS),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(c. a suppa),
						'one' => q({0}CaS),
						'other' => q({0}CaS),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(c. a the),
						'one' => q({0}CaT),
						'other' => q({0}CaT),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(c. a the),
						'one' => q({0}CaT),
						'other' => q({0}CaT),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(direction),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(direction),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(fortia g),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(fortia g),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(m/s²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(m/s²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(°),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(°),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(rad),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(rad),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(rev),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(rev),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ac),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ac),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ha),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ha),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(cm²),
						'per' => q({0}/cm²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(cm²),
						'per' => q({0}/cm²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ft²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ft²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(in²),
						'per' => q({0}/in²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(in²),
						'per' => q({0}/in²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(km²),
						'per' => q({0}/km²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(km²),
						'per' => q({0}/km²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(m²),
						'per' => q({0}/m²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(m²),
						'per' => q({0}/m²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(mi²),
						'per' => q({0}/mi²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(mi²),
						'per' => q({0}/mi²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(yd²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(yd²),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(kt),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(kt),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(mmol/L),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(mmol/L),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ppm),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(mi/gal),
						'one' => q({0} mi/gal),
						'other' => q({0} mi/gal),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(mi/gal),
						'one' => q({0} mi/gal),
						'other' => q({0} mi/gal),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(mi/gal imp.),
						'one' => q({0} mi/gal imp.),
						'other' => q({0} mi/gal imp.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(mi/gal imp.),
						'one' => q({0} mi/gal imp.),
						'other' => q({0} mi/gal imp.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} E),
						'north' => q({0} N),
						'south' => q({0} S),
						'west' => q({0} W),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} E),
						'north' => q({0} N),
						'south' => q({0} S),
						'west' => q({0} W),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(b),
						'one' => q({0} b),
						'other' => q({0} b),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(b),
						'one' => q({0} b),
						'other' => q({0} b),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(B),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(B),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Gb),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Gb),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(GB),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(GB),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(kb),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(kb),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(kB),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(kB),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Mb),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Mb),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(MB),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(MB),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(PB),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(PB),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Tb),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Tb),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(TB),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(TB),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(scl),
						'one' => q({0} scl),
						'other' => q({0} scl),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(scl),
						'one' => q({0} scl),
						'other' => q({0} scl),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(dies),
						'one' => q({0} die),
						'other' => q({0} dies),
						'per' => q({0}/d),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(dies),
						'one' => q({0} die),
						'other' => q({0} dies),
						'per' => q({0}/d),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(horas),
						'one' => q({0} hr),
						'other' => q({0} hr),
						'per' => q({0}/h),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(horas),
						'one' => q({0} hr),
						'other' => q({0} hr),
						'per' => q({0}/h),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(μs),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(μs),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(millisec),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(millisec),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(min),
						'one' => q({0} min),
						'other' => q({0} min),
						'per' => q({0}/min),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(min),
						'one' => q({0} min),
						'other' => q({0} min),
						'per' => q({0}/min),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(menses),
						'one' => q({0} mense),
						'other' => q({0} menses),
						'per' => q({0}/m),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(menses),
						'one' => q({0} mense),
						'other' => q({0} menses),
						'per' => q({0}/m),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ns),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ns),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(sec),
						'one' => q({0} sec),
						'other' => q({0} sec),
						'per' => q({0}/s),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(sec),
						'one' => q({0} sec),
						'other' => q({0} sec),
						'per' => q({0}/s),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(septimanas),
						'one' => q({0} sept),
						'other' => q({0} sept),
						'per' => q({0}/sept),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(septimanas),
						'one' => q({0} sept),
						'other' => q({0} sept),
						'per' => q({0}/sept),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(annos),
						'one' => q({0} an),
						'other' => q({0} an),
						'per' => q({0}/an),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(annos),
						'one' => q({0} an),
						'other' => q({0} an),
						'per' => q({0}/an),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(A),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(mA),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(mA),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(V),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(V),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(cal),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(cal),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(kcal),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(kcal),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(J),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(J),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(kcal),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(kcal),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(kJ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(kJ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(kWh),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(kWh),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(GHz),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(GHz),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Hz),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Hz),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(kHz),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(kHz),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(MHz),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(MHz),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ua),
						'one' => q({0} ua),
						'other' => q({0} ua),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ua),
						'one' => q({0} ua),
						'other' => q({0} ua),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(cm),
						'per' => q({0}/cm),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(cm),
						'per' => q({0}/cm),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(dm),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(dm),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ft),
						'per' => q({0}/ft),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ft),
						'per' => q({0}/ft),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(in),
						'per' => q({0}/in),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(in),
						'per' => q({0}/in),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(km),
						'per' => q({0}/km),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(km),
						'per' => q({0}/km),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(al),
						'one' => q({0} al),
						'other' => q({0} al),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(al),
						'one' => q({0} al),
						'other' => q({0} al),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(m),
						'per' => q({0}/m),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(m),
						'per' => q({0}/m),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μm),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μm),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(mi),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(mi),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(smi),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(smi),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(mm),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(mm),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(nm),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(nm),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(pc),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(pc),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(pm),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(pm),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(pt),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(pt),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(yd),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(yd),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(ct),
						'one' => q({0} ct),
						'other' => q({0} ct),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(ct),
						'one' => q({0} ct),
						'other' => q({0} ct),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(g),
						'per' => q({0}/g),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(g),
						'per' => q({0}/g),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(kg),
						'per' => q({0}/kg),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(kg),
						'per' => q({0}/kg),
					},
					# Long Unit Identifier
					'mass-metric-ton' => {
						'name' => q(t),
					},
					# Core Unit Identifier
					'metric-ton' => {
						'name' => q(t),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(μg),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(μg),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(mg),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(mg),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(oz),
						'per' => q({0}/oz),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(oz),
						'per' => q({0}/oz),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(oz t),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(oz t),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(lb),
						'per' => q({0}/lb),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(lb),
						'per' => q({0}/lb),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(tn),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(tn),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0}/{1}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(GW),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(GW),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(cv),
						'one' => q({0} cv),
						'other' => q({0} cv),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(cv),
						'one' => q({0} cv),
						'other' => q({0} cv),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(kW),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(kW),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(MW),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(MW),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(mW),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(mW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(W),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(W),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(atm),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(atm),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(mbar),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(mbar),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(km/h),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(km/h),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(kn),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(kn),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(m/s),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(m/s),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(mi/h),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(mi/h),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°F),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°F),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'name' => q(°),
					},
					# Core Unit Identifier
					'generic' => {
						'name' => q(°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(K),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(acre pd),
						'one' => q({0} ac pd),
						'other' => q({0} ac pd),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(acre pd),
						'one' => q({0} ac pd),
						'other' => q({0} ac pd),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(barril),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(barril),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(bushels),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(bushels),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(cl),
						'one' => q({0} cl),
						'other' => q({0} cl),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(cl),
						'one' => q({0} cl),
						'other' => q({0} cl),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(pd³),
						'one' => q({0} pd³),
						'other' => q({0} pd³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(pd³),
						'one' => q({0} pd³),
						'other' => q({0} pd³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(in³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(in³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(yd³),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(yd³),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(tas),
						'one' => q({0} tas),
						'other' => q({0} tas),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(tas),
						'one' => q({0} tas),
						'other' => q({0} tas),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(tasm),
						'one' => q({0} tasm),
						'other' => q({0} tasm),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(tasm),
						'one' => q({0} tasm),
						'other' => q({0} tasm),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(dl),
						'one' => q({0} dl),
						'other' => q({0} dl),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(dl),
						'one' => q({0} dl),
						'other' => q({0} dl),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(cocl. a dessert),
						'one' => q({0} cocl. a dessert),
						'other' => q({0} cocl. a dessert),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(cocl. a dessert),
						'one' => q({0} cocl. a dessert),
						'other' => q({0} cocl. a dessert),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(cocl. a dessert imp.),
						'one' => q({0} cocl. a dessert imp.),
						'other' => q({0} cocl. a dessert imp.),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(cocl. a dessert imp.),
						'one' => q({0} cocl. a dessert imp.),
						'other' => q({0} cocl. a dessert imp.),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(drachma liq.),
						'one' => q({0} dr liq),
						'other' => q({0} dr liq),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(drachma liq.),
						'one' => q({0} dr liq),
						'other' => q({0} dr liq),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(guttas),
						'one' => q({0} gutta),
						'other' => q({0} guttas),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(guttas),
						'one' => q({0} gutta),
						'other' => q({0} guttas),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(oz liq),
						'one' => q({0} oz liq),
						'other' => q({0} oz liq),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(oz liq),
						'one' => q({0} oz liq),
						'other' => q({0} oz liq),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(oz liq imp.),
						'one' => q({0} oz liq imp.),
						'other' => q({0} oz liq imp.),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(oz liq imp.),
						'one' => q({0} oz liq imp.),
						'other' => q({0} oz liq imp.),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(gal imp),
						'one' => q({0} gal imp),
						'other' => q({0} gal imp),
						'per' => q({0}/gal imp),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(gal imp),
						'one' => q({0} gal imp),
						'other' => q({0} gal imp),
						'per' => q({0}/gal imp),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(hl),
						'one' => q({0} hl),
						'other' => q({0} hl),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(hl),
						'one' => q({0} hl),
						'other' => q({0} hl),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(litros),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(litros),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(Ml),
						'one' => q({0} Ml),
						'other' => q({0} Ml),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(Ml),
						'one' => q({0} Ml),
						'other' => q({0} Ml),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ml),
						'one' => q({0} ml),
						'other' => q({0} ml),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ml),
						'one' => q({0} ml),
						'other' => q({0} ml),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(pintas),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(pintas),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(ptm),
						'one' => q({0} ptm),
						'other' => q({0} ptm),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(ptm),
						'one' => q({0} ptm),
						'other' => q({0} ptm),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(cocl. a suppa),
						'one' => q({0} c. a suppa),
						'other' => q({0} c. a suppa),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(cocl. a suppa),
						'one' => q({0} c. a suppa),
						'other' => q({0} c. a suppa),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(cocl. a the),
						'one' => q({0} cocl. a the),
						'other' => q({0} cocl. a the),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(cocl. a the),
						'one' => q({0} cocl. a the),
						'other' => q({0} cocl. a the),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:si|s|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 2,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 mil',
					'other' => '0 mil',
				},
				'10000' => {
					'one' => '00 mil',
					'other' => '00 mil',
				},
				'100000' => {
					'one' => '000 mil',
					'other' => '000 mil',
				},
				'1000000' => {
					'one' => '0 mln',
					'other' => '0 mln',
				},
				'10000000' => {
					'one' => '00 mln',
					'other' => '00 mln',
				},
				'100000000' => {
					'one' => '000 mln',
					'other' => '000 mln',
				},
				'1000000000' => {
					'one' => '0 mld',
					'other' => '0 mld',
				},
				'10000000000' => {
					'one' => '00 mld',
					'other' => '00 mld',
				},
				'100000000000' => {
					'one' => '000 mld',
					'other' => '000 mld',
				},
				'1000000000000' => {
					'one' => '0 bln',
					'other' => '0 bln',
				},
				'10000000000000' => {
					'one' => '00 bln',
					'other' => '00 bln',
				},
				'100000000000000' => {
					'one' => '000 bln',
					'other' => '000 bln',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 mille',
					'other' => '0 milles',
				},
				'10000' => {
					'one' => '00 mille',
					'other' => '00 milles',
				},
				'100000' => {
					'one' => '000 mille',
					'other' => '000 milles',
				},
				'1000000' => {
					'one' => '0 million',
					'other' => '0 milliones',
				},
				'10000000' => {
					'one' => '00 million',
					'other' => '00 milliones',
				},
				'100000000' => {
					'one' => '000 million',
					'other' => '000 milliones',
				},
				'1000000000' => {
					'one' => '0 milliardo',
					'other' => '0 milliardos',
				},
				'10000000000' => {
					'one' => '00 milliardo',
					'other' => '00 milliardos',
				},
				'100000000000' => {
					'one' => '000 milliardo',
					'other' => '000 milliardos',
				},
				'1000000000000' => {
					'one' => '0 billion',
					'other' => '0 billiones',
				},
				'10000000000000' => {
					'one' => '00 billion',
					'other' => '00 billiones',
				},
				'100000000000000' => {
					'one' => '000 billion',
					'other' => '000 billiones',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 mil',
					'other' => '0 mil',
				},
				'10000' => {
					'one' => '00 mil',
					'other' => '00 mil',
				},
				'100000' => {
					'one' => '000 mil',
					'other' => '000 mil',
				},
				'1000000' => {
					'one' => '0 mln',
					'other' => '0 mln',
				},
				'10000000' => {
					'one' => '00 mln',
					'other' => '00 mln',
				},
				'100000000' => {
					'one' => '000 mln',
					'other' => '000 mln',
				},
				'1000000000' => {
					'one' => '0 mld',
					'other' => '0 mld',
				},
				'10000000000' => {
					'one' => '00 mld',
					'other' => '00 mld',
				},
				'100000000000' => {
					'one' => '000 mld',
					'other' => '000 mld',
				},
				'1000000000000' => {
					'one' => '0 bln',
					'other' => '0 bln',
				},
				'10000000000000' => {
					'one' => '00 bln',
					'other' => '00 bln',
				},
				'100000000000000' => {
					'one' => '000 bln',
					'other' => '000 bln',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤ #,##0.00)',
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ALL' => {
			display_name => {
				'currency' => q(lek albanese),
				'one' => q(lekë albanese),
				'other' => q(lekë albanese),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(florino antillan),
				'one' => q(florino antillan),
				'other' => q(florinos antillan),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(kwanza angolan),
				'one' => q(kwanza angolan),
				'other' => q(kwanzas angolan),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(peso argentin),
				'one' => q(peso argentin),
				'other' => q(pesos argentin),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(dollar australian),
				'one' => q(dollar australian),
				'other' => q(dollares australian),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(florino aruban),
				'one' => q(florino aruban),
				'other' => q(florinos aruban),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(marco convertibile de Bosnia-Herzegovina),
				'one' => q(marcos convertibile de Bosnia-Herzegovina),
				'other' => q(marcos convertibile de Bosnia-Herzegovina),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(dollar barbadian),
				'one' => q(dollar barbadian),
				'other' => q(dollares barbadian),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(lev bulgare),
				'one' => q(leva bulgare),
				'other' => q(leva bulgare),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(franco burundese),
				'one' => q(franco burundese),
				'other' => q(francos burundese),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(dollar bermudan),
				'one' => q(dollar bermudan),
				'other' => q(dollares bermudan),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(boliviano bolivian),
				'one' => q(boliviano bolivian),
				'other' => q(bolivianos bolivian),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(real brasilian),
				'one' => q(real brasilian),
				'other' => q(reales brasilian),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(dollar bahamian),
				'one' => q(dollar bahamian),
				'other' => q(dollares bahamian),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(pula botswanese),
				'one' => q(pula botswanese),
				'other' => q(pulas botswanese),
			},
		},
		'BYN' => {
			display_name => {
				'currency' => q(rublo bielorusse),
				'one' => q(rublos bielorusse),
				'other' => q(rublos bielorusse),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(dollar belizan),
				'one' => q(dollar belizan),
				'other' => q(dollares belizan),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(dollar canadian),
				'one' => q(dollar canadian),
				'other' => q(dollares canadian),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(franco congolese),
				'one' => q(franco congolese),
				'other' => q(francos congolese),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(franco suisse),
				'one' => q(franco suisse),
				'other' => q(francos suisse),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(peso chilen),
				'one' => q(peso chilen),
				'other' => q(pesos chilen),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(yuan chinese),
				'one' => q(yuan chinese),
				'other' => q(yuan chinese),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(peso colombian),
				'one' => q(peso colombian),
				'other' => q(pesos colombian),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(colon costarican),
				'one' => q(colon costarican),
				'other' => q(colones costarican),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(peso cuban convertibile),
				'one' => q(peso cuban convertibile),
				'other' => q(pesos cuban convertibile),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(peso cuban),
				'one' => q(peso cuban),
				'other' => q(pesos cuban),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(escudo capoverdian),
				'one' => q(escudo capoverdian),
				'other' => q(escudos capoverdian),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(corona chec),
				'one' => q(coronas chec),
				'other' => q(coronas chec),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Marco geman),
				'one' => q(marco german),
				'other' => q(marcos german),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(franco djibutian),
				'one' => q(franco djibutian),
				'other' => q(francos djibutian),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(corona danese),
				'one' => q(corona danese),
				'other' => q(coronas danese),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(peso dominican),
				'one' => q(peso dominican),
				'other' => q(pesos dominican),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(dinar algerin),
				'one' => q(dinar algerin),
				'other' => q(dinares algerin),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Corona estonian),
				'one' => q(corona estonian),
				'other' => q(coronas estonian),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(libra egyptie),
				'one' => q(libra egyptie),
				'other' => q(libras egyptie),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(nakfa eritree),
				'one' => q(nakfa eritree),
				'other' => q(nakfas eritree),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(birr ethiope),
				'one' => q(birr ethiope),
				'other' => q(birres ethiope),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(euro),
				'one' => q(euro),
				'other' => q(euros),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Marco finnese),
				'one' => q(marco finnese),
				'other' => q(marcos finnese),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(dollar fijian),
				'one' => q(dollar fijian),
				'other' => q(dollares fijian),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(libra falklandese),
				'one' => q(libra falklandese),
				'other' => q(libras falklandese),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Franco francese),
				'one' => q(franco francese),
				'other' => q(francos francese),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(libra sterling),
				'one' => q(libra sterling),
				'other' => q(libras sterling),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(cedi ghanese),
				'one' => q(cedi ghanese),
				'other' => q(cedis ghanese),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(libra de Gibraltar),
				'one' => q(libras de Gibraltar),
				'other' => q(libras de Gibraltar),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(dalasi gambian),
				'one' => q(dalasis gambian),
				'other' => q(dalasis gambian),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(franco guinean),
				'one' => q(francos guinean),
				'other' => q(francos guinean),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(quetzal guatemaltec),
				'one' => q(quetzal guatemaltec),
				'other' => q(quetzales guatemaltec),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(dollar guyanese),
				'one' => q(dollar guyanese),
				'other' => q(dollares guyanese),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(lempira hondurese),
				'one' => q(lempira hondurese),
				'other' => q(lempiras hondurese),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(kuna croate),
				'one' => q(kunas croate),
				'other' => q(kunas croate),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(gourde haitian),
				'one' => q(gourde haitian),
				'other' => q(gourdes haitian),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(forint hungare),
				'one' => q(forintes hungare),
				'other' => q(forintes hungare),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Libra irlandese),
				'one' => q(libra irlandese),
				'other' => q(libras irlandese),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(rupia indian),
				'one' => q(rupia indian),
				'other' => q(rupias indian),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(corona islandese),
				'one' => q(corona islandese),
				'other' => q(coronas islandese),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(dollar jamaican),
				'one' => q(dollar jamaican),
				'other' => q(dollares jamaican),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(yen japonese),
				'one' => q(yen japonese),
				'other' => q(yen japonese),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(shilling kenyan),
				'one' => q(shilling kenyan),
				'other' => q(shillings kenyan),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(franco comorian),
				'one' => q(franco comorian),
				'other' => q(francos comorian),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(dollar del Insulas Caiman),
				'one' => q(dollar del Insulas Caiman),
				'other' => q(dollares del Insulas Caiman),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(dollar liberian),
				'one' => q(dollar liberian),
				'other' => q(dollares liberian),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(dinar libyc),
				'one' => q(dinar libyc),
				'other' => q(dinares libyc),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(dirham marocchin),
				'one' => q(dirham marocchin),
				'other' => q(dirhams marocchin),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(leu moldave),
				'one' => q(lei moldave),
				'other' => q(lei moldave),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ariary malgache),
				'one' => q(ariary malgache),
				'other' => q(ariary malgache),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(denar macedonie),
				'one' => q(denari macedonie),
				'other' => q(denari macedonie),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(ouguiya mauritan \(1973–2017\)),
				'one' => q(ouguiya mauritan \(1973–2017\)),
				'other' => q(ouguiyas mauritan \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(ouguiya mauritan),
				'one' => q(ouguiyas mauritan),
				'other' => q(ouguiyas mauritan),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(rupia mauritian),
				'one' => q(rupia mauritian),
				'other' => q(rupias mauritian),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(kwacha malawian),
				'one' => q(kwacha malawian),
				'other' => q(kwacha malawian),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(peso mexican),
				'one' => q(peso mexican),
				'other' => q(pesos mexican),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(metical mozambican),
				'one' => q(metical mozambican),
				'other' => q(meticales mozambican),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(dollar namibian),
				'one' => q(dollar namibian),
				'other' => q(dollares namibian),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(naira nigerian),
				'one' => q(nairas nigerian),
				'other' => q(nairas nigerian),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(cordoba nicaraguan),
				'one' => q(cordoba nicaraguan),
				'other' => q(cordobas nicaraguan),
			},
		},
		'NLG' => {
			symbol => 'ƒ',
			display_name => {
				'currency' => q(Florino nederlandese),
				'one' => q(florino nederlandese),
				'other' => q(florinos nederlandese),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(corona norvegian),
				'one' => q(corona norvegian),
				'other' => q(coronas norvegian),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(dollar neozelandese),
				'one' => q(dollar neozelandese),
				'other' => q(dollares neozelandese),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(balboa panamen),
				'one' => q(balboa panamen),
				'other' => q(balboas panamen),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(sol peruvian),
				'one' => q(sol peruvian),
				'other' => q(soles peruvian),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(kina papuan),
				'one' => q(kina papuan),
				'other' => q(kinas papuan),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(zloty polonese),
				'one' => q(zlotys polonese),
				'other' => q(zlotys polonese),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(guarani paraguayan),
				'one' => q(guarani paraguayan),
				'other' => q(guaranis paraguayan),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(leu romanian),
				'one' => q(lei romanian),
				'other' => q(lei romanian),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(dinar serbe),
				'one' => q(dinares serbe),
				'other' => q(dinares serbe),
			},
		},
		'RUB' => {
			symbol => '₽',
			display_name => {
				'currency' => q(rublo russe),
				'one' => q(rublos russe),
				'other' => q(rublos russe),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(franco ruandese),
				'one' => q(franco ruandese),
				'other' => q(francos ruandese),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(dollar del insulas Salomon),
				'one' => q(dollar del insulas Salomon),
				'other' => q(dollares del insulas Salomon),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(rupia seychellese),
				'one' => q(rupia seychellese),
				'other' => q(rupias seychellese),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(libra sudanese),
				'one' => q(libra sudanese),
				'other' => q(libras sudanese),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(corona svedese),
				'one' => q(corona svedese),
				'other' => q(coronas svedese),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(libra de St. Helena),
				'one' => q(libra de St. Helena),
				'other' => q(libras de St. Helena),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(leone sierraleonese),
				'one' => q(leones sierraleonese),
				'other' => q(leones sierraleonese),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(shilling somali),
				'one' => q(shilling somali),
				'other' => q(shillings somali),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(dollar surinamese),
				'one' => q(dollar surinamese),
				'other' => q(dollares surinamese),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(libra sud-sudanese),
				'one' => q(libra sud-sudanese),
				'other' => q(libras sud-sudanese),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(dobra de São Tomé e Príncipe),
				'one' => q(dobra de São Tomé e Príncipe),
				'other' => q(dobras de São Tomé e Príncipe),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(lilangeni swazilandese),
				'one' => q(lilangeni swazilandese),
				'other' => q(emalangeni swazilandese),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(dinar tunisian),
				'one' => q(dinar tunisian),
				'other' => q(dinares tunisian),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(paʻanga tongan),
				'one' => q(paʻanga tongan),
				'other' => q(paʻangas tongan),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(dollar de Trinidad e Tobago),
				'one' => q(dollar de Trinidad e Tobago),
				'other' => q(dollares de Trinidad e Tobago),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(shilling tanzanian),
				'one' => q(shilling tanzanian),
				'other' => q(shillings tanzanian),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(hryvnia ukrainian),
				'one' => q(hryvni ukrainian),
				'other' => q(hryvni ukrainian),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(shilling ugandese),
				'one' => q(shilling ugandese),
				'other' => q(shillings ugandese),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(dollar statounitese),
				'one' => q(dollar statounitese),
				'other' => q(dollares statounitese),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(peso uruguayan),
				'one' => q(peso uruguayan),
				'other' => q(pesos uruguayan),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(bolivar venezuelan \(2008–2018\)),
				'one' => q(bolivar venezuelan \(2008–2018\)),
				'other' => q(bolivares venezuelan \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(bolivar venezuelan),
				'one' => q(bolivar venezuelan),
				'other' => q(bolivares venezuelan),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(vatu vanuatuan),
				'one' => q(vatu vanuatuan),
				'other' => q(vatus vanuatuan),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(tala samoan),
				'one' => q(tala samoan),
				'other' => q(talas samoan),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(franco CFA de Africa Central),
				'one' => q(franco CFA de Africa Central),
				'other' => q(francos CFA de Africa Central),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(dollar del Caribes Oriental),
				'one' => q(dollar del Caribes Oriental),
				'other' => q(dollares del Caribes Oriental),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(franco CFA de Africa Occidental),
				'one' => q(francos CFA de Africa Occidental),
				'other' => q(francos CFA de Africa Occidental),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(franco CFP),
				'one' => q(franco CFP),
				'other' => q(francos CFP),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(moneta incognite),
				'one' => q(\(moneta incognite\)),
				'other' => q(\(moneta incognite\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(rand sudafrican),
				'one' => q(rand sudafrican),
				'other' => q(rand sudafrican),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(kwacha zambian),
				'one' => q(kwacha zambian),
				'other' => q(kwacha zambian),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'jan',
							'feb',
							'mar',
							'apr',
							'mai',
							'jun',
							'jul',
							'aug',
							'sep',
							'oct',
							'nov',
							'dec'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'j',
							'f',
							'm',
							'a',
							'm',
							'j',
							'j',
							'a',
							's',
							'o',
							'n',
							'd'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'januario',
							'februario',
							'martio',
							'april',
							'maio',
							'junio',
							'julio',
							'augusto',
							'septembre',
							'octobre',
							'novembre',
							'decembre'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'jan',
							'feb',
							'mar',
							'apr',
							'mai',
							'jun',
							'jul',
							'aug',
							'sep',
							'oct',
							'nov',
							'dec'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'januario',
							'februario',
							'martio',
							'april',
							'maio',
							'junio',
							'julio',
							'augusto',
							'septembre',
							'octobre',
							'novembre',
							'decembre'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'lun',
						tue => 'mar',
						wed => 'mer',
						thu => 'jov',
						fri => 'ven',
						sat => 'sab',
						sun => 'dom'
					},
					narrow => {
						mon => 'l',
						tue => 'm',
						wed => 'm',
						thu => 'j',
						fri => 'v',
						sat => 's',
						sun => 'd'
					},
					short => {
						mon => 'lu',
						tue => 'ma',
						wed => 'me',
						thu => 'jo',
						fri => 've',
						sat => 'sa',
						sun => 'do'
					},
					wide => {
						mon => 'lunedi',
						tue => 'martedi',
						wed => 'mercuridi',
						thu => 'jovedi',
						fri => 'venerdi',
						sat => 'sabbato',
						sun => 'dominica'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'lun',
						tue => 'mar',
						wed => 'mer',
						thu => 'jov',
						fri => 'ven',
						sat => 'sab',
						sun => 'dom'
					},
					narrow => {
						mon => 'l',
						tue => 'm',
						wed => 'm',
						thu => 'j',
						fri => 'v',
						sat => 's',
						sun => 'd'
					},
					short => {
						mon => 'lu',
						tue => 'ma',
						wed => 'me',
						thu => 'jo',
						fri => 've',
						sat => 'sa',
						sun => 'do'
					},
					wide => {
						mon => 'lunedi',
						tue => 'martedi',
						wed => 'mercuridi',
						thu => 'jovedi',
						fri => 'venerdi',
						sat => 'sabbato',
						sun => 'dominica'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'T1',
						1 => 'T2',
						2 => 'T3',
						3 => 'T4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1me trimestre',
						1 => '2nde trimestre',
						2 => '3tie trimestre',
						3 => '4te trimestre'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'T1',
						1 => 'T2',
						2 => 'T3',
						3 => 'T4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1me trimestre',
						1 => '2nde trimestre',
						2 => '3tie trimestre',
						3 => '4te trimestre'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'narrow' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'wide' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'narrow' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
				'wide' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'a.Chr.',
				'1' => 'p.Chr.'
			},
			wide => {
				'0' => 'ante Christo',
				'1' => 'post Christo'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE 'le' d 'de' MMMM y G},
			'long' => q{d 'de' MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{dd-MM-y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE 'le' d 'de' MMMM y},
			'long' => q{d 'de' MMMM y},
			'medium' => q{d MMM y},
			'short' => q{dd-MM-y},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} 'a' {0}},
			'long' => q{{1} 'a' {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} 'a' {0}},
			'long' => q{{1} 'a' {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E dd-MM},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMd => q{d 'de' MMMM},
			MMMd => q{d MMM},
			Md => q{dd-MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{MM-y GGGGG},
			yyyyMEd => q{E dd-MM-y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E d MMM y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{dd-MM-y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ 'de' y G},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E d MMM y G},
			GyMMMd => q{d MMM y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E dd-MM},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMW => q{'septimana' W 'de' MMMM},
			MMMMd => q{d 'de' MMMM},
			MMMd => q{d MMM},
			Md => q{dd-MM},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{MM-y},
			yMEd => q{E dd-MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{dd-MM-y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ 'de' y},
			yw => q{'septimana' w 'de' Y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{MM – MM},
			},
			MEd => {
				M => q{E dd-MM – E dd-MM},
				d => q{E dd-MM – E dd-MM},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E d MMM – E d MMM},
				d => q{E d MMM – E d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{dd-MM – dd-MM},
				d => q{dd-MM – dd-MM},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{MM-y – MM-y GGGGG},
				y => q{MM-y – MM-y GGGGG},
			},
			yMEd => {
				M => q{E dd-MM-y – E dd-MM-y GGGGG},
				d => q{E dd-MM-y – E dd-MM-y GGGGG},
				y => q{E dd-MM-y – E dd-MM-y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E d MMM – E d MMM y G},
				d => q{E d MMM – E d MMM y G},
				y => q{E d MMM y – E d MMM y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y G},
				d => q{d – d MMM y G},
				y => q{d MMM y – d MMM y G},
			},
			yMd => {
				M => q{dd-MM-y – dd-MM-y GGGGG},
				d => q{dd-MM-y – dd-MM-y GGGGG},
				y => q{dd-MM-y – dd-MM-y GGGGG},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{MM – MM},
			},
			MEd => {
				M => q{E MM-dd – E MM-dd},
				d => q{E MM-dd – E MM-dd},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E d MMM – E d MMM},
				d => q{E d MMM – E d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{MM-dd – MM-dd},
				d => q{MM-dd – MM-dd},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h – h a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{MM-y – MM-y},
				y => q{MM-y – MM-y},
			},
			yMEd => {
				M => q{E dd-MM-y – E dd-MM-y},
				d => q{E dd-MM-y – E dd-MM-y},
				y => q{E dd-MM-y – E dd-MM-y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E d MMM – E d MMM y},
				d => q{E d MMM – E d MMM y},
				y => q{E d MMM y – E d MMM y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d – d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{dd-MM-y – dd-MM-y},
				d => q{dd-MM-y – dd-MM-y},
				y => q{dd-MM-y – dd-MM-y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(hora de {0}),
		regionFormat => q(hora estive de {0}),
		regionFormat => q(hora normal de {0}),
		fallbackFormat => q({1} ({0})),
		'Africa/Ceuta' => {
			exemplarCity => q#Ceuta#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Djibuti#,
		},
		'Alaska' => {
			long => {
				'daylight' => q#hora estive de Alaska#,
				'generic' => q#hora de Alaska#,
				'standard' => q#hora normal de Alaska#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Adak#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Anchorage#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Anguilla#,
		},
		'America/Antigua' => {
			exemplarCity => q#Antigua#,
		},
		'America/Aruba' => {
			exemplarCity => q#Aruba#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Bahia de Banderas#,
		},
		'America/Barbados' => {
			exemplarCity => q#Barbados#,
		},
		'America/Belize' => {
			exemplarCity => q#Belize#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Blanc-Sablon#,
		},
		'America/Boise' => {
			exemplarCity => q#Boise#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Cambridge Bay#,
		},
		'America/Cancun' => {
			exemplarCity => q#Cancun#,
		},
		'America/Cayman' => {
			exemplarCity => q#Caiman#,
		},
		'America/Chicago' => {
			exemplarCity => q#Chicago#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Chihuahua#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Atikokan#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Costa Rica#,
		},
		'America/Creston' => {
			exemplarCity => q#Creston#,
		},
		'America/Curacao' => {
			exemplarCity => q#Curaçao#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Danmarkshavn#,
		},
		'America/Dawson' => {
			exemplarCity => q#Dawson#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Dawson Creek#,
		},
		'America/Denver' => {
			exemplarCity => q#Denver#,
		},
		'America/Detroit' => {
			exemplarCity => q#Detroit#,
		},
		'America/Dominica' => {
			exemplarCity => q#Dominica#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Edmonton#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#El Salvador#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Fort Nelson#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Glace Bay#,
		},
		'America/Godthab' => {
			exemplarCity => q#Nuuk#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Goose Bay#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Grand Turk#,
		},
		'America/Grenada' => {
			exemplarCity => q#Grenada#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Guadeloupe#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Guatemala#,
		},
		'America/Halifax' => {
			exemplarCity => q#Halifax#,
		},
		'America/Havana' => {
			exemplarCity => q#Havana#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Hermosillo#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Knox, Indiana#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Marengo, Indiana#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Petersburg, Indiana#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Tell City, Indiana#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Vevay, Indiana#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Vincennes, Indiana#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Winamac, Indiana#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Indianapolis#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Inuvik#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Iqaluit#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Jamaica#,
		},
		'America/Juneau' => {
			exemplarCity => q#Juneau#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Monticello, Kentucky#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Kralendijk#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Los Angeles#,
		},
		'America/Louisville' => {
			exemplarCity => q#Louisville#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Lower Prince’s Quarter#,
		},
		'America/Managua' => {
			exemplarCity => q#Managua#,
		},
		'America/Marigot' => {
			exemplarCity => q#Marigot#,
		},
		'America/Martinique' => {
			exemplarCity => q#Martinica#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Matamoros#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Mazatlan#,
		},
		'America/Menominee' => {
			exemplarCity => q#Menominee#,
		},
		'America/Merida' => {
			exemplarCity => q#Merida#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Metlakatla#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Citate de Mexico#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Miquelon#,
		},
		'America/Moncton' => {
			exemplarCity => q#Moncton#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Monterrey#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Montserrat#,
		},
		'America/Nassau' => {
			exemplarCity => q#Nassau#,
		},
		'America/New_York' => {
			exemplarCity => q#Nove York#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Nipigon#,
		},
		'America/Nome' => {
			exemplarCity => q#Nome#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Beulah, Dakota del Nord#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Center, Dakota del Nord#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#New Salem, Dakota del Nord#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Ojinaga#,
		},
		'America/Panama' => {
			exemplarCity => q#Panama#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Pangnirtung#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Phoenix#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Port-au-Prince#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Port of Spain#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Porto Rico#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Rainy River#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Rankin Inlet#,
		},
		'America/Regina' => {
			exemplarCity => q#Regina#,
		},
		'America/Resolute' => {
			exemplarCity => q#Resolute#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Santo Domingo#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Ittoqqortoormiit#,
		},
		'America/Sitka' => {
			exemplarCity => q#Sitka#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Sancte Bartholomeo#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Sancte Johannes de Terranova#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Sancte Christophoro#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Sancte Lucia#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Sancte Thomas#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Sancte Vincente#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Swift Current#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Tegucigalpa#,
		},
		'America/Thule' => {
			exemplarCity => q#Thule#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Thunder Bay#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Tijuana#,
		},
		'America/Toronto' => {
			exemplarCity => q#Toronto#,
		},
		'America/Tortola' => {
			exemplarCity => q#Tortola#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Vancouver#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Whitehorse#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Winnipeg#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Yakutat#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Yellowknife#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#hora estive central#,
				'generic' => q#hora central#,
				'standard' => q#hora normal central#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#hora estive del est#,
				'generic' => q#hora del est#,
				'standard' => q#hora normal del est#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#hora estive del montanias#,
				'generic' => q#hora del montanias#,
				'standard' => q#hora normal del montanias#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#hora estive pacific#,
				'generic' => q#hora pacific#,
				'standard' => q#hora normal pacific#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Longyearbyen#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Anadyr#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Barnaul#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Chita#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Hongkong#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Irkutsk#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Kamchatka#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Chandyga#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Krasnoyarsk#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Magadan#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Novokuznetsk#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Novosibirsk#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Omsk#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Sachalin#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Srednekolymsk#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Tomsk#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Ust-Nera#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Vladivostok#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Yakutsk#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Ekaterinburg#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#hora estive atlantic#,
				'generic' => q#hora atlantic#,
				'standard' => q#hora normal atlantic#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Azores#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Bermuda#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Canarias#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Capo Verde#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Feroe#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Madeira#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Reykjavik#,
		},
		'Azores' => {
			long => {
				'daylight' => q#hora estive del Azores#,
				'generic' => q#hora del Azores#,
				'standard' => q#hora normal del Azores#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#hora estive de Cuba#,
				'generic' => q#hora de Cuba#,
				'standard' => q#hora normal de Cuba#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Universal Tempore Coordinate#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Citate incognite#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Amsterdam#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Andorra#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Astrakhan#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Athenas#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Belgrado#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Berlin#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Bratislava#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Bruxelles#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Bucarest#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Budapest#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Büsingen#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Chisinau#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Copenhagen#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Dublin#,
			long => {
				'daylight' => q#Hora estive irlandese#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Gibraltar#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Guernsey#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Helsinki#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Insula de Man#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Jersey#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Kaliningrad#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Kiev#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Kirov#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Lisbona#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Ljubljana#,
		},
		'Europe/London' => {
			exemplarCity => q#London#,
			long => {
				'daylight' => q#Hora estive britannic#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Luxemburg#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Madrid#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Malta#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Mariehamn#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Minsk#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Monaco#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Moscova#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Oslo#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Paris#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Podgorica#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Praga#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Riga#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Roma#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Samara#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#San Marino#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Sarajevo#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Saratov#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Simferopol#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Skopje#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Sofia#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Stockholm#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Tallinn#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Tirana#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ulyanovsk#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Uzhgorod#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Vaduz#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Vaticano#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Vienna#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Vilnius#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Volgograd#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Varsovia#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Zagreb#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Zaporozhye#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Zurich#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#hora estive de Europa central#,
				'generic' => q#hora de Europa central#,
				'standard' => q#hora normal de Europa central#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#hora estive de Europa oriental#,
				'generic' => q#hora de Europa oriental#,
				'standard' => q#hora normal de Europa oriental#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#hora de Europa ultra-oriental#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#hora estive de Europa occidental#,
				'generic' => q#hora de Europa occidental#,
				'standard' => q#hora normal de Europa occidental#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#hora medie de Greenwich#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#hora estive de Groenlandia oriental#,
				'generic' => q#hora de Groenlandia oriental#,
				'standard' => q#hora normal de Groenlandia oriental#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#hora estive de Groenlandia occidental#,
				'generic' => q#hora de Groenlandia occidental#,
				'standard' => q#hora normal de Groenlandia occidental#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#hora estive de Hawaii-Aleutianas#,
				'generic' => q#hora de Hawaii-Aleutianas#,
				'standard' => q#hora normal de Hawaii-Aleutianas#,
			},
		},
		'Indian/Maldives' => {
			exemplarCity => q#Maldivas#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Mauritio#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Mayotta#,
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#hora estive de Irkutsk#,
				'generic' => q#hora de Irkutsk#,
				'standard' => q#hora normal de Irkutsk#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#hora estive de Krasnoyarsk#,
				'generic' => q#hora de Krasnoyarsk#,
				'standard' => q#hora normal de Krasnoyarsk#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#hora estive de Magadan#,
				'generic' => q#hora de Magadan#,
				'standard' => q#hora normal de Magadan#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#hora estive del nordwest de Mexico#,
				'generic' => q#hora del nordwest de Mexico#,
				'standard' => q#hora normal del nordwest de Mexico#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#hora estive del Pacifico mexican#,
				'generic' => q#hora del Pacifico mexican#,
				'standard' => q#hora normal del Pacifico mexican#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#hora estive de Moscova#,
				'generic' => q#hora de Moscova#,
				'standard' => q#hora normal de Moscova#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#hora estive de Terranova#,
				'generic' => q#hora de Terranova#,
				'standard' => q#hora normal de Terranova#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#hora estive de Novosibirsk#,
				'generic' => q#hora de Novosibirsk#,
				'standard' => q#hora normal de Novosibirsk#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#hora estive de Omsk#,
				'generic' => q#hora de Omsk#,
				'standard' => q#hora normal de Omsk#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#hora estive de Saint-Pierre e Miquelon#,
				'generic' => q#hora de Saint-Pierre e Miquelon#,
				'standard' => q#hora normal de Saint-Pierre e Miquelon#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#hora estive de Sachalin#,
				'generic' => q#hora de Sachalin#,
				'standard' => q#hora normal de Sachalin#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#hora estive de Vladivostok#,
				'generic' => q#hora de Vladivostok#,
				'standard' => q#hora normal de Vladivostok#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#hora estive de Volgograd#,
				'generic' => q#hora de Volgograd#,
				'standard' => q#hora normal de Volgograd#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#hora estive de Yakutsk#,
				'generic' => q#hora de Yakutsk#,
				'standard' => q#hora normal de Yakutsk#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#hora estive de Ekaterinburg#,
				'generic' => q#hora de Ekaterinburg#,
				'standard' => q#hora normal de Ekaterinburg#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
